/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.permission.OrgRangeHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AreaInfo;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.crm.plugins.support.defaultValue.SaleDefaultValueHelper;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.util.app.ContextUtil;

public class CommonF7FilterHelper {
    public static void setDeptFilter(DynamicFormApplication application, String deptKey) throws BOSException, EASBizException {
        application.setFieldFilter(deptKey, CommonF7FilterHelper.getDepartmentFilterString(ContextUtil.getCurrentUserInfo((Context)application.getContext()).getPerson()));
    }

    private static String getDepartmentFilterString(PersonInfo person) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        if (person != null) {
            AdminOrgUnitCollection posiMemberColl = OrgRangeHelper.getAllAdminOrgUnit(null, (BOSUuid)person.getId());
            oql.append("id in (");
            if (posiMemberColl != null) {
                for (int i = 0; i < posiMemberColl.size(); ++i) {
                    AdminOrgUnitInfo adminOrgUnitInfo = posiMemberColl.get(i);
                    if (adminOrgUnitInfo == null) continue;
                    oql.append("'").append(adminOrgUnitInfo.getId()).append("',");
                }
            }
            oql.append(")");
            if (oql.indexOf(",") != -1) {
                oql.deleteCharAt(oql.lastIndexOf(","));
            }
        } else {
            oql.append("id='null'");
        }
        return oql.toString();
    }

    public static void setAreaFilter(DynamicFormApplication application, BaseDataFilterArg arg, String countryKey, String areaKey, String provinceKey, String cityKey, String regionKey) throws EASBizException, BOSException {
        if (areaKey.equalsIgnoreCase(arg.getKey())) {
            CommonF7FilterHelper.setAreaFilter(arg);
        } else if (provinceKey.equalsIgnoreCase(arg.getKey())) {
            CommonF7FilterHelper.setProvinceFilter(application, arg, countryKey, areaKey);
        } else if (cityKey.equalsIgnoreCase(arg.getKey())) {
            CommonF7FilterHelper.setCityFilter(application, arg, countryKey, areaKey, provinceKey);
        } else if (regionKey.equalsIgnoreCase(arg.getKey())) {
            CommonF7FilterHelper.setRegionFilter(application, arg, countryKey, cityKey);
        }
    }

    private static CountryInfo checkCountry(DynamicFormApplication application, String countryKey) throws BOSException, EASBizException {
        CountryInfo country = (CountryInfo)application.getValue(countryKey, 0);
        if (country == null) {
            throw new BOSException("\u8bf7\u60a8\u5148\u9009\u62e9\u56fd\u5bb6\u3002");
        }
        return country;
    }

    private static void setAreaFilter(BaseDataFilterArg arg) throws BOSException, EASBizException {
        String oql = CommonF7FilterHelper.getAreaFilter();
        arg.setOql(oql);
    }

    private static void setProvinceFilter(DynamicFormApplication application, BaseDataFilterArg arg, String countryKey, String areaKey) throws BOSException, EASBizException {
        CountryInfo country = CommonF7FilterHelper.checkCountry(application, countryKey);
        AreaInfo area = (AreaInfo)application.getValue(areaKey, 0);
        String countryId = country.getId().toString();
        String areaId = area == null ? null : area.getId().toString();
        String oql = CommonF7FilterHelper.getProvinceFilter(countryId, areaId);
        arg.setOql(oql);
    }

    private static void setCityFilter(DynamicFormApplication application, BaseDataFilterArg arg, String countryKey, String areaKey, String provinceKey) throws BOSException, EASBizException {
        CountryInfo country = CommonF7FilterHelper.checkCountry(application, countryKey);
        AreaInfo area = (AreaInfo)application.getValue(areaKey, 0);
        ProvinceInfo province = (ProvinceInfo)application.getValue(provinceKey, 0);
        String countryId = country.getId().toString();
        String areaId = area == null ? null : area.getId().toString();
        String provinceId = province == null ? null : province.getId().toString();
        String oql = CommonF7FilterHelper.getCityFilter(countryId, areaId, provinceId);
        arg.setOql(oql);
    }

    private static void setRegionFilter(DynamicFormApplication application, BaseDataFilterArg arg, String countryKey, String cityKey) throws BOSException, EASBizException {
        CommonF7FilterHelper.checkCountry(application, countryKey);
        CityInfo city = (CityInfo)application.getValue(cityKey, 0);
        if (city == null) {
            throw new BOSException("\u8bf7\u60a8\u5148\u9009\u62e9\u57ce\u5e02\u3002");
        }
        String cityId = city == null ? null : city.getId().toString();
        String oql = CommonF7FilterHelper.getRegionFilter(cityId);
        arg.setOql(oql);
    }

    private static String getRegionFilter(String cityId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (cityId != null) {
            sql.append(" city.id = '").append(cityId).append("'");
        }
        return sql.toString();
    }

    private static String getAreaFilter() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" id is not null");
        return sql.toString();
    }

    private static String getProvinceFilter(String countryId, String areaId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (countryId != null) {
            sql.append(" country.id = '").append(countryId).append("'");
        }
        if (areaId != null) {
            sql.append(" and area.id = '").append(areaId).append("'");
        }
        return sql.toString();
    }

    private static String getCityFilter(String countryId, String areaId, String provinceId) throws BOSException, EASBizException {
        String provinceFilter;
        StringBuffer sql = new StringBuffer();
        if (provinceId != null) {
            sql.append(" province.id = '").append(provinceId).append("'");
        } else if (!(countryId == null && areaId == null || (provinceFilter = CommonF7FilterHelper.getProvinceFilter(countryId, areaId)) == null || "".equals(provinceFilter.trim()))) {
            CoreBaseCollection provinceCollection = null;
            provinceCollection = ProvinceFactory.getRemoteInstance().getCollection(" where " + provinceFilter);
            if (provinceCollection != null && !provinceCollection.isEmpty() && provinceCollection.size() > 0) {
                sql.append(" province.id in (");
                int size = provinceCollection.size();
                for (int i = 0; i < size; ++i) {
                    sql.append("'").append(((ProvinceInfo)provinceCollection.get(i)).getId().toString()).append("',");
                }
                sql.append(")");
                sql.deleteCharAt(sql.lastIndexOf(","));
            } else {
                sql.append(" id is null");
            }
        }
        return sql.toString();
    }

    public static void setRoleFilter(BillApplication application, String roleKey) throws EASBizException, BOSException {
        application.setFieldFilter(roleKey, " name != 'Admin'");
    }

    public static String buildF7ShareUserFilter(Context ctx) throws BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" creator.id='").append(user.getId()).append("'");
        StringBuffer sb = new StringBuffer();
        sb.append(" or ( id in ( select SHAREUSER.FEntityID from T_CRM_OpAssociatedUser SHAREUSER where SHAREUSER.FUserID='" + user.getId() + "') )");
        oql.append(sb);
        return oql.toString();
    }

    public static void setSaleGroupFilter(BillApplication application, String saleGroupKey, String saleOrgKey) throws EASBizException, BOSException {
        SaleOrgUnitInfo saleOrgInfo = ContextUtil.getCurrentSaleUnit((Context)application.getContext());
        if (null == saleOrgInfo || !saleOrgInfo.isIsBizUnit()) {
            application.setFieldFilter(saleGroupKey, " id='null' ");
            return;
        }
        SaleOrgUnitInfo saleOrg = (SaleOrgUnitInfo)application.getValue(saleOrgKey, 0);
        if (saleOrg == null) {
            application.setFieldFilter(saleGroupKey, " id='null' ");
            return;
        }
        SalePersonCollection salePersons = SaleDefaultValueHelper.getSaleGroupByUser(application, ContextUtil.getCurrentUserInfo((Context)application.getContext()), saleOrg);
        if (null != salePersons && salePersons.size() > 0) {
            int size = salePersons.size();
            String[] saleGroupIds = new String[size];
            for (int i = 0; i < size; ++i) {
                saleGroupIds[i] = String.valueOf(salePersons.get(i).getSaleGroup().getId());
            }
            application.setFieldFilter(saleGroupKey, " id  in  (" + CommonUtil.arrayToString(saleGroupIds) + ")");
        } else {
            application.setFieldFilter(saleGroupKey, " id='null'");
        }
    }

    public static String setSaleGroupFilter(BillApplication application, String saleOrgKey, UserInfo userInfo) throws EASBizException, BOSException {
        if (null == userInfo) {
            throw new BOSException("\u8bf7\u5148\u8f93\u5165\u65b0\u8d1f\u8d23\u7528\u6237\u3002");
        }
        SaleOrgUnitInfo saleOrgInfo = ContextUtil.getCurrentSaleUnit((Context)application.getContext());
        if (null == saleOrgInfo || !saleOrgInfo.isIsBizUnit()) {
            return " id is null ";
        }
        SaleOrgUnitInfo saleOrg = (SaleOrgUnitInfo)application.getValue(saleOrgKey, 0);
        if (saleOrg == null) {
            return " id is null ";
        }
        SalePersonCollection salePersons = SaleDefaultValueHelper.getSaleGroupByUser(application, userInfo, saleOrg);
        if (null != salePersons && salePersons.size() > 0) {
            int size = salePersons.size();
            String[] saleGroupIds = new String[size];
            for (int i = 0; i < size; ++i) {
                saleGroupIds[i] = String.valueOf(salePersons.get(i).getSaleGroup().getId());
            }
            return " id  in  (" + CommonUtil.arrayToString(saleGroupIds) + ")";
        }
        return " id is null ";
    }

    public static String buildSaleGroupFilter(BillApplication application, String saleOrgKey) throws BOSException {
        SaleOrgUnitInfo saleOrgInfo = ContextUtil.getCurrentSaleUnit((Context)application.getContext());
        if (null == saleOrgInfo || !saleOrgInfo.isIsBizUnit()) {
            return " id='null' ";
        }
        SaleOrgUnitInfo saleOrg = (SaleOrgUnitInfo)application.getValue(saleOrgKey, 0);
        if (saleOrg == null) {
            return " id='null' ";
        }
        SalePersonCollection salePersons = SaleDefaultValueHelper.getSaleGroupByUser(application, ContextUtil.getCurrentUserInfo((Context)application.getContext()), saleOrg);
        if (null != salePersons && salePersons.size() > 0) {
            int size = salePersons.size();
            String[] saleGroupIds = new String[size];
            for (int i = 0; i < size; ++i) {
                saleGroupIds[i] = String.valueOf(salePersons.get(i).getSaleGroup().getId());
            }
            return " id  in  (" + CommonUtil.arrayToString(saleGroupIds) + ")";
        }
        return " id='null' ";
    }
}

