/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.permission.OrgRangeHelper;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.OrgUnitUtil;
import com.kingdee.eas.util.app.ContextUtil;

public class SaleF7FilterHelper {
    public static void setSaleOrgFilter(DynamicFormApplication application, String[] keys, String permissionItem) throws BOSException, EASBizException {
        OrgUnitCollection collection = OrgUnitUtil.getAuthOrgByPermItem((Context)application.getContext(), (OrgType)OrgType.Sale, (String)permissionItem, (int)2);
        if (collection != null && !collection.isEmpty()) {
            int i;
            StringBuffer oql = new StringBuffer(" id in (");
            for (i = 0; i < collection.size(); ++i) {
                OrgUnitInfo org = collection.get(i);
                oql.append("'").append(org.getId()).append("',");
            }
            oql.append(") and isBizUnit=1");
            oql.deleteCharAt(oql.lastIndexOf(","));
            if (keys != null) {
                for (i = 0; i < keys.length; ++i) {
                    application.setFieldFilter(keys[i], oql.toString());
                }
            }
        }
    }

    public static void setFilterAfterSallerChange(DynamicFormApplication application, DataChangeCommandArg arg, String sellerKey, String deptKey, String userKey) throws EASBizException, BOSException {
        if (sellerKey.equalsIgnoreCase(arg.getKey())) {
            IObjectValue newValue = (IObjectValue)arg.getNewValue();
            if (newValue instanceof PersonInfo) {
                application.setFieldFilter(deptKey, SaleF7FilterHelper.getDepartmentFilterString((PersonInfo)newValue));
                application.setFieldFilter(userKey, SaleF7FilterHelper.getUserFilterString((PersonInfo)newValue));
            } else {
                if (newValue != null && ((SalePersonInfo)newValue).getPerson() != null) {
                    application.setFieldFilter(deptKey, SaleF7FilterHelper.getDepartmentFilterString((SalePersonInfo)newValue));
                }
                application.setFieldFilter(userKey, SaleF7FilterHelper.getUserFilterString((SalePersonInfo)newValue));
            }
        }
    }

    public static String getDepartmentFilterString(SalePersonInfo seller) throws BOSException, EASBizException {
        if (seller != null) {
            return SaleF7FilterHelper.getDepartmentFilterString(seller.getPerson());
        }
        return "";
    }

    public static String getDepartmentFilterString(PersonInfo person) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        if (person != null) {
            AdminOrgUnitCollection posiMemberColl = OrgRangeHelper.getAllAdminOrgUnit(null, (BOSUuid)person.getId());
            oql.append("id in (");
            if (posiMemberColl != null) {
                for (int i = 0; i < posiMemberColl.size(); ++i) {
                    AdminOrgUnitInfo adminOrgUnitInfo = posiMemberColl.get(i);
                    if (adminOrgUnitInfo == null) continue;
                    oql.append("'").append(adminOrgUnitInfo.getId()).append("',");
                }
            }
            oql.append(")");
            if (oql.indexOf(",") != -1) {
                oql.deleteCharAt(oql.lastIndexOf(","));
            }
        }
        return oql.toString();
    }

    public static String getUserFilterString(SalePersonInfo seller) throws BOSException {
        if (seller != null) {
            SaleF7FilterHelper.getUserFilterString(seller.getPerson());
        }
        return "";
    }

    public static String getUserFilterString(PersonInfo person) throws BOSException {
        StringBuffer oql = new StringBuffer();
        if (person != null) {
            UserCollection users = UserFactory.getRemoteInstance().getUserCollection("where person.id='" + person.getId().toString() + "'");
            if (users != null && !users.isEmpty()) {
                oql = oql.append(" id in (");
                for (int i = 0; i < users.size(); ++i) {
                    UserInfo user = users.get(i);
                    oql.append("'").append(user.getId()).append("',");
                }
                oql.append(")");
                oql.deleteCharAt(oql.lastIndexOf(","));
            } else {
                oql = oql.append(" id is null");
            }
        }
        return oql.toString();
    }

    public static void getMaterialSalesFilterString(BillApplication application) throws BOSException {
        CtrlUnitInfo cu = ContextUtil.getCurrentSaleUnit((Context)application.getContext()).getCU();
        if (cu != null) {
            String cuId = cu.getId().toString();
            StringBuffer oqlFilter = new StringBuffer(" SaleOrgUnit.CU.id = '").append(cuId).append("'");
            application.setFieldFilter("FMaterialName", oqlFilter.toString());
        }
    }
}

