/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.codingrule.CodingRuleUtils;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.bs.SaleFunctionCollection;
import com.kingdee.eas.scm.crm.bs.SaleFunctionFactory;
import com.kingdee.eas.scm.crm.bs.SaleFunctionInfo;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleStageCollection;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleStageFactory;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleStageInfo;
import com.kingdee.eas.scm.crm.common.BillStatusEnum;
import com.kingdee.eas.scm.crm.common.ClueContactorTypeEnum;
import com.kingdee.eas.scm.crm.common.ExecuteStatusEnum;
import com.kingdee.eas.scm.crm.customer.ContactFactory;
import com.kingdee.eas.scm.crm.customer.ContactInfo;
import com.kingdee.eas.scm.crm.customer.CustomerFactory;
import com.kingdee.eas.scm.crm.customer.CustomerGroupDetailCollection;
import com.kingdee.eas.scm.crm.customer.CustomerGroupDetailInfo;
import com.kingdee.eas.scm.crm.customer.CustomerInfo;
import com.kingdee.eas.scm.crm.plugins.util.BillStatusManageUtil;
import com.kingdee.eas.scm.crm.plugins.util.BillViewUtil;
import com.kingdee.eas.scm.crm.plugins.util.BusinessException;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.FinanceUtil;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageCollection;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportFactory;
import com.kingdee.eas.scm.crm.sm.BusinOpportInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportProductCollection;
import com.kingdee.eas.scm.crm.sm.BusinOpportProductInfo;
import com.kingdee.eas.scm.crm.sm.ClueBizOppFactory;
import com.kingdee.eas.scm.crm.sm.ClueBizOppInfo;
import com.kingdee.eas.scm.crm.sm.ClueContacorFactory;
import com.kingdee.eas.scm.crm.sm.ClueContacorInfo;
import com.kingdee.eas.scm.crm.sm.ClueCustomerFactory;
import com.kingdee.eas.scm.crm.sm.ClueCustomerInfo;
import com.kingdee.eas.scm.crm.sm.ClueCustomerTypeEnum;
import com.kingdee.eas.scm.crm.sm.ClueFactory;
import com.kingdee.eas.scm.crm.sm.ClueInfo;
import com.kingdee.eas.scm.crm.sm.ClueIntenProductEntryCollection;
import com.kingdee.eas.scm.crm.sm.ClueIntenProductEntryInfo;
import com.kingdee.eas.scm.crm.sm.IClueBizOpp;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class ClueBillViewSupport {
    private BillApplication application;
    private ClueInfo clueInfo;

    public ClueBillViewSupport() {
    }

    public ClueBillViewSupport(BillApplication billApplication) {
        this.application = billApplication;
    }

    public void lockElementByKeys(String[] keys, boolean isLock) {
        BillViewUtil.lockElementByKeys(this.application, keys, isLock);
    }

    public void lockElementByKeys(List keys, boolean isLock) {
        this.lockElementByKeys(CommonUtil.list2Array(keys), isLock);
    }

    public void antiClose(String operation) throws EASBizException, BaseException {
        ClueInfo clueInfo = (ClueInfo)this.application.getBillValue();
        if (clueInfo.getExecuteStatus().getValue() > 3) {
            IObjectPK[] pks = BillViewUtil.beforeLog(this.application, "unClose", "\u53cd\u5173\u95ed", new String[]{clueInfo.getId().toString()});
            clueInfo.setExecuteStatus(ExecuteStatusEnum.EXECUTING);
            this.application.showMessage("\u53cd\u5173\u95ed\u64cd\u4f5c\u6210\u529f\u3002");
            ClueFactory.getRemoteInstance().save((CoreBaseInfo)clueInfo);
            BillViewUtil.afterLog(this.application, pks, new String[]{clueInfo.getId().toString()});
            this.application.getView().refresh();
        } else {
            this.application.showMessage("\u5355\u636e\u4e0d\u80fd\u6267\u884c\u53cd\u5173\u95ed\u3002");
        }
    }

    public String copy2Contactor(ClueInfo clueInfo, UserInfo userInfo) throws EASBizException, BOSException {
        if (null != userInfo) {
            userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(userInfo.getId()));
        }
        ContactInfo contactInfo = new ContactInfo();
        contactInfo.setName(clueInfo.getContactName());
        contactInfo.setSex(clueInfo.getContactorSex());
        contactInfo.setCustomerDepartment(clueInfo.getContactorDept());
        contactInfo.setContactPosition(clueInfo.getContactorPosition());
        contactInfo.setTelephone(clueInfo.getContactorPhone());
        contactInfo.setEmail(clueInfo.getContactorEmail());
        contactInfo.setMobilePhone(clueInfo.getContactorMobileNo());
        contactInfo.setAddress(clueInfo.getContactorAddress());
        contactInfo.setCustomer(clueInfo.getCustomer());
        contactInfo.setBillStatus(BillStatusEnum.TEMPORARILYSAVED);
        String number = CodingRuleUtils.getNumberByClient((IObjectValue)contactInfo, (String)ContextUtil.getCurrentOrgUnit((Context)this.application.getContext()).getId().toString());
        contactInfo.setNumber(number);
        BillViewUtil.setSystemFieldValue(this.application, (IObjectValue)contactInfo);
        contactInfo.setPerson(userInfo != null ? userInfo.getPerson() : null);
        contactInfo.setInt("cultureDegree", -1);
        contactInfo.setCreator(userInfo);
        BillViewUtil.setDefaultRole(this.application, (IObjectValue)contactInfo, userInfo, "AaSzVCXfQaWc8lYhj9rQKJp+rpI=");
        String contactorId = ContactFactory.getRemoteInstance().addnew(contactInfo).toString();
        ClueContacorInfo clueContacorInfo = new ClueContacorInfo();
        clueContacorInfo.setContactor(ContactFactory.getRemoteInstance().getContactInfo((IObjectPK)new ObjectUuidPK(contactorId)));
        clueContacorInfo.setClue(clueInfo);
        ClueContacorFactory.getRemoteInstance().addnew(clueContacorInfo);
        return contactorId;
    }

    public void createNewContactor() throws EASBizException, BOSException {
        UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo("select id,CU,person where id ='" + ContextUtil.getCurrentUserInfo((Context)this.application.getContext()).getId() + "'");
        String newContactorId = new ClueBillViewSupport(this.application).copy2Contactor(this.clueInfo, userInfo);
        this.clueInfo.setContactorType(ClueContactorTypeEnum.existingContactor);
        this.clueInfo.setContactName(null);
        this.clueInfo.setContact(ContactFactory.getRemoteInstance().getContactInfo((IObjectPK)new ObjectUuidPK(newContactorId)));
        ClueFactory.getRemoteInstance().save((CoreBaseInfo)this.clueInfo);
        this.application.getBillView().refresh();
        BillViewUtil.showBillView(this.application, newContactorId, "AaSzVCXfQaWc8lYhj9rQKJp+rpI=", "\u8054\u7cfb\u4eba");
    }

    public void createNewCustomer() throws EASBizException, BOSException {
        UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo("select id,CU,person where id ='" + ContextUtil.getCurrentUserInfo((Context)this.application.getContext()).getId() + "'");
        String newCustomerId = new ClueBillViewSupport(this.application).copy2Customer(this.clueInfo, userInfo);
        this.clueInfo.setCustomerType(ClueCustomerTypeEnum.existingCustomer);
        this.clueInfo.setCustomerName(null);
        this.clueInfo.setCustomer(CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(newCustomerId)));
        ClueFactory.getRemoteInstance().save((CoreBaseInfo)this.clueInfo);
        this.application.getBillView().refresh();
        BillViewUtil.showBillView(this.application, newCustomerId, "hBY+5dRaSPubFHE+sDIb8Zp+rpI=", "\u5ba2\u6237\u6863\u6848");
    }

    public String copy2Customer(ClueInfo clueInfo, UserInfo userInfo) throws EASBizException, BOSException {
        if (null != userInfo) {
            userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(userInfo.getId()));
        }
        CustomerInfo customerInfo = new CustomerInfo();
        customerInfo.setName(clueInfo.getCustomerName());
        customerInfo.setBillStatus(BillStatusEnum.TEMPORARILYSAVED);
        String number = CodingRuleUtils.getNumberByClient((IObjectValue)customerInfo, (String)ContextUtil.getCurrentOrgUnit((Context)this.application.getContext()).getId().toString());
        customerInfo.setNumber(number);
        BillViewUtil.setSystemFieldValue(this.application, (IObjectValue)customerInfo);
        customerInfo.setCreator(userInfo);
        customerInfo.setPerson(userInfo != null ? userInfo.getPerson() : null);
        BillViewUtil.setDefaultRole(this.application, (IObjectValue)customerInfo, userInfo, "hBY+5dRaSPubFHE+sDIb8Zp+rpI=");
        CSSPGroupStandardCollection coll = CSSPGroupStandardFactory.getRemoteInstance().getCSSPGroupStandardCollection("select * where type=1 and isBasic=1");
        if (coll != null && !coll.isEmpty()) {
            CustomerGroupDetailInfo customerGroupDetailInfo = new CustomerGroupDetailInfo();
            customerGroupDetailInfo.setCustomerGroupStandard(coll.get(0));
            CustomerGroupDetailCollection customerGroupDetailCollection = new CustomerGroupDetailCollection();
            customerGroupDetailCollection.add(customerGroupDetailInfo);
            customerInfo.put("customerGroupDetails", (Object)customerGroupDetailCollection);
        }
        String customerId = CustomerFactory.getRemoteInstance().addnew(customerInfo).toString();
        ClueCustomerInfo clueCustomerInfo = new ClueCustomerInfo();
        clueCustomerInfo.setCustomer(CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(customerId)));
        clueCustomerInfo.setClue(clueInfo);
        ClueCustomerFactory.getRemoteInstance().addnew(clueCustomerInfo);
        if (clueInfo.getContactorType().getValue() == 1) {
            // empty if block
        }
        return customerId;
    }

    public String convert2BizOpp(ClueInfo clueInfo, UserInfo userInfo) throws EASBizException, BOSException {
        if (null != userInfo) {
            userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(userInfo.getId()));
        }
        if (clueInfo.getContactorType().equals((Object)ClueContactorTypeEnum.newContactor)) {
            String contactorId = this.copy2Contactor(clueInfo, userInfo);
            clueInfo.setContactorType(ClueContactorTypeEnum.existingContactor);
            clueInfo.setContactName(null);
            clueInfo.setContact(ContactFactory.getRemoteInstance().getContactInfo((IObjectPK)new ObjectUuidPK(contactorId)));
        }
        if (clueInfo.getCustomerType().equals((Object)ClueCustomerTypeEnum.newCustomer)) {
            String customerId = this.copy2Customer(clueInfo, userInfo);
            clueInfo.setCustomerType(ClueCustomerTypeEnum.existingCustomer);
            clueInfo.setCustomerName(null);
            clueInfo.setCustomer(CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(customerId)));
        }
        BusinOpportInfo businOpportInfo = new BusinOpportInfo();
        String number = CodingRuleUtils.getNumberByClient((IObjectValue)businOpportInfo, (String)ContextUtil.getCurrentOrgUnit((Context)this.application.getContext()).getId().toString());
        businOpportInfo.setNumber(number);
        SaleOrgUnitInfo saleOrgUnig = ContextUtil.getCurrentSaleUnit((Context)this.application.getContext());
        if (saleOrgUnig.isIsBizUnit()) {
            businOpportInfo.setSaleOrgUnit(saleOrgUnig);
            CompanyOrgUnitInfo companyOrg = FinanceUtil.getCompanyOrgUnit(OrgType.Sale, saleOrgUnig.getId());
            businOpportInfo.setCompanyOrgUnit(companyOrg);
        }
        businOpportInfo.setName(clueInfo.getName());
        businOpportInfo.setCustomer(clueInfo.getCustomer());
        businOpportInfo.setMainContact(clueInfo.getContact());
        businOpportInfo.setBillStatus(BillStatusEnum.TEMPORARILYSAVED);
        businOpportInfo.setExecuteStatus(ExecuteStatusEnum.NEW);
        businOpportInfo.setCreator(userInfo);
        businOpportInfo.setSaleOrgUnit(clueInfo.getSaleOrgUnit());
        businOpportInfo.setSaleGroup(clueInfo.getSaleGroup());
        businOpportInfo.setCompanyOrgUnit(clueInfo.getCompanyOrgUnit());
        businOpportInfo.setCurrency(clueInfo.getCurrency());
        businOpportInfo.setExchangeRate(clueInfo.getExchangeRate());
        businOpportInfo.setPerson(userInfo != null ? userInfo.getPerson() : null);
        businOpportInfo.setRegdate(new Date());
        ClueIntenProductEntryCollection intenProductEntries = clueInfo.getIntenProductEntry();
        BusinOpportProductCollection businOpportProductCollection = new BusinOpportProductCollection();
        BigDecimal amount = new BigDecimal(0.0);
        if (!intenProductEntries.isEmpty()) {
            ClueIntenProductEntryInfo clueIntenProductEntryInfo = null;
            int size = intenProductEntries.size();
            for (int i = 0; i < size; ++i) {
                clueIntenProductEntryInfo = intenProductEntries.get(i);
                BusinOpportProductInfo productInfo = new BusinOpportProductInfo();
                productInfo.setSeq(clueIntenProductEntryInfo.getSeq());
                productInfo.setMaterial(clueIntenProductEntryInfo.getMaterial());
                productInfo.setUnit(clueIntenProductEntryInfo.getUnit());
                productInfo.setQuantity(clueIntenProductEntryInfo.getQuantity());
                productInfo.setPrice(clueIntenProductEntryInfo.getPrice());
                productInfo.setComputeAmount(clueIntenProductEntryInfo.getComputeAmount());
                amount = amount.add(clueIntenProductEntryInfo.getComputeAmount());
                businOpportProductCollection.add(productInfo);
            }
            businOpportInfo.getProduct().addCollection(businOpportProductCollection);
        }
        businOpportInfo.setBudgeting(amount);
        businOpportInfo.setExecuteStatus(ExecuteStatusEnum.EXECUTING);
        BillViewUtil.setDefaultRole(this.application, (IObjectValue)businOpportInfo, userInfo, "xr3oDk8uSgaJC/UmsKBrwJp+rpI=");
        SaleFunctionInfo functionInfo = this.getDefaultSaleFunction();
        if (functionInfo != null) {
            businOpportInfo.setSaleFunction(functionInfo);
            businOpportInfo.setSaleStage(this.getDefaultSaleStage());
            SaleFunctionSaleStageInfo saleFunctionSaleStageInfo = this.getDefaultSaleStage();
            if (saleFunctionSaleStageInfo != null) {
                businOpportInfo.setSuccessRate(saleFunctionSaleStageInfo.getSaleStage().getSuccessRate());
            }
            this.setDefaultBusinStage(businOpportInfo, functionInfo);
        }
        ClueFactory.getRemoteInstance().save((CoreBaseInfo)clueInfo);
        this.application.getView().refresh();
        BillViewUtil.setSystemFieldValue(this.application, (IObjectValue)businOpportInfo);
        String bizOppId = BusinOpportFactory.getRemoteInstance().addnew(businOpportInfo).toString();
        IClueBizOpp iClueBizOpp = ClueBizOppFactory.getRemoteInstance();
        if (iClueBizOpp.getCollection("select id  where bizOpp.id='" + bizOppId + "' and Clue.id='" + clueInfo.getId() + "'").size() == 0) {
            ClueBizOppInfo clueBizOppInfo = new ClueBizOppInfo();
            clueBizOppInfo.setBizOpp(BusinOpportFactory.getRemoteInstance().getBusinOpportInfo((IObjectPK)new ObjectUuidPK(String.valueOf(bizOppId))));
            clueBizOppInfo.setClue(clueInfo);
            iClueBizOpp.addnew(clueBizOppInfo);
        }
        BillViewUtil.showBillView(this.application, bizOppId, "xr3oDk8uSgaJC/UmsKBrwJp+rpI=", "\u5546\u673a");
        return bizOppId;
    }

    private SaleFunctionSaleStageInfo getDefaultSaleStage() throws EASBizException, BOSException {
        SaleFunctionSaleStageCollection stageCollection;
        SaleFunctionInfo functionInfo = this.getDefaultSaleFunction();
        if (functionInfo != null && !(stageCollection = this.getSaleStageCollection(functionInfo)).isEmpty()) {
            SaleFunctionSaleStageInfo stageInfo = stageCollection.get(0);
            return stageInfo;
        }
        return null;
    }

    public void antiAudit(String operation) {
        if (BillViewUtil.checkBillStatus(operation, this.application)) {
            // empty if block
        }
    }

    public void initPageElements() throws EASBizException, BOSException {
        BillStatusManageUtil billStatusManageUtil = new BillStatusManageUtil(this.application);
        billStatusManageUtil.initBillButtons();
        this.clueInfo = (ClueInfo)this.application.getBillModel().getBillValue();
        if (this.clueInfo.getBillStatus().equals((Object)BillStatusEnum.ADD) && this.clueInfo.getCustomerType() == null) {
            this.clueInfo.setCustomerType(ClueCustomerTypeEnum.newCustomer);
            this.clueInfo.setContactorType(ClueContactorTypeEnum.newContactor);
        }
        if (this.clueInfo.getId() != null && this.clueInfo.getContactorType().getValue() == 1) {
            ContactInfo contactInfo = ContactFactory.getRemoteInstance().getContactInfo((IObjectPK)new ObjectUuidPK(this.clueInfo.getContact().getId()));
            this.application.setValue("FContactorAddress", (Object)contactInfo.getAddress(), 0);
            this.application.setValue("FContactorDept", (Object)contactInfo.getCustomerDepartment(), 0);
            this.application.setValue("FContactorEmail", (Object)contactInfo.getEmail(), 0);
            this.application.setValue("FContactorMobile", (Object)contactInfo.getMobilePhone(), 0);
            this.application.setValue("FContactorTelNo", (Object)contactInfo.getTelephone(), 0);
            if (contactInfo.getContactPosition() != null) {
                this.application.setValue("FContactorPosition", (Object)new Integer(contactInfo.getContactPosition().getValue()), 0);
            }
            if (contactInfo.getSex() != null) {
                this.application.setValue("FContactorSex", (Object)new Integer(contactInfo.getSex().getValue()), 0);
            }
        }
        this.lockCustomerRelatedElements();
        this.lockContactorRelatedElements();
    }

    public void lockCustomerRelatedElements() {
        OperationStatus operationStatus = this.application.getBillView().getOperationStatus();
        if (OperationStatus.VIEW.equals(operationStatus)) {
            BillViewUtil.lockElementByKeys(this.application, new String[]{"FbdCustomer", "FCustomerName"}, true);
            return;
        }
        boolean isNew = true;
        if (this.clueInfo != null) {
            isNew = ClueCustomerTypeEnum.newCustomer.equals((Object)this.clueInfo.getCustomerType());
        }
        String clearKey = isNew ? "FbdCustomer" : "FCustomerName";
        try {
            this.application.setValue(clearKey, null, 0);
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        this.application.lockElement("FCustomerName", !isNew);
        this.application.lockElement("FbdCustomer", isNew);
    }

    public void clearExistCustomerField() throws EASBizException, BOSException {
        this.application.setValue("FbdCustomer", (Object)"", 0);
        this.application.setValue("FCustomerNumber", (Object)"", 0);
    }

    public void clearExistContactorField() throws EASBizException, BOSException {
        this.application.setValue("FContactor", (Object)"", 0);
        this.application.setValue("FContactorNumber", (Object)"", 0);
        this.application.setValue("FContactorName", (Object)"", 0);
        this.application.setValue("FContactorEmail", (Object)"", 0);
        this.application.setValue("FContactorMobile", (Object)"", 0);
        this.application.setValue("FContactorTelNo", (Object)"", 0);
        this.application.setValue("FContactorSex", (Object)"", 0);
        this.application.setValue("FContactorPosition", (Object)"", 0);
        this.application.setValue("FContactorDept", (Object)"", 0);
        this.application.setValue("FContactorAddress", (Object)"", 0);
    }

    public void lockContactorRelatedElements() {
        String[] keys = new String[]{"FContactorName", "FContactorEmail", "FContactorMobile", "FContactorTelNo", "FContactorSex", "FContactorPosition", "FContactorDept", "FContactorAddress"};
        boolean isNew = true;
        OperationStatus operationStatus = this.application.getBillView().getOperationStatus();
        if (OperationStatus.VIEW.equals(operationStatus)) {
            BillViewUtil.lockElementByKeys(this.application, keys, true);
            this.application.lockElement("FContactor", true);
            return;
        }
        if (this.clueInfo != null) {
            isNew = ClueContactorTypeEnum.newContactor.equals((Object)this.clueInfo.getContactorType());
        }
        String clearKey = isNew ? "FContactor" : "FContactorName";
        try {
            this.application.setValue(clearKey, null, 0);
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        this.application.lockElement("FContactor", isNew);
        BillViewUtil.lockElementByKeys(this.application, keys, !isNew);
    }

    public void setCustomerMustInput() {
        ClueInfo clueInf = (ClueInfo)this.application.getBillValue();
        Object customerType = this.application.getValue("FCustomerType", 0);
        boolean isNew = true;
        if (clueInf != null && clueInf.getId() != null) {
            isNew = ClueCustomerTypeEnum.newCustomer.equals((Object)this.clueInfo.getCustomerType());
        } else if (null != customerType) {
            isNew = (Integer)customerType == 0;
        }
        this.application.setMustInput("FCustomerName", isNew);
        this.application.setMustInput("FbdCustomer", !isNew);
    }

    public void setContactorMustInput() {
        ClueInfo clueInf = (ClueInfo)this.application.getBillValue();
        Object contactorType = this.application.getValue("FContactorType", 0);
        boolean isNew = true;
        if (clueInf != null && clueInf.getId() != null) {
            isNew = ClueContactorTypeEnum.newContactor.equals((Object)this.clueInfo.getContactorType());
        } else if (null != contactorType) {
            isNew = (Integer)contactorType == 0;
        }
        this.application.setMustInput("FContactorName", isNew);
        this.application.setMustInput("FContactor", !isNew);
    }

    public boolean checkFieldsBeforeSave() {
        return this.checkCustomerRelatedFields() && this.checkContactorRelatedFields();
    }

    public boolean checkCustomerRelatedFields() {
        this.clueInfo = (ClueInfo)this.application.getBillModel().getBillValue();
        if (ClueCustomerTypeEnum.newCustomer.equals((Object)this.clueInfo.getCustomerType())) {
            if (StringUtils.isEmpty((String)this.clueInfo.getCustomerName())) {
                this.application.showMessage("\u5ba2\u6237\u540d\u79f0\u5fc5\u586b\u3002");
                return false;
            }
        } else if (this.clueInfo.getCustomer() == null) {
            this.application.showMessage("\u5ba2\u6237\u5fc5\u586b\u3002");
            return false;
        }
        return true;
    }

    public boolean checkContactorRelatedFields() {
        this.clueInfo = (ClueInfo)this.application.getBillModel().getBillValue();
        if (ClueContactorTypeEnum.newContactor.equals((Object)this.clueInfo.getContactorType())) {
            if (StringUtils.isEmpty((String)this.clueInfo.getContactName())) {
                this.application.showMessage("\u8054\u7cfb\u4eba\u540d\u79f0\u5fc5\u586b\u3002");
                return false;
            }
        } else if (this.clueInfo.getContact() == null) {
            this.application.showMessage("\u8054\u7cfb\u4eba\u5fc5\u586b\u3002");
            return false;
        }
        return true;
    }

    public OrgUnitCollection getCompanyOrgUnit(String saleOrgUnitId) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection collection = iOrgRelation.getToUnit(saleOrgUnitId, 2, 1);
        return collection;
    }

    /*
     * Unable to fully structure code
     */
    public void buildLink(ClueInfo clueInfo) {
        clueInf = clueInfo;
        preCuleInfo = (ClueInfo)this.application.getApplicationContext().getData("PRE_BILL_ENTITY_DATA");
        if (ClueContactorTypeEnum.newContactor.equals((Object)clueInf.getContactorType())) {
            try {
                if (preCuleInfo == null || preCuleInfo.getContact() == null) ** GOTO lbl29
                preContactorId = preCuleInfo.getContact().getId().toString();
                if (preCuleInfo.getContactorType().getValue() != 1 || clueInf.getContactorType().getValue() != 0) ** GOTO lbl29
                ClueContacorFactory.getRemoteInstance().delete(" where clue.id='" + clueInf.getId() + "' and  contactor.id='" + preContactorId + "'");
            }
            catch (EASBizException e) {
                throw new BusinessException(e);
            }
            catch (BOSException e) {
                throw new BusinessException(e);
            }
        } else {
            clueContacorInfo = new ClueContacorInfo();
            clueContacorInfo.setContactor(clueInf.getContact());
            clueContacorInfo.setClue(clueInf);
            try {
                cll = ClueContacorFactory.getRemoteInstance().getClueContacorCollection("select id  where  clue.id='" + clueInf.getId() + "' and contactor.id='" + clueInf.getContact().getId() + "'");
                if (cll == null || cll.size() == 0) {
                    ClueContacorFactory.getRemoteInstance().addnew(clueContacorInfo);
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
        }
lbl29:
        // 6 sources

        if (ClueCustomerTypeEnum.newCustomer.equals((Object)clueInf.getCustomerType())) {
            try {
                if (preCuleInfo == null || preCuleInfo.getCustomer() == null) ** GOTO lbl55
                preCustomerId = preCuleInfo.getCustomer().getId().toString();
                if (preCuleInfo.getCustomerType().getValue() != 1 || clueInf.getCustomerType().getValue() != 0) ** GOTO lbl55
                ClueCustomerFactory.getRemoteInstance().delete(" where clue.id='" + clueInf.getId() + "' and customer.id='" + preCustomerId + "'");
            }
            catch (EASBizException e) {
                throw new BusinessException(e);
            }
            catch (BOSException e) {
                throw new BusinessException(e);
            }
        } else {
            clueCustomerInfo = new ClueCustomerInfo();
            clueCustomerInfo.setCustomer(clueInf.getCustomer());
            clueCustomerInfo.setClue(clueInf);
            try {
                cll = ClueCustomerFactory.getRemoteInstance().getClueCustomerCollection("select id  where  clue.id='" + clueInf.getId() + "' and customer.id='" + clueInf.getCustomer().getId() + "'");
                if (cll == null || cll.size() == 0) {
                    ClueCustomerFactory.getRemoteInstance().addnew(clueCustomerInfo);
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
        }
lbl55:
        // 6 sources

    }

    private SaleFunctionInfo getDefaultSaleFunction() throws BOSException, EASBizException {
        SaleFunctionCollection collection;
        SaleOrgUnitInfo loginSaleOrg = (SaleOrgUnitInfo)this.application.getContext().get((Object)OrgType.Sale);
        StringBuffer oql = new StringBuffer();
        SaleFunctionInfo defalutFunction = null;
        if (loginSaleOrg != null) {
            oql.append("select *,SaleStage.* where cu.id='").append(loginSaleOrg.getId()).append("' and  isEnabled != 0  and isDeleted = 0 and  IsDefuSaleFun = 1 order by name");
            collection = SaleFunctionFactory.getRemoteInstance().getSaleFunctionCollection(oql.toString());
            if (collection != null && !collection.isEmpty()) {
                boolean hasDefauFunction = false;
                for (int i = 0; i < collection.size(); ++i) {
                    SaleFunctionInfo functionInfo = collection.get(i);
                    if (!functionInfo.isIsDefuSaleFun()) continue;
                    hasDefauFunction = true;
                    defalutFunction = functionInfo;
                    break;
                }
                if (!hasDefauFunction) {
                    defalutFunction = collection.get(0);
                }
            } else {
                CtrlUnitInfo cu = loginSaleOrg.getCU();
                defalutFunction = this.getDefalutSaleFunctionByCU(cu);
            }
        }
        if (defalutFunction != null) {
            oql = new StringBuffer();
            oql.append("select *,SaleStage.* where id='").append(defalutFunction.getId()).append("' and  isEnabled != 0  and isDeleted = 0 and IsDefuSaleFun = 1 order by SaleStage.stageNum");
            collection = SaleFunctionFactory.getRemoteInstance().getSaleFunctionCollection(oql.toString());
            if (!collection.isEmpty()) {
                return collection.get(0);
            }
        }
        return null;
    }

    private SaleFunctionInfo getDefalutSaleFunctionByCU(CtrlUnitInfo cu) throws BOSException, EASBizException {
        if (cu != null) {
            cu = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cu.getId()));
            StringBuffer oql = new StringBuffer("select *");
            oql.append(" where isEnabled != 0").append(" and isDeleted = 0").append(" and IsDefuSaleFun = 1").append(" and cu.id='").append(cu.getId()).append("' order by name");
            SaleFunctionCollection collection = SaleFunctionFactory.getRemoteInstance().getSaleFunctionCollection(oql.toString());
            boolean hasDefauFunction = false;
            if (collection != null && !collection.isEmpty()) {
                for (int i = 0; i < collection.size(); ++i) {
                    SaleFunctionInfo saleFunction = collection.get(i);
                    if (!saleFunction.isIsDefuSaleFun()) continue;
                    hasDefauFunction = true;
                    return saleFunction;
                }
                if (!hasDefauFunction) {
                    return collection.get(0);
                }
            } else {
                return this.getDefalutSaleFunctionByCU(cu.getParent());
            }
        }
        return null;
    }

    private SaleFunctionSaleStageCollection getSaleStageCollection(SaleFunctionInfo functionInfo) throws BOSException {
        StringBuffer oql = new StringBuffer("select *, saleStage.* ");
        oql.append(" where parent.id = '").append(functionInfo.getId()).append("' order by stageNum");
        SaleFunctionSaleStageCollection stageCollection = SaleFunctionSaleStageFactory.getRemoteInstance().getSaleFunctionSaleStageCollection(oql.toString());
        return stageCollection;
    }

    public String builderContactorFilter(int customerType, CustomerInfo customerInfo) throws BOSException {
        String filter = CRMPermissionHelper.buildMyFilterF7(this.application.getContext());
        if (customerType == 0) {
            filter = filter + " and (customer.id is null)";
        } else if (customerInfo != null && customerType == 1) {
            filter = filter + " and (customer.id ='" + customerInfo.getId() + "')";
        }
        return filter;
    }

    private void setDefaultBusinStage(BusinOpportInfo opportInfo, SaleFunctionInfo functionInfo) throws BOSException, EASBizException {
        BusinOpportBusinStageCollection businStageCollection = opportInfo.getBusinStage();
        businStageCollection.clear();
        if (functionInfo != null) {
            SaleFunctionSaleStageCollection saleStageCollection = this.getSaleStageCollection(functionInfo);
            int size = saleStageCollection.size();
            for (int i = 0; i < size; ++i) {
                BusinOpportBusinStageInfo businStageInfo = new BusinOpportBusinStageInfo();
                businStageInfo.setSeq(i + 1);
                businStageInfo.setSaleStage(saleStageCollection.get(i).getSaleStage());
                businStageInfo.setNumDays(saleStageCollection.get(i).getNumDays());
                businStageInfo.setSuccessRate(saleStageCollection.get(i).getSuccessRate());
                businStageCollection.add(businStageInfo);
            }
        }
    }
}

