/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.common.BillStatusEnum;
import com.kingdee.eas.scm.crm.common.CrmBillBaseInfo;
import com.kingdee.eas.scm.crm.common.ExecuteStatusEnum;
import com.kingdee.eas.scm.crm.plugins.util.BillViewUtil;
import com.kingdee.eas.scm.crm.plugins.util.BusinessException;
import com.kingdee.eas.scm.crm.plugins.util.ReflectionUtils;
import com.kingdee.eas.scm.crm.service.ServiceBillBaseInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportInfo;
import com.kingdee.eas.scm.crm.sm.ClueInfo;
import com.kingdee.eas.scm.crm.sm.SaleBillBaseInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class BillStatusManageUtil {
    private BillApplication application;
    public static final String ACTION_SUBMIT = "submit";
    public static final String ACTION_AUDIT = "audit";
    public static final String ACTION_UNAUDIT = "unAudit";
    public static final String ACTION_CLOSE = "close";
    public static final String ACTION_UNCLOSE = "unClose";
    public static final String ACTION_DISABLED = "disabled";
    public static final String ACTION_ENABLED = "enabled";
    public static final String ACTION_REVOKE = "revoke";
    public static final String ACTION_CHANGE = "change";
    public static final String ACTION_UPLOAD = "upload";
    private static Map operateKeyNameMap = new HashMap();

    public BillStatusManageUtil() {
    }

    public BillStatusManageUtil(BillApplication application) {
        this.application = application;
    }

    public boolean isObeyStatusConvertRule(String operation) {
        if (ACTION_UNAUDIT.equals(operation)) {
            return this.checkBillStatus(BillStatusEnum.AUDITED, operation);
        }
        if (ACTION_CLOSE.equals(operation)) {
            return this.checkBillStatus(BillStatusEnum.AUDITED, operation);
        }
        if (ACTION_DISABLED.equals(operation)) {
            return this.checkBillStatus(BillStatusEnum.AUDITED, operation);
        }
        if (ACTION_ENABLED.equals(operation)) {
            return this.checkBillStatus(BillStatusEnum.CANCEL, operation);
        }
        if (ACTION_REVOKE.equals(operation)) {
            return this.checkBillStatus(BillStatusEnum.SUBMITED, operation);
        }
        if (ACTION_CHANGE.equals(operation)) {
            return this.checkBillStatus(BillStatusEnum.AUDITED, operation);
        }
        return false;
    }

    public boolean checkBillStatus(BillStatusEnum billStatusEnum, String operation) {
        CrmBillBaseInfo crmBillBaseInfo = (CrmBillBaseInfo)this.application.getBillModel().getBillValue();
        BillStatusEnum currentStatus = crmBillBaseInfo.getBillStatus();
        if (currentStatus == billStatusEnum) {
            return true;
        }
        this.application.showMessage(currentStatus.getAlias() + "\u72b6\u6001\u7684\u5355\u636e\u4e0d\u80fd" + operateKeyNameMap.get(operation) + "\u3002");
        return false;
    }

    public void lockButtons() {
        int statusInt;
        OperationStatus operationStatus = this.application.getBillView().getOperationStatus();
        CrmBillBaseInfo crmBillBaseInfo = (CrmBillBaseInfo)this.application.getBillModel().getBillValue();
        BillStatusEnum billstatus = crmBillBaseInfo.getBillStatus();
        if (billstatus.getValue() <= 2) {
            this.lockElement(ACTION_SUBMIT, false);
            if (OperationStatus.VIEW.equals(operationStatus) && billstatus.getValue() == 2) {
                this.lockElement(ACTION_SUBMIT, true);
            }
        }
        if (billstatus.getValue() == 4 && OperationStatus.VIEW.equals(operationStatus)) {
            this.lockElement(ACTION_UNAUDIT, false);
            this.lockElement(ACTION_CLOSE, false);
            this.lockElement(ACTION_CHANGE, false);
            this.lockElement(ACTION_DISABLED, false);
        } else if (billstatus != BillStatusEnum.CLOSED) {
            if (billstatus == BillStatusEnum.CANCEL) {
                this.lockElement(ACTION_ENABLED, false);
            } else if (billstatus == BillStatusEnum.SUBMITED && OperationStatus.VIEW.equals(operationStatus)) {
                this.lockElement(ACTION_REVOKE, false);
                this.lockElement(ACTION_AUDIT, false);
            }
        }
        if ((crmBillBaseInfo instanceof ClueInfo || crmBillBaseInfo instanceof BusinOpportInfo) && (statusInt = ((SaleBillBaseInfo)crmBillBaseInfo).getExecuteStatus().getValue()) >= ExecuteStatusEnum.SUCCESSCOLSE.getValue()) {
            this.lockElement(ACTION_CLOSE, true);
            this.lockElements(new String[]{"add", ACTION_UNCLOSE}, false);
            this.lockDistributeRecycleBtns(true);
            this.lockElements(new String[]{"edit", "save", ACTION_SUBMIT, ACTION_AUDIT, ACTION_UNAUDIT, "convert2Contactor", "convert2Customer", "distributeClue", "Fbtn3"}, true);
            if (crmBillBaseInfo instanceof BusinOpportInfo) {
                this.lockElement("3", true);
            }
        }
        if ((billstatus.getValue() == 2 || billstatus.getValue() == 1) && OperationStatus.EDIT.equals(operationStatus)) {
            this.lockElement(ACTION_UPLOAD, false);
        }
        if (4 == billstatus.getValue()) {
            this.application.lockElement("FbtnAudit", true);
            this.application.lockElement("FbtnUpload", true);
        }
    }

    public void lockDistributeRecycleBtns(boolean isLock) {
        BillViewUtil.lockElementByKeys(this.application, new String[]{"FdistributeUser", "FrecycleUser", "FdistributePerson", "FrecyclePerson"}, isLock);
    }

    public void setButtonsDefault(boolean defaultStatus) {
        this.lockElement(ACTION_SUBMIT, defaultStatus);
        this.lockElement(ACTION_UNAUDIT, defaultStatus);
        this.lockElement(ACTION_CLOSE, defaultStatus);
        this.lockElement(ACTION_CHANGE, defaultStatus);
        this.lockElement(ACTION_DISABLED, defaultStatus);
        this.lockElement(ACTION_REVOKE, defaultStatus);
        this.lockElement(ACTION_ENABLED, defaultStatus);
        this.lockElement(ACTION_UNCLOSE, defaultStatus);
    }

    public void lockElement(String key, boolean status) {
        this.application.lockElement("Fbtn" + StringUtils.capitalize((String)key), status);
    }

    public void lockElements(String[] keys, boolean status) {
        for (int i = 0; i < keys.length; ++i) {
            this.lockElement(keys[i], status);
        }
    }

    public void initBillButtons() {
        CrmBillBaseInfo crmBillBaseInfo = (CrmBillBaseInfo)this.application.getBillModel().getBillValue();
        if (crmBillBaseInfo instanceof ServiceBillBaseInfo) {
            return;
        }
        this.setButtonsDefault(true);
        this.lockButtons();
    }

    void changeBillStatus(BillStatusEnum billStatusEnum, String operation) {
        if (!this.isObeyStatusConvertRule(operation)) {
            return;
        }
        IObjectValue billValue = this.application.getBillModel().getBillValue();
        ReflectionUtils.invokeSetterMethod(billValue, "billStatus", (Object)billStatusEnum);
    }

    void changeBillStatusAndSave(BillStatusEnum billStatusEnum, String operation) {
        if (!this.isObeyStatusConvertRule(operation)) {
            return;
        }
        this.changeBillStatus(billStatusEnum, operation);
        try {
            this.application.save();
        }
        catch (EASBizException e) {
            throw new BusinessException(e);
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
    }

    static {
        operateKeyNameMap.put("save", "\u4fdd\u5b58");
        operateKeyNameMap.put(ACTION_SUBMIT, "\u63d0\u4ea4");
        operateKeyNameMap.put(ACTION_AUDIT, "\u5ba1\u6838");
        operateKeyNameMap.put(ACTION_UNAUDIT, "\u53cd\u5ba1\u6838");
        operateKeyNameMap.put(ACTION_CLOSE, "\u5173\u95ed");
        operateKeyNameMap.put(ACTION_UNCLOSE, "\u53cd\u5173\u95ed");
        operateKeyNameMap.put(ACTION_DISABLED, "\u7981\u7528");
        operateKeyNameMap.put(ACTION_ENABLED, "\u542f\u7528");
        operateKeyNameMap.put(ACTION_REVOKE, "\u5e9f\u5f03");
        operateKeyNameMap.put(ACTION_CHANGE, "\u53d8\u66f4");
        operateKeyNameMap.put(ACTION_UPLOAD, "\u9644\u4ef6\u7ba1\u7406");
    }
}

