/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.util.StringUtil;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.scm.crm.common.CrmBillBaseInfo;
import com.kingdee.eas.scm.crm.common.CrmRoleCollection;
import com.kingdee.eas.scm.crm.common.CrmRoleFactory;
import com.kingdee.eas.scm.crm.common.CrmRoleInfo;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.CrmAuthUtil;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserCollection;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserFactory;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CRMPermissionHelper {
    public static String getAdmin(String formId) throws EASBizException, BOSException {
        return CRMPermissionHelper.getAdmin(null, formId);
    }

    public static String getAdmin(Context ctx, String formId) throws EASBizException, BOSException {
        CrmRoleInfo crmRole = CRMPermissionHelper.getAdminRole(ctx, formId);
        if (crmRole != null) {
            return StringUtil.buildStringForObjNameAndNumber((Object[])new Object[]{crmRole});
        }
        return null;
    }

    public static Map getCRMPermissionMap(String[] recordIDs, String relProp, Context ctx) throws BOSException {
        HashMap m = new HashMap();
        int size = recordIDs.length;
        for (int i = 0; i <= size / 50; ++i) {
            int j;
            StringBuffer oql = new StringBuffer(CRMPermissionHelper.initPermissionOql(ctx, relProp));
            int offset = 50 * i;
            if (size - offset > 50) {
                for (j = offset; j < 50; ++j) {
                    oql.append("'").append(recordIDs[j]).append("',");
                }
            } else {
                for (j = offset; j < size; ++j) {
                    oql.append("'").append(recordIDs[j]).append("',");
                }
            }
            oql.deleteCharAt(oql.lastIndexOf(","));
            oql.append(")");
            OpAssociatedUserCollection collection = OpAssociatedUserFactory.getRemoteInstance().getOpAssociatedUserCollection(oql.toString());
            if (collection == null) continue;
            CRMPermissionHelper.buildPermissionMap(relProp, collection, m, ctx);
        }
        return m;
    }

    private static String initPermissionOql(Context ctx, String relProp) {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        StringBuffer oql = new StringBuffer();
        oql.append("select relProp.id,roles where user.id='").append(userInfo.getId()).append("'");
        oql.append(" and relProp.id in (");
        return oql.toString().replaceAll("relProp", relProp);
    }

    private static void buildPermissionMap(String relProp, OpAssociatedUserCollection collection, Map m, Context ctx) throws BOSException {
        for (int index = 0; index < collection.size(); ++index) {
            OpAssociatedUserInfo info = collection.get(index);
            if (info.get(relProp) == null || info.getRoles() == null) continue;
            String id = ((CrmBillBaseInfo)info.get(relProp)).getId().toString();
            String existPermissionKey = (String)m.get(id);
            String[] roleNumbers = StringUtil.handleMulDatabase((String)info.getRoles(), (int)0);
            CrmRoleCollection roles = CrmRoleFactory.getRemoteInstance().getCrmRoleCollection("where number in (" + CommonUtil.arrayToString(roleNumbers) + ")");
            ArrayList<String> permissionKeys = new ArrayList<String>();
            if (roles != null) {
                for (int i = 0; i < roles.size(); ++i) {
                    String perm = roles.get(i).getPermissionKey();
                    if (perm == null) continue;
                    permissionKeys.add(perm);
                }
            }
            if (permissionKeys.isEmpty()) continue;
            String permissionKey = CrmAuthUtil.getInstance(ctx).mergePermissionKeys(permissionKeys);
            if (existPermissionKey == null) {
                m.put(id, permissionKey);
                continue;
            }
            ArrayList<String> l = new ArrayList<String>();
            l.add(existPermissionKey);
            l.add(permissionKey);
            m.put(id, CrmAuthUtil.getInstance(ctx).mergePermissionKeys(l));
        }
    }

    public static List getDataPermissionRecordIDs(String permItemName, Context ctx, BOSObjectType type) throws EASBizException, BOSException {
        ArrayList<String> l = new ArrayList<String>();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        OrgUnitInfo org = ContextUtil.getCurrentOrgUnit((Context)ctx);
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getRemoteInstance();
        String rule = provider.getPermissionRule((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(org.getId()), permItemName);
        if (rule != null) {
            ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)type, ICoreBillBase.class);
            try {
                EntityViewInfo evi = new EntityViewInfo(rule);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                evi.getSelector().addObjectCollection((IObjectCollection)selector);
                CoreBaseCollection coll = coreBase.getCollection(evi);
                if (coll != null) {
                    for (int i = 0; i < coll.size(); ++i) {
                        l.add(coll.get(i).getId().toString());
                    }
                }
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return l;
    }

    public static boolean hasDataPermission(Context ctx, String permItemName, String id) throws BOSException, EASBizException {
        BOSObjectType type = BOSUuid.read((String)id).getType();
        List ids = CRMPermissionHelper.getDataPermissionRecordIDs(permItemName, ctx, type);
        return ids == null ? false : ids.contains(id);
    }

    public static boolean isResponsible(String id, Context ctx, BOSObjectType type) throws EASBizException, BOSException {
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)type, ICoreBillBase.class);
        return coreBase.exists("select id where creator.id='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId() + "' and id='" + id + "'");
    }

    public static List getNoResponsibleIDs(List selectBillIds, Context ctx, BOSObjectType type) throws BOSException, EASBizException {
        ArrayList<String> l = new ArrayList<String>();
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)type, ICoreBillBase.class);
        StringBuffer oql = new StringBuffer("select id , name where creator.id <> '");
        oql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("' and id in (");
        oql.append(CommonUtil.listToString(selectBillIds)).append(")");
        CoreBaseCollection coll = coreBase.getCollection(oql.toString());
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                l.add(coll.get(i).getId().toString());
            }
        }
        return l;
    }

    public static String buildUserOql(Context ctx) {
        StringBuffer oql = new StringBuffer();
        oql.append("( creator.id='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("')");
        return oql.toString();
    }

    public static String buildShareUserOqlByUser(Context ctx) {
        StringBuffer oql = new StringBuffer();
        oql.append("  id in ( select SHAREUSER.FEntityID from T_CRM_OpAssociatedUser SHAREUSER where SHAREUSER.FUserID='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("') ");
        return oql.toString();
    }

    public static String buildCUOql(Context ctx) {
        StringBuffer oql = new StringBuffer();
        oql.append(" CU.id='").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()).append("'");
        return oql.toString();
    }

    public static String buildShareUserOqlByCU(Context ctx) {
        StringBuffer oql = new StringBuffer();
        oql.append("id in ( select SHAREUSER.FEntityID from T_CRM_OpAssociatedUser SHAREUSER where SHAREUSER.FCtrlUnitID='").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()).append("') ");
        return oql.toString();
    }

    public static String buildLogicDeleteOql() {
        return "isDeleted=0";
    }

    public static String buildF7ShareUserFilter(Context ctx) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append(" creator.id='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("' and isDeleted = 0");
        oql.append(" or ( id in ( select SHAREUSER.FEntityID from T_CRM_OpAssociatedUser SHAREUSER where SHAREUSER.FUserID='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("') and isDeleted = 0 )");
        return oql.toString();
    }

    public static String buildF7ShareUserFilterByCU(Context ctx) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("( CU.id='").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()).append("' and isDeleted = 0 )");
        oql.append(" or ( id in ( select SHAREUSER.FEntityID from T_CRM_OpAssociatedUser SHAREUSER where SHAREUSER.FCtrlUnitID='").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()).append("') and isDeleted = 0 )");
        return oql.toString();
    }

    public static String buildMyFilterF7(Context ctx) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("( (creator.id='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("' and isDeleted = 0)");
        oql.append(" or ( id in ( select SHAREUSER.FEntityID from T_CRM_OpAssociatedUser SHAREUSER where SHAREUSER.FUserID='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("') and isDeleted = 0 ))");
        oql.append(" and CU.id='").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()).append("' and isDeleted = 0");
        return oql.toString();
    }

    public static String buildMyF7Filter(Context ctx) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("( (creator.id='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("' and isDeleted = 0)");
        oql.append(" or ( id in ( select SHAREUSER.FEntityID from T_CRM_OpAssociatedUser SHAREUSER where SHAREUSER.FUserID='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("') and isDeleted = 0 ))");
        oql.append(" and  (").append(CRMPermissionHelper.buildF7ShareUserFilterByCU(ctx)).append(")");
        return oql.toString();
    }

    public static String buildF7ShareUserFilterByOU(Context ctx, String orgFieldName) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append(" (" + orgFieldName + ".id='").append(ContextUtil.getCurrentOrgUnit((Context)ctx).getId()).append("' and isDeleted = 0)");
        oql.append(" and( ( id in ( select SHAREUSER.FEntityID from T_CRM_OpAssociatedUser SHAREUSER where SHAREUSER.FCtrlUnitID='").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()).append("') and isDeleted = 0 ) or ").append(CRMPermissionHelper.buildUserOql(ctx)).append(" )");
        return oql.toString();
    }

    public static CrmRoleInfo getAdminRole(String formID) throws BOSException {
        return CRMPermissionHelper.getAdminRole(null, formID);
    }

    public static CrmRoleInfo getAdminRole(Context ctx, String formID) throws BOSException {
        return CRMPermissionHelper.getRole(ctx, formID, "\u8d1f\u8d23\u4eba");
    }

    public static CrmRoleInfo getViewRole(Context ctx, String formID) throws BOSException {
        return CRMPermissionHelper.getRole(formID, "\u4e2a\u4eba\u5173\u8054\u6570\u636e\u67e5\u770b\u89d2\u8272");
    }

    public static CrmRoleInfo getShareUserRole(String formID) throws BOSException {
        return CRMPermissionHelper.getRole(formID, "\u5171\u4eab\u4eba");
    }

    public static CrmRoleInfo getRole(String formID, String roleName) throws BOSException {
        return CRMPermissionHelper.getRole(null, formID, roleName);
    }

    public static CrmRoleInfo getRole(Context ctx, String formID, String roleName) throws BOSException {
        CrmRoleInfo role = null;
        CrmRoleCollection infos = null;
        infos = ctx != null ? CrmRoleFactory.getLocalInstance(ctx).getCrmRoleCollection("select * where form.sourceBillId='" + formID + "' and name='" + roleName + "'") : CrmRoleFactory.getRemoteInstance().getCrmRoleCollection("select * where form.sourceBillId='" + formID + "' and name='" + roleName + "'");
        if (infos != null && infos.size() > 0) {
            role = infos.get(0);
        }
        return role;
    }
}

