/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import java.math.BigDecimal;

public class FinanceUtil {
    public static CompanyOrgUnitInfo getCompanyOrgUnit(OrgType orgType, BOSUuid orgPK) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection collection = iOrgRelation.getToUnit(orgPK.toString(), orgType.getValue(), 1);
        if (collection.size() > 0) {
            return (CompanyOrgUnitInfo)collection.get(0);
        }
        return null;
    }

    public static CurrencyInfo getBaseCurrencyInfo(CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select baseCurrency.* where id='" + companyOrgUnitInfo.getId() + "'");
        return companyOrgUnitInfo.getBaseCurrency();
    }

    public static BigDecimal getExchangeRate(BOSUuid exchangeTablePK, BOSUuid sourceCurrencyPK, BOSUuid targetCurrencyPK) throws BOSException, EASBizException {
        IExchangeRate ie;
        ExchangeRateInfo exchangeRate;
        BigDecimal rate = new BigDecimal(1.0);
        if (exchangeTablePK != null && sourceCurrencyPK != null && targetCurrencyPK != null && !targetCurrencyPK.toString().equals(exchangeTablePK.toString()) && (exchangeRate = (ie = ExchangeRateFactory.getRemoteInstance()).getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTablePK), (IObjectPK)new ObjectUuidPK(sourceCurrencyPK), (IObjectPK)new ObjectUuidPK(targetCurrencyPK), null)) != null) {
            ConvertModeEnum mode = exchangeRate.getConvertMode();
            rate = mode != null && mode.getValue() == 1 ? new BigDecimal(1.0).divide(exchangeRate.getConvertRate(), exchangeRate.getPrecision(), 4) : exchangeRate.getConvertRate();
        }
        return rate;
    }

    public static BigDecimal getConvertRate(ExchangeRateInfo exchangeRate) throws BOSException, EASBizException {
        BigDecimal convertRate = null;
        ConvertModeEnum mode = exchangeRate.getConvertMode();
        convertRate = mode != null && mode.getValue() == 1 ? new BigDecimal(1.0).divide(exchangeRate.getConvertRate(), exchangeRate.getPrecision(), 4) : exchangeRate.getConvertRate();
        return convertRate;
    }

    public static BigDecimal getRateByExchangeRate(ExchangeRateInfo exchangeRateInfo) {
        BigDecimal rate = new BigDecimal(1.0);
        if (exchangeRateInfo != null) {
            ConvertModeEnum mode = exchangeRateInfo.getConvertMode();
            rate = mode != null && mode.getValue() == 1 ? new BigDecimal(1.0).divide(exchangeRateInfo.getConvertRate(), exchangeRateInfo.getPrecision(), 4) : exchangeRateInfo.getConvertRate();
        }
        return rate;
    }

    public static ConvertModeEnum getConvertModeByExchangeRate(ExchangeRateInfo exchangeRateInfo) {
        ConvertModeEnum convertMode = null;
        if (exchangeRateInfo != null) {
            convertMode = exchangeRateInfo.getConvertMode();
        }
        return convertMode;
    }
}

