/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.list.ListApplication;
import com.kingdee.eas.base.form.plugin.OperationHelper;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.scm.crm.plugins.util.BusinessException;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.MyRemoteObjectUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.List;

public class ListViewUtil {
    public static boolean isSelectedRecords(ListApplication application, String alertMsg) {
        String defaultMsg = "\u8bf7\u9009\u62e9\u4e00\u884c\u6216\u4e00\u884c\u4ee5\u4e0a\u7684\u8bb0\u5f55\u3002";
        if (!ListViewUtil.isSelectedRecords(application)) {
            application.showMessage(alertMsg == null ? defaultMsg : alertMsg);
            return false;
        }
        return true;
    }

    public static boolean isSelectedRecords(ListApplication application) {
        String[] selectedIds = null;
        try {
            selectedIds = application.getListView().getSelectedBillIds();
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
        return null != selectedIds && selectedIds.length != 0;
    }

    public static FilterInfo buildS4Filter(ListApplication application) throws BOSException {
        CtrlUnitInfo cu = application.getMainOrgUnit().getCU();
        return ListViewUtil.buildS4Filter(cu);
    }

    public static FilterInfo buildS4Filter(CtrlUnitInfo cu) throws BOSException {
        if (null == cu) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524dCU\u7684id\u4e3a\u7a7a\uff01");
        }
        CtrlUnitCollection cus = null;
        cus = CommonUtil.getFullCu(cu);
        FilterInfo filter = new FilterInfo();
        int num = cus.size();
        for (int i = 0; i < num; ++i) {
            CtrlUnitInfo ctrlUnitInfo = cus.get(i);
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ctrlUnitInfo.getId()));
        }
        StringBuffer maskstring = new StringBuffer();
        for (int n = 0; n < filter.getFilterItems().size(); ++n) {
            if (n != filter.getFilterItems().size() - 1) {
                maskstring.append("#" + n + " or ");
                continue;
            }
            maskstring.append("#" + n);
        }
        filter.setMaskString(maskstring.toString());
        return filter;
    }

    public static void logicDelete(ListApplication application, String id) {
        BOSObjectType billType = BOSObjectType.create((String)application.getForm().getBosType());
        EntityObjectInfo bo = ListViewUtil.getEntity(billType);
        String tableName = bo.getTable().getName();
        try {
            MyRemoteObjectUtil.getInstance().execute(application.getContext(), "update " + tableName + " set FIsDeleted=1 where FID ='" + id + "'");
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    public static void logicDelete(ListApplication application) {
        String[] ids = null;
        try {
            ids = application.getListView().getSelectedBillIds();
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        ListViewUtil.logicDelete(application, ids);
    }

    public static void logicDelete(ListApplication application, String[] ids) {
        if (null == ids) {
            return;
        }
        BOSObjectType billType = BOSObjectType.create((String)application.getForm().getBosType());
        EntityObjectInfo bo = ListViewUtil.getEntity(billType);
        String tableName = bo.getTable().getName();
        for (int i = 0; i < ids.length; ++i) {
            String sql = "UPDATE " + tableName + " SET FIsDeleted=" + 1 + " WHERE FID='" + ids[i] + "'";
            try {
                MyRemoteObjectUtil.getInstance().execute(application.getContext(), sql);
                continue;
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        }
        application.showMessage("\u5220\u9664\u6210\u529f\uff01");
    }

    public static void logicDelete(ListApplication application, List ids) {
        ListViewUtil.logicDelete(application, CommonUtil.list2Array(ids));
    }

    public static FilterInfo buildRelatedFilterStr(ListApplication application, String relateBosTypeStr, String mainField, String fieldName) {
        IDynamicFormView parent = application.getDynamicFormView().getParentFormView();
        if (parent == null) {
            return null;
        }
        String parentId = (String)parent.getApplicationContext().getData("BillId");
        FilterInfo filterInfo = new FilterInfo();
        if (parentId == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id = '@#$%^&*()!#$$%&'"));
            return filterInfo;
        }
        BOSObjectType relateBosType = BOSObjectType.create((String)relateBosTypeStr);
        EntityObjectInfo bo = ListViewUtil.getEntity(relateBosType);
        String assTableName = bo.getTable().getName();
        if ("contract".equalsIgnoreCase(fieldName)) {
            fieldName = "contactor";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(  id in ( select assTable.F" + fieldName + "ID from " + assTableName + " assTable  where assTable.F" + mainField + "Id='");
        sb.append(parentId + "') )");
        filterInfo.getFilterItems().add(new FilterItemInfo(sb.toString()));
        return filterInfo;
    }

    public static String[] getFieldValues(CoreBaseCollection cll, String fieldName) {
        int size = cll.size();
        String[] ids = new String[size];
        for (int i = 0; i < size; ++i) {
            CoreBaseInfo cbi = cll.get(i);
            if (fieldName.equals("contract")) {
                fieldName = "contactor";
            }
            ids[i] = ((CoreBaseInfo)cbi.get(fieldName)).getId().toString();
        }
        return ids;
    }

    public static PropertyCollection getRelatedRecords(EntityObjectInfo entity_info) {
        PropertyCollection propertys = entity_info.getEntityProperties();
        PropertyCollection compostionProperies = new PropertyCollection();
        int size = propertys.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo info = propertys.get(i);
            if (!(info instanceof LinkPropertyInfo)) continue;
            try {
                RelationshipType relationship = ((LinkPropertyInfo)info).getRelationship().getLinkType(entity_info);
                if (!RelationshipType.COMPOSITION.equals((Object)relationship)) continue;
                compostionProperies.add(info);
                continue;
            }
            catch (Exception ex) {
                Logger.error((Throwable)ex);
            }
        }
        return compostionProperies;
    }

    public static IObjectPK[] beforeLog(ListApplication application, FormOperation fo) throws EASBizException, BOSException {
        fo.setLogEnabled(false);
        String[] ids = application.getListView().getSelectedBillIds();
        BOSObjectType billType = BOSObjectType.create((String)application.getForm().getBosType());
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)billType, ICoreBillBase.class);
        IObjectPK[] pks = new IObjectPK[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            pks[i] = OperationHelper.beforeLogSevice((FormOperation)fo, (IObjectValue)coreBase.getValue((IObjectPK)new ObjectUuidPK(ids[i])));
        }
        return pks;
    }

    public static void afterLog(ListApplication application, IObjectPK[] beforePks, String[] ids) throws EASBizException, BOSException {
        List filterPks = ListViewUtil.filterNull(beforePks);
        List filterIds = ListViewUtil.filterNull(ids);
        if (filterPks.isEmpty() || filterIds.isEmpty()) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(" id  in(" + CommonUtil.listToString(filterPks) + ")"));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSuccessed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("userID", (Object)ContextUtil.getCurrentUserInfo((Context)application.getContext()).getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("instanceId in(" + CommonUtil.listToString(filterIds) + ")"));
        IObjectPK[] pks = AppLogFactory.getRemoteInstance().getPKList(filterInfo, null);
        if (pks != null && pks.length == filterIds.size()) {
            CommonUtil.upateLogStatus(application.getContext(), pks);
        }
    }

    public static List filterNull(Object[] ids) {
        if (ids == null) {
            return new ArrayList(0);
        }
        ArrayList<Object> temp = new ArrayList<Object>();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            temp.add(ids[i]);
        }
        return temp;
    }

    public static IObjectPK[] beforeLog(ListApplication application, String operationName, String operationLabelName, String[] ids) throws EASBizException, BOSException {
        IObjectPK[] pks = new IObjectPK[ids.length];
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("number"));
        MyRemoteObjectUtil remoteObjectFacade = MyRemoteObjectUtil.getInstance();
        for (int i = 0; i < ids.length; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(ids[i]);
            IObjectValue objValue = remoteObjectFacade.load(ids[i], sc);
            pks[i] = LogUtil.beginLogWithDescription(null, (String)operationName, (BOSObjectType)objValue.getBOSType(), (IObjectPK)pk, (String)objValue.get("number").toString(), (String)operationLabelName);
        }
        return pks;
    }

    public static EntityObjectInfo getEntity(BOSObjectType bosType) {
        EntityObjectInfo info = null;
        try {
            if (!StringUtil.isEmpty((String)bosType.toString())) {
                info = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }
}

