/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);

    public static Object invokeGetterMethod(Object target, String propertyName) {
        String[] propertyNames = propertyName.split("\\.");
        if (propertyNames.length == 1) {
            String getterMethodName = "get" + StringUtils.capitalize((String)propertyName);
            return ReflectionUtils.invokeMethod(target, getterMethodName, new Class[0], new Object[0]);
        }
        for (int n = 0; n < propertyNames.length; ++n) {
            String getterMethodName = "get" + StringUtils.capitalize((String)propertyNames[n]);
            target = ReflectionUtils.invokeMethod(target, getterMethodName, new Class[0], new Object[0]);
        }
        return target;
    }

    public static void invokeSetterMethod(Object target, String propertyName, Object value) {
        ReflectionUtils.invokeSetterMethod(target, propertyName, value, null);
    }

    public static void invokeSetterMethod(Object target, String propertyName, Object value, Class propertyType) {
        Class<?> type = propertyType != null ? propertyType : value.getClass();
        String setterMethodName = "set" + StringUtils.capitalize((String)propertyName);
        ReflectionUtils.invokeMethod(target, setterMethodName, new Class[]{type}, new Object[]{value});
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + object + "]");
        }
        ReflectionUtils.makeAccessible(field);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38", (Object)e.getMessage());
        }
        return result;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        Field field = ReflectionUtils.getDeclaredField(object, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + object + "]");
        }
        ReflectionUtils.makeAccessible(field);
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38", (Object)e.getMessage());
        }
    }

    public static Object invokeMethod(Object object, String methodName, Class[] parameterTypes, Object[] parameters) {
        Method method = ReflectionUtils.getDeclaredMethod(object, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + object + "]");
        }
        method.setAccessible(true);
        try {
            return method.invoke(object, parameters);
        }
        catch (Exception e) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    protected static Field getDeclaredField(Object object, String fieldName) {
        for (Class<?> superClass = object.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    protected static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    protected static Method getDeclaredMethod(Object object, String methodName, Class[] parameterTypes) {
        for (Class<?> superClass = object.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static List convertElementPropertyToList(Collection collection, String propertyName) {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] arrays = collection.toArray();
        int length = arrays.length;
        try {
            for (int i = 0; i < length; ++i) {
                list.add(PropertyUtils.getProperty((Object)arrays[i], (String)propertyName));
            }
        }
        catch (Exception e) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(e);
        }
        return list;
    }

    public static String convertElementPropertyToString(Collection collection, String propertyName, String separator) {
        List list = ReflectionUtils.convertElementPropertyToList(collection, propertyName);
        return StringUtils.join((Object[])list.toArray(), (String)separator);
    }

    public static Object convertStringToObject(String value, Class toType) {
        try {
            return ConvertUtils.convert((String)value, (Class)toType);
        }
        catch (Exception e) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException("Reflection Exception.");
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException("Reflection Exception.", ((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }
}

