/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.form.model.command.CommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.plugins.util.CrmAuthUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractCRMBillPlugin
extends AbstractBillPlugin {
    protected static final String CT_CREATEUNIT_KEY = "ForgControlUnit";
    protected static final String CT_CREATETIME_KEY = "FCreateTime";
    protected static final String CT_AUDITOR_KEY = "FAuditor";
    protected static final String CT_AUDITTIME_KEY = "FAuditTime";
    protected static final String CT_LASTUPDATEUSER_KEY = "FLastUpdateUser";
    protected static final String CT_LASTUPDATETIME_KEY = "FLastUpdateTime";
    protected String crmPermissionKey;
    protected boolean enabledDirector;

    protected abstract boolean isEnableCRMPemission();

    public void afterBindData() throws EASBizException, BOSException {
        super.afterBindData();
        this.processCrmPermissionOnInit();
        this.doLockElementAfterBindData();
    }

    protected abstract void doLockElementAfterBindData() throws EASBizException, BOSException;

    protected void getFieldFilter(BaseDataFilterArg arg) throws EASBizException, BOSException {
        this.doGetFieldFilter(arg);
    }

    public abstract void doGetFieldFilter(BaseDataFilterArg var1) throws EASBizException, BOSException;

    protected void processCrmPermissionOnInit() throws EASBizException, BOSException {
        if (this.isEnableCRMPemission()) {
            this.initPermission();
            this.setDisplayFormat();
        }
    }

    private void initPermission() throws EASBizException, BOSException {
        String recordID = this.getBillID();
        if (recordID != null) {
            Context ctx = this.getContext();
            Map permissions = CRMPermissionHelper.getCRMPermissionMap(new String[]{recordID}, null, ctx);
            this.crmPermissionKey = (String)permissions.get(recordID);
        }
    }

    private void setDisplayFormat() throws EASBizException, BOSException {
        if (this.doCRMPermission()) {
            List relationKeys;
            Context ctx = this.getContext();
            List fieldKeys = CrmAuthUtil.getInstance(ctx).getUnAuthedUIComponentKeys("xr3oDk8uSgaJC/UmsKBrwJp+rpI=", 1, this.crmPermissionKey);
            if (fieldKeys != null && !fieldKeys.isEmpty()) {
                this.application.setMaskFieldList((ArrayList)fieldKeys);
            }
            if ((relationKeys = CrmAuthUtil.getInstance(ctx).getUnAuthedUIComponentKeys("xr3oDk8uSgaJC/UmsKBrwJp+rpI=", 2, this.crmPermissionKey)) != null && !relationKeys.isEmpty()) {
                for (int i = 0; i < relationKeys.size(); ++i) {
                    this.application.hideElement((String)relationKeys.get(i), true);
                }
            }
        }
    }

    public void afterCreateNewData() throws EASBizException, BOSException {
        super.afterCreateNewData();
        this.application.setValue(CT_CREATEUNIT_KEY, (Object)ContextUtil.getCurrentCtrlUnit((Context)this.getContext()), 0);
        this.application.setValue(CT_CREATETIME_KEY, (Object)new Date(), 0);
    }

    public void fireButtonClick(CommandArg arg) throws EASBizException, BOSException {
        super.fireButtonClick(arg);
        if (this.getBillID() != null && this.doCRMPermission()) {
            this.checkCRMPermissionBeforeOperation(arg);
        }
    }

    private void checkCRMPermissionBeforeOperation(CommandArg arg) throws EASBizException, BOSException {
        List buttonKeys = CrmAuthUtil.getInstance(this.getContext()).getUnAuthedUIComponentKeys("xr3oDk8uSgaJC/UmsKBrwJp+rpI=", 0, this.crmPermissionKey);
        for (int i = 0; i < buttonKeys.size(); ++i) {
            String key = (String)buttonKeys.get(i);
            if (!key.equalsIgnoreCase(arg.getKey())) continue;
            throw new BOSException("\u6ca1\u6709\u6743\u9650\u3002");
        }
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        ObjectBaseInfo ob;
        if (("Save".equalsIgnoreCase(operation.getOperation()) || "Submit".equalsIgnoreCase(operation.getOperation())) && (ob = (ObjectBaseInfo)this.application.getBillModel().getBillValue()).getId() != null) {
            this.application.setValue(CT_LASTUPDATEUSER_KEY, (Object)ContextUtil.getCurrentUserInfo((Context)this.getContext()), 0);
            this.application.setValue(CT_LASTUPDATETIME_KEY, (Object)new Date(), 0);
        }
        return super.beforeOperation(operation);
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        super.afterOperation(operation);
        if ("Audit".equalsIgnoreCase(operation.getOperation())) {
            this.application.setValue(CT_AUDITOR_KEY, (Object)ContextUtil.getCurrentUserInfo((Context)this.getContext()), 0);
            this.application.setValue(CT_AUDITTIME_KEY, (Object)new Date(), 0);
            this.application.save();
        }
        if ("Copy".equalsIgnoreCase(operation.getOperation())) {
            this.application.setValue(CT_AUDITOR_KEY, null, 0);
            this.application.setValue(CT_AUDITTIME_KEY, null, 0);
        }
    }

    protected final boolean doCRMPermission() {
        if (this.isEnableCRMPemission()) {
            return this.crmPermissionKey != null && !this.enabledDirector;
        }
        return false;
    }

    protected final Context getContext() {
        return this.application.getContext();
    }

    protected final void setData(String key, Object o) {
        this.application.getApplicationContext().putData(key, o);
    }

    protected final Object getParentData(String key) {
        IDynamicFormView parent = this.application.getDynamicFormView().getParentFormView();
        if (parent != null) {
            return parent.getApplicationContext().getData(key);
        }
        return null;
    }

    protected final String getBillID() {
        ObjectBaseInfo billValue = (ObjectBaseInfo)this.application.getBillModel().getBillValue();
        return billValue.getId() == null ? null : billValue.getId().toString();
    }

    protected final String getPermissionName(String operationName) {
        FormOperation operation = this.application.getForm().getOperation(operationName);
        return operation == null ? "" : operation.getPermissionItem();
    }

    protected final boolean isNewBill() {
        ObjectBaseInfo obj = (ObjectBaseInfo)this.application.getBillModel().getBillValue();
        return obj == null || obj.getId() == null;
    }

    protected final void lockSameRowElements(String[] keys, int row) {
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                this.application.lockElement(keys[i], row, true);
            }
        }
    }

    protected final void unLockSameRowElements(String[] keys, int row) {
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                this.application.lockElement(keys[i], row, false);
            }
        }
    }
}

