/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.CommandArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.plugins.support.DefaultValueHelper;
import com.kingdee.eas.scm.crm.plugins.support.FilterHelper;
import com.kingdee.eas.scm.crm.plugins.support.defaultValue.SaleDefaultValueHelper;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.MyRemoteObjectUtil;
import com.kingdee.eas.scm.crm.sm.BusinOpportInfo;
import com.kingdee.eas.scm.crm.sm.ClueInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDistributePlugin
extends AbstractBillPlugin {
    protected static final String CT_SELLER_KEY = "FbdUser";
    protected static final String CT_SALEORG_KEY = "ForgSaleOrgUnit";
    protected static final String CT_SALEGROUP_KEY = "FbdSaleGroup";
    protected static final String CT_DEPARTMENT_KEY = "ForgDepartment";
    protected static final String CT_USER_KEY = "FbdUser";
    private static final String CT_COMPANTYORGUNIT_KEY = "ForgCompanyOrgUnit";
    private StringBuffer alert = new StringBuffer();
    private List billIDs;
    protected static final String BTN_DISTRIBUTE = "FbtnAssign";

    public void onLoad() {
        try {
            String permissionItem;
            super.onLoad();
            IDynamicFormView listParentView = this.application.getDynamicFormView().getParentFormView();
            if (listParentView != null && (permissionItem = String.valueOf(this.getParentData("permissionName"))) != null) {
                FilterHelper.setSaleOrgFilter((DynamicFormApplication)this.application, new String[]{CT_SALEORG_KEY}, permissionItem);
            }
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
    }

    protected final Object getParentData(String key) {
        IDynamicFormView parent = this.application.getDynamicFormView().getParentFormView();
        if (parent != null) {
            return parent.getApplicationContext().getData(key);
        }
        return null;
    }

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        this.initIdsByCrmPermission();
        return super.onInitialize(param);
    }

    private void initIdsByCrmPermission() throws BOSException, EASBizException {
        String[] ids = CommonUtil.initBillIDsForOpenWindow(this.application);
        Context ctx = this.application.getContext();
        if (ids != null && ids.length > 0) {
            List directorIDs = null;
            List noAdminList = null;
            if (this.isEnableCrmPermission() && this.getBosObjectType() != null) {
                BOSObjectType bosType = this.getBosObjectType();
                noAdminList = CRMPermissionHelper.getNoResponsibleIDs(CommonUtil.array2List(ids), ctx, bosType);
                directorIDs = CRMPermissionHelper.getDataPermissionRecordIDs(this.getPermissionName(), ctx, bosType);
            }
            ArrayList<String> l = new ArrayList<String>();
            List closeList = this.getCloseList(ids);
            boolean successAll = true;
            int successId = 0;
            int failedID = 0;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i];
                if (this.isEnableCrmPermission() && !directorIDs.contains(id) && noAdminList.contains(id)) {
                    successAll = false;
                    ++failedID;
                    sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(i + 1).append("\u3001\u53ea\u6709\u5355\u636e\u7684\u8d1f\u8d23\u4eba\u624d\u80fd\u64cd\u4f5c\u5f53\u524d\u529f\u80fd<br>");
                    continue;
                }
                if (closeList.contains(id)) {
                    successAll = false;
                    ++failedID;
                    sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(i + 1).append("\u3001\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u5206\u914d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458<br>");
                    continue;
                }
                l.add(id);
                ++successId;
                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(i + 1).append("\u3001\u5206\u914d\u6210\u529f <br>");
            }
            if (!l.isEmpty()) {
                this.billIDs = l;
            }
            this.alert.append("\u6210\u529f\u5206\u914d").append(successId).append("\u6761\u8bb0\u5f55\uff0c\u5931\u8d25").append(failedID).append("\u6761\u3002");
            if (!successAll) {
                this.alert.append("<br><br>\u8be6\u7ec6\u4fe1\u606f\uff1a<br>").append(sb.toString());
            }
        }
    }

    private List getAuditList(String[] ids) throws BOSException {
        ArrayList<String> l = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FId from ").append(this.application.getBillModel().getBusinessInfo().getEntity(0).getTableName()).append(" where FId in (");
        for (int i = 0; i < ids.length; ++i) {
            sql.append("'").append(ids[i]).append("',");
        }
        sql.append(")");
        if (sql.indexOf(",") != -1) {
            sql.deleteCharAt(sql.lastIndexOf(","));
        }
        sql.append(" and FBillStatus=4");
        IRowSet idSet = MyRemoteObjectUtil.getInstance().executeQuery(this.application.getContext(), sql.toString());
        try {
            if (idSet != null) {
                while (idSet.next()) {
                    l.add(idSet.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return l;
    }

    private List getCloseList(String[] ids) throws BOSException {
        ArrayList<String> l = new ArrayList<String>();
        String bosType = this.application.getBillModel().getBusinessInfo().getEntity(0).getBosType();
        if (!bosType.equals(new ClueInfo().getBOSType().toString()) && !bosType.equals(new BusinOpportInfo().getBOSType().toString())) {
            return l;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FId from ").append(this.application.getBillModel().getBusinessInfo().getEntity(0).getTableName()).append(" where FId in (");
        for (int i = 0; i < ids.length; ++i) {
            sql.append("'").append(ids[i]).append("',");
        }
        sql.append(")");
        if (sql.indexOf(",") != -1) {
            sql.deleteCharAt(sql.lastIndexOf(","));
        }
        sql.append(" and FexecuteStatus>3 ");
        IRowSet idSet = MyRemoteObjectUtil.getInstance().executeQuery(this.application.getContext(), sql.toString());
        try {
            if (idSet != null) {
                while (idSet.next()) {
                    l.add(idSet.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return l;
    }

    public void afterCreateNewData() throws EASBizException, BOSException {
        super.afterCreateNewData();
        DefaultValueHelper.setDefaultValueForSale(this.application, "FbdUser", null, CT_SALEORG_KEY, null, false);
        SaleDefaultValueHelper.setSaleGroupValue(this.application, null, CT_SALEGROUP_KEY);
    }

    public void dataChanged(DataChangeCommandArg arg) {
        super.dataChanged(arg);
        if (CT_SALEORG_KEY.equalsIgnoreCase(arg.getKey()) || "FbdUser".equalsIgnoreCase(arg.getKey())) {
            try {
                this.application.setValue(CT_SALEGROUP_KEY, null, 0);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public void fireButtonClick(CommandArg arg) throws EASBizException, BOSException {
        super.fireButtonClick(arg);
        if (BTN_DISTRIBUTE.equalsIgnoreCase(arg.getKey())) {
            if (this.billIDs != null) {
                this.doDistribute(this.application, this.billIDs);
            }
            this.application.showConfirm("close", "", this.alert.toString(), 0);
        } else {
            this.application.close();
        }
    }

    protected abstract void doDistribute(BillApplication var1, List var2) throws EASBizException, BOSException;

    protected abstract String getPermissionName();

    protected abstract boolean isEnableCrmPermission();

    protected BOSObjectType getBosObjectType() {
        return null;
    }

    public void afterConfirm(String id, int returnOption) throws EASBizException, BOSException {
        if ("close".equalsIgnoreCase(id)) {
            this.application.setParentRefresh(true);
            this.application.close();
        }
        super.afterConfirm(id, returnOption);
    }
}

