/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.bs;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.bs.SaleStageFactory;
import com.kingdee.eas.scm.crm.bs.SaleStageInfo;
import com.kingdee.eas.scm.crm.plugins.bill.bs.AbstractBSModulerBillPlugin;
import com.kingdee.eas.scm.crm.plugins.support.filter.EnableHelper;
import com.kingdee.eas.scm.crm.plugins.util.BusinessException;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SaleStageBillPlugin
extends AbstractBSModulerBillPlugin {
    private static final String CT_STAGESEQNO_KEY = "FSEQNO";
    private List ids = null;
    private String status;
    private String fieldName = "FIsEnabled";

    public void checkSeqNoUniq(DataChangeCommandArg dataChangeCommandArg) {
        if (CT_STAGESEQNO_KEY.equals(dataChangeCommandArg.getKey())) {
            String seqNumValue = (String)dataChangeCommandArg.getNewValue();
            this.checkSeqNumUniqAndShowMsg(seqNumValue);
        }
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        SaleStageInfo saleStageInfo;
        if (!(!operation.getOperation().equals("Save") && !operation.getOperation().equals("Submit") || this.checkStageNameUniqAndShowMsg((saleStageInfo = (SaleStageInfo)this.application.getBillModel().getBillValue()).getName()) && this.checkSeqNumUniqAndShowMsg(String.valueOf(saleStageInfo.getSeqNum())))) {
            return false;
        }
        return super.beforeOperation(operation);
    }

    private boolean checkSeqNumUniqAndShowMsg(String seqNumValue) {
        if (StringUtils.isEmpty((String)seqNumValue)) {
            return true;
        }
        boolean isExits = false;
        SaleStageInfo saleStageInfo = (SaleStageInfo)this.application.getBillModel().getBillValue();
        StringBuffer filterStr = new StringBuffer("select id  where  seqNum = " + seqNumValue + " and IsDeleted = 0");
        if (saleStageInfo.getId() != null) {
            filterStr.append(" and  id<>'" + saleStageInfo.getId().toString() + "'");
        }
        try {
            isExits = SaleStageFactory.getRemoteInstance().exists(filterStr.toString());
        }
        catch (EASBizException e) {
            throw new BusinessException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new BusinessException(e.getMessage(), e);
        }
        if (isExits) {
            this.application.showMessage("\u9636\u6bb5\u987a\u5e8f\u53f7\u91cd\u590d\uff0c\u8bf7\u60a8\u91cd\u65b0\u8f93\u5165\u3002");
            return false;
        }
        return true;
    }

    private boolean checkStageNameUniqAndShowMsg(String stageName) {
        if (StringUtils.isEmpty((String)stageName)) {
            return true;
        }
        boolean isExits = false;
        SaleStageInfo saleStageInfo = (SaleStageInfo)this.application.getBillModel().getBillValue();
        StringBuffer filterStr = new StringBuffer("select id  where  name = '" + stageName + "'  and IsDeleted = 0 ");
        if (saleStageInfo.getId() != null) {
            filterStr.append(" and  id<>'" + saleStageInfo.getId().toString() + "'");
        }
        try {
            isExits = SaleStageFactory.getRemoteInstance().exists(filterStr.toString());
        }
        catch (EASBizException e) {
            throw new BusinessException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new BusinessException(e.getMessage(), e);
        }
        if (isExits) {
            this.application.showMessage("\u9636\u6bb5\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u60a8\u91cd\u65b0\u8f93\u5165\u3002");
            return false;
        }
        return true;
    }

    public void setEnabledAction() throws EASBizException, BOSException {
        this.status = "1";
        this.ids = new ArrayList(1);
        SaleStageInfo typeInfo = (SaleStageInfo)this.application.getBillModel().getBillValue();
        if (typeInfo.isIsEnabled()) {
            this.application.showMessage("\u53ea\u6709\u7981\u7528\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u542f\u7528\u3002");
            return;
        }
        this.ids.add(typeInfo.getId().toString());
        EnableHelper.setIsEnabled(this.getContext(), this.ids, this.getTableName(), this.fieldName, this.status);
        this.application.showMessage("\u542f\u7528\u64cd\u4f5c\u6210\u529f\u3002");
        this.application.getBillView().refresh();
    }

    public void setDisabledAction() throws EASBizException, BOSException, SQLException {
        this.status = "0";
        this.ids = new ArrayList(1);
        SaleStageInfo typeInfo = (SaleStageInfo)this.application.getBillModel().getBillValue();
        if (!typeInfo.isIsEnabled()) {
            this.application.showMessage("\u53ea\u6709\u542f\u7528\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u7981\u7528\u3002");
            return;
        }
        this.ids.add(typeInfo.getId().toString());
        List filterList = EnableHelper.setIsEnabledFilter((DynamicFormApplication)this.application, this.ids, this.getTableName(), this.status);
        if (filterList.size() < 1) {
            this.application.showMessage("\u9500\u552e\u9636\u6bb5\u88ab\u5f15\u7528\u4e0d\u80fd\u7981\u7528\u3002");
            return;
        }
        this.ids.add(typeInfo.getId().toString());
        EnableHelper.setIsEnabled(this.getContext(), this.ids, this.getTableName(), this.fieldName, this.status);
        this.application.showMessage("\u7981\u7528\u64cd\u4f5c\u6210\u529f\u3002");
        this.application.getBillView().refresh();
    }

    private String getTableName() {
        return this.application.getBillModel().getBusinessInfo().getEntity(0).getTableName();
    }

    public boolean isEnableCRMPermission() {
        return false;
    }

    protected boolean isCRMBaseData() {
        return true;
    }
}

