/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.model.IDynamicFormModel;
import com.kingdee.eas.base.form.model.bill.IBillModel;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.common.CrmPermissionItemCollection;
import com.kingdee.eas.scm.crm.common.CrmPermissionItemFactory;
import com.kingdee.eas.scm.crm.common.CrmPermissionItemInfo;
import com.kingdee.eas.scm.crm.common.CrmRoleCollection;
import com.kingdee.eas.scm.crm.common.CrmRoleFactory;
import com.kingdee.eas.scm.crm.common.CrmRoleInfo;
import com.kingdee.eas.scm.crm.common.FormInfo;
import com.kingdee.eas.scm.crm.common.ICrmRole;
import com.kingdee.eas.scm.crm.common.RoleTypeEnum;
import com.kingdee.eas.scm.crm.plugins.bill.AbstractCRMModuleBillPlugin;
import com.kingdee.eas.scm.crm.plugins.util.BusinessException;
import com.kingdee.eas.scm.crm.plugins.util.CrmAuthUtil;
import com.kingdee.eas.scm.crm.sm.BusinOpportInfo;
import java.text.ParseException;

public class CrmRoleBillPlugin
extends AbstractCRMModuleBillPlugin {
    private static final String CT_F7FORMTYPE_KEY = "F7FromType";

    protected void carrayValueAfterDataChanged(DataChangeCommandArg arg) throws EASBizException, BOSException {
    }

    protected void changeFilterAfterDataChanged(DataChangeCommandArg arg) throws EASBizException, BOSException {
    }

    public void doAfterCreateNewData() throws EASBizException, BOSException {
        this.initUiComponent();
    }

    public void doAfterDataChanged(DataChangeCommandArg arg) throws EASBizException, BOSException {
        this.billTypedataChanged(arg);
    }

    protected void doOnLoad() throws EASBizException, BOSException {
        this.initUiComponent();
    }

    protected void setDefaultValueAfterCreateNewData() throws EASBizException, BOSException {
    }

    protected void setFilterOnLoad() throws EASBizException, BOSException {
    }

    protected void storeShareDataOnLoad() throws EASBizException, BOSException {
    }

    private void initUiComponent() {
        String formId;
        CrmPermissionItemCollection crmPermissionItemCollection = null;
        CrmRoleInfo crmRoleInfo = (CrmRoleInfo)this.application.getBillModel().getBillValue();
        if ((String)this.getParentData("BillId") == null) {
            crmRoleInfo.setType(RoleTypeEnum.SYSTEMROLE);
        } else {
            formId = (String)this.getParentData("crm_role_type");
            this.application.lockElement(CT_F7FORMTYPE_KEY, true);
            try {
                this.application.setFieldFilter(CT_F7FORMTYPE_KEY, "id = '" + formId + "'");
            }
            catch (BOSException e) {
                throw new BusinessException(e);
            }
            crmRoleInfo.setType(RoleTypeEnum.CUSTOMROLE);
        }
        if (null != crmRoleInfo.getId()) {
            crmPermissionItemCollection = this.getAvalilblePermissionItemsByFormId(crmRoleInfo.getForm().getId());
            crmRoleInfo.put("crmPermissionItem", (Object)crmPermissionItemCollection);
            CrmAuthUtil.getInstance(this.application.getContext()).initCrmPermissionItemCollectionAuthed(crmRoleInfo.getCrmPermissionItem(), crmRoleInfo.getPermissionKey());
        } else if (this.getParentData("BillId") != null) {
            formId = (String)this.getParentData("crm_role_type");
            crmPermissionItemCollection = this.getAvalilblePermissionItemsByFormId(BOSUuid.read((String)formId));
            FormInfo form = new FormInfo();
            form.setId(BOSUuid.read((String)formId));
            try {
                this.application.setValue(CT_F7FORMTYPE_KEY, (Object)form, 0);
            }
            catch (EASBizException e) {
                throw new BusinessException(e);
            }
            catch (BOSException e) {
                throw new BusinessException(e);
            }
            crmRoleInfo.put("crmPermissionItem", (Object)crmPermissionItemCollection);
            this.initCrmPermissionItemEntries(crmRoleInfo.getCrmPermissionItem());
        }
        IBillModel ibillModel = this.application.getBillModel();
        try {
            ibillModel.setBillValue((IObjectValue)crmRoleInfo);
            try {
                this.application.getBillView().bindData((IDynamicFormModel)ibillModel);
            }
            catch (JSONException e) {
                throw new BusinessException(e);
            }
            catch (ParseException e) {
                throw new BusinessException(e);
            }
        }
        catch (EASBizException e) {
            throw new BusinessException(e);
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
    }

    public void billTypedataChanged(DataChangeCommandArg dataChangeCommandArg) {
        try {
            CrmPermissionItemCollection crmPermissionItemCollection = null;
            if (CT_F7FORMTYPE_KEY.equalsIgnoreCase(dataChangeCommandArg.getKey())) {
                CrmRoleInfo crmRoleInfo = (CrmRoleInfo)this.application.getBillModel().getBillValue();
                if (null != crmRoleInfo && null != dataChangeCommandArg.getNewValue()) {
                    crmPermissionItemCollection = this.getAvalilblePermissionItemsByFormId(((FormInfo)dataChangeCommandArg.getNewValue()).getId());
                    if (crmRoleInfo.getId() != null) {
                        CrmRoleInfo crmRole = CrmRoleFactory.getRemoteInstance().getCrmRoleInfo((IObjectPK)new ObjectUuidPK(crmRoleInfo.getId()));
                        if (crmRole.getForm().getId().equals((Object)crmRoleInfo.getForm().getId())) {
                            CrmAuthUtil.getInstance(this.application.getContext()).initCrmPermissionItemCollectionAuthed(crmPermissionItemCollection, crmRole.getPermissionKey());
                        } else {
                            this.initCrmPermissionItemEntries(crmPermissionItemCollection);
                        }
                    } else {
                        this.initCrmPermissionItemEntries(crmPermissionItemCollection);
                    }
                    crmRoleInfo.put("crmPermissionItem", (Object)crmPermissionItemCollection);
                }
                this.application.getView().bindData((IDynamicFormModel)this.application.getBillModel());
            }
        }
        catch (EASBizException e) {
            throw new BusinessException(e);
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
        catch (JSONException e) {
            throw new BusinessException(e);
        }
        catch (ParseException e) {
            throw new BusinessException(e);
        }
    }

    public boolean beforeSaveOrSubmitData() {
        CrmRoleInfo crmRoleInfo = (CrmRoleInfo)this.application.getBillModel().getBillValue();
        if (!this.isRoleNameIsSystemUniq(crmRoleInfo)) {
            this.application.showMessage("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\u3002");
            return false;
        }
        CrmAuthUtil cau = CrmAuthUtil.getInstance(this.application.getContext());
        String permissionKeyStr = cau.generatePermmissionKeyStr(crmRoleInfo.getCrmPermissionItem());
        crmRoleInfo.put("crmPermissionItem", null);
        crmRoleInfo.setPermissionKey(permissionKeyStr);
        if (null != this.getParentData("BillId")) {
            BusinOpportInfo record = new BusinOpportInfo();
            record.setId(BOSUuid.read((String)((String)this.getParentData("BillId"))));
            crmRoleInfo.setRecord(record);
        }
        try {
            ICrmRole icrmRole = CrmRoleFactory.getRemoteInstance();
            icrmRole.addNewRecord(crmRoleInfo);
            this.initUiComponent();
            this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u6210\u529f\u3002");
        }
        catch (EASBizException e) {
            throw new BusinessException(e);
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
        return false;
    }

    private boolean checkRoleNameUniq(BOSUuid formId, String roleName, int roleType, BOSUuid crmRoleId) {
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            viewInfo.getSelector().add(new SelectorItemInfo(" id "));
            if (roleType == 1 || roleType == 0 || roleType == -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo("form", (Object)formId, CompareType.EQUALS));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(roleType), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)roleName, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDeleted", (Object)new Integer(0), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            CrmRoleCollection crmRoleCollection = CrmRoleFactory.getRemoteInstance().getCrmRoleCollection(viewInfo);
            if (null != crmRoleId && null != crmRoleCollection && crmRoleCollection.size() == 1) {
                return crmRoleId.equals((Object)crmRoleCollection.get(0).getId());
            }
            return null == crmRoleCollection || crmRoleCollection.size() == 0;
        }
        catch (BOSException e) {
            throw new BusinessException("can't instance ICrmRole db erro", e);
        }
    }

    private void initCrmPermissionItemEntries(CrmPermissionItemCollection crmPermissionItemCollection) {
        int size = crmPermissionItemCollection.size();
        CrmPermissionItemInfo crmPermissionItemInfo = null;
        for (int i = 0; i < size; ++i) {
            crmPermissionItemInfo = crmPermissionItemCollection.get(i);
            crmPermissionItemInfo.setSeq(i + 1);
            crmPermissionItemInfo.setIsEnabled(false);
        }
    }

    private boolean isRoleNameIsSystemName(CrmRoleInfo crmRoleInfo) {
        return crmRoleInfo.getType().getValue() != -1 && !"Admin".equalsIgnoreCase(crmRoleInfo.getName()) && !"\u67e5\u770b".equalsIgnoreCase(crmRoleInfo.getName());
    }

    private boolean isRoleNameIsSystemUniq(CrmRoleInfo crmRoleInfo) {
        return this.checkRoleNameUniq(crmRoleInfo.getForm().getId(), crmRoleInfo.getName(), crmRoleInfo.getType().getValue(), crmRoleInfo.getId());
    }

    private CrmPermissionItemCollection getAvalilblePermissionItemsByFormId(BOSUuid formId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.getSelector().add(new SelectorItemInfo(" * "));
        filterInfo.getFilterItems().add(new FilterItemInfo("form.id", (Object)formId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)new Boolean(true), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        CrmPermissionItemCollection crmPermissionItemCollection = null;
        try {
            crmPermissionItemCollection = CrmPermissionItemFactory.getRemoteInstance().getCrmPermissionItemCollection(viewInfo.toString() + " order by permissionCode");
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
        return crmPermissionItemCollection;
    }

    protected boolean isEnableCRMPemission() {
        return false;
    }
}

