/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.common.BillStatusEnum;
import com.kingdee.eas.scm.crm.common.InitialStateEnum;
import com.kingdee.eas.scm.crm.common.SystemInitializationCollection;
import com.kingdee.eas.scm.crm.common.SystemInitializationFactory;
import com.kingdee.eas.scm.crm.common.SystemInitializationInfo;
import com.kingdee.eas.scm.crm.customer.CustomerCompanyInfoFactory;
import com.kingdee.eas.scm.crm.customer.CustomerInfo;
import com.kingdee.eas.scm.crm.customer.CustomerSaleInfoFactory;
import com.kingdee.eas.scm.crm.plugins.bill.common.SyncBaseData;
import com.kingdee.eas.scm.crm.plugins.bill.common.SyncToEASException;
import com.kingdee.eas.util.app.ContextUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;

public class SystemInitBillPlugin
extends AbstractBillPlugin {
    private static final String BTN_INIT_KEY = "Fbtn";
    private static final String CT_SYSSTATE_KEY = "Flist";
    private static final String CT_CREATOR_KEY = "Fbasedata";
    private static final String CT_CREATORTIME_KEY = "Fdate";
    private static int status;
    private SystemInitializationCollection coll;

    public final void afterCreateNewData() throws EASBizException, BOSException {
        super.afterCreateNewData();
        this.setDefaultValue();
    }

    public void afterBindData() throws EASBizException, BOSException {
        this.lockElementOnInitalize();
    }

    public void lockElementOnInitalize() throws EASBizException, BOSException {
        if (this.coll != null && this.coll.size() != 0) {
            this.application.lockElement(BTN_INIT_KEY, true);
            this.application.lockElement(CT_SYSSTATE_KEY, true);
            this.application.lockElement(CT_CREATOR_KEY, true);
            this.application.lockElement(CT_CREATORTIME_KEY, true);
        }
    }

    public void setDefaultValue() throws EASBizException, BOSException {
        this.coll = SystemInitializationFactory.getRemoteInstance().getSystemInitializationCollection();
        if (this.coll != null && this.coll.size() != 0) {
            SystemInitializationInfo info = this.coll.get(0);
            this.application.setValue(CT_SYSSTATE_KEY, (Object)new Integer(1), 0);
            this.application.setValue(CT_CREATOR_KEY, (Object)info.getCreator(), 0);
            this.application.setValue(CT_CREATORTIME_KEY, (Object)info.getCreateTime(), 0);
        } else {
            this.application.setValue(CT_SYSSTATE_KEY, (Object)new Integer(0), 0);
        }
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        super.doCustomOperation(operation);
        try {
            MethodUtils.invokeMethod((Object)((Object)this), (String)(operation + "Action"), null);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException("\u8bf7\u68c0\u67e5\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u662f\u5426\u8bbe\u7f6e\u6b63\u786e\u3002", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException("\u8bf7\u68c0\u67e5\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u662f\u5426\u8bbe\u7f6e\u6b63\u786e\u3002", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException("\u8bf7\u68c0\u67e5\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u662f\u5426\u8bbe\u7f6e\u6b63\u786e\u3002", (Throwable)e);
        }
    }

    public void initCrmCustomerAction() throws SyncToEASException {
        if (status != 0) {
            this.application.showMessage("\u6b63\u5728\u521d\u59cb\u5316\u4e2d\u3002");
            return;
        }
        try {
            status = 1;
            HashMap<String, String> propertyMapping = new HashMap<String, String>();
            propertyMapping.put("parent", "parent");
            propertyMapping.put("customerGroupDetails:parent", "customerGroupDetails:parent");
            HashMap<String, Object> specifiedValues = new HashMap<String, Object>();
            specifiedValues.put("isInsideCust", new Boolean(true));
            specifiedValues.put("billStatus", (Object)BillStatusEnum.AUDITED);
            specifiedValues.put("dataSource", "EAS\u5ba2\u6237\u5bfc\u5165");
            specifiedValues.put("creator", new UserInfo());
            specifiedValues.put("handler", ContextUtil.getCurrentUserInfo((Context)this.application.getContext()));
            specifiedValues.put("person", ContextUtil.getCurrentUserInfo((Context)this.application.getContext()).getPerson());
            Map idMap = SyncBaseData.copyAllCoreBaseDataToDB(CustomerInfo.class, com.kingdee.eas.basedata.master.cssp.CustomerInfo.class, null, propertyMapping, specifiedValues);
            if (!idMap.isEmpty()) {
                propertyMapping.clear();
                propertyMapping.put("customer", "customer");
                propertyMapping.put("deliveryAddresses:customerSaleInfo", "deliveryAddresses:customerSaleInfo");
                CoreBaseCollection saleInfos = SyncBaseData.copyAllCoreBaseData(com.kingdee.eas.scm.crm.customer.CustomerSaleInfoInfo.class, CustomerSaleInfoInfo.class, new String[]{"id", "settlementOrgUnit", "billingOrgUnit", "deliverOrgUnit"}, propertyMapping, null);
                this.setCRMCustomer(saleInfos, idMap, "customer");
                propertyMapping.clear();
                propertyMapping.put("customer", "customer");
                CoreBaseCollection fiInfos = SyncBaseData.copyAllCoreBaseData(com.kingdee.eas.scm.crm.customer.CustomerCompanyInfoInfo.class, CustomerCompanyInfoInfo.class, new String[]{"id"}, propertyMapping, null);
                this.setCRMCustomer(fiInfos, idMap, "customer");
                CustomerSaleInfoFactory.getRemoteInstance().addnew(saleInfos);
                CustomerCompanyInfoFactory.getRemoteInstance().addnew(fiInfos);
            }
            SystemInitializationInfo info = (SystemInitializationInfo)this.application.getBillValue();
            info.setInitialState(InitialStateEnum.INITIALIZED);
            this.application.save();
            this.application.showMessage("\u521d\u59cb\u5316\u6210\u529f\u3002");
        }
        catch (EASBizException e) {
            status = 0;
            throw new SyncToEASException("\u521d\u59cb\u5316\u5931\u8d25\u3002", e);
        }
        catch (BOSException e) {
            status = 0;
            throw new SyncToEASException("\u521d\u59cb\u5316\u5931\u8d25\u3002", e);
        }
    }

    private void setCRMCustomer(CoreBaseCollection coll, Map m, String propName) {
        for (int i = 0; i < coll.size(); ++i) {
            CoreBaseInfo info = coll.get(i);
            CustomerInfo oldCustomer = (CustomerInfo)info.get(propName);
            String newId = (String)m.get(oldCustomer.getId().toString());
            if (newId == null) continue;
            CustomerInfo newCustomer = new CustomerInfo();
            newCustomer.setId(BOSUuid.read((String)newId));
            info.put(propName, (Object)newCustomer);
        }
    }
}

