/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.customer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.common.BillStatusEnum;
import com.kingdee.eas.scm.crm.customer.CustomerConversionFactory;
import com.kingdee.eas.scm.crm.customer.CustomerConversionInfo;
import com.kingdee.eas.scm.crm.customer.CustomerFactory;
import com.kingdee.eas.scm.crm.customer.CustomerInfo;
import com.kingdee.eas.scm.crm.plugins.bill.customer.CustomerBillPlugin;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.commons.lang.StringUtils;

public class CustomerConversionBillPlugin
extends CustomerBillPlugin {
    private com.kingdee.eas.basedata.master.cssp.CustomerInfo easCustomer;
    private CoreBaseCollection crmCustomers;
    private boolean converting;

    public void storeShareDataOnInitalize() throws EASBizException, BOSException {
        super.storeShareDataOnInitalize();
        CustomerConversionInfo info = (CustomerConversionInfo)this.application.getBillValue();
        this.storeDataInPageScope("BillStatus", (Object)info.getBillStatus());
    }

    protected String getPermRelProp() {
        return "customerConversion";
    }

    protected String getDistributeShareUserPermissionName() {
        return "crm_customerConversion_distributePerson";
    }

    protected String getDistributeUserPermissionName() {
        return "crm_customerConversion_distributUser";
    }

    protected String getRecycleSharerUserPermissionName() {
        return "crm_customerConversion_recyclePerson";
    }

    protected String getRecycleUserPermissionName() {
        return "crm_customerConversion_recycleUser";
    }

    public void convertAction() throws BOSException, EASBizException {
        CustomerConversionInfo info = (CustomerConversionInfo)this.application.getBillValue();
        ObjectUuidPK pk = new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)this.getContext()).getId());
        String param = ParamManager.getParamValue(null, (IObjectPK)pk, (String)"CRM_CustomerConversion0003");
        if (StringUtils.isEmpty((String)info.getTaxRegisterNo())) {
            this.application.showMessage("\u7a0e\u52a1\u767b\u8bb0\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return;
        }
        if (param != null && Boolean.TRUE.toString().equals(param) && info.getBillStatus() != BillStatusEnum.AUDITED) {
            this.application.showMessage("\u8bf7\u5148\u5ba1\u6838\u5355\u636e\u3002");
            return;
        }
        if (info.isIsInsideCust()) {
            this.application.showMessage("\u8f6c\u6b63\u5355\u5df2\u7ecf\u505a\u8fc7\u8f6c\u5165\u5904\u7406\u3002");
            return;
        }
        this.crmCustomers = CustomerFactory.getRemoteInstance().getCollection("select id where customerConversion.id='" + info.getId() + "'");
        if (this.crmCustomers != null && this.crmCustomers.size() == 0) {
            this.application.showMessage("\u8f6c\u6b63\u5355\u6ca1\u6709\u5173\u8054\u5ba2\u6237\u6863\u6848\uff0c\u8bf7\u5148\u5173\u8054\u81f3\u5c11\u4e00\u4e2a\u5ba2\u6237\u6863\u6848\u3002");
            return;
        }
        ICustomer customer = com.kingdee.eas.basedata.master.cssp.CustomerFactory.getRemoteInstance();
        CustomerCollection coll = customer.getCustomerCollection("select id where name='" + info.getName() + "' or number='" + info.getNumber() + "'");
        if (coll.size() == 1) {
            this.easCustomer = coll.get(0);
            this.application.showConfirm("checkNumberDup", "\u63d0\u793a", info.getName() + "\u5ba2\u6237\u4e0e\u8f6c\u6b63\u5ba2\u6237\u91cd\u590d\uff0c\u662f\u5426\u9700\u8981\u5173\u8054\u8be5\u5ba2\u6237\uff1f", 2);
            return;
        }
        if (coll.size() > 1) {
            this.application.showMessage("\u6709\u591a\u4e2a\u5ba2\u6237\u4e0e\u8f6c\u6b63\u5ba2\u6237\u91cd\u590d\uff0c\u4e0d\u80fd\u8f6c\u5165\u3002");
            return;
        }
        if (!this.converting) {
            this.converting = true;
            CustomerConversionFactory.getRemoteInstance().convert(info);
            this.application.showConfirm("successConvert", "\u63d0\u793a", "\u751f\u6210\u5ba2\u6237\u4e3b\u6570\u636e\u6210\u529f\u3002", 0);
        }
    }

    public void afterConfirm(String id, int returnOption) throws EASBizException, BOSException {
        if ("checkNumberDup".equalsIgnoreCase(id) && 0 == returnOption) {
            CustomerConversionInfo info = (CustomerConversionInfo)this.application.getBillValue();
            info.setCustomerEAS(this.easCustomer);
            info.setIsInsideCust(true);
            IObjectPK pk = CustomerConversionFactory.getRemoteInstance().save((CoreBaseInfo)info);
            for (int i = 0; i < this.crmCustomers.size(); ++i) {
                CustomerInfo customer = (CustomerInfo)this.crmCustomers.get(i);
                customer.setCustomerEAS(this.easCustomer);
                info.setId(BOSUuid.read((String)pk.toString()));
                customer.setCustomerConversion(info);
                customer.setIsInsideCust(true);
            }
            CustomerFactory.getRemoteInstance().save(this.crmCustomers);
            this.application.getBillView().refresh();
            this.converting = false;
        }
        if ("successConvert".equalsIgnoreCase(id)) {
            this.application.getBillView().refresh();
            this.application.setParentRefresh(true);
            this.converting = false;
        }
    }

    protected boolean enableSubmitToAudit() throws EASBizException, BOSException {
        String param = ParamManager.getParamValue(null, null, (String)"CRM_CustomerConversion0001");
        return param != null && Boolean.TRUE.toString().equals(param);
    }

    protected boolean enableUnAudit() throws EASBizException, BOSException {
        String param = ParamManager.getParamValue(null, null, (String)"CRM_CustomerConversion0002");
        return param != null && Boolean.TRUE.toString().equals(param);
    }

    protected boolean isCRMBaseData() {
        return true;
    }
}

