/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.CommandArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.license.expirecheck.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleStageCollection;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleStageFactory;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleStageInfo;
import com.kingdee.eas.scm.crm.bs.SaleStageInfo;
import com.kingdee.eas.scm.crm.plugins.support.SaleHelper;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageCollection;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageFactory;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportFactory;
import com.kingdee.eas.scm.crm.sm.BusinOpportInfo;
import java.math.BigDecimal;
import java.util.Date;

public class BizAdvanceBillPlugin
extends AbstractBillPlugin {
    private static final String CT_STAGE_KEY = "FbdSaleStage";
    private static final String CT_NUMDAYS_KEY = "FNumDays";
    private static final String CT_PLAN_BEGIN_DAY_KEY = "FPlanBeginDate";
    private static final String CT_PLAN_FINISH_DAY_KEY = "FPlanFinishDate";
    private static final String CT_AC_BEGIN_DAY_KEY = "FActualBeginDate";
    private static final String CT_AC_FINISH_DAY_KEY = "FActualFinishDate";
    private static final String CT_RATE_KEY = "FSuccessRate";
    private static final String CT_BUDGET_KEY = "Fbudgeting";
    private static final String CT_DESCRIPTION_KEY = "FtxtDescription";
    private static final String BTN_OK = "FbtnOk";
    private BusinOpportBusinStageInfo nextStageInfo;
    private BusinOpportInfo businOpportInfo;
    private BusinOpportBusinStageInfo stageInfo;

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        String businOpportID = (String)this.application.getCustomParameter("BillId");
        this.businOpportInfo = BusinOpportFactory.getRemoteInstance().getBusinOpportInfo((IObjectPK)new ObjectUuidPK(businOpportID));
        this.stageInfo = this.getStageInfo(this.businOpportInfo);
        if (this.stageInfo != null) {
            this.nextStageInfo = this.generateNextStage(this.businOpportInfo);
        }
        if (this.businOpportInfo.getSaleFunction() != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("parent.id", (Object)this.businOpportInfo.getSaleFunction().getId(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            view.setFilter(filter);
            SaleFunctionSaleStageCollection saleFunctionSaleStages = SaleFunctionSaleStageFactory.getRemoteInstance().getSaleFunctionSaleStageCollection(view);
            if (!saleFunctionSaleStages.isEmpty()) {
                StringBuffer oql = new StringBuffer(" saleStage.id in (");
                for (int i = 0; i < saleFunctionSaleStages.size(); ++i) {
                    SaleFunctionSaleStageInfo SaleFunctionSaleStage2 = saleFunctionSaleStages.get(i);
                    if (SaleFunctionSaleStage2.getSaleStage() == null) continue;
                    oql.append("'").append(SaleFunctionSaleStage2.getSaleStage().getId()).append("',");
                }
                oql.append(")");
                oql.deleteCharAt(oql.lastIndexOf(","));
                this.application.setFieldFilter(CT_STAGE_KEY, oql.toString());
            }
        }
        return super.onInitialize(param);
    }

    public void afterCreateNewData() throws EASBizException, BOSException {
        super.afterCreateNewData();
        if (this.nextStageInfo != null) {
            this.application.setValue(CT_STAGE_KEY, (Object)this.nextStageInfo.getSaleStage(), 0);
            this.application.setValue(CT_PLAN_BEGIN_DAY_KEY, (Object)this.nextStageInfo.getPlanBeginDate(), 0);
            this.application.setValue(CT_PLAN_FINISH_DAY_KEY, (Object)this.nextStageInfo.getPlanFinishDate(), 0);
            this.application.setValue(CT_AC_BEGIN_DAY_KEY, (Object)this.nextStageInfo.getActualBeginDate(), 0);
            this.application.setValue(CT_AC_FINISH_DAY_KEY, (Object)this.nextStageInfo.getActualFinishDate(), 0);
            this.application.setValue(CT_RATE_KEY, (Object)this.nextStageInfo.getSuccessRate(), 0);
            this.application.setValue(CT_BUDGET_KEY, (Object)this.nextStageInfo.getBudgeting(), 0);
        }
    }

    public void fireButtonClick(CommandArg commandArg) throws EASBizException, BOSException {
        super.fireButtonClick(commandArg);
        if (commandArg.getKey().equalsIgnoreCase(BTN_OK)) {
            if (this.application.getValue(CT_NUMDAYS_KEY, 0) != null) {
                // empty if block
            }
            this.nextStageInfo.setPlanBeginDate((Date)this.application.getValue(CT_PLAN_BEGIN_DAY_KEY, 0));
            this.nextStageInfo.setPlanFinishDate((Date)this.application.getValue(CT_PLAN_FINISH_DAY_KEY, 0));
            this.nextStageInfo.setActualBeginDate((Date)this.application.getValue(CT_AC_BEGIN_DAY_KEY, 0));
            this.nextStageInfo.setActualFinishDate((Date)this.application.getValue(CT_AC_FINISH_DAY_KEY, 0));
            this.nextStageInfo.setSuccessRate((BigDecimal)this.application.getValue(CT_RATE_KEY, 0));
            this.nextStageInfo.setBudgeting((BigDecimal)this.application.getValue(CT_BUDGET_KEY, 0));
            this.nextStageInfo.setDescription((String)this.application.getValue(CT_DESCRIPTION_KEY, 0));
            if (!this.businOpportInfo.getBusinStage().isEmpty()) {
                this.businOpportInfo.getBusinStage().add(this.nextStageInfo);
                this.businOpportInfo.getBusinStage().get(this.businOpportInfo.getBusinStage().size() - 1).setSeq(this.businOpportInfo.getBusinStage().size());
            }
            SaleHelper.setValueForBusinStageTask(this.businOpportInfo, (SaleStageInfo)this.application.getValue(CT_STAGE_KEY, 0));
            this.businOpportInfo.setBudgeting((BigDecimal)this.application.getValue(CT_BUDGET_KEY, 0));
            this.businOpportInfo.setSuccessRate(this.nextStageInfo.getSuccessRate());
            BusinOpportFactory.getRemoteInstance().save((CoreBaseInfo)this.businOpportInfo);
            this.application.setParentRefresh(true);
            this.application.close();
        }
    }

    private BusinOpportBusinStageInfo getStageInfo(BusinOpportInfo businOpportInfo) throws BOSException {
        if (businOpportInfo.getSaleStage() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("saleStage", (Object)String.valueOf(businOpportInfo.getSaleStage().getId()), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            viewInfo.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("saleStage.*"));
            viewInfo.setSelector(sic);
            BusinOpportBusinStageCollection collection = BusinOpportBusinStageFactory.getRemoteInstance().getBusinOpportBusinStageCollection(viewInfo);
            if (!collection.isEmpty()) {
                return collection.get(0);
            }
        }
        return null;
    }

    private BusinOpportBusinStageInfo generateNextStage(BusinOpportInfo businOpportInfo) throws BOSException {
        BusinOpportBusinStageInfo newStage = new BusinOpportBusinStageInfo();
        newStage.setParent(businOpportInfo);
        StringBuffer oql = new StringBuffer();
        oql.append("where saleStage='").append(businOpportInfo.getSaleStage().getId()).append("'");
        oql.append(" and parent.id='").append(businOpportInfo.getSaleFunction().getId()).append("'");
        SaleFunctionSaleStageCollection collection = SaleFunctionSaleStageFactory.getRemoteInstance().getSaleFunctionSaleStageCollection(oql.toString());
        if (!collection.isEmpty()) {
            SaleFunctionSaleStageInfo saleFunctionSaleStage = collection.get(0);
            SaleFunctionSaleStageCollection nextCollection = SaleFunctionSaleStageFactory.getRemoteInstance().getSaleFunctionSaleStageCollection("select *,saleStage.* where parent.id='" + businOpportInfo.getSaleFunction().getId() + "' and stageNum>" + saleFunctionSaleStage.getStageNum() + " order by stageNum");
            if (!nextCollection.isEmpty()) {
                SaleFunctionSaleStageInfo nextSaleFunctionSaleStage = nextCollection.get(0);
                newStage.setPlanBeginDate(this.stageInfo.getActualFinishDate());
                if (this.stageInfo.getActualFinishDate() != null) {
                    int day = 0;
                    if (nextSaleFunctionSaleStage.getNumDays() > 0) {
                        day = nextSaleFunctionSaleStage.getNumDays() - 1;
                    }
                    newStage.setPlanFinishDate(DateUtil.addDate((Date)this.stageInfo.getActualFinishDate(), (int)day));
                }
                newStage.setActualBeginDate(this.stageInfo.getActualFinishDate());
                newStage.setSuccessRate(nextSaleFunctionSaleStage.getSuccessRate());
                newStage.setBudgeting(businOpportInfo.getBudgeting());
            }
        }
        return newStage;
    }

    public void dataChanged(DataChangeCommandArg dataChangeCommandArg) {
        try {
            if (dataChangeCommandArg.getKey().equalsIgnoreCase(CT_STAGE_KEY)) {
                BusinOpportBusinStageInfo stage = new BusinOpportBusinStageInfo();
                SaleStageInfo saleStage = (SaleStageInfo)dataChangeCommandArg.getNewValue();
                SaleFunctionSaleStageCollection collection = SaleFunctionSaleStageFactory.getRemoteInstance().getSaleFunctionSaleStageCollection("select *,saleStage.* where parent.id='" + this.businOpportInfo.getSaleFunction().getId() + "' and saleStage.id='" + saleStage.getId() + "'");
                if (!collection.isEmpty()) {
                    SaleFunctionSaleStageInfo saleFunctionSaleStage = collection.get(0);
                    stage.setPlanBeginDate(this.stageInfo.getActualFinishDate());
                    if (this.stageInfo.getActualFinishDate() != null) {
                        int day = 0;
                        if (saleFunctionSaleStage.getNumDays() > 0) {
                            day = saleFunctionSaleStage.getNumDays() - 1;
                        }
                        stage.setPlanFinishDate(DateUtil.addDate((Date)this.stageInfo.getActualFinishDate(), (int)day));
                    }
                    stage.setActualBeginDate(this.stageInfo.getActualFinishDate());
                    stage.setSuccessRate(saleFunctionSaleStage.getSuccessRate());
                    stage.setBudgeting(this.businOpportInfo.getBudgeting());
                }
                this.application.setValue(CT_PLAN_BEGIN_DAY_KEY, (Object)stage.getPlanBeginDate(), 0);
                this.application.setValue(CT_PLAN_FINISH_DAY_KEY, (Object)stage.getPlanFinishDate(), 0);
                this.application.setValue(CT_AC_BEGIN_DAY_KEY, (Object)stage.getActualBeginDate(), 0);
                this.application.setValue(CT_AC_FINISH_DAY_KEY, (Object)stage.getActualFinishDate(), 0);
                this.application.setValue(CT_RATE_KEY, (Object)stage.getSuccessRate(), 0);
                this.application.setValue(CT_BUDGET_KEY, (Object)stage.getBudgeting(), 0);
            }
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
    }
}

