/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.common.ExecuteStatusEnum;
import com.kingdee.eas.scm.crm.sm.BusinOpportFactory;
import com.kingdee.eas.scm.crm.sm.BusinOpportInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public class BizFailCloseBillPlugin
extends AbstractBillPlugin {
    private static final String CT_REASON_KEY = "FaListCloseReson";
    private static final String CT_DESCRIPTION_KEY = "FClosInstruct";
    private static final String CT_ACTAMOUNT_KEY = "FCurrActualAmount";
    private static final String CT_ACTDATE_KEY = "FLastUpdateTime";
    private static final String BTN_OK = "FbtnOk";
    private BusinOpportInfo businOpportInfo;

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        String businOpportID = (String)this.application.getCustomParameter("BillId");
        this.businOpportInfo = BusinOpportFactory.getRemoteInstance().getBusinOpportInfo((IObjectPK)new ObjectUuidPK(businOpportID));
        return super.onInitialize(param);
    }

    public void afterCreateNewData() throws EASBizException, BOSException {
        super.afterCreateNewData();
        this.application.setValue(CT_ACTAMOUNT_KEY, (Object)new BigDecimal(0.0), 0);
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        super.doCustomOperation(operation);
        if (operation.equalsIgnoreCase(BTN_OK)) {
            Date time = (Date)this.application.getValue(CT_ACTDATE_KEY, 0);
            if (time != null) {
                this.businOpportInfo.setLastUpdateTime(new Timestamp(time.getTime()));
            }
            this.businOpportInfo.setExecuteStatus(ExecuteStatusEnum.FAILEDCLOSE);
            BusinOpportFactory.getRemoteInstance().save((CoreBaseInfo)this.businOpportInfo);
            this.application.setParentRefresh(true);
            this.application.close();
        }
    }
}

