/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.codingrule.CodingRuleUtils;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleStageFactory;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleStageInfo;
import com.kingdee.eas.scm.crm.common.BillStatusEnum;
import com.kingdee.eas.scm.crm.common.ExecuteStatusEnum;
import com.kingdee.eas.scm.crm.plugins.util.BillViewUtil;
import com.kingdee.eas.scm.crm.sm.AdvanceStageExecuteStateEnum;
import com.kingdee.eas.scm.crm.sm.BusinOpportAdvanceStageFactory;
import com.kingdee.eas.scm.crm.sm.BusinOpportAdvanceStageInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageCollection;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportFactory;
import com.kingdee.eas.scm.crm.sm.BusinOpportInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;

public class BusinOpportCloseBillPlugin
extends AbstractBillPlugin {
    private static final String CT_EXECUTESTATUS_KEY = "FradioGroup";
    private static final String CT_CLOSERESULT_KEY = "FCloseResult";
    private static final String BTN_OK = "FbtnOk";
    private BusinOpportInfo opportInfo;

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        String businOpportId = (String)this.application.getCustomParameter("BillId");
        this.opportInfo = BusinOpportFactory.getRemoteInstance().getBusinOpportInfo((IObjectPK)new ObjectUuidPK(businOpportId));
        return super.onInitialize(param);
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        super.doCustomOperation(operation);
        Context ctx = this.application.getContext();
        if (BTN_OK.equalsIgnoreCase(operation)) {
            String memo = (String)this.application.getBillValue().get("CloseReason");
            if (memo != null && memo.length() > 1000) {
                this.application.showMessage("\u5173\u95ed\u539f\u56e0\u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e1000\u3002");
                return;
            }
            this.opportInfo.setExecuteStatus(ExecuteStatusEnum.getEnum((Integer)this.application.getValue(CT_EXECUTESTATUS_KEY, 0)));
            this.opportInfo.setCloseReason((String)this.application.getValue(CT_CLOSERESULT_KEY, 0));
            BusinOpportAdvanceStageInfo advanceStageInfo = new BusinOpportAdvanceStageInfo();
            advanceStageInfo.setNumber(null);
            StringBuffer oql = new StringBuffer("select * ,saleStage.* where id = '");
            oql.append(this.opportInfo.getSaleStage().getId().toString() + "'");
            SaleFunctionSaleStageInfo stageInfo = SaleFunctionSaleStageFactory.getRemoteInstance().getSaleFunctionSaleStageInfo(oql.toString());
            advanceStageInfo.setName(stageInfo.getSaleStage().getName() + " \u9636\u6bb5\u63a8\u8fdb");
            advanceStageInfo.setCurrentSaleStage(stageInfo);
            advanceStageInfo.setCurrency(this.opportInfo.getCurrency());
            advanceStageInfo.setBusinOpport(this.opportInfo);
            advanceStageInfo.setSaleOrgUnit(this.opportInfo.getSaleOrgUnit());
            advanceStageInfo.setIsCloseBusin(true);
            int executeState = (Integer)this.application.getValue(CT_EXECUTESTATUS_KEY, 0);
            if (executeState == 5) {
                advanceStageInfo.setExecuteStateEnum(AdvanceStageExecuteStateEnum.closeFailed);
            } else if (executeState == 4) {
                advanceStageInfo.setExecuteStateEnum(AdvanceStageExecuteStateEnum.closeSuccess);
            }
            advanceStageInfo.setExecuteStatus(this.opportInfo.getExecuteStatus());
            advanceStageInfo.setCloseReason((String)this.application.getValue(CT_CLOSERESULT_KEY, 0));
            advanceStageInfo.setBillStatus(BillStatusEnum.AUDITED);
            BusinOpportBusinStageCollection businStageCollection = this.opportInfo.getBusinStage();
            int size = businStageCollection.size();
            for (int i = 0; i < size; ++i) {
                BusinOpportBusinStageInfo businStageInfo = businStageCollection.get(i);
                if (!businStageInfo.getSaleStage().getId().equals((Object)stageInfo.getSaleStage().getId())) continue;
                advanceStageInfo.setCurrentPlanBeginDate(businStageInfo.getPlanBeginDate());
                advanceStageInfo.setCurrentPlanFinishDate(businStageInfo.getPlanFinishDate());
                if (!this.existAdvanceStage(this.opportInfo)) {
                    advanceStageInfo.setCurrentActualBeginDate(this.opportInfo.getBeginDate());
                } else {
                    advanceStageInfo.setCurrentActualBeginDate(businStageInfo.getActualBeginDate());
                }
                advanceStageInfo.setCurrentActualFinishDate(new Date());
                advanceStageInfo.setCurrentSuccessRate(businStageInfo.getSuccessRate());
                advanceStageInfo.setCurrentBudgeting(businStageInfo.getBudgeting());
                advanceStageInfo.setCurrentDescription(businStageInfo.getDescription());
                businStageInfo.setActualFinishDate(new Date());
            }
            BillViewUtil.setSystemFieldValue(this.application, (IObjectValue)advanceStageInfo);
            BillViewUtil.setDefaultRole(this.application, (IObjectValue)advanceStageInfo, this.opportInfo.getCreator(), "GE9bmApeSRWatipdXKjEJpp+rpI=");
            advanceStageInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            advanceStageInfo.setAuditTime(new Date());
            String number = CodingRuleUtils.getNumberByClient((IObjectValue)advanceStageInfo, (String)ContextUtil.getCurrentOrgUnit((Context)this.application.getContext()).getId().toString());
            advanceStageInfo.setNumber(number);
            BusinOpportAdvanceStageFactory.getRemoteInstance().addnew(advanceStageInfo);
            this.opportInfo.setSaleStage(null);
            BusinOpportFactory.getRemoteInstance().save((CoreBaseInfo)this.opportInfo);
            this.application.setParentRefresh(true);
            this.application.close();
        } else if ("close".equalsIgnoreCase(operation)) {
            this.application.close();
        }
    }

    private boolean existAdvanceStage(BusinOpportInfo opport) throws EASBizException, BOSException {
        boolean flag = BusinOpportAdvanceStageFactory.getRemoteInstance().exists("select * where businOpport = '" + opport.getId().toString() + "'");
        return flag;
    }
}

