/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleUtils;
import com.kingdee.eas.base.form.core.UserDefinedData.UserDefinedDataEntryInfo;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.web.DynamicWebFormPanel;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.crm.bs.SaleFunctionCollection;
import com.kingdee.eas.scm.crm.bs.SaleFunctionFactory;
import com.kingdee.eas.scm.crm.bs.SaleFunctionInfo;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleStageCollection;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleStageFactory;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleStageInfo;
import com.kingdee.eas.scm.crm.bs.SaleStageInfo;
import com.kingdee.eas.scm.crm.common.BillStatusEnum;
import com.kingdee.eas.scm.crm.common.BillTypeEnum;
import com.kingdee.eas.scm.crm.common.ExecuteStatusEnum;
import com.kingdee.eas.scm.crm.customer.ContactFactory;
import com.kingdee.eas.scm.crm.customer.ContactInfo;
import com.kingdee.eas.scm.crm.customer.CustomerFactory;
import com.kingdee.eas.scm.crm.customer.CustomerInfo;
import com.kingdee.eas.scm.crm.plugins.bill.common.SyncBaseData;
import com.kingdee.eas.scm.crm.plugins.bill.common.SyncToEASException;
import com.kingdee.eas.scm.crm.plugins.bill.sale.AbstractSaleModuleBillPlugin;
import com.kingdee.eas.scm.crm.plugins.support.CarryValueHelper;
import com.kingdee.eas.scm.crm.plugins.support.defaultValue.SaleDefaultValueHelper;
import com.kingdee.eas.scm.crm.plugins.support.filter.CommonF7FilterHelper;
import com.kingdee.eas.scm.crm.plugins.util.BillStatusManageUtil;
import com.kingdee.eas.scm.crm.plugins.util.BillViewUtil;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.UDDUtil;
import com.kingdee.eas.scm.crm.sm.BizOppContactFactory;
import com.kingdee.eas.scm.crm.sm.BizOppContactInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportAdvanceStageCollection;
import com.kingdee.eas.scm.crm.sm.BusinOpportAdvanceStageFactory;
import com.kingdee.eas.scm.crm.sm.BusinOpportAdvanceStageInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageCollection;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageTaskCollection;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageTaskInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportFactory;
import com.kingdee.eas.scm.crm.sm.BusinOpportInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportProductCollection;
import com.kingdee.eas.scm.crm.sm.BusinOpportProductInfo;
import com.kingdee.eas.scm.crm.sm.ClueBizOppFactory;
import com.kingdee.eas.scm.crm.sm.ClueBizOppInfo;
import com.kingdee.eas.scm.crm.sm.ClueInfo;
import com.kingdee.eas.scm.crm.sm.IBusinOpport;
import com.kingdee.eas.scm.crm.sm.QuotationFactory;
import com.kingdee.eas.scm.crm.sm.QuotationInfo;
import com.kingdee.eas.scm.crm.sm.QuotationProductCollection;
import com.kingdee.eas.scm.crm.sm.QuotationProductInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class BusinessBillPlugin
extends AbstractSaleModuleBillPlugin {
    private static final String CT_COMPANTYORGUNIT_KEY = "ForgCompanyOrgUnit";
    private static final String CT_CURRENCY_KEY = "FbdCurrency";
    private static final String CT_EXCHANGERATE_KEY = "FExchangeRate";
    private static final String CT_CONVERTMETHOD_KEY = "FConvertMode";
    private static final String CT_BIZDAT_KEY = "FBizDate";
    private static final String CT_SALEFUN_KEY = "FBDSALEFUN";
    private static final String CT_SALESTAGE_KEY = "FSaleStage";
    private static final String CT_MISSIONADDNEW_KEY = "FMissionAddNew";
    private static final String CT_MISSIOINSERT_KEY = "Fbtn131";
    private static final String CT_BUSINSALESTAGE_KEY = "FBusinSaleStage";
    private static final String CT_BILLSTATUS_KEY = "Flist";
    private static final String CT_PRICE_KEY = "FPrdtPrice";
    private static final String BT_AUDIT_KEY = "FbtnAudit";
    private static final String CT_CURRENTSALESTAGE_KEY = "Fbasedata6";
    private static final String CT_SUCCESSRATE_KEY = "Ffloat";

    public void setDefaultValue() throws EASBizException, BOSException {
        UserDefinedDataEntryInfo opportSource;
        BusinOpportInfo opportInfo = (BusinOpportInfo)this.application.getBillValue();
        super.setDefaultValue();
        this.application.setMustInput(CT_CURRENTSALESTAGE_KEY, true);
        if (this.getBillID() == null && opportInfo.getSaleOrgUnit() == null) {
            SaleDefaultValueHelper.setAmountValue(this.application, OrgType.Sale, CT_COMPANTYORGUNIT_KEY, CT_CURRENCY_KEY, CT_EXCHANGERATE_KEY, CT_CONVERTMETHOD_KEY, CT_BIZDAT_KEY);
        }
        if (opportInfo.getOpportSource() == null && (opportSource = UDDUtil.loadUDDEntryByName("\u7ebf\u7d22\u5546\u673a\u6765\u6e90", "\u5458\u5de5\u6316\u6398")) != null) {
            opportInfo.setOpportSource(opportSource);
        }
        SaleFunctionInfo functionInfo = this.getDefaultSaleFunction();
        if (opportInfo.getSaleFunction() == null && functionInfo != null) {
            opportInfo.setSaleFunction(functionInfo);
            opportInfo.setSaleStage(this.getDefaultSaleStage());
            opportInfo.setSuccessRate(this.getDefaultSaleStage().getSaleStage().getSuccessRate() == null ? new BigDecimal(0.0) : this.getDefaultSaleStage().getSaleStage().getSuccessRate());
            this.setDefaultBusinStage(opportInfo, functionInfo);
        }
        opportInfo.setExecuteStatus(ExecuteStatusEnum.NEW);
    }

    private void setDefaultBusinStage(BusinOpportInfo opportInfo, SaleFunctionInfo functionInfo) throws BOSException, EASBizException {
        BusinOpportBusinStageCollection businStageCollection = opportInfo.getBusinStage();
        businStageCollection.clear();
        if (functionInfo != null) {
            SaleFunctionSaleStageCollection saleStageCollection = this.getSaleStageCollection(functionInfo);
            int size = saleStageCollection.size();
            for (int i = 0; i < size; ++i) {
                BusinOpportBusinStageInfo businStageInfo = new BusinOpportBusinStageInfo();
                businStageInfo.setSeq(i + 1);
                businStageInfo.setSaleStage(saleStageCollection.get(i).getSaleStage());
                businStageInfo.setNumDays(saleStageCollection.get(i).getNumDays());
                businStageInfo.setSuccessRate(saleStageCollection.get(i).getSuccessRate());
                businStageCollection.add(businStageInfo);
            }
        }
    }

    public void storeShareDataOnInitalize() throws EASBizException, BOSException {
        super.storeShareDataOnInitalize();
        this.storeDataInPageScope("BillType", (Object)BillTypeEnum.BIZ);
        BusinOpportInfo opportInfo = (BusinOpportInfo)this.application.getBillValue();
        if (opportInfo.getId() != null) {
            this.storeDataInPageScope("BillId", opportInfo.getId().toString());
            this.storeDataInPageScope("businCustomerId", opportInfo.getCustomer().getId().toString());
            this.storeDataInPageScope("businContactId", opportInfo.getMainContact().getId().toString());
        }
    }

    private SaleFunctionSaleStageInfo getDefaultSaleStage() throws EASBizException, BOSException {
        SaleFunctionSaleStageCollection stageCollection;
        SaleFunctionInfo functionInfo = this.getDefaultSaleFunction();
        if (functionInfo != null && !(stageCollection = this.getSaleStageCollection(functionInfo)).isEmpty()) {
            SaleFunctionSaleStageInfo stageInfo = stageCollection.get(0);
            return stageInfo;
        }
        return null;
    }

    public void lockElementOnInitalize() throws EASBizException, BOSException {
        BOSUuid uuid;
        String mainEntityId;
        super.lockElementOnInitalize();
        BillStatusManageUtil billStatusManageUtil = new BillStatusManageUtil(this.application);
        billStatusManageUtil.initBillButtons();
        BusinOpportInfo opportInfo = (BusinOpportInfo)this.application.getBillValue();
        if (opportInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
            this.application.lockElement(CT_SALEFUN_KEY, 0, true);
            this.application.lockElement(BT_AUDIT_KEY, true);
        }
        if (opportInfo.getExecuteStatus().getValue() > 3) {
            this.application.setMustInput(CT_CURRENTSALESTAGE_KEY, false);
        }
        if ((mainEntityId = (String)this.getParentData("BillId")) != null && (uuid = BOSUuid.read((String)mainEntityId)).getType().equals((Object)new CustomerInfo().getBOSType())) {
            CustomerInfo customer = new CustomerInfo();
            customer.setId(uuid);
            this.application.setValue("FbdCustomer", (Object)customer, 0);
            this.application.lockElement("FbdCustomer", true);
        }
        if (this.getBillID() != null) {
            int statusInt;
            BillStatusEnum billstatus = opportInfo.getBillStatus();
            OperationStatus operationStatus = this.application.getBillView().getOperationStatus();
            if (billstatus.getValue() == 4 && OperationStatus.VIEW.equals(operationStatus)) {
                new BillStatusManageUtil(this.application).lockElement("unAudit", !this.enableUnAudit());
            }
            if ((statusInt = opportInfo.getExecuteStatus().getValue()) >= ExecuteStatusEnum.SUCCESSCOLSE.getValue()) {
                new BillStatusManageUtil(this.application).lockElement("unClose", !this.enableUnClose());
            }
        }
    }

    protected boolean enableSubmitToAudit() throws EASBizException, BOSException {
        return BillViewUtil.isSystemParamConfigEnabled("CRM_Submit_BusinOpport0001", this.application);
    }

    protected boolean enableUnAudit() throws EASBizException, BOSException {
        return BillViewUtil.isSystemParamConfigEnabled("CRM_UnAudit_BusinOpport0002", this.application);
    }

    protected boolean enableUnClose() throws EASBizException, BOSException {
        return BillViewUtil.isSystemParamConfigEnabled("CRM_UnClose_BusinOpport0003", this.application);
    }

    private SaleFunctionInfo getDefaultSaleFunction() throws BOSException, EASBizException {
        SaleFunctionCollection collection;
        SaleOrgUnitInfo loginSaleOrg = (SaleOrgUnitInfo)this.getContext().get((Object)OrgType.Sale);
        StringBuffer oql = new StringBuffer();
        SaleFunctionInfo defalutFunction = null;
        if (loginSaleOrg != null) {
            oql.append("select *,SaleStage.* where cu.id='").append(loginSaleOrg.getId()).append("' and  isEnabled != 0  and isDeleted = 0 and  IsDefuSaleFun = 1    order by name");
            collection = SaleFunctionFactory.getRemoteInstance().getSaleFunctionCollection(oql.toString());
            if (collection != null && !collection.isEmpty()) {
                defalutFunction = collection.get(0);
            } else {
                CtrlUnitInfo cu = loginSaleOrg.getCU();
                defalutFunction = this.getDefalutSaleFunctionByCU(cu);
            }
        }
        if (defalutFunction != null) {
            oql = new StringBuffer();
            oql.append("select *,SaleStage.* where id='").append(defalutFunction.getId()).append("' and  isEnabled != 0  and isDeleted = 0 and IsDefuSaleFun = 1 order by SaleStage.stageNum");
            collection = SaleFunctionFactory.getRemoteInstance().getSaleFunctionCollection(oql.toString());
            if (!collection.isEmpty()) {
                return collection.get(0);
            }
        }
        return null;
    }

    private SaleFunctionInfo getDefalutSaleFunctionByCU(CtrlUnitInfo cu) throws BOSException, EASBizException {
        if (cu != null) {
            cu = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cu.getId()));
            StringBuffer oql = new StringBuffer("select *");
            oql.append(" where isEnabled != 0").append(" and isDeleted = 0").append(" and IsDefuSaleFun = 1").append(" and cu.id='").append(cu.getId()).append("' order by name");
            SaleFunctionCollection collection = SaleFunctionFactory.getRemoteInstance().getSaleFunctionCollection(oql.toString());
            if (collection != null && !collection.isEmpty()) {
                return collection.get(0);
            }
            return this.getDefalutSaleFunctionByCU(cu.getParent());
        }
        return null;
    }

    public void carrayValue(DataChangeCommandArg arg) throws EASBizException, BOSException {
        super.carrayValue(arg);
        BusinOpportInfo opportInfo = (BusinOpportInfo)this.application.getBillValue();
        this.carrayForSaleFun(opportInfo, arg);
    }

    private void dataChangeForSuccessRate(BusinOpportInfo opportInfo, DataChangeCommandArg arg) throws EASBizException, BOSException {
        if ("Ffloat1".equalsIgnoreCase(arg.getKey())) {
            BusinOpportBusinStageCollection businStages = (BusinOpportBusinStageCollection)((Object)opportInfo.get("businStage"));
            BusinOpportBusinStageInfo selectedBusinStage = businStages.get(arg.getRow());
            SaleStageInfo selectedSaleStage = selectedBusinStage.getSaleStage();
            SaleFunctionSaleStageInfo currSaleFunSaleStage = opportInfo.getSaleStage();
            if (currSaleFunSaleStage != null) {
                SaleStageInfo currSaleStage = currSaleFunSaleStage.getSaleStage();
                if (selectedSaleStage != null && currSaleStage != null && selectedSaleStage.getId().equals((Object)currSaleStage.getId())) {
                    this.application.setValue(CT_SUCCESSRATE_KEY, arg.getNewValue(), 0);
                }
            }
        }
    }

    private void carrayForSaleFun(BusinOpportInfo opportInfo, DataChangeCommandArg arg) throws BOSException, EASBizException {
        if (CT_SALEFUN_KEY.equalsIgnoreCase(arg.getKey())) {
            SaleFunctionSaleStageCollection stageCollection;
            SaleFunctionInfo functionInfo;
            if (BillStatusEnum.AUDITED.equals((Object)opportInfo.getBillStatus())) {
                this.application.showMessage("\u5355\u636e\u72b6\u6001\u4e3a\u5ba1\u6838\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u9500\u552e\u65b9\u6cd5\u3002");
                return;
            }
            this.application.setValue(CT_CURRENTSALESTAGE_KEY, null, 0);
            if (opportInfo.getSaleFunction() != null && !opportInfo.getSaleFunction().isEmpty() && (functionInfo = opportInfo.getSaleFunction()) != null && !(stageCollection = this.getSaleStageCollection(functionInfo)).isEmpty() && stageCollection != null) {
                SaleFunctionSaleStageInfo stageInfo = stageCollection.get(0);
                this.application.setValue(CT_CURRENTSALESTAGE_KEY, (Object)stageInfo, 0);
                this.application.setValue(CT_SUCCESSRATE_KEY, (Object)stageInfo.getSuccessRate(), 0);
            }
        }
    }

    private SaleFunctionSaleStageCollection getSaleStageCollection(SaleFunctionInfo functionInfo) throws BOSException {
        StringBuffer oql = new StringBuffer("select *, saleStage.* ");
        oql.append(" where parent.id = '").append(functionInfo.getId()).append("' order by stageNum");
        SaleFunctionSaleStageCollection stageCollection = SaleFunctionSaleStageFactory.getRemoteInstance().getSaleFunctionSaleStageCollection(oql.toString());
        return stageCollection;
    }

    public void setF7DefaultFilter() throws EASBizException, BOSException {
        super.setF7DefaultFilter();
        this.application.setFieldFilter("FContactor", CommonF7FilterHelper.buildF7ShareUserFilter(this.getContext()));
        this.setSaleFunctionFilter(this.application, "FbdSaleFun");
        BusinOpportInfo opportInfo = (BusinOpportInfo)this.application.getBillValue();
        SaleFunctionInfo functionInfo = opportInfo.getSaleFunction();
        if (functionInfo != null) {
            this.setSaleStageFilter(functionInfo, CT_CURRENTSALESTAGE_KEY);
            BusinOpportBusinStageCollection bizOppMissionStageCollection = opportInfo.getBusinStage();
            this.setBizOppMissionStageFilter(this.application, CT_BUSINSALESTAGE_KEY, bizOppMissionStageCollection);
        }
    }

    private void setSaleStageFilter(SaleFunctionInfo saleFunction, String key) throws BOSException {
        StringBuffer oql = saleFunction != null ? new StringBuffer(" parent.id = '" + saleFunction.getId().toString() + "'") : new StringBuffer(" parent.id = 'no'");
        this.application.setFieldFilter(key, oql.toString());
    }

    private void setSaleFunctionFilter(BillApplication application, String key) throws BOSException, EASBizException {
        Context ctx = application.getContext();
        SaleOrgUnitInfo loginSaleOrg = (SaleOrgUnitInfo)ctx.get((Object)OrgType.Sale);
        if (loginSaleOrg != null) {
            HashSet saleFunctions = new HashSet();
            this.getSaleFunctionsByCU(loginSaleOrg.getCU(), saleFunctions);
            StringBuffer oql = new StringBuffer(" id in (");
            for (SaleFunctionInfo saleFunction : saleFunctions) {
                oql.append("'").append(saleFunction.getId()).append("',");
            }
            oql.append(")");
            if (oql.indexOf(",") != -1) {
                oql.deleteCharAt(oql.lastIndexOf(","));
            }
            application.setFieldFilter(key, oql.toString());
        }
    }

    private void getSaleFunctionsByCU(CtrlUnitInfo cu, Set saleFunctions) throws BOSException, EASBizException {
        if (cu != null) {
            cu = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cu.getId()));
            StringBuffer oql = new StringBuffer("select *");
            oql.append(" where isEnabled != 0");
            oql.append(" and isDeleted != 1");
            oql.append(" and cu.id='").append(cu.getId()).append("' order by name");
            SaleFunctionCollection collection = SaleFunctionFactory.getRemoteInstance().getSaleFunctionCollection(oql.toString());
            if (collection != null && !collection.isEmpty()) {
                for (int i = 0; i < collection.size(); ++i) {
                    saleFunctions.add(collection.get(i));
                }
            }
            this.getSaleFunctionsByCU(cu.getParent(), saleFunctions);
        }
    }

    public void changeF7Filter(DataChangeCommandArg arg) throws EASBizException, BOSException {
        super.changeF7Filter(arg);
        BusinOpportInfo opportInfo = (BusinOpportInfo)this.application.getBillValue();
        if (CT_SALESTAGE_KEY.equalsIgnoreCase(arg.getKey())) {
            boolean flag = false;
            BusinOpportBusinStageCollection stageCollection = opportInfo.getBusinStage();
            int size = stageCollection.size();
            for (int i = 0; i < size; ++i) {
                if (stageCollection.get(i).getSaleStage() == null) continue;
                flag = true;
                break;
            }
            if (flag) {
                this.setBizOppMissionStageFilter(this.application, CT_BUSINSALESTAGE_KEY, stageCollection);
            }
        }
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        BusinOpportInfo opportInfo = (BusinOpportInfo)this.application.getBillValue();
        if (CT_MISSIONADDNEW_KEY.equalsIgnoreCase(this.buttonClickedKey) || CT_MISSIOINSERT_KEY.equalsIgnoreCase(this.buttonClickedKey)) {
            BusinOpportBusinStageCollection stageCollection = opportInfo.getBusinStage();
            boolean flag = true;
            int size = stageCollection.size();
            for (int i = 0; i < size; ++i) {
                if (stageCollection.get(i).getSaleStage() == null) continue;
                flag = false;
                break;
            }
            if (flag) {
                this.application.showMessage("\u8bf7\u5148\u5f55\u5165\u5546\u673a\u9636\u6bb5\u3002");
                return false;
            }
        }
        if ("Edit".equalsIgnoreCase(operation.getOperation())) {
            if (opportInfo.getBillStatus() == BillStatusEnum.AUDITED) {
                this.application.showMessage("\u5ba1\u6838\u7684\u5355\u636e\u4e0d\u80fd\u4fee\u6539\u3002");
                return false;
            }
            if (ExecuteStatusEnum.FAILEDCLOSE == opportInfo.getExecuteStatus()) {
                this.application.showMessage("\u6267\u884c\u72b6\u6001\u4e3a\u5931\u8d25\u5173\u95ed\u7684\u5355\u636e\u4e0d\u80fd\u4fee\u6539\u3002");
                return false;
            }
            if (ExecuteStatusEnum.SUCCESSCOLSE == opportInfo.getExecuteStatus()) {
                this.application.showMessage("\u6267\u884c\u72b6\u6001\u4e3a\u6210\u529f\u5173\u95ed\u7684\u5355\u636e\u4e0d\u80fd\u4fee\u6539\u3002");
                return false;
            }
        }
        return super.beforeOperation(operation);
    }

    public void doAfterDataChanged(DataChangeCommandArg arg) throws EASBizException, BOSException {
        BusinOpportBusinStageTaskInfo businStageTaskInfo;
        BusinOpportBusinStageTaskCollection businStageTaskCollection;
        Date planFinishTime;
        Date planBeginTime;
        BusinOpportInfo opportInfo;
        super.doAfterDataChanged(arg);
        if (CT_CURRENCY_KEY.equalsIgnoreCase(arg.getKey())) {
            BusinOpportInfo businOpportInfo;
            CurrencyInfo newCurrency = (CurrencyInfo)arg.getNewValue();
            CurrencyInfo oldCurrency = (CurrencyInfo)arg.getOldValue();
            CompanyOrgUnitInfo fiCompanyOrgInfo = (CompanyOrgUnitInfo)this.application.getValue(CT_COMPANTYORGUNIT_KEY, 0);
            if (null != fiCompanyOrgInfo) {
                fiCompanyOrgInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select * where id='" + fiCompanyOrgInfo.getId() + "'");
            }
            if ((businOpportInfo = (BusinOpportInfo)this.application.getBillModel().getBillValue()) != null && businOpportInfo.getProduct() != null) {
                CarryValueHelper.carryTaxPriceValueByCurrency((DynamicFormApplication)this.application, arg, fiCompanyOrgInfo, newCurrency, oldCurrency, CT_PRICE_KEY, businOpportInfo.getProduct().size());
            }
        }
        if (CT_SALEFUN_KEY.equalsIgnoreCase(arg.getKey())) {
            BusinOpportInfo opportInfo2 = (BusinOpportInfo)this.application.getBillValue();
            BusinOpportBusinStageCollection businStageCollection = opportInfo2.getBusinStage();
            this.setSaleStageFilter(opportInfo2.getSaleFunction(), CT_CURRENTSALESTAGE_KEY);
            SaleFunctionInfo functionInfo = opportInfo2.getSaleFunction();
            if (businStageCollection != null && !businStageCollection.isEmpty()) {
                businStageCollection.clear();
            }
            this.setDefaultBusinStage(opportInfo2, functionInfo);
            WebBillEditPanel web = (WebBillEditPanel)this.application.getBillView();
            try {
                web.getEntryData("F8");
            }
            catch (JSONException e) {
                Logger.error((Throwable)e);
            }
        }
        if ("ForgSaleOrgUnit".equalsIgnoreCase(arg.getKey())) {
            this.application.setValue("FbdSaleGroup", null, 0);
        }
        DynamicWebFormPanel parent = (DynamicWebFormPanel)this.application.getView().getParentFormView();
        if ("FbdCustomer".equalsIgnoreCase(arg.getKey()) && parent.getParentFormView() == null) {
            this.application.setValue("FContactor", null, 0);
        }
        if (CT_CURRENTSALESTAGE_KEY.equalsIgnoreCase(arg.getKey())) {
            BusinOpportInfo opportInfo3 = (BusinOpportInfo)this.application.getBillValue();
            this.application.setValue(CT_SUCCESSRATE_KEY, (Object)(opportInfo3.getSaleStage() != null ? opportInfo3.getSaleStage().getSuccessRate() : null), 0);
        }
        if ("Fdate1".equalsIgnoreCase(arg.getKey()) || "Fdate".equalsIgnoreCase(arg.getKey())) {
            int numDays = 0;
            opportInfo = (BusinOpportInfo)this.application.getBillValue();
            BusinOpportBusinStageCollection businStageCollection = opportInfo.getBusinStage();
            BusinOpportBusinStageInfo businStageInfo = businStageCollection.get(arg.getRow());
            planBeginTime = businStageInfo.getPlanBeginDate();
            planFinishTime = businStageInfo.getPlanFinishDate();
            if (null != planBeginTime && null != planFinishTime) {
                if (planBeginTime.after(planFinishTime)) {
                    this.application.showMessage("\u9636\u6bb5\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u9636\u6bb5\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u3002");
                    return;
                }
                numDays = CommonUtil.getDiffDays(planFinishTime, planBeginTime) + 1;
                this.application.setValue("Fint3", (Object)new Integer(numDays), arg.getRow());
            }
        }
        if ("Fdate5".equalsIgnoreCase(arg.getKey()) || "Fdate6".equalsIgnoreCase(arg.getKey())) {
            int numDays = 0;
            opportInfo = (BusinOpportInfo)this.application.getBillValue();
            businStageTaskCollection = opportInfo.getBusinStageTask();
            businStageTaskInfo = businStageTaskCollection.get(arg.getRow());
            planBeginTime = businStageTaskInfo.getTaskPlanDate();
            planFinishTime = businStageTaskInfo.getTaskFinishDate();
            if (null != planBeginTime && null != planFinishTime) {
                if (planBeginTime.after(planFinishTime)) {
                    this.application.showMessage("\u4efb\u52a1\u9884\u8ba1\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4efb\u52a1\u9884\u8ba1\u5f00\u59cb\u65f6\u95f4\u3002");
                    return;
                }
                numDays = CommonUtil.getDiffDays(planFinishTime, planBeginTime) + 1;
                this.application.setValue("Fint5", (Object)new Integer(numDays), arg.getRow());
            }
        }
        if ("Fdate7".equalsIgnoreCase(arg.getKey()) || "Fdate8".equalsIgnoreCase(arg.getKey())) {
            int numDays = 0;
            opportInfo = (BusinOpportInfo)this.application.getBillValue();
            businStageTaskCollection = opportInfo.getBusinStageTask();
            businStageTaskInfo = businStageTaskCollection.get(arg.getRow());
            planBeginTime = businStageTaskInfo.getTaskActBeginDate();
            planFinishTime = businStageTaskInfo.getTaskActFinishDate();
            if (null != planBeginTime && null != planFinishTime) {
                if (planBeginTime.after(planFinishTime)) {
                    this.application.showMessage("\u4efb\u52a1\u5b9e\u9645\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4efb\u52a1\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4\u3002");
                    return;
                }
                numDays = CommonUtil.getDiffDays(planFinishTime, planBeginTime) + 1;
                this.application.setValue("Fint6", (Object)new Integer(numDays), arg.getRow());
            }
        }
        BusinOpportInfo opportInfo4 = (BusinOpportInfo)this.application.getBillValue();
        this.dataChangeForSuccessRate(opportInfo4, arg);
    }

    public boolean beforeSaveOrSubmitData() {
        BusinOpportInfo opportInfo = (BusinOpportInfo)this.application.getBillValue();
        opportInfo.setExecuteStatus(ExecuteStatusEnum.EXECUTING);
        return super.beforeSaveOrSubmitData();
    }

    private void setBizOppMissionStageFilter(BillApplication application, String key, BusinOpportBusinStageCollection stageCollection) throws BOSException {
        StringBuffer oql = new StringBuffer(" id in (");
        int size = stageCollection.size();
        for (int i = 0; i < size; ++i) {
            SaleStageInfo stageInfo = stageCollection.get(i).getSaleStage();
            if (stageInfo == null) continue;
            oql.append("'").append(stageInfo.getId()).append("',");
        }
        oql.append(")");
        if (oql.indexOf(",") != -1) {
            oql.deleteCharAt(oql.lastIndexOf(","));
        }
        application.setFieldFilter(key, oql.toString());
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        BusinOpportInfo opportInfo;
        BillTypeEnum type;
        super.afterOperation(operation);
        String mainEntityId = (String)this.getParentData("BillId");
        if (null != mainEntityId && "Save".equalsIgnoreCase(operation.getOperation()) && BillTypeEnum.CLUE.equals((Object)(type = (BillTypeEnum)((Object)this.getParentData("BillType"))))) {
            ClueInfo clue = new ClueInfo();
            clue.setId(BOSUuid.read((String)mainEntityId));
            ClueBizOppInfo clueBizOppInfo = new ClueBizOppInfo();
            clueBizOppInfo.setBizOpp((BusinOpportInfo)this.application.getBillValue());
            clueBizOppInfo.setClue(clue);
            ClueBizOppFactory.getRemoteInstance().addnew(clueBizOppInfo);
        }
        if ("Save".equals(operation.getOperation()) || "Submit".equals(operation.getOperation())) {
            opportInfo = (BusinOpportInfo)this.application.getBillValue();
            BizOppContactInfo contactInfo = new BizOppContactInfo();
            contactInfo.setBiz(opportInfo);
            contactInfo.setContactor(opportInfo.getMainContact());
            BizOppContactFactory.getRemoteInstance().save((CoreBaseInfo)contactInfo);
        } else if ("Copy".equalsIgnoreCase(operation.getOperation())) {
            opportInfo = (BusinOpportInfo)this.application.getBillValue();
            BusinOpportBusinStageCollection businStageCollection = opportInfo.getBusinStage();
            SaleFunctionInfo functionInfo = opportInfo.getSaleFunction();
            if (businStageCollection != null && !businStageCollection.isEmpty()) {
                businStageCollection.clear();
            }
            if (functionInfo != null) {
                SaleFunctionSaleStageCollection saleStageCollection = this.getSaleStageCollection(functionInfo);
                int size = saleStageCollection.size();
                for (int i = 0; i < size; ++i) {
                    BusinOpportBusinStageInfo businStageInfo = new BusinOpportBusinStageInfo();
                    businStageInfo.setSeq(i + 1);
                    businStageInfo.setSaleStage(saleStageCollection.get(i).getSaleStage());
                    businStageInfo.setNumDays(saleStageCollection.get(i).getNumDays());
                    businStageInfo.setSuccessRate(saleStageCollection.get(i).getSuccessRate());
                    businStageCollection.add(businStageInfo);
                    this.application.setValue("Fint2", (Object)new Integer(i + 1), i);
                    this.application.setValue(CT_SALESTAGE_KEY, (Object)saleStageCollection.get(i).getSaleStage(), i);
                    this.application.setValue("Fint3", (Object)new Integer(saleStageCollection.get(i).getNumDays()), i);
                    this.application.setValue("Ffloat1", (Object)saleStageCollection.get(i).getSuccessRate(), i);
                }
            }
            BusinOpportBusinStageTaskCollection businStageTaskCollection = (BusinOpportBusinStageTaskCollection)((Object)this.application.getBillValue().get("businStageTask"));
            try {
                WebBillEditPanel billPanle = (WebBillEditPanel)this.application.getBillView();
                while (businStageTaskCollection.size() > 0) {
                    billPanle.handleEntry("F12", "DeleteEntry", businStageTaskCollection.size() - 1);
                }
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public boolean isEnableCRMPermission() {
        return true;
    }

    protected String getPermRelProp() {
        return "businOpport";
    }

    public void closeAction() throws EASBizException, BOSException {
        Integer billStates = (Integer)this.application.getValue(CT_BILLSTATUS_KEY, 0);
        if (billStates == 4) {
            BusinOpportInfo businessInfo = (BusinOpportInfo)this.application.getBillValue();
            CommonUtil.openWindow((IFormApplication)this.application, "bR3wKytCQtKzqobRZFOZCJp+rpI=", businessInfo.getId().toString(), "\u5546\u673a\u5173\u95ed", 640, 445);
        } else {
            this.application.showMessage("\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u5173\u95ed\u3002");
        }
    }

    public void unAuditAction() throws EASBizException, BOSException {
        BusinOpportInfo opportInfo = (BusinOpportInfo)this.application.getBillValue();
        BillStatusEnum billStatus = opportInfo.getBillStatus();
        if (!this.enableUnAudit()) {
            this.application.showMessage("\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002");
            return;
        }
        if (ExecuteStatusEnum.SUCCESSCOLSE.equals((Object)opportInfo.getExecuteStatus())) {
            this.application.showMessage("\u6267\u884c\u72b6\u6001\u4e3a\u6210\u529f\u5173\u95ed\u7684\u5355\u636e\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002");
            return;
        }
        if (ExecuteStatusEnum.FAILEDCLOSE.equals((Object)opportInfo.getExecuteStatus())) {
            this.application.showMessage("\u6267\u884c\u72b6\u6001\u4e3a\u5931\u8d25\u5173\u95ed\u7684\u5355\u636e\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002");
            return;
        }
        if (BillStatusEnum.AUDITED == billStatus) {
            opportInfo.setInt("billStatus", 1);
            opportInfo.put("auditTime", null);
            opportInfo.put("auditor", null);
            IBusinOpport opport = BusinOpportFactory.getRemoteInstance();
            opport.save((CoreBaseInfo)opportInfo);
            this.application.showMessage("\u53cd\u5ba1\u6838\u6210\u529f\u3002");
            this.application.getBillView().refresh();
        } else {
            this.application.showMessage("\u53ea\u6709\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u53cd\u5ba1\u6838\u3002");
        }
    }

    public void unCloseAction() throws EASBizException, BOSException {
        if (!this.enableUnClose()) {
            this.application.showMessage("\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5173\u95ed\u3002");
            return;
        }
        BusinOpportInfo businOpportInfo = (BusinOpportInfo)this.application.getBillValue();
        if (businOpportInfo.getExecuteStatus().getValue() > 3) {
            businOpportInfo.setSaleStage(this.getLastAdvanceSaleStage(businOpportInfo));
            businOpportInfo.setExecuteStatus(ExecuteStatusEnum.EXECUTING);
            this.application.save();
            this.application.getBillView().refresh();
        } else {
            this.application.showMessage("\u53ea\u6709\u6267\u884c\u72b6\u6001\u4e3a\u5173\u95ed\u7684\u5355\u636e\u624d\u80fd\u53cd\u5173\u95ed\u3002");
        }
    }

    private SaleFunctionSaleStageInfo getLastAdvanceSaleStage(BusinOpportInfo businOpportInfo) throws BOSException {
        StringBuffer oql = new StringBuffer("select * where businOpport = '");
        oql.append(businOpportInfo.getId().toString());
        oql.append("' order by createTime");
        BusinOpportAdvanceStageCollection advanceStageCollection = BusinOpportAdvanceStageFactory.getRemoteInstance().getBusinOpportAdvanceStageCollection(oql.toString());
        if (!advanceStageCollection.isEmpty()) {
            SaleFunctionSaleStageInfo stageInfo = advanceStageCollection.get(advanceStageCollection.size() - 1).getCurrentSaleStage();
            return stageInfo;
        }
        return null;
    }

    protected String getDistributeShareUserPermissionName() {
        return "crm_businOpport_distributPerson";
    }

    protected String getDistributeUserPermissionName() {
        return "crm_businOpport_distributUser";
    }

    protected String getRecycleSharerUserPermissionName() {
        return "crm_businOpport_recyclePerson";
    }

    protected String getRecycleUserPermissionName() {
        return "crm_businOpport_recycleUser";
    }

    public void convert2QuotationAction() throws EASBizException, BOSException {
        String flag = new String();
        this.storeDataInPageScope("operation", flag);
        QuotationInfo quotationInfo = new QuotationInfo();
        BusinOpportInfo opportInfo = (BusinOpportInfo)this.application.getBillValue();
        SaleOrgUnitInfo saleOrgUnitInfo = opportInfo.getSaleOrgUnit();
        if (saleOrgUnitInfo != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("isBizUnit");
            saleOrgUnitInfo = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(saleOrgUnitInfo.getId()), sic);
            if (!saleOrgUnitInfo.isIsBizUnit()) {
                this.application.showMessage("\u5f53\u524d\u5546\u673a\u7684\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u5b9e\u4f53\u9500\u552e\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5904\u7406\u4e1a\u52a1\u64cd\u4f5c\u3002");
                return;
            }
        }
        quotationInfo.setBusinOpport(opportInfo);
        quotationInfo.setCustomer(opportInfo.getCustomer());
        quotationInfo.setContact(opportInfo.getMainContact());
        quotationInfo.setSaleOrgUnit(opportInfo.getSaleOrgUnit());
        quotationInfo.setSaleGroup(opportInfo.getSaleGroup());
        quotationInfo.setCurrency(opportInfo.getCurrency());
        quotationInfo.setExchangeRate(opportInfo.getExchangeRate());
        quotationInfo.setConvertMode(opportInfo.getConvertMode());
        quotationInfo.setCompanyOrgUnit(opportInfo.getCompanyOrgUnit());
        ContactInfo contactinfo = ContactFactory.getRemoteInstance().getContactInfo("select * where id='" + opportInfo.getMainContact().getId() + "'");
        if (contactinfo != null) {
            quotationInfo.setContactPhone(contactinfo.getTelephone());
            quotationInfo.setPhone(contactinfo.getMobilePhone());
            quotationInfo.setFaxNumber(contactinfo.getFax());
        }
        BusinOpportProductCollection businCollection = opportInfo.getProduct();
        QuotationProductCollection quotationCollection = new QuotationProductCollection();
        BigDecimal totalAmount = new BigDecimal(0.0);
        BigDecimal totalTax = new BigDecimal(0.0);
        BigDecimal totalTaxAmount = new BigDecimal(0.0);
        if (!businCollection.isEmpty()) {
            BusinOpportProductInfo businProductInfo = null;
            int size = businCollection.size();
            for (int i = 0; i < size; ++i) {
                BigDecimal maxTaxtRate;
                BigDecimal tempTaxtRate;
                businProductInfo = businCollection.get(i);
                BigDecimal quotationProductPrice = businProductInfo.getPrice();
                MaterialSalesCollection materials = MaterialSalesFactory.getRemoteInstance().getMaterialSalesCollection("select taxRate where material.id='" + businProductInfo.getMaterial().getId() + "' and taxRate is not null");
                BigDecimal taxRate = null;
                taxRate = materials != null && !materials.isEmpty() ? ((tempTaxtRate = materials.get(0).getTaxRate()).compareTo(maxTaxtRate = new BigDecimal(9.9999999999999E11)) == 1 ? maxTaxtRate : tempTaxtRate) : new BigDecimal(17.0);
                QuotationProductInfo productInfo = new QuotationProductInfo();
                BigDecimal price = quotationProductPrice == null ? new BigDecimal(0.0) : quotationProductPrice.divide(new BigDecimal(1.0).add(taxRate.divide(new BigDecimal(100.0), 4, 4)), 4, 4);
                productInfo.setPrice(price);
                productInfo.setSeq(businProductInfo.getSeq());
                productInfo.setMaterial(businProductInfo.getMaterial());
                productInfo.setUnit(businProductInfo.getUnit());
                productInfo.setQuantity(businProductInfo.getQuantity());
                productInfo.setRatePrice(businProductInfo.getPrice());
                productInfo.setAssistUnitQty(new BigDecimal(0.0));
                productInfo.setRate(taxRate);
                productInfo.setDiscount(new BigDecimal(0.0));
                BigDecimal taxAmount = businProductInfo.getQuantity().multiply(businProductInfo.getPrice());
                totalTaxAmount = totalTaxAmount.add(taxAmount);
                productInfo.setTaxAmount(taxAmount);
                BigDecimal tax = taxAmount.divide(new BigDecimal(1.0).add(taxRate.divide(new BigDecimal(100.0), 4, 4)), 4, 4).multiply(taxRate.divide(new BigDecimal(100.0), 4, 4));
                totalTax = totalTax.add(tax);
                productInfo.setTax(tax);
                BigDecimal amount = taxAmount.subtract(tax);
                totalAmount = totalAmount.add(amount);
                productInfo.setAmount(amount);
                BigDecimal actRatePrice = taxAmount.divide(businProductInfo.getQuantity(), 4, 4);
                productInfo.setActRatePrice(actRatePrice);
                BigDecimal actPrice = amount.divide(businProductInfo.getQuantity(), 4, 4);
                productInfo.setActualPrice(actPrice);
                productInfo.setDiscountAmount(new BigDecimal(0.0));
                quotationCollection.add(productInfo);
            }
        }
        quotationInfo.setTotalAmount(totalAmount);
        quotationInfo.setTotalTax(totalTax);
        quotationInfo.setTotalTaxAmount(totalTaxAmount);
        quotationInfo.setBillType(BillTypeEnum.QUOTATION);
        BillViewUtil.setSystemFieldValue(this.application, (IObjectValue)quotationInfo);
        BillViewUtil.setDefaultRole(this.application, (IObjectValue)quotationInfo, opportInfo.getCreator(), "GE9bmApeSRWatipdXKjEJpp+rpI=");
        quotationInfo.setName(opportInfo.getName());
        quotationInfo.setIsInTax(true);
        quotationInfo.getProduct().addCollection(quotationCollection);
        quotationInfo.setBillStatus(BillStatusEnum.TEMPORARILYSAVED);
        quotationInfo.setQuotDate(new Date());
        quotationInfo.setEffectDate(CommonUtil.dateAddByMonth(new Date(), 1));
        String number = CodingRuleUtils.getNumberByClient((IObjectValue)quotationInfo, (String)ContextUtil.getCurrentOrgUnit((Context)this.application.getContext()).getId().toString());
        quotationInfo.setNumber(number);
        String quotationId = QuotationFactory.getRemoteInstance().addnew(quotationInfo).toString();
        this.application.setParentRefresh(true);
        BillViewUtil.showBillView(this.application, quotationId, "GE9bmApeSRWatipdXKjEJpp+rpI=", "\u9500\u552e\u62a5\u4ef7");
    }

    private boolean existAdvanceStage(BusinOpportInfo opport) throws EASBizException, BOSException {
        boolean flag = BusinOpportAdvanceStageFactory.getRemoteInstance().exists("select * where businOpport = '" + opport.getId().toString() + "' and isDeleted = 0");
        return flag;
    }

    private boolean existAuditStage(BusinOpportInfo opport) throws EASBizException, BOSException {
        StringBuffer oql = new StringBuffer("select * where businOpport = '" + opport.getId().toString());
        oql.append("' and billStatus <> 4");
        oql.append(" and isDeleted = 0");
        boolean flag = BusinOpportAdvanceStageFactory.getRemoteInstance().exists(oql.toString());
        return flag;
    }

    public void convert2AdvanceStageAction() throws CodingRuleException, EASBizException, BOSException {
        BusinOpportInfo businOpportInfo = (BusinOpportInfo)this.application.getBillModel().getBillValue();
        if (!BillStatusEnum.AUDITED.equals((Object)businOpportInfo.getBillStatus())) {
            this.application.showMessage("\u5355\u636e\u72b6\u6001\u4e3a\u5ba1\u6838\u7684\u5355\u636e\u624d\u53ef\u4ee5\u9636\u6bb5\u63a8\u8fdb\u3002");
            return;
        }
        if (ExecuteStatusEnum.SUCCESSCOLSE.equals((Object)businOpportInfo.getExecuteStatus())) {
            this.application.showMessage("\u6267\u884c\u72b6\u6001\u4e3a\u6210\u529f\u5173\u95ed\u7684\u5355\u636e\u4e0d\u80fd\u9636\u6bb5\u63a8\u8fdb\u3002");
            return;
        }
        if (ExecuteStatusEnum.FAILEDCLOSE.equals((Object)businOpportInfo.getExecuteStatus())) {
            this.application.showMessage("\u6267\u884c\u72b6\u6001\u4e3a\u5931\u8d25\u5173\u95ed\u7684\u5355\u636e\u4e0d\u80fd\u9636\u6bb5\u63a8\u8fdb\u3002");
            return;
        }
        SaleOrgUnitInfo saleOrgUnitInfo = businOpportInfo.getSaleOrgUnit();
        if (saleOrgUnitInfo != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("isBizUnit");
            saleOrgUnitInfo = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(saleOrgUnitInfo.getId()), sic);
            if (!saleOrgUnitInfo.isIsBizUnit()) {
                this.application.showMessage("\u5f53\u524d\u5546\u673a\u7684\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u5b9e\u4f53\u9500\u552e\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5904\u7406\u4e1a\u52a1\u64cd\u4f5c\u3002");
                return;
            }
        }
        if (this.existAuditStage(businOpportInfo)) {
            this.application.showMessage("\u5546\u673a\u5f53\u524d\u9500\u552e\u9636\u6bb5\u5df2\u7ecf\u751f\u6210\u9636\u6bb5\u63a8\u8fdb\u5355\u3002");
            return;
        }
        BusinOpportAdvanceStageInfo advanceStageInfo = new BusinOpportAdvanceStageInfo();
        this.application.load(this.application.getBillValue().getString("id"));
        BusinOpportInfo opportInfo = (BusinOpportInfo)this.application.getBillValue();
        SaleFunctionSaleStageInfo stageInfo = opportInfo.getSaleStage();
        if (stageInfo == null) {
            this.application.showMessage("\u6267\u884c\u72b6\u6001\u4e3a\u5173\u95ed\u7684\u5355\u636e\u4e0d\u80fd\u9636\u6bb5\u63a8\u8fdb\u3002");
            return;
        }
        BusinOpportBusinStageCollection businStageCollection = opportInfo.getBusinStage();
        int size = businStageCollection.size();
        for (int i = 0; i < size; ++i) {
            BusinOpportBusinStageInfo businStageInfo = businStageCollection.get(i);
            SaleStageInfo info = businStageInfo.getSaleStage();
            if (info == null || !stageInfo.getSaleStage().getId().equals((Object)info.getId())) continue;
            advanceStageInfo.setCurrentSaleStage(opportInfo.getSaleStage());
            advanceStageInfo.setCurrentPlanBeginDate(businStageInfo.getPlanBeginDate());
            advanceStageInfo.setCurrentPlanFinishDate(businStageInfo.getPlanFinishDate());
            if (!this.existAdvanceStage(businOpportInfo)) {
                advanceStageInfo.setCurrentActualBeginDate(opportInfo.getBeginDate());
            } else {
                advanceStageInfo.setCurrentActualBeginDate(businStageInfo.getActualBeginDate());
            }
            advanceStageInfo.setCurrentSuccessRate(businStageInfo.getSuccessRate());
            advanceStageInfo.setCurrentBudgeting(businStageInfo.getBudgeting());
            advanceStageInfo.setCurrentDescription(businStageInfo.getDescription());
            if (i + 1 >= size) continue;
            BusinOpportBusinStageInfo nextBusinStageInfo = businStageCollection.get(i + 1);
            SaleFunctionSaleStageInfo nextSaleStage = this.getSaleFunctionSaleStage(businOpportInfo.getSaleFunction(), nextBusinStageInfo.getSaleStage());
            advanceStageInfo.setNextSaleStage(nextSaleStage);
            advanceStageInfo.setSuccessRate(nextSaleStage.getSuccessRate());
        }
        BillViewUtil.setSystemFieldValue(this.application, (IObjectValue)advanceStageInfo);
        BillViewUtil.setDefaultRole(this.application, (IObjectValue)advanceStageInfo, opportInfo.getCreator(), "sXS/h9UOSRaXM/Sx8eEyuJp+rpI=");
        advanceStageInfo.setSaleFunction(opportInfo.getSaleFunction());
        advanceStageInfo.setName(opportInfo.getSaleStage().getSaleStage().getName());
        advanceStageInfo.setBusinOpport(opportInfo);
        advanceStageInfo.setCompanyOrgUnit(opportInfo.getCompanyOrgUnit());
        advanceStageInfo.setSaleOrgUnit(opportInfo.getSaleOrgUnit());
        advanceStageInfo.setCurrency(opportInfo.getCurrency());
        advanceStageInfo.setBillStatus(BillStatusEnum.TEMPORARILYSAVED);
        String number = CodingRuleUtils.getNumberByClient((IObjectValue)advanceStageInfo, (String)ContextUtil.getCurrentOrgUnit((Context)this.application.getContext()).getId().toString());
        advanceStageInfo.setNumber(number);
        String advanceStageId = BusinOpportAdvanceStageFactory.getRemoteInstance().addnew(advanceStageInfo).toString();
        this.application.setParentRefresh(true);
        BillViewUtil.showBillView(this.application, advanceStageId, "sXS/h9UOSRaXM/Sx8eEyuJp+rpI=", "\u5546\u673a\u9636\u6bb5\u63a8\u8fdb\u5355");
    }

    private SaleFunctionSaleStageInfo getSaleFunctionSaleStage(SaleFunctionInfo functionInfo, SaleStageInfo stageInfo) throws BOSException {
        StringBuffer oql = new StringBuffer("select *, saleStage.* ");
        oql.append(" where parent.id = '").append(functionInfo.getId().toString()).append("'");
        oql.append(" and saleStage.id = '" + stageInfo.getId().toString() + "'");
        SaleFunctionSaleStageCollection stageCollection = SaleFunctionSaleStageFactory.getRemoteInstance().getSaleFunctionSaleStageCollection(oql.toString());
        return stageCollection.get(0);
    }

    public void convert2EASSaleOrderAction() throws EASBizException, BOSException, SyncToEASException, ParserException {
        CustomerInfo customer;
        BusinOpportInfo businOpportInfo = (BusinOpportInfo)this.application.getBillModel().getBillValue();
        if (businOpportInfo.isIsProduceEASOrder()) {
            this.application.showMessage("\u5546\u673a\u5df2\u8f6c\u9500\u552e\u8ba2\u5355\u3002");
            return;
        }
        if (businOpportInfo.getSaleGroup() == null) {
            this.application.showMessage("\u5546\u673a\u7684\u9500\u552e\u5c0f\u7ec4\u5fc5\u987b\u6709\u503c\uff0c\u624d\u80fd\u8fdb\u884c\u8be5\u4e1a\u52a1\u64cd\u4f5c\u3002");
            return;
        }
        if (!BillViewUtil.isHasEntryData(this.application, "FProduct")) {
            this.application.showMessage("\u610f\u5411\u4ea7\u54c1\u5206\u5f55\u81f3\u5c11\u5b58\u5728\u4e00\u6761\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u8be5\u4e1a\u52a1\u64cd\u4f5c\u3002");
            return;
        }
        SaleOrgUnitInfo saleOrgUnitInfo = businOpportInfo.getSaleOrgUnit();
        if (saleOrgUnitInfo != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("isBizUnit");
            saleOrgUnitInfo = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(saleOrgUnitInfo.getId()), sic);
            if (!saleOrgUnitInfo.isIsBizUnit()) {
                this.application.showMessage("\u5f53\u524d\u5546\u673a\u7684\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u662f\u5b9e\u4f53\u9500\u552e\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5904\u7406\u4e1a\u52a1\u64cd\u4f5c\u3002");
                return;
            }
        }
        if ((customer = businOpportInfo.getCustomer()) != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("customerEAS.*");
            customer = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(customer.getId()), sic);
            if (!customer.isIsInsideCust()) {
                this.application.showMessage("\u5ba2\u6237\u672a\u505a\u8f6c\u6b63\u5904\u7406\uff0c\u8bf7\u5148\u5b8c\u6210\u5ba2\u6237\u8f6c\u6b63\u64cd\u4f5c\u3002");
                return;
            }
            if (customer.getCustomerEAS().getUsedStatus().getValue() != 1) {
                this.application.showMessage("\u5546\u673a\u7684" + customer.getName() + "\u5ba2\u6237\u5bf9\u5e94\u7684EAS\u5ba2\u6237\u6570\u636e" + customer.getCustomerEAS().getName() + "\u672a\u5ba1\u6838\u3002");
                return;
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("saleOrgUnit"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("customer = '" + customer.getCustomerEAS().getId().toString() + "'"));
            filterInfo.getFilterItems().add(new FilterItemInfo("SaleOrgUnit = '" + businOpportInfo.getSaleOrgUnit().getId() + "'"));
            viewInfo.setFilter(filterInfo);
            CustomerSaleInfoCollection BDCustomerSaleInfoCollection = CustomerSaleInfoFactory.getRemoteInstance().getCustomerSaleInfoCollection(viewInfo);
            if (BDCustomerSaleInfoCollection.size() < 1) {
                StringBuffer alerts = new StringBuffer("\u5546\u673a\u7684");
                alerts.append(customer.getName());
                alerts.append("\u5ba2\u6237\u5bf9\u5e94\u7684EAS\u5ba2\u6237\u6570\u636e\uff08");
                alerts.append(customer.getCustomerEAS().getName());
                alerts.append("\uff09\u672a\u5206\u914d\u5230");
                alerts.append(businOpportInfo.getSaleOrgUnit().getName());
                alerts.append("\u9500\u552e\u7ec4\u7ec7\u4e0a\uff0c\u4e0d\u80fd\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c\u3002");
                this.application.showMessage(alerts.toString());
                return;
            }
            String sPK = this.copyBusinOpportToSaleOrder(businOpportInfo, customer);
            this.rewriteBusinOpport(businOpportInfo.getId().toString(), sPK);
            this.application.showMessage("\u9500\u552e\u8ba2\u5355\u5df2\u7ecf\u751f\u6210\uff01");
        }
        this.application.getBillView().refresh();
    }

    private String copyBusinOpportToSaleOrder(BusinOpportInfo businOpportInfo, CustomerInfo customer) throws SyncToEASException, EASBizException, BOSException {
        ArrayList<String> ignoreProperties = new ArrayList<String>();
        ignoreProperties.add("id");
        ignoreProperties.add("billType");
        ignoreProperties.add("product");
        HashMap<String, Object> specifiedValues = new HashMap<String, Object>();
        specifiedValues.put("orderCustomer", customer.getCustomerEAS());
        specifiedValues.put("bizType", BizTypeFactory.getRemoteInstance().getBizTypeInfo("select id where name='\u666e\u901a\u9500\u552e'"));
        specifiedValues.put("isInTax", Boolean.TRUE);
        specifiedValues.put("baseStatus", BillBaseStatusEnum.TEMPORARILYSAVED);
        specifiedValues.put("sourceBillId", businOpportInfo.getId().toString());
        specifiedValues.put("sourceBillType", "u8s3tsKHckKxZ+uHL2qa1EY+1VI=");
        specifiedValues.put("bizDate", new Date());
        HashMap<String, String> propertyMapping = new HashMap<String, String>();
        propertyMapping.put("person", "salePerson");
        SaleOrderInfo saleOrder = (SaleOrderInfo)SyncBaseData.copyCoreBaseData2(SaleOrderInfo.class, (IObjectValue)businOpportInfo, ignoreProperties, propertyMapping, specifiedValues);
        String number = CodingRuleUtils.getNumberByClient((IObjectValue)saleOrder, (String)ContextUtil.getCurrentOrgUnit((Context)this.application.getContext()).getId().toString());
        saleOrder.setNumber(number);
        this.copyEntries(businOpportInfo, saleOrder);
        return SaleOrderFactory.getRemoteInstance().addnew((CoreBaseInfo)saleOrder).toString();
    }

    private void copyEntries(BusinOpportInfo businOpportInfo, SaleOrderInfo saleOrder) throws SyncToEASException, BOSException {
        BusinOpportProductCollection products = businOpportInfo.getProduct();
        BigDecimal totalAmount = new BigDecimal(0.0);
        BigDecimal totalTax = new BigDecimal(0.0);
        BigDecimal totalTaxAmount = new BigDecimal(0.0);
        if (products != null) {
            BusinOpportProductInfo product = null;
            ArrayList<String> ignoreProperties = new ArrayList<String>();
            ignoreProperties.add("id");
            HashMap<String, String> propertyMapping = new HashMap<String, String>();
            propertyMapping.put("quantity", "qty");
            propertyMapping.put("price", "taxPrice");
            propertyMapping.put("computeAmount", "amount");
            HashMap<String, Object> specifiedValues = new HashMap<String, Object>();
            specifiedValues.put("sourceBillId", businOpportInfo.getId().toString());
            specifiedValues.put("sourceBillNumber", businOpportInfo.getNumber());
            for (int i = 0; i < products.size(); ++i) {
                BigDecimal maxTaxtRate;
                BigDecimal tempTaxtRate;
                product = products.get(i);
                if (product.getId() == null) {
                    this.application.showMessage("\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\u3002");
                    return;
                }
                specifiedValues.put("sourceBillEntryId", product.getId().toString());
                specifiedValues.put("sourceBillEntrySeq", new Integer(product.getSeq()));
                BigDecimal saleOrderEntryPrice = product.getPrice();
                MaterialSalesCollection materials = MaterialSalesFactory.getRemoteInstance().getMaterialSalesCollection("select taxRate where material.id='" + product.getMaterial().getId() + "' and taxRate is not null");
                BigDecimal taxRate = null;
                taxRate = materials != null && !materials.isEmpty() ? ((tempTaxtRate = materials.get(0).getTaxRate()).compareTo(maxTaxtRate = new BigDecimal(9.9999999999999E11)) == 1 ? maxTaxtRate : tempTaxtRate) : new BigDecimal(17.0);
                specifiedValues.put("taxRate", taxRate);
                BigDecimal price = saleOrderEntryPrice.divide(new BigDecimal(1.0).add(taxRate.divide(new BigDecimal(100.0), 4, 4)), 4, 4);
                specifiedValues.put("price", price);
                BigDecimal taxAmount = product.getQuantity().multiply(product.getPrice());
                totalTaxAmount = totalTaxAmount.add(taxAmount);
                specifiedValues.put("taxAmount", taxAmount);
                BigDecimal tax = taxAmount.divide(new BigDecimal(1.0).add(taxRate.divide(new BigDecimal(100.0), 4, 4)), 4, 4).multiply(taxRate.divide(new BigDecimal(100.0), 4, 4));
                totalTax = totalTax.add(tax);
                specifiedValues.put("tax", tax);
                BigDecimal amount = taxAmount.subtract(tax);
                totalAmount = totalAmount.add(amount);
                specifiedValues.put("amount", amount);
                BigDecimal actRatePrice = null;
                actRatePrice = product.getQuantity().equals(new BigDecimal(0.0)) ? new BigDecimal(0.0) : taxAmount.divide(product.getQuantity(), 4, 4);
                specifiedValues.put("actualTaxPrice", actRatePrice);
                BigDecimal actPrice = null;
                actPrice = product.getQuantity().equals(new BigDecimal(0.0)) ? new BigDecimal(0.0) : amount.divide(product.getQuantity(), 4, 4);
                specifiedValues.put("actualPrice", actPrice);
                BigDecimal discount = new BigDecimal(0.0);
                BigDecimal discountAmount = new BigDecimal(0.0);
                specifiedValues.put("discount", discount);
                specifiedValues.put("discountAmount", discountAmount);
                SaleOrderEntryInfo entryInfo = (SaleOrderEntryInfo)SyncBaseData.copyCoreBaseData2(SaleOrderEntryInfo.class, (IObjectValue)product, ignoreProperties, propertyMapping, specifiedValues);
                saleOrder.getEntries().add(entryInfo);
            }
        }
        saleOrder.setTotalAmount(totalAmount);
        saleOrder.setTotalTax(totalTax);
        saleOrder.setTotalTaxAmount(totalTaxAmount);
    }

    private void rewriteBusinOpport(String qPK, String sPK) throws EASBizException, BOSException {
        BusinOpportInfo businOpportInfo = new BusinOpportInfo();
        businOpportInfo.setIsProduceEASOrder(true);
        businOpportInfo.setId(BOSUuid.read((String)qPK));
        SaleOrderInfo saleOrder = new SaleOrderInfo();
        saleOrder.setId(BOSUuid.read((String)sPK));
        businOpportInfo.setEASSaleOrder(saleOrder);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("isProduceEASOrder");
        sic.add("EASSaleOrder");
        BusinOpportFactory.getRemoteInstance().updatePartial(businOpportInfo, sic);
    }

    public void onGetFieldFilter(BaseDataFilterArg arg) throws EASBizException, BOSException {
        CustomerInfo customerInfo;
        super.onGetFieldFilter(arg);
        if ("FContactor".equalsIgnoreCase(arg.getKey()) && (null == (customerInfo = (CustomerInfo)this.application.getValue("FbdCustomer", 0)) || StringUtils.isEmpty((String)customerInfo.getId().toString()))) {
            throw new BOSException("\u8bf7\u5148\u8f93\u5165\u5ba2\u6237\u3002");
        }
    }
}

