/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.common.ExecuteStatusEnum;
import com.kingdee.eas.scm.crm.plugins.util.BillViewUtil;
import com.kingdee.eas.scm.crm.sm.ClueFactory;
import com.kingdee.eas.scm.crm.sm.ClueInfo;
import java.sql.Timestamp;
import java.util.Date;

public class ClueCloseBillPlugin
extends AbstractBillPlugin {
    private static final String CT_CLOSERESULT_KEY = "FCloseResult";
    private static final String CT_BILLSTATES_KEY = "FradioGroup";
    private static final String BTN_OK = "FbtnOk";
    private ClueInfo ClueInfo;

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        String clueID = (String)this.application.getCustomParameter("BillId");
        this.ClueInfo = ClueFactory.getRemoteInstance().getClueInfo((IObjectPK)new ObjectUuidPK(clueID));
        return super.onInitialize(param);
    }

    public void afterCreateNewData() throws EASBizException, BOSException {
        super.afterCreateNewData();
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        super.doCustomOperation(operation);
        if (BTN_OK.equalsIgnoreCase(operation)) {
            String memo = (String)this.application.getBillValue().get("CloseResult");
            if (memo != null && memo.length() > 1000) {
                this.application.showMessage("\u5173\u95ed\u539f\u56e0\u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e1000\u3002");
                return;
            }
            IObjectPK[] pks = BillViewUtil.beforeLog(this.application, "unClose", "\u5173\u95ed", new String[]{this.ClueInfo.getId().toString()});
            this.ClueInfo.setExecuteStatus(ExecuteStatusEnum.getEnum((Integer)this.application.getValue(CT_BILLSTATES_KEY, 0)));
            this.ClueInfo.setCloseResult((String)this.application.getValue(CT_CLOSERESULT_KEY, 0));
            ClueFactory.getRemoteInstance().save((CoreBaseInfo)this.ClueInfo);
            BillViewUtil.afterLog(this.application, pks, new String[]{this.ClueInfo.getId().toString()});
            this.application.setParentRefresh(true);
            this.ClueInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
            this.application.showMessage("\u5173\u95ed\u64cd\u4f5c\u6210\u529f\u3002");
            this.application.close();
        } else if ("close".equalsIgnoreCase(operation)) {
            this.application.close();
        }
    }
}

