/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IDynamicFormModel;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.orgext.ServiceOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.plugins.bill.service.AbstractServiceModuleBillPlugin;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.FinanceUtil;
import com.kingdee.eas.scm.crm.service.ServiceDispatchInfo;
import com.kingdee.eas.scm.crm.service.ServiceOrderInfo;
import com.kingdee.eas.scm.crm.service.ServiceOrderProductCollection;
import java.math.BigDecimal;
import java.text.ParseException;

public class ServiceOrderBillPlugin
extends AbstractServiceModuleBillPlugin {
    private static final String KEY_COMPANY = "ForgCompanyOrgUnit";
    private static final String KEY_CURRENCY = "FbdCurrency";
    private static final String KEY_RATE = "FRate";

    public void doOnLoad() {
    }

    public void doAfterCreateNewData() throws EASBizException, BOSException {
        ServiceDispatchInfo serviceDispatchInfo;
        ServiceOrderInfo serviceOrderInfo = (ServiceOrderInfo)this.application.getBillModel().getBillValue();
        ServiceOrgUnitInfo serviceOrgUnitInfo = (ServiceOrgUnitInfo)this.application.getValue("ForgServiceOrgUnit", 0);
        this.setOrgUnitByServiceOrgUnit(serviceOrgUnitInfo, serviceOrderInfo);
        IDynamicFormView parentView = this.application.getDynamicFormView().getParentFormView();
        if (null != parentView && null != (serviceDispatchInfo = (ServiceDispatchInfo)parentView.getApplicationContext().getData("ServiceDispatch"))) {
            serviceOrderInfo.setServiceDispatch(serviceDispatchInfo);
        }
    }

    public void doDataChanged(DataChangeCommandArg dataChangeCommandArg) {
        ServiceOrderInfo serviceOrderInfo = (ServiceOrderInfo)this.application.getBillModel().getBillValue();
        try {
            CompanyOrgUnitInfo companyOrgUnitInfo;
            ServiceOrgUnitInfo serviceOrgUnitInfo;
            if ("FbdServicePerson".equalsIgnoreCase(dataChangeCommandArg.getKey())) {
                serviceOrgUnitInfo = (ServiceOrgUnitInfo)this.application.getValue("ForgServiceOrgUnit", 0);
                this.setOrgUnitByServiceOrgUnit(serviceOrgUnitInfo, serviceOrderInfo);
                this.application.getView().bindData((IDynamicFormModel)this.application.getBillModel());
            }
            if ("ForgServiceOrgUnit".equalsIgnoreCase(dataChangeCommandArg.getKey())) {
                serviceOrgUnitInfo = serviceOrderInfo.getServiceOrgUnit();
                this.setOrgUnitByServiceOrgUnit(serviceOrgUnitInfo, serviceOrderInfo);
                this.application.getView().bindData((IDynamicFormModel)this.application.getBillModel());
            } else if (KEY_COMPANY.equalsIgnoreCase(dataChangeCommandArg.getKey())) {
                companyOrgUnitInfo = serviceOrderInfo.getCompanyOrgUnit();
                this.setCurrencyForCompanyOrgUnit(companyOrgUnitInfo);
            } else if (KEY_CURRENCY.equalsIgnoreCase(dataChangeCommandArg.getKey())) {
                companyOrgUnitInfo = serviceOrderInfo.getCompanyOrgUnit();
                CurrencyInfo currencyInfo = serviceOrderInfo.getCurrency();
                this.setRateForCurrency(companyOrgUnitInfo, currencyInfo);
            }
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        catch (JSONException e) {
            Logger.error((Throwable)e);
        }
        catch (ParseException e) {
            Logger.error((Throwable)e);
        }
    }

    private void setCurrencyForCompanyOrgUnit(CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        if (companyOrgUnitInfo != null) {
            companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select *,baseCurrency.* where id = '" + companyOrgUnitInfo.getId() + "'");
            CurrencyInfo currencyInfo = FinanceUtil.getBaseCurrencyInfo(companyOrgUnitInfo);
            if (null != currencyInfo) {
                this.setRateForCurrency(companyOrgUnitInfo, currencyInfo);
            } else {
                this.application.setValue(KEY_RATE, null, 0);
            }
            this.application.setValue(KEY_CURRENCY, (Object)currencyInfo, 0);
        } else {
            this.application.setValue(KEY_CURRENCY, null, 0);
            this.application.setValue(KEY_RATE, null, 0);
        }
    }

    private void setRateForCurrency(CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        if (companyOrgUnitInfo != null && currencyInfo != null) {
            companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select *,baseCurrency.* where id = '" + companyOrgUnitInfo.getId() + "'");
            BOSUuid exchangetableId = companyOrgUnitInfo.getBaseExchangeTable().getId();
            BigDecimal exchangeRate = FinanceUtil.getExchangeRate(exchangetableId, currencyInfo.getId(), companyOrgUnitInfo.getBaseCurrency().getId());
            this.application.setValue(KEY_RATE, (Object)exchangeRate, 0);
        } else {
            this.application.setValue(KEY_RATE, null, 0);
        }
    }

    private void setDefaultCurrencyAndRateForCompanyOrgUnit(ServiceOrderInfo serviceOrderInfo, CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        if (companyOrgUnitInfo != null) {
            companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select *,baseCurrency.* where id = '" + companyOrgUnitInfo.getId() + "'");
            CurrencyInfo currencyInfo = FinanceUtil.getBaseCurrencyInfo(companyOrgUnitInfo);
            serviceOrderInfo.setCurrency(currencyInfo);
            if (null != currencyInfo) {
                BOSUuid exchangetableId = companyOrgUnitInfo.getBaseExchangeTable().getId();
                BigDecimal exchangeRate = FinanceUtil.getExchangeRate(exchangetableId, currencyInfo.getId(), companyOrgUnitInfo.getBaseCurrency().getId());
                serviceOrderInfo.setExchangeRate(exchangeRate);
            }
        }
    }

    private void setOrgUnitByServiceOrgUnit(ServiceOrgUnitInfo serviceOrgUnitInfo, ServiceOrderInfo serviceOrderInfo) throws EASBizException, BOSException {
        block5: {
            int size;
            ServiceOrderProductCollection serviceOrderProductCollection;
            block4: {
                serviceOrderProductCollection = serviceOrderInfo.getProduct();
                size = serviceOrderProductCollection.size();
                if (null == serviceOrgUnitInfo) break block4;
                CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)CommonUtil.getOrgUnit(OrgType.getEnum((int)100), OrgType.Company, serviceOrgUnitInfo.getId());
                serviceOrderInfo.setCompanyOrgUnit(companyOrgUnitInfo);
                this.setDefaultCurrencyAndRateForCompanyOrgUnit(serviceOrderInfo, companyOrgUnitInfo);
                if (null == serviceOrderProductCollection || serviceOrderProductCollection.isEmpty()) break block5;
                for (int i = 0; i < size; ++i) {
                    StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)CommonUtil.getOrgUnit(OrgType.getEnum((int)100), OrgType.Storage, serviceOrgUnitInfo.getId());
                    serviceOrderProductCollection.get(i).setStorageOrgUnit(storageOrgUnitInfo);
                    if (null != storageOrgUnitInfo) {
                        SaleOrgUnitInfo saleOrgUnitInfo = (SaleOrgUnitInfo)CommonUtil.getOrgUnit(OrgType.Storage, OrgType.Sale, storageOrgUnitInfo.getId());
                        serviceOrderProductCollection.get(i).setSaleOrgUnit(saleOrgUnitInfo);
                        continue;
                    }
                    serviceOrderProductCollection.get(i).setSaleOrgUnit(null);
                }
                break block5;
            }
            if (null != serviceOrderProductCollection && !serviceOrderProductCollection.isEmpty()) {
                for (int i = 0; i < size; ++i) {
                    serviceOrderProductCollection.get(i).setStorageOrgUnit(null);
                    serviceOrderProductCollection.get(i).setSaleOrgUnit(null);
                }
            }
        }
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        super.afterOperation(operation);
        ServiceOrderInfo serviceOrderInfo = (ServiceOrderInfo)this.application.getBillModel().getBillValue();
        ServiceOrgUnitInfo serviceOrgUnitInfo = serviceOrderInfo.getServiceOrgUnit();
        if ("NewEntry".equalsIgnoreCase(operation.getOperation()) && null != serviceOrgUnitInfo) {
            ServiceOrderProductCollection serviceOrderProductCollection = serviceOrderInfo.getProduct();
            int size = serviceOrderProductCollection.size();
            if (null != serviceOrderProductCollection && size > 0) {
                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)CommonUtil.getOrgUnit(OrgType.getEnum((int)100), OrgType.Storage, serviceOrgUnitInfo.getId());
                serviceOrderProductCollection.get(size - 1).setStorageOrgUnit(storageOrgUnitInfo);
                if (null != storageOrgUnitInfo) {
                    SaleOrgUnitInfo saleOrgUnitInfo = (SaleOrgUnitInfo)CommonUtil.getOrgUnit(OrgType.Storage, OrgType.Sale, storageOrgUnitInfo.getId());
                    serviceOrderProductCollection.get(size - 1).setSaleOrgUnit(saleOrgUnitInfo);
                }
                try {
                    this.application.getView().bindData((IDynamicFormModel)this.application.getBillModel());
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void doGetFieldFilter(BaseDataFilterArg arg) throws EASBizException, BOSException {
    }

    protected void doLockElementAfterBindData() throws EASBizException, BOSException {
    }
}

