/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.bill.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.base.form.core.UserDefinedData.UserDefinedDataEntryInfo;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.customer.CustomerInfo;
import com.kingdee.eas.scm.crm.plugins.ServiceCommonMethods;
import com.kingdee.eas.scm.crm.plugins.bill.service.AbstractServiceModuleBillPlugin;
import com.kingdee.eas.scm.crm.plugins.util.UDDUtil;
import com.kingdee.eas.scm.crm.service.ServiceFlowInfo;
import com.kingdee.eas.scm.crm.service.ServiceRepairFactory;
import com.kingdee.eas.scm.crm.service.ServiceRepairInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ServiceRepairBillPlugin
extends AbstractServiceModuleBillPlugin {
    private static final String SHARE_USERS_FORMID = "m8KyymtaS0ytjYIY3v/D9Jp+rpI=";
    private static final String CHARGE_ITEM_FORMID = "9V8j/KnXSj2oHcl0s6W4AZp+rpI=";
    private static final String ACCESSORIES_USERS_FORMID = "ky1sip39RvKECM2yHitWv5p+rpI=";

    public void setDefaultValue() throws EASBizException, BOSException {
        UserDefinedDataEntryInfo handleStatus;
        ServiceRepairInfo serviceRepairInfo = (ServiceRepairInfo)this.application.getBillValue();
        if (!this.isCopyForm()) {
            UserDefinedDataEntryInfo urgencyLevel;
            this.application.setValue("FbdServicePerson", (Object)ContextUtil.getCurrentUserInfo((Context)this.getContext()), 0);
            UserDefinedDataEntryInfo isUnderGuaranty = UDDUtil.loadUDDEntryByName("\u8fd4\u5382\u7ef4\u4fee\u662f\u5426\u4fdd\u5185", "\u672a\u77e5");
            if (null != isUnderGuaranty) {
                this.application.setValue("FIsUnderGuaranty", (Object)isUnderGuaranty, 0);
            }
            if (null != (urgencyLevel = UDDUtil.loadUDDEntryByName("\u7d27\u6025\u7a0b\u5ea6", "\u4e2d"))) {
                this.application.setValue("FUrgencyLevelID", (Object)urgencyLevel, 0);
            }
        }
        if (null != (handleStatus = UDDUtil.loadUDDEntryByName("\u8fd4\u5382\u7ef4\u4fee\u5904\u7406\u72b6\u6001", "\u53d7\u7406"))) {
            serviceRepairInfo.setHandleStatus(handleStatus);
        }
        serviceRepairInfo.setRecordDate(new Date());
        super.setDefaultValue();
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        ServiceRepairInfo serviceRepairInfo = (ServiceRepairInfo)this.application.getBillValue();
        if ("Save".equalsIgnoreCase(operation.getOperation()) || "Submit".equalsIgnoreCase(operation.getOperation())) {
            if (StringUtils.isEmpty((String)serviceRepairInfo.getName())) {
                this.application.showMessage("\u4e3b\u9898\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (StringUtils.isEmpty((String)serviceRepairInfo.getRepairer())) {
                this.application.showMessage("\u9001\u4fee\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (null == serviceRepairInfo.getRepairerPhone()) {
                this.application.showMessage("\u9001\u4fee\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (null == serviceRepairInfo.getDeliveryPhone()) {
                this.application.showMessage("\u56de\u5bc4\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (null == serviceRepairInfo.getAddressee()) {
                this.application.showMessage("\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (null != serviceRepairInfo.getDeadline() && serviceRepairInfo.getRecordDate().after(serviceRepairInfo.getDeadline())) {
                this.application.showMessage("\u8981\u6c42\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u9001\u4fee\u65f6\u95f4");
                return false;
            }
        }
        return super.beforeOperation(operation);
    }

    public void beforeCopy(BillApplication application) {
        try {
            ServiceCommonMethods.beforCopyForFlowStage(application);
            ServiceCommonMethods.beforCopyForAcce(application);
            ServiceCommonMethods.beforCopyForChargeItem(application);
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    public void carrayValue(DataChangeCommandArg arg) throws EASBizException, BOSException {
        CustomerInfo customer;
        super.carrayValue(arg);
        ServiceRepairInfo serviceRepairInfo = (ServiceRepairInfo)this.application.getBillModel().getBillValue();
        if ("FServiceFlow".equalsIgnoreCase(arg.getKey())) {
            ServiceFlowInfo serviceFlow = serviceRepairInfo.getServiceFlow();
            if (null != serviceFlow && serviceFlow.getFlowStage() != null) {
                this.application.setValue("FlowStage", (Object)serviceFlow.getFlowStage().get(0), 0);
            }
            this.storeDataInPageScope("FlowStage", serviceFlow != null ? serviceFlow.getFlowStage().get(0) : null);
        }
        if ("FCustomer".equalsIgnoreCase(arg.getKey()) && (customer = serviceRepairInfo.getCustomer()) != null) {
            StringBuffer oql = new StringBuffer(20);
            oql.append("customer.id='" + customer.getId().toString() + "'");
            this.application.setFieldFilter("FServiceAsset", oql.toString());
            this.application.setValue("FServiceAsset", null, 0);
        }
    }

    public void doAfterDataChanged(DataChangeCommandArg arg) throws EASBizException, BOSException {
        ServiceRepairInfo serviceRepairInfo = (ServiceRepairInfo)this.application.getBillValue();
        if (null != serviceRepairInfo.getHandleStatus()) {
            if ("\u5904\u7406".equals(serviceRepairInfo.getHandleStatus().toString())) {
                // empty if block
            }
            if (!"\u5173\u95ed".equals(serviceRepairInfo.getHandleStatus().toString()) || "\u7ec8\u6b62".equals(serviceRepairInfo.getHandleStatus().toString())) {
                // empty if block
            }
        }
        super.doAfterDataChanged(arg);
    }

    public void setF7DefaultFilter() throws EASBizException, BOSException {
        super.setF7DefaultFilter();
        this.application.setFieldFilter("FServiceFlow", "flowType = 3");
    }

    public void doDistributeInitParmAction() {
        super.doDistributeInitParmAction();
        try {
            UserDefinedDataEntryInfo dealStatus = UDDUtil.loadUDDEntryByName("\u8fd4\u5382\u7ef4\u4fee\u5904\u7406\u72b6\u6001", "\u5904\u7406");
            this.storeDataInPageScope("handleStatusID", dealStatus.getId().toString());
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    public int getCommHandValue(String handstatus) {
        if (handstatus.equals("\u53d7\u7406")) {
            return 0;
        }
        if (handstatus.equals("\u5173\u95ed") || handstatus.equals("\u7ec8\u6b62")) {
            return 9;
        }
        if (handstatus.equals("\u5904\u7406")) {
            return 1;
        }
        return super.getCommHandValue(handstatus);
    }

    public Map checkBeforeClose(List idList) throws EASBizException, BOSException {
        if (null == idList || idList.size() < 1) {
            return null;
        }
        return ServiceRepairFactory.getRemoteInstance().checkBeforeClose(idList);
    }

    public Map checkBeforeAntiClose(List idList) throws EASBizException, BOSException {
        if (null == idList || idList.size() < 1) {
            return null;
        }
        return ServiceRepairFactory.getRemoteInstance().checkBeforeAntiClose(idList);
    }

    public UserDefinedDataEntryInfo getHandleStatus() throws BOSException {
        return UDDUtil.loadUDDEntryByName("\u8fd4\u5382\u7ef4\u4fee\u5904\u7406\u72b6\u6001", "\u5904\u7406");
    }

    public UserDefinedDataEntryInfo getSuccessHandleStatus() throws BOSException {
        return UDDUtil.loadUDDEntryByName("\u8fd4\u5382\u7ef4\u4fee\u5904\u7406\u72b6\u6001", "\u5173\u95ed");
    }

    public UserDefinedDataEntryInfo getFailHandleStatus() throws BOSException {
        return UDDUtil.loadUDDEntryByName("\u8fd4\u5382\u7ef4\u4fee\u5904\u7406\u72b6\u6001", "\u7ec8\u6b62");
    }

    protected String getPermRelProp() {
        return "serviceRepair";
    }

    public String getShareFormId() {
        return SHARE_USERS_FORMID;
    }

    public String getChargeItemFormId() {
        return CHARGE_ITEM_FORMID;
    }

    public String getAccessoriesFormId() {
        return ACCESSORIES_USERS_FORMID;
    }
}

