/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.list;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.command.BeforeDeleteArg;
import com.kingdee.eas.base.form.model.command.BeforeListFieldRenderArg;
import com.kingdee.eas.base.form.model.command.BeforeQueryArg;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.plugins.support.filter.DeleteFilterSuit;
import com.kingdee.eas.scm.crm.plugins.support.filter.PermissionFilter;
import com.kingdee.eas.scm.crm.plugins.support.filter.XmlFilter;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.ListViewUtil;
import com.kingdee.eas.scm.crm.plugins.util.MyRemoteObjectUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractCRMListPlugin
extends ListPlugin {
    private Map permissions;

    protected abstract boolean isEnableCRMPemission();

    public void onBeforeQuery(BeforeQueryArg arg) {
        super.onBeforeQuery(arg);
        try {
            this.appendCondition(arg);
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendCondition(BeforeQueryArg arg) throws BOSException {
        FilterInfo filter = arg.getFilterInfo();
        FilterInfo dataPermissionFilter = arg.getPermissionFilterInfo();
        FilterInfo cuFilter = new FilterInfo();
        cuFilter.getFilterItems().add(new FilterItemInfo("CU.id='" + ContextUtil.getCurrentCtrlUnit((Context)this.getContext()).getId() + "'"));
        filter.mergeFilter(cuFilter, "and");
        if (dataPermissionFilter != null) {
            filter.mergeFilter(dataPermissionFilter, "and");
            if (this.isRelationBill()) {
                filter.mergeFilter(this.generateCreatorFilter(), "and");
            }
            if (this.isEnableCRMPemission()) {
                filter.mergeFilter(this.generatePermissionFilter(), "or");
            }
        } else {
            if (this.isRelationBill()) {
                filter.mergeFilter(this.generateCreatorFilter(), "and");
            }
            if (this.isEnableCRMPemission()) {
                filter.mergeFilter(this.generatePermissionFilter(), "or");
            }
        }
        arg.setCustomziedFilter(true);
    }

    private FilterInfo generateCreatorFilter() {
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("creator.id='").append(ContextUtil.getCurrentUserInfo((Context)this.getContext()).getId()).append("'");
        filter.getFilterItems().add(new FilterItemInfo(sb.toString()));
        return filter;
    }

    private FilterInfo generatePermissionFilter() {
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append(" id in (select bizUser.FEntityID from T_CRM_OpAssociatedUser bizUser where bizUser.FUserID='");
        sb.append(ContextUtil.getCurrentUserInfo((Context)this.getContext()).getId()).append("')");
        filter.getFilterItems().add(new FilterItemInfo(sb.toString()));
        return filter;
    }

    public void beforeFieldRender(BeforeListFieldRenderArg arg) throws EASBizException, BOSException {
        super.beforeFieldRender(arg);
        if (!this.isEnableCRMPemission() || this.permissions != null) {
            // empty if block
        }
    }

    public void pageChanged() throws EASBizException, BOSException {
        super.pageChanged();
        if (this.isEnableCRMPemission()) {
            LinkedList recordIDs = this.application.getListModel().getCurrentPageIdList();
            Context ctx = this.getContext();
            this.permissions = CRMPermissionHelper.getCRMPermissionMap(recordIDs.toArray(new String[recordIDs.size()]), null, ctx);
        }
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        if (!this.isEnableCRMPemission() || "Edit".equalsIgnoreCase(operation.getOperation())) {
            // empty if block
        }
        if ("Delete".equalsIgnoreCase(operation.getOperation())) {
            try {
                ListViewUtil.logicDelete(this.application, this.doDeleteFilter(CommonUtil.array2List(this.application.getListView().getSelectedBillIds())));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return false;
        }
        return super.beforeOperation(operation);
    }

    public void onBeforeDelete(BeforeDeleteArg arg) {
        try {
            this.doDeleteFilter(arg);
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doDeleteFilter(BeforeDeleteArg arg) throws BOSException, SQLException, EASBizException {
        List ids = arg.getIdList();
        String tableName = this.getMainTableName();
        Map numMap = AbstractCRMListPlugin.getNumberMap(this.getContext(), ids, tableName);
        DeleteFilterSuit filterSuit = new DeleteFilterSuit(numMap);
        filterSuit.addFilter(new PermissionFilter(this.isEnableCRMPemission(), numMap, this.application));
        filterSuit.addFilter(new XmlFilter(tableName, numMap));
        String alerts = filterSuit.runFilter(this.getContext(), ids);
        this.application.showMessage(alerts);
    }

    protected List doDeleteFilter(List ids) throws BOSException, SQLException, EASBizException {
        String tableName = this.getMainTableName();
        Map numMap = AbstractCRMListPlugin.getNumberMap(this.getContext(), ids, tableName);
        DeleteFilterSuit filterSuit = new DeleteFilterSuit(numMap);
        filterSuit.addFilter(new PermissionFilter(this.isEnableCRMPemission(), numMap, this.application));
        filterSuit.addFilter(new XmlFilter(tableName, numMap));
        String alerts = filterSuit.runFilter(this.getContext(), ids);
        this.application.showMessage(alerts);
        return ids;
    }

    protected final void setData(String key, Object o) {
        this.application.getApplicationContext().putData(key, o);
    }

    protected final Object getParentData(String key) {
        IDynamicFormView parent = this.application.getDynamicFormView().getParentFormView();
        if (parent != null) {
            return parent.getApplicationContext().getData(key);
        }
        return null;
    }

    protected final String getPermissionName(String operationName) {
        FormOperation operation = this.application.getForm().getOperation(operationName);
        return operation == null ? "" : operation.getPermissionItem();
    }

    protected final Context getContext() {
        return this.application.getContext();
    }

    protected final void storeShareData(String key) {
        IObjectValue obj = (IObjectValue)this.getParentData(key);
        if (obj != null) {
            this.setData(key, obj);
        }
    }

    protected final boolean isRelationBill() {
        IDynamicFormView parent = this.application.getDynamicFormView().getParentFormView();
        return parent != null;
    }

    protected final String getMainTableName() {
        return this.application.getListModel().getBusinessInfo().getEntity(0).getTableName();
    }

    private static final Map getNumberMap(Context ctx, List list, String tableName) throws BOSException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList loopList = new ArrayList(list);
        MyRemoteObjectUtil remoteObjectUtil = MyRemoteObjectUtil.getInstance();
        while ((double)loopList.size() / 50.0 > 0.0) {
            List tempList = CommonUtil.getTempList(loopList);
            StringBuffer sql = new StringBuffer("select FId,FNumber from " + tableName + " where fid in (" + CommonUtil.listToString(tempList) + ")");
            IRowSet numberSet = remoteObjectUtil.executeQuery(ctx, sql.toString());
            while (numberSet.next()) {
                map.put(numberSet.getString(1), numberSet.getString(2));
            }
            loopList.removeAll(tempList);
        }
        return map;
    }
}

