/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.list.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.model.command.BeforeQueryArg;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.common.CrmRoleCollection;
import com.kingdee.eas.scm.crm.common.CrmRoleFactory;
import com.kingdee.eas.scm.crm.common.CrmRoleInfo;
import com.kingdee.eas.scm.crm.common.FormInfo;
import com.kingdee.eas.scm.crm.plugins.list.AbstractCRMListPlugin;
import com.kingdee.eas.scm.crm.plugins.util.BusinessException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CrmRoleListPlugin
extends AbstractCRMListPlugin {
    private static final String CT_FORM_TYPE_KEY = "F7FromType";
    private static final String ACTION_ENABLED = "Enabled";
    private static final String ACTION_DISABLED = "Disabled";

    public void onLoad() {
        String formId = (String)this.application.getCustomParameter("crm_role_type");
        if (null != formId && formId.trim().length() != 0) {
            FormInfo form = new FormInfo();
            form.setId(BOSUuid.read((String)formId));
            try {
                this.application.setFieldFilter(CT_FORM_TYPE_KEY, "id = '" + formId + "'");
                this.application.setValue(CT_FORM_TYPE_KEY, (Object)form, 0);
            }
            catch (EASBizException e) {
                throw new BusinessException(e);
            }
            catch (BOSException e) {
                throw new BusinessException(e);
            }
        }
    }

    public void onBeforeQuery(BeforeQueryArg arg) {
        String formId = (String)this.application.getCustomParameter("crm_role_type");
        String recordId = (String)this.application.getCustomParameter("BillId");
        this.application.getApplicationContext().putData("crm_role_type", (Object)(formId != null ? formId : null));
        this.application.getApplicationContext().putData("BillId", (Object)(recordId != null ? recordId : null));
        if (recordId != null) {
            arg.setFilterBy("t1.FRecordId='" + recordId + "'");
        } else {
            arg.setFilterBy(this.application.getFieldName("Flist", false) + "=" + String.valueOf(0));
        }
        FilterInfo crmFitler = new FilterInfo();
        crmFitler.getFilterItems().add(this.buildLogicDeleteFilter());
        try {
            arg.getFilterInfo().mergeFilter(crmFitler, "and");
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
        super.onBeforeQuery(arg);
    }

    private FilterItemInfo buildLogicDeleteFilter() {
        FilterItemInfo logicDeletedFilterItem = new FilterItemInfo("isDeleted = 0");
        return logicDeletedFilterItem;
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        String[] selectedIds = this.application.getListView().getSelectedBillIds();
        if (null == selectedIds || selectedIds.length == 0) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6216\u4e00\u884c\u4ee5\u4e0a\u7684\u8bb0\u5f55\u3002");
            return;
        }
        if (ACTION_DISABLED.equals(operation)) {
            this.setStatusDisbaled(selectedIds);
        } else if (ACTION_ENABLED.equals(operation)) {
            this.setStatusEnabled(selectedIds);
        }
        this.application.getListView().refresh();
    }

    private void setStatusEnabled(String[] selectedIds) throws EASBizException, BOSException {
        List operationIds = this.array2List(selectedIds);
        int size = operationIds.size();
        int loop = size / 50 + 1;
        CrmRoleCollection crmRoleCollection = new CrmRoleCollection();
        for (int i = 0; i < loop; ++i) {
            CrmRoleCollection tempCrmRoleCollection = null;
            try {
                int end = i == loop - 1 ? size : (i + 1) * 50;
                tempCrmRoleCollection = CrmRoleFactory.getRemoteInstance().getCrmRoleCollection(this.buildAbleEntityViewInfo(operationIds.subList(i * 50, end), false));
            }
            catch (BOSException e) {
                throw new BusinessException(e);
            }
            crmRoleCollection.addCollection(tempCrmRoleCollection);
        }
        this.setCrmRoleStatus(crmRoleCollection, true);
    }

    private void setStatusDisbaled(String[] selectedIds) throws EASBizException, BOSException {
        List operationIds = this.array2List(selectedIds);
        int size = operationIds.size();
        int loop = size / 50 + 1;
        CrmRoleCollection crmRoleCollection = new CrmRoleCollection();
        for (int i = 0; i < loop; ++i) {
            CrmRoleCollection tempCrmRoleCollection = null;
            try {
                int end = i == loop - 1 ? size : (i + 1) * 50;
                tempCrmRoleCollection = CrmRoleFactory.getRemoteInstance().getCrmRoleCollection(this.buildAbleEntityViewInfo(operationIds.subList(i * 50, end), true));
            }
            catch (BOSException e) {
                throw new BusinessException(e);
            }
            crmRoleCollection.addCollection(tempCrmRoleCollection);
        }
        this.setCrmRoleStatus(crmRoleCollection, false);
    }

    private void setCrmRoleStatus(CrmRoleCollection crmRoleCollection, boolean statusValue) throws EASBizException, BOSException {
        CrmRoleInfo crmRoleInfo = null;
        int size = crmRoleCollection.size();
        for (int i = 0; i < size; ++i) {
            crmRoleInfo = crmRoleCollection.get(i);
            crmRoleInfo.setIsEnabled(statusValue);
            CrmRoleFactory.getRemoteInstance().save((CoreBaseInfo)crmRoleInfo);
        }
    }

    private EntityViewInfo buildAbleEntityViewInfo(List deleteIds, boolean status) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        HashSet idsSet = new HashSet(deleteIds);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo selectedIdsfilterItemInfo = new FilterItemInfo("id", idsSet, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(selectedIdsfilterItemInfo);
        FilterItemInfo statsfilterItemInfo = new FilterItemInfo("isEnabled", (Object)new Boolean(status), CompareType.EQUALS);
        filterInfo.getFilterItems().add(statsfilterItemInfo);
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    protected boolean isEnableCRMPemission() {
        return false;
    }

    private List array2List(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        if (array == null || array.length == 0) {
            return list;
        }
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }
}

