/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.list.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.command.BeforeQueryArg;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.OrgUnitUtil;
import com.kingdee.eas.util.app.ContextUtil;

public class SaleOrderListPlugin
extends ListPlugin {
    static final String VIEW_PERMISSION = "crm_saleOrder_view";

    public void onLoad() {
        super.onLoad();
        try {
            StringBuffer oqlBuf = new StringBuffer();
            String shareFilter = this.buildF7ShareUserFilter(this.application.getContext());
            oqlBuf.append("CRMCustomer.id in (select Fid from T_CRM_Customer  where " + shareFilter + ")");
            this.application.setFieldFilter("FCustomer", oqlBuf.toString());
            String oql = this.getSaleOrgFilter();
            this.application.setFieldFilter("FSaleOrg", oql);
            this.application.setFieldFilter("FsaleGroup", this.getSaleGropFilter());
            SaleOrgUnitInfo saleOrg = ContextUtil.getCurrentSaleUnit((Context)this.application.getContext());
            if (saleOrg != null && saleOrg.isIsBizUnit()) {
                this.application.setValue("FSaleOrg", (Object)ContextUtil.getCurrentSaleUnit((Context)this.application.getContext()), 0);
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
    }

    private String getSaleGropFilter() {
        SaleOrgUnitInfo saleOrg = ContextUtil.getCurrentSaleUnit((Context)this.application.getContext());
        StringBuffer filter = new StringBuffer();
        if (saleOrg != null) {
            filter.append("saleOrg.id = '" + saleOrg.getId().toString() + "'");
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.application.getContext());
            PersonInfo person = userInfo.getPerson();
            if (person != null) {
                if (filter.length() > 0) {
                    filter.append(" and person.id= '" + person.getId().toString() + "'");
                } else {
                    filter.append("person.id= '" + person.getId().toString() + "'");
                }
            } else {
                filter.append("person.id='notExit'");
            }
        }
        return filter.toString();
    }

    private String buildF7ShareUserFilter(Context ctx) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append(" FcreatorID='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("' and FisDeleted = 0");
        oql.append(" or ( Fid in ( select SHAREUSER.FEntityID from T_CRM_OpAssociatedUser SHAREUSER where SHAREUSER.FUserID='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("') and FisDeleted = 0 )");
        return oql.toString();
    }

    public String getSaleOrgFilter() throws BOSException, EASBizException {
        OrgUnitCollection collection = OrgUnitUtil.getAuthOrgByPermItem((Context)this.application.getContext(), (OrgType)OrgType.Sale, (String)VIEW_PERMISSION, (int)2);
        if (collection != null && !collection.isEmpty()) {
            StringBuffer oql = new StringBuffer(" id in (");
            for (int i = 0; i < collection.size(); ++i) {
                OrgUnitInfo org = collection.get(i);
                oql.append("'").append(org.getId()).append("',");
            }
            oql.append(") and isBizUnit = 1");
            oql.deleteCharAt(oql.lastIndexOf(","));
            return oql.toString();
        }
        return null;
    }

    protected final String getPermissionName(String operationName) {
        FormOperation operation = this.application.getForm().getOperation(operationName);
        return operation == null ? "" : operation.getPermissionItem();
    }

    public void onBeforeQuery(BeforeQueryArg arg) {
        super.onBeforeQuery(arg);
        SaleOrgUnitInfo saleOrg = ContextUtil.getCurrentSaleUnit((Context)this.application.getContext());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.application.getContext());
        PersonInfo person = userInfo.getPerson();
        if (saleOrg != null && !saleOrg.isIsBizUnit()) {
            arg.setFilterBy("1<>1");
            return;
        }
        if (person == null) {
            arg.setFilterBy("1<>1");
            return;
        }
        try {
            StringBuffer filter = new StringBuffer();
            filter.append("FsalePersonid = '" + person.getId().toString() + "'");
            String shareSql = this.buildF7ShareUserFilter(this.application.getContext());
            StringBuffer shareFilter = new StringBuffer("FOrderCustomerID in (select crmCustomer.FCustomerEASID from T_CRM_CUSTOMER crmCustomer where crmCustomer.FID in (select Fid from T_CRM_Customer  where ");
            shareFilter.append(shareSql).append("))");
            StringBuffer saleOrgFilter = new StringBuffer();
            OrgUnitCollection collection = OrgUnitUtil.getAuthOrgByPermItem((Context)this.application.getContext(), (OrgType)OrgType.Sale, (String)this.getPermissionName("View"), (int)2);
            if (collection != null && !collection.isEmpty()) {
                StringBuffer saleOrgSql = new StringBuffer(" Fid in (");
                for (int i = 0; i < collection.size(); ++i) {
                    OrgUnitInfo org = collection.get(i);
                    saleOrgSql.append("'").append(org.getId()).append("',");
                }
                saleOrgSql.append(") and FisBizUnit = 1");
                saleOrgSql.deleteCharAt(saleOrgSql.lastIndexOf(","));
                saleOrgFilter.append("FSaleOrgUnitID in (select fid from T_ORG_Sale where" + saleOrgSql + ")");
                filter.append(" and " + saleOrgFilter.toString());
            }
            if (saleOrgFilter.length() > 0) {
                filter.append(" and ");
                filter.append(shareFilter.toString());
            }
            arg.setFilterBy(filter.toString());
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
    }
}

