/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.metadata.ButtonAppearance;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.command.CommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.crm.plugins.support.MutexHelper;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.plugins.util.CrmAuthUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractCRMBaseBillPlugin
extends AbstractBillPlugin {
    protected String permissionValue;
    protected boolean isSpecial;
    private static final String RELOADPERMISSION = "isReloadPermission";
    protected boolean isResponsible;

    protected abstract boolean isCRMBaseData();

    protected abstract String getPermRelProp();

    protected boolean isEnableCRMPermission() {
        return this.getPermRelProp() != null;
    }

    public void afterBindData() throws EASBizException, BOSException {
        super.afterBindData();
        MutexHelper.requestMutexForBill(this.application);
        if (!this.isNewBill()) {
            this.loadCrmPermission();
        } else if (this.isReloadCrmPermission()) {
            this.loadCrmPermission();
        }
        this.crmBillInitalize();
    }

    protected final void loadCrmPermission() throws EASBizException, BOSException {
        String billID;
        if (this.isEnableCRMPermission() && (billID = this.getBillID()) != null) {
            Context ctx = this.getContext();
            if (this.getPermRelProp() != null) {
                Map m = CRMPermissionHelper.getCRMPermissionMap(new String[]{billID}, this.getPermRelProp(), ctx);
                this.permissionValue = (String)m.get(billID);
                this.application.getApplicationContext().putData("crmpermission", (Object)this.permissionValue);
            }
            this.isSpecial = CRMPermissionHelper.hasDataPermission(ctx, this.getPermissionName("View"), billID);
            this.isResponsible = CRMPermissionHelper.isResponsible(billID, this.getContext(), this.application.getBillValue().getBOSType());
            this.application.getApplicationContext().putData("isEnableSpercialPermission", (Object)this.isSpecial);
            this.application.getApplicationContext().putData("isResponsible", (Object)this.isResponsible);
            this.application.getApplicationContext().putData("isParentCRMBaseData", (Object)this.isCRMBaseData());
        }
    }

    protected final boolean isReloadCrmPermission() {
        Object o = this.getParentData(RELOADPERMISSION);
        return o != null && (Boolean.TRUE.equals(o) || "true".equalsIgnoreCase(o.toString().trim()));
    }

    protected void crmBillInitalize() throws EASBizException, BOSException {
    }

    protected final void setComponentsDisplayFormat() throws EASBizException, BOSException {
        if (this.isProcessCRMPermission()) {
            List relationKeys;
            Context ctx = this.getContext();
            List fieldKeys = CrmAuthUtil.getInstance(ctx).getUnAuthedUIComponentKeys(this.gerFormID(), 1, this.permissionValue);
            if (fieldKeys != null && !fieldKeys.isEmpty()) {
                this.application.setMaskFieldList((ArrayList)fieldKeys);
            }
            if ((relationKeys = CrmAuthUtil.getInstance(ctx).getUnAuthedUIComponentKeys(this.gerFormID(), 2, this.permissionValue)) != null && !relationKeys.isEmpty()) {
                for (int i = 0; i < relationKeys.size(); ++i) {
                    this.application.hideElement((String)relationKeys.get(i), true);
                }
            }
        }
    }

    private String gerFormID() {
        return this.application.getForm().getId();
    }

    protected final boolean isProcessCRMPermission() {
        return this.isEnableCRMPermission() && this.permissionValue != null && !this.isSpecial;
    }

    public void fireButtonClick(CommandArg arg) throws EASBizException, BOSException {
        super.fireButtonClick(arg);
        MutexHelper.checkMutexForBillView(this.application, arg);
        this.checkCRMPermission(arg);
    }

    protected final void checkCRMPermission(CommandArg arg) throws EASBizException, BOSException {
        ButtonAppearance buttonAppearance = this.application.getBillView().getLayoutInfo().getButtonAppearance(arg.getKey());
        boolean isNewButton = buttonAppearance.getCaption().trim().equalsIgnoreCase("\u65b0\u589e");
        if (isNewButton) {
            return;
        }
        if (this.isResponsible) {
            return;
        }
        if (this.getBillID() != null && this.isEnableCRMPermission()) {
            if (this.application.getForm().getName().indexOf("\u6211\u7684") != -1) {
                if (this.checkResponsible()) {
                    throw new BOSException("\u53ea\u6709\u5355\u636e\u7684\u8d1f\u8d23\u7528\u6237\u624d\u80fd\u64cd\u4f5c\u5f53\u524d\u529f\u80fd\u3002");
                }
            } else {
                IDynamicFormView parent = this.application.getBillView().getParentFormView();
                if (parent != null && parent.getParentFormView() != null) {
                    if (buttonAppearance.getCaption().trim().equalsIgnoreCase("\u5ba1\u6838") || buttonAppearance.getCaption().trim().equalsIgnoreCase("\u53cd\u5ba1\u6838")) {
                        if (this.application.getForm().getId().toString().equals("sgfQ1NiDR1+nmWgxf9tlppp+rpI=") || this.application.getForm().getId().toString().equals("sXS/h9UOSRaXM/Sx8eEyuJp+rpI=")) {
                            Boolean special = (Boolean)parent.getParentFormView().getApplicationContext().getData("isEnableSpercialPermission");
                            if (special != null && special.booleanValue() && parent.getParentFormView().getLayoutInfo().getCaption().indexOf("\u6211\u7684") == -1) {
                                return;
                            }
                            throw new BOSException("\u53ea\u6709\u5173\u8054\u5355\u636e\u7684\u8d1f\u8d23\u7528\u6237\u624d\u80fd\u64cd\u4f5c\u5f53\u524d\u529f\u80fd\u3002");
                        }
                        if (!this.isSpecial && this.checkResponsible()) {
                            throw new BOSException("\u53ea\u6709\u5173\u8054\u5355\u636e\u7684\u8d1f\u8d23\u7528\u6237\u624d\u80fd\u64cd\u4f5c\u5f53\u524d\u529f\u80fd\u3002");
                        }
                    } else if (this.checkResponsible()) {
                        throw new BOSException("\u53ea\u6709\u5173\u8054\u5355\u636e\u7684\u8d1f\u8d23\u7528\u6237\u624d\u80fd\u64cd\u4f5c\u5f53\u524d\u529f\u80fd\u3002");
                    }
                } else if (!this.isSpecial && this.checkResponsible()) {
                    throw new BOSException("\u53ea\u6709\u5355\u636e\u7684\u8d1f\u8d23\u7528\u6237\u624d\u80fd\u64cd\u4f5c\u5f53\u524d\u529f\u80fd\u3002");
                }
            }
        }
    }

    protected boolean checkResponsible() {
        return true;
    }

    protected final Context getContext() {
        return this.application.getContext();
    }

    protected final Object getParentData(String key) {
        IDynamicFormView parent = this.application.getDynamicFormView().getParentFormView();
        if (parent != null) {
            return parent.getApplicationContext().getData(key);
        }
        return null;
    }

    protected final String getBillID() {
        ObjectBaseInfo billValue = (ObjectBaseInfo)this.application.getBillModel().getBillValue();
        return billValue.getId() == null ? null : billValue.getId().toString();
    }

    protected final String getPermissionName(String operationName) {
        FormOperation operation = this.application.getForm().getOperation(operationName);
        return operation == null ? "" : operation.getPermissionItem();
    }

    protected final boolean isNewBill() {
        ObjectBaseInfo obj = (ObjectBaseInfo)this.application.getBillModel().getBillValue();
        if (this.application.getBillView().getOperationStatus().equals(OperationStatus.ADDNEW)) {
            return true;
        }
        return obj == null || obj.getId() == null;
    }

    public void beforeCloseForm() throws BOSException {
        MutexHelper.releaseMutextForBill(this.application);
    }
}

