/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.bill.IBillView;
import com.kingdee.eas.base.form.model.command.BeforeCommandArg;
import com.kingdee.eas.base.form.model.command.BeforeDeleteArg;
import com.kingdee.eas.base.form.model.command.BeforeListFieldRenderArg;
import com.kingdee.eas.base.form.model.command.BeforeQueryArg;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.plugins.support.MutexHelper;
import com.kingdee.eas.scm.crm.plugins.support.filter.DeleteFilterHelper;
import com.kingdee.eas.scm.crm.plugins.support.filter.DeleteFilterSuit;
import com.kingdee.eas.scm.crm.plugins.support.filter.PermissionFilter;
import com.kingdee.eas.scm.crm.plugins.support.filter.XmlFilter;
import com.kingdee.eas.scm.crm.plugins.util.CRMPermissionHelper;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.CrmAuthUtil;
import com.kingdee.eas.scm.crm.plugins.util.ListViewUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public abstract class AbstractCRMBaseListPlugin
extends ListPlugin {
    protected List viewSpecialIDs;

    protected abstract boolean isEnableSpercialDataPermission();

    protected abstract boolean isCRMBaseData();

    protected boolean isCRMBaseDataS4() {
        return false;
    }

    protected abstract String getPermRelProp();

    protected boolean isEnableCRMPermission() {
        return this.getPermRelProp() != null;
    }

    protected abstract String getRelationBillKey();

    public final void onBeforeQuery(BeforeQueryArg arg) {
        super.onBeforeQuery(arg);
        try {
            this.appendListFilter(this.appendCRMListFilter(arg));
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void appendListFilter(FilterInfo var1) throws BOSException;

    private FilterInfo appendCRMListFilter(BeforeQueryArg arg) throws BOSException {
        FilterInfo filter = arg.getFilterInfo();
        FilterItemInfo mainOrgFilterItem = arg.getMainOrgFilterItem();
        if (mainOrgFilterItem != null && mainOrgFilterItem.get("compareValue") != null && mainOrgFilterItem.get("compareValue").equals("NO PERMISSION")) {
            return filter;
        }
        FilterInfo dataPermissionFilter = arg.getPermissionFilterInfo();
        FilterInfo crmFitler = new FilterInfo();
        filter.getFilterItems().add(this.buildLogicDeleteFilter());
        if (this.isCRMBaseData()) {
            crmFitler.getFilterItems().add(new FilterItemInfo("CU.id='" + ContextUtil.getCurrentCtrlUnit((Context)this.getContext()).getId() + "'"));
            if (this.isMine() && !this.isRelationBill()) {
                crmFitler.getFilterItems().add(this.generateResponsibleFilter());
            }
        } else if (mainOrgFilterItem != null) {
            crmFitler.getFilterItems().add(mainOrgFilterItem);
        }
        if (!this.isRelationBill()) {
            this.appendCommonListFilter(filter, crmFitler, dataPermissionFilter, mainOrgFilterItem);
        } else {
            this.appendRelationListFilter(filter, crmFitler, mainOrgFilterItem);
        }
        arg.setCustomziedFilter(true);
        return filter;
    }

    private void appendCommonListFilter(FilterInfo filter, FilterInfo crmFitler, FilterInfo dataPermissionFilter, FilterItemInfo mainOrgFilterItem) throws BOSException {
        FilterInfo shareFitler = this.isCRMBaseData() && !this.isMine() ? this.buildShareFilter() : this.buildShareFilter(mainOrgFilterItem);
        if (this.isEnableSpercialDataPermission() && dataPermissionFilter != null && !this.isCRMBaseData()) {
            filter.mergeFilter(dataPermissionFilter, "and");
        }
        filter.mergeFilter(crmFitler, "and");
        if (this.isEnableCRMPermission() && shareFitler != null) {
            filter.mergeFilter(shareFitler, "or");
        }
    }

    private void appendRelationListFilter(FilterInfo filter, FilterInfo crmFitler, FilterItemInfo mainOrgFilterItem) throws BOSException {
        Boolean isParentResponsible = (Boolean)this.getParentData("isResponsible");
        if (isParentResponsible != null && isParentResponsible.booleanValue()) {
            return;
        }
        boolean isParentCRMBaseData = this.getParentData("isParentCRMBaseData") == null ? false : (Boolean)this.getParentData("isParentCRMBaseData");
        IDynamicFormView parentView = this.application.getListView().getParentFormView();
        if (parentView != null && parentView instanceof IBillView) {
            if (this.isOpenFromRelationList() && ((IBillView)parentView).getBillModel().getBillValue().get("associatedUser") != null && !this.isParentResposiblity() && !this.isParentSpecial() && !this.isParentShareUser()) {
                crmFitler.getFilterItems().add(this.generateNonePermissionFilter());
                filter.mergeFilter(crmFitler, "and");
                return;
            }
            if (isParentCRMBaseData ? parentView.getLayoutInfo().getCaption().indexOf("\u6211\u7684") == -1 : this.isParentSpecial()) {
                return;
            }
        }
        String key = this.getRelationBillKey();
        String permissionValue = (String)this.getParentData("crmpermission");
        if (key != null && permissionValue != null) {
            int roleType = CrmAuthUtil.getInstance(this.getContext()).getRelatedFormAuth(this.getParentFormID(), key, permissionValue);
            switch (roleType) {
                case 1: {
                    crmFitler.getFilterItems().add(this.generateNonePermissionFilter());
                    filter.mergeFilter(crmFitler, "and");
                    break;
                }
                case 2: {
                    crmFitler.getFilterItems().add(this.generateResponsibleFilter());
                    filter.mergeFilter(crmFitler, "and");
                    filter.mergeFilter(this.buildShareFilter(mainOrgFilterItem), "or");
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    crmFitler.getFilterItems().add(this.generateNonePermissionFilter());
                    filter.mergeFilter(crmFitler, "and");
                }
            }
        }
    }

    private boolean isOpenFromRelationList() {
        IDynamicFormView firstView = this.application.getListView().getParentFormView();
        if (firstView == null) {
            return false;
        }
        IDynamicFormView secendView = firstView.getParentFormView();
        if (secendView == null) {
            return false;
        }
        IDynamicFormView thirdView = secendView.getParentFormView();
        return thirdView != null && thirdView instanceof IBillView;
    }

    private boolean isParentSpecial() {
        Boolean isParentSpecial = (Boolean)this.getParentData("isEnableSpercialPermission");
        return isParentSpecial != null && isParentSpecial != false;
    }

    private boolean isParentResposiblity() {
        Boolean isResponsible = (Boolean)this.getParentData("isResponsible");
        return isResponsible != null && isResponsible != false;
    }

    private boolean isParentShareUser() {
        String permissionValue = (String)this.getParentData("crmpermission");
        return permissionValue != null;
    }

    private FilterItemInfo buildLogicDeleteFilter() {
        FilterItemInfo logicDeletedFilterItem = new FilterItemInfo("isDeleted = 0");
        return logicDeletedFilterItem;
    }

    private FilterItemInfo generateNonePermissionFilter() {
        return new FilterItemInfo("id='NO PERMISSION'");
    }

    private FilterItemInfo generateResponsibleFilter() {
        StringBuffer sb = new StringBuffer();
        sb.append("creator.id='").append(ContextUtil.getCurrentUserInfo((Context)this.getContext()).getId()).append("'");
        return new FilterItemInfo(sb.toString());
    }

    private FilterInfo buildShareFilter(FilterItemInfo mainOrgFilterItem) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDeleted = 0 "));
        filter.getFilterItems().add(new FilterItemInfo("creator.id!='" + ContextUtil.getCurrentUserInfo((Context)this.getContext()).getId() + "'"));
        if (mainOrgFilterItem != null) {
            filter.getFilterItems().add(mainOrgFilterItem);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" id in (select top 2000 shareUser.FEntityID from T_CRM_OpAssociatedUser shareUser where shareUser.FUserID='");
        sb.append(ContextUtil.getCurrentUserInfo((Context)this.getContext()).getId()).append("')");
        filter.getFilterItems().add(new FilterItemInfo(sb.toString()));
        return filter;
    }

    private FilterInfo buildShareFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDeleted = 0 "));
        filter.getFilterItems().add(new FilterItemInfo("creator.id!='" + ContextUtil.getCurrentUserInfo((Context)this.getContext()).getId() + "'"));
        StringBuffer sb = new StringBuffer();
        sb.append(" id in (select top 2000 shareUser.FEntityID from T_CRM_OpAssociatedUser shareUser where shareUser.FCtrlUnitID='");
        sb.append(ContextUtil.getCurrentCtrlUnit((Context)this.getContext()).getId()).append("')");
        filter.getFilterItems().add(new FilterItemInfo(sb.toString()));
        return filter;
    }

    public final void beforeFieldRender(BeforeListFieldRenderArg arg) throws EASBizException, BOSException {
        super.beforeFieldRender(arg);
    }

    protected final void setDisplayFormat(Map permissionMap, String formID, BeforeListFieldRenderArg arg) {
        String permissionKey;
        String recordID;
        if (this.isEnableCRMPermission() && !this.hasDataPermission(recordID = arg.getBillId()) && (permissionKey = (String)permissionMap.get(recordID)) != null) {
            String componentKey = arg.getKey();
            if (!CrmAuthUtil.getInstance(this.application.getContext()).isUIComponentAuthed(formID, componentKey, permissionKey)) {
                arg.setFormatString("*********");
                arg.setRenderAsMask(true);
            }
        }
    }

    private boolean hasDataPermission(String billID) {
        if (this.viewSpecialIDs == null) {
            return true;
        }
        return this.viewSpecialIDs.contains(billID);
    }

    public final void pageChanged() throws EASBizException, BOSException {
        super.pageChanged();
        if (this.isEnableCRMPermission()) {
            Context ctx = this.getContext();
            if (this.isEnableSpercialDataPermission()) {
                this.viewSpecialIDs = CRMPermissionHelper.getDataPermissionRecordIDs(this.getPermissionName("View"), ctx, this.getMainBOSObjectType());
            }
        }
    }

    public void beforeBarItemClick(BeforeCommandArg arg) throws EASBizException, BOSException {
        super.beforeBarItemClick(arg);
        MutexHelper.checkMutexForList(arg, this.application);
        if (this.isEnableCRMPermission()) {
            boolean isRelatedAndRemove;
            boolean isNew = "mnuFileNew".equalsIgnoreCase(arg.getKey());
            if (isNew) {
                this.commonCheck();
            }
            if ("mnuEditModify".equalsIgnoreCase(arg.getKey())) {
                this.checkEdit();
            }
            boolean bl = isRelatedAndRemove = (isRelatedAndRemove = "FbtnRelate".equalsIgnoreCase(arg.getKey())) || "FbtnRemove".equalsIgnoreCase(arg.getKey());
            if (isRelatedAndRemove) {
                this.checkRelatedAndRemove();
            }
        }
    }

    protected void commonCheck() throws BOSException {
        if (this.isRelationBill() && !this.isParentResposiblity() && !this.isParentSpecial() && !this.isParentShareUser()) {
            throw new BOSException("\u975e\u4e3b\u5355\u636e\u5171\u4eab\u6210\u5458\u7684\u7528\u6237\u4e0d\u80fd\u64cd\u4f5c\u5f53\u524d\u529f\u80fd\u3002");
        }
    }

    protected void checkEdit() throws BOSException, EASBizException {
        String billID;
        String string = billID = this.application.getListView().getSelectedBillIds() == null ? null : this.application.getListView().getSelectedBillIds()[0];
        if (billID == null) {
            return;
        }
        if (!this.isRelationBill()) {
            this.checkCommonEdit(billID);
        } else {
            this.checkRelationEdit(billID);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCommonEdit(String billID) throws BOSException, EASBizException {
        if (this.isCRMBaseData()) {
            if (!this.isMine()) return;
            this.checkResponsible(billID, false);
            return;
        } else {
            if (this.viewSpecialIDs != null && this.viewSpecialIDs.contains(billID)) {
                return;
            }
            this.checkResponsible(billID, false);
        }
    }

    private void checkRelationEdit(String billID) throws BOSException, EASBizException {
        this.checkResponsible(billID, true);
    }

    private void checkResponsible(String billID, boolean isRelation) throws BOSException, EASBizException {
        boolean isResponsible = CRMPermissionHelper.isResponsible(billID, this.getContext(), this.getMainBOSObjectType());
        if (!isResponsible) {
            if (isRelation) {
                throw new BOSException("\u53ea\u6709\u5173\u8054\u5355\u636e\u7684\u8d1f\u8d23\u7528\u6237\u624d\u80fd\u64cd\u4f5c\u5f53\u524d\u529f\u80fd\u3002");
            }
            throw new BOSException("\u53ea\u6709\u5355\u636e\u7684\u8d1f\u8d23\u7528\u6237\u624d\u80fd\u64cd\u4f5c\u5f53\u524d\u529f\u80fd\u3002");
        }
    }

    protected void checkRelatedAndRemove() throws BOSException {
        Boolean isParentResponsible = (Boolean)this.getParentData("isResponsible");
        Boolean isParentSpecial = (Boolean)this.getParentData("isEnableSpercialPermission");
        String parentFormID = this.application.getListView().getParentFormView().getLayoutInfo().getFormId();
        if ("hBY+5dRaSPubFHE+sDIb8Zp+rpI=".equals(parentFormID) || "AaSzVCXfQaWc8lYhj9rQKJp+rpI=".equals(parentFormID) || "JwcwG79uTOKiIY1hJ3/8Q5p+rpI=".equals(parentFormID)) {
            return;
        }
        if ("SnF/VGUBT7OixSpLdGEA55p+rpI=".equals(parentFormID) || "hYNK2XQoR+C0bx4qYRzJI5p+rpI=".equals(parentFormID) || "WBydHaL+RjuUN5YVmb15aZp+rpI=".equals(parentFormID) ? isParentResponsible != null && isParentResponsible == false : isParentResponsible != null && isParentResponsible == false && isParentSpecial != null && isParentSpecial == false) {
            throw new BOSException("\u53ea\u6709\u4e3b\u5355\u636e\u7684\u8d1f\u8d23\u7528\u6237\u624d\u80fd\u64cd\u4f5c\u5f53\u524d\u529f\u80fd\u3002");
        }
    }

    public final boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        boolean status = super.beforeOperation(operation);
        if ("Delete".equalsIgnoreCase(operation.getOperation())) {
            status = status && this.logicDelete(operation);
        }
        status = status && this.doBeforeOperation(operation);
        return status;
    }

    private boolean logicDelete(FormOperation operation) throws EASBizException, BOSException {
        try {
            IObjectPK[] pks = ListViewUtil.beforeLog(this.application, operation);
            List ids2Delete = this.doDeleteFilter(CommonUtil.array2List(this.application.getListView().getSelectedBillIds()));
            ListViewUtil.logicDelete(this.application, ids2Delete);
            if (pks != null) {
                ListViewUtil.afterLog(this.application, pks, CommonUtil.list2Array(ids2Delete));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public boolean doBeforeOperation(FormOperation operation) throws EASBizException, BOSException {
        return true;
    }

    public final void onBeforeDelete(BeforeDeleteArg arg) {
        try {
            super.onBeforeDelete(arg);
            this.doDeleteFilter(arg.getIdList());
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
    }

    private List doDeleteFilter(List ids) throws BOSException, SQLException, EASBizException {
        String tableName = this.getMainTableName();
        Map numMap = DeleteFilterHelper.getNumberMap(this.getContext(), ids, tableName);
        DeleteFilterSuit filterSuit = new DeleteFilterSuit(numMap);
        String formId = this.application.getListView().getLayoutInfo().getFormId();
        if (!("AaSzVCXfQaWc8lYhj9rQKJp+rpI=".equals(formId) || "hBY+5dRaSPubFHE+sDIb8Zp+rpI=".equals(formId) || "JwcwG79uTOKiIY1hJ3/8Q5p+rpI=".equals(formId))) {
            filterSuit.addFilter(new PermissionFilter(this.isEnableCRMPermission(), numMap, this.application));
        }
        filterSuit.addFilter(new XmlFilter(tableName, numMap));
        String alerts = filterSuit.runFilter(this.getContext(), ids);
        this.application.showMessage(alerts);
        return ids;
    }

    protected final void storeDataInPageScope(String key, Object o) {
        this.application.getApplicationContext().putData(key, o);
    }

    protected final Object getParentData(String key) {
        IDynamicFormView parent = this.application.getDynamicFormView().getParentFormView();
        if (parent != null) {
            return parent.getApplicationContext().getData(key);
        }
        return null;
    }

    protected final String getPermissionName(String operationName) {
        FormOperation operation = this.application.getForm().getOperation(operationName);
        return operation == null ? "" : operation.getPermissionItem();
    }

    protected final Context getContext() {
        return this.application.getContext();
    }

    protected final IDynamicFormView getParentView() {
        return this.application.getView().getParentFormView();
    }

    protected final String getParentFormID() {
        IDynamicFormView parentView = this.getParentView();
        return parentView == null ? "" : parentView.getLayoutInfo().getFormId();
    }

    protected boolean isRelationBill() {
        return this.getParentView() != null;
    }

    protected final String getMainTableName() {
        return this.application.getListModel().getBusinessInfo().getEntity(0).getTableName();
    }

    protected final BOSObjectType getMainBOSObjectType() {
        return BOSObjectType.create((String)this.application.getListModel().getBusinessInfo().getEntity(0).getBosType());
    }

    protected final boolean isMine() {
        if (this.application.getListView().getLayoutInfo().getCaption().indexOf("\u6211\u7684") != -1) {
            return true;
        }
        String openSrc = (String)this.application.getCustomParameter("openSrc");
        return openSrc != null && openSrc.equals("1");
    }
}

