/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.plugins.support.SaleHelper;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.FinanceUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class CarryValueHelper {
    public static final int DEFAULTAMOUNT_PRICISION = 6;

    public static void carryValueBySaller(DynamicFormApplication application, DataChangeCommandArg arg, String sallerKey, String saleOrgKey, String saleGroupKey, String departmentKey, String userKey, boolean isNew) throws BOSException, EASBizException {
        if (sallerKey.equalsIgnoreCase(arg.getKey())) {
            IObjectValue salePersonInfo = (IObjectValue)arg.getNewValue();
            if (salePersonInfo != null) {
                ForbidStatusEnum status;
                SaleGroupInfo newGroup;
                if (salePersonInfo.get("id") != null && (newGroup = SaleHelper.getGroupBySellerId(application, salePersonInfo.get("id").toString())) != null && (status = newGroup.getDeletedStatus()) != null && status.getValue() == 1) {
                    application.setValue(saleGroupKey, (Object)newGroup, 0);
                }
                PersonInfo personInfo = null;
                personInfo = salePersonInfo instanceof PersonInfo ? (PersonInfo)salePersonInfo : ((SalePersonInfo)salePersonInfo).getPerson();
                if (personInfo != null) {
                    Context ctx = application.getContext();
                    IPerson iPerson = PersonFactory.getRemoteInstance();
                    AdminOrgUnitInfo adminOrgUnitInfo = iPerson.getPrimaryAdminOrgUnit(personInfo.getId());
                    application.setValue(departmentKey, (Object)adminOrgUnitInfo, 0);
                    if (userKey != null) {
                        if (isNew) {
                            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                            if (personInfo.equals((Object)user.getPerson())) {
                                application.setValue(userKey, (Object)ContextUtil.getCurrentUserInfo((Context)ctx), 0);
                            } else {
                                application.setValue(userKey, (Object)CommonUtil.getUser(personInfo), 0);
                            }
                        } else {
                            application.setValue(userKey, (Object)CommonUtil.getUser(personInfo), 0);
                        }
                    }
                }
            } else {
                if (userKey != null) {
                    application.setValue(userKey, null, 0);
                }
                application.setValue(departmentKey, null, 0);
                application.setValue(saleGroupKey, null, 0);
            }
        }
    }

    public static void carryValueBySaleOrg(DynamicFormApplication application, DataChangeCommandArg arg, String sallerKey, String saleOrgKey, String saleGroupKey, String departmentKey, String userKey, String companyOrgKey, String currencyKey) throws EASBizException, BOSException {
        if (saleOrgKey.equalsIgnoreCase(arg.getKey())) {
            application.setValue(saleGroupKey, null, 0);
            if (companyOrgKey != null) {
                SaleOrgUnitInfo saleOrgUnitInfo = (SaleOrgUnitInfo)arg.getNewValue();
                if (saleOrgUnitInfo != null) {
                    CompanyOrgUnitInfo companyOrg = FinanceUtil.getCompanyOrgUnit(OrgType.Sale, saleOrgUnitInfo.getId());
                    application.setValue(companyOrgKey, (Object)companyOrg, 0);
                    if (companyOrg != null) {
                        CurrencyInfo currency = FinanceUtil.getBaseCurrencyInfo(companyOrg);
                        if (currency != null) {
                            if (currencyKey != null) {
                                application.setValue(currencyKey, (Object)currency, 0);
                            }
                        } else if (currencyKey != null) {
                            application.setValue(currencyKey, null, 0);
                        }
                    } else {
                        application.setValue(companyOrgKey, null, 0);
                        if (currencyKey != null) {
                            application.setValue(currencyKey, null, 0);
                        }
                    }
                } else {
                    application.setValue(companyOrgKey, null, 0);
                    if (currencyKey != null) {
                        application.setValue(currencyKey, null, 0);
                    }
                }
            }
        }
    }

    public static void carryValueByCurrency(DynamicFormApplication application, DataChangeCommandArg arg, String currencyKey, String companyOrgKey, String exchangeRateKey, String convertMethodKey, String bizDateKey) throws EASBizException, BOSException {
        if (currencyKey.equalsIgnoreCase(arg.getKey())) {
            CurrencyInfo currency = (CurrencyInfo)arg.getNewValue();
            CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)application.getValue(companyOrgKey, 0);
            CurrencyInfo baseCurrency = null;
            if (companyOrgUnit != null) {
                companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select * where id='" + companyOrgUnit.getId() + "'");
                baseCurrency = FinanceUtil.getBaseCurrencyInfo(companyOrgUnit);
            }
            if (currency != null && baseCurrency != null) {
                if (baseCurrency.getId().equals((Object)currency.getId())) {
                    application.setValue(exchangeRateKey, (Object)new BigDecimal(1.0), 0);
                    application.setEnabled(exchangeRateKey, false);
                    application.setValue(convertMethodKey, (Object)new Integer(0), 0);
                } else {
                    ExchangeRateInfo exchangeRate;
                    application.setEnabled(exchangeRateKey, true);
                    Date bizDate = (Date)application.getValue(bizDateKey, 0);
                    ExchangeTableInfo exchangeTable = companyOrgUnit.getBaseExchangeTable();
                    if (exchangeTable != null && (exchangeRate = ExchangeRateFactory.getRemoteInstance().getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTable.getId()), (IObjectPK)new ObjectUuidPK(currency.getId()), (IObjectPK)new ObjectUuidPK(baseCurrency.getId()), bizDate)) != null) {
                        BigDecimal convertRate = FinanceUtil.getConvertRate(exchangeRate);
                        application.setValue(exchangeRateKey, (Object)convertRate, 0);
                        if (exchangeRate.getConvertMode() != null) {
                            application.setValue(convertMethodKey, (Object)new Integer(exchangeRate.getConvertMode().getValue()), 0);
                        } else {
                            application.setValue(convertMethodKey, (Object)new Integer(0), 0);
                        }
                    }
                }
            } else {
                application.setValue(exchangeRateKey, null, 0);
                application.setValue(convertMethodKey, null, 0);
            }
        }
    }

    public static void carryValueByProductNumber(DynamicFormApplication application, DataChangeCommandArg arg, String saleOrgUnitKey, String productNumberKey, String priceKey, String taxRateKey, String baseUnitKey, String unitKey, String assistUnitKey) throws EASBizException, BOSException {
        if (productNumberKey.equalsIgnoreCase(arg.getKey())) {
            int row = arg.getRow();
            OrgUnitInfo orgUnit = (OrgUnitInfo)application.getValue(saleOrgUnitKey, 0);
            if (orgUnit != null) {
                CarryValueHelper.setMaterialRate(application, orgUnit, row, productNumberKey, taxRateKey);
                CarryValueHelper.setMeasureUnit(application, orgUnit, row, productNumberKey, baseUnitKey, unitKey, assistUnitKey);
            }
        }
    }

    private static void setMaterialRate(DynamicFormApplication application, OrgUnitInfo orgUnit, int row, String productNumberKey, String taxRateKey) throws EASBizException, BOSException {
        Context ctx = application.getContext();
        orgUnit = ContextUtil.getCurrentSaleUnit((Context)ctx);
        MaterialInfo materialInfo = (MaterialInfo)application.getValue(productNumberKey, row);
        if (orgUnit.isIsSaleOrgUnit() && materialInfo != null) {
            MaterialSalesCollection materials = MaterialSalesFactory.getRemoteInstance().getMaterialSalesCollection("select taxRate where material.id='" + materialInfo.getId() + "' and taxRate is not null");
            BigDecimal taxRate = null;
            taxRate = materials != null && !materials.isEmpty() ? materials.get(0).getTaxRate() : new BigDecimal(17.0);
            application.setValue(taxRateKey, (Object)taxRate, row);
        }
    }

    private static void setMeasureUnit(DynamicFormApplication application, OrgUnitInfo orgUnit, int row, String productNumberKey, String baseUnitKey, String unitKey, String assistUnitKey) throws BOSException, EASBizException {
        MaterialInfo materialInfo = (MaterialInfo)application.getValue(productNumberKey, row);
        MeasureUnitInfo baseUnitInfo = null;
        MeasureUnitInfo unitInfo = null;
        if (materialInfo != null) {
            baseUnitInfo = materialInfo.getBaseUnit();
            MaterialSalesCollection materialSalesCollection = MaterialSalesFactory.getRemoteInstance().getMaterialSalesCollection("select unit.* where material.id='" + materialInfo.getId() + "' and orgUnit.id='" + orgUnit.getId() + "'");
            if (materialSalesCollection != null && !materialSalesCollection.isEmpty()) {
                unitInfo = materialSalesCollection.get(0).getUnit();
            }
            application.setValue(baseUnitKey, (Object)baseUnitInfo, row);
            application.setValue(unitKey, (Object)unitInfo, row);
            application.setValue(assistUnitKey, (Object)materialInfo.getAssistUnit(), row);
        }
    }

    public static void carryValueByUnitOrQty(DynamicFormApplication application, DataChangeCommandArg arg, String qtyKey, String baseUnitQtyKey, String productNumberKey, String unitKey) throws EASBizException, BOSException {
        if (qtyKey.equalsIgnoreCase(arg.getKey()) || unitKey.equalsIgnoreCase(arg.getKey())) {
            int row = arg.getRow();
            MaterialInfo materialInfo = (MaterialInfo)application.getValue(productNumberKey, row);
            BigDecimal qty = new BigDecimal("0.00");
            BigDecimal baseQty = new BigDecimal("0.00");
            if (application.getValue(qtyKey, row) != null) {
                qty = (BigDecimal)application.getValue(qtyKey, row);
            }
            MeasureUnitInfo unitInfo = (MeasureUnitInfo)application.getValue(unitKey, row);
            if (materialInfo != null && unitInfo != null) {
                MultiMeasureUnitCollection multiMeasureUnits = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection("where material.id = '" + materialInfo.getId().toString() + "' and measureUnit.id = '" + unitInfo.getId().toString() + "'");
                BigDecimal baseConvsRate = new BigDecimal("0.00");
                if (multiMeasureUnits != null && !multiMeasureUnits.isEmpty()) {
                    baseConvsRate = multiMeasureUnits.get(0).getBaseConvsRate();
                }
                baseQty = qty.multiply(baseConvsRate);
            }
            application.setValue(qtyKey, (Object)qty, row);
            application.setValue(baseUnitQtyKey, (Object)baseQty, row);
        }
    }

    public static void carryTaxPriceValueByCurrency(DynamicFormApplication application, DataChangeCommandArg arg, CompanyOrgUnitInfo fiCompanyOrgInfo, CurrencyInfo newCurrencyInfo, CurrencyInfo oldCurrencyInfo, String taxPriceKey, int entryNum) throws EASBizException, BOSException {
        ObjectUuidPK destCurrPK;
        ObjectUuidPK sourceCurrPK;
        BigDecimal ONE = new BigDecimal("1.00");
        ExchangeRateInfo exchangeRateInfo1 = null;
        ExchangeRateInfo exchangeRateInfo2 = null;
        BigDecimal exchangerate = ONE;
        BigDecimal exchangerate1 = ONE;
        BigDecimal exchangerate2 = ONE;
        CurrencyInfo baseCurrInfo = null;
        Context ctx = application.getContext();
        int PERCISION = 10;
        int SCALE = 6;
        if (fiCompanyOrgInfo != null) {
            baseCurrInfo = fiCompanyOrgInfo.getBaseCurrency();
        }
        if (baseCurrInfo == null || newCurrencyInfo == null || oldCurrencyInfo == null) {
            return;
        }
        if (!baseCurrInfo.getId().toString().equals(newCurrencyInfo.getId().toString()) && (exchangeRateInfo1 = CarryValueHelper.getExchangeRate(ctx, fiCompanyOrgInfo, (IObjectPK)(sourceCurrPK = new ObjectUuidPK(newCurrencyInfo.getId())), (IObjectPK)(destCurrPK = new ObjectUuidPK(baseCurrInfo.getId())))) != null) {
            exchangerate1 = exchangeRateInfo1.getConvertRate();
        }
        if (!baseCurrInfo.getId().toString().equals(oldCurrencyInfo.getId().toString()) && (exchangeRateInfo2 = CarryValueHelper.getExchangeRate(ctx, fiCompanyOrgInfo, (IObjectPK)(sourceCurrPK = new ObjectUuidPK(oldCurrencyInfo.getId())), (IObjectPK)(destCurrPK = new ObjectUuidPK(baseCurrInfo.getId())))) != null) {
            exchangerate2 = exchangeRateInfo2.getConvertRate();
        }
        exchangerate = exchangeRateInfo2 != null && exchangeRateInfo2.getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE ? exchangerate.divide(exchangerate2, 10, 4) : exchangerate.multiply(exchangerate2);
        exchangerate = exchangeRateInfo1 != null && exchangeRateInfo1.getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE ? exchangerate.multiply(exchangerate1) : exchangerate.divide(exchangerate1, 10, 4);
        for (int i = 0; i < entryNum; ++i) {
            BigDecimal price = (BigDecimal)application.getValue(taxPriceKey, i);
            price = price.multiply(exchangerate).setScale(6, 4);
            application.setValue(taxPriceKey, (Object)price, i);
        }
    }

    private static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = ExchangeRateFactory.getRemoteInstance().getExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK, (Date)new Timestamp(Calendar.getInstance().getTimeInMillis()));
        return exchangeRateInfo;
    }
}

