/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitExtInfo;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.crm.plugins.support.SaleHelper;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.FinanceUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;

public class DefaultValueHelper {
    public static void setDefaultValueForCTKey(BillApplication application, String ctKey, OrgType type) {
        Context ctx = application.getContext();
        OrgUnitExtInfo orgUnit = (OrgUnitExtInfo)ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)type);
        if (orgUnit != null && orgUnit.isIsBizUnit()) {
            try {
                application.setValue(ctKey, (Object)orgUnit, 0);
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public static void setDefaultValueForSale(BillApplication application, String sellerKey, String saleGroupKey, String saleOrgKey, String depKey, boolean isDelegatDept) throws BOSException, EASBizException {
        Context ctx = application.getContext();
        OrgUnitExtInfo orgUnit = (OrgUnitExtInfo)ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.Sale);
        SalePersonInfo seller = SaleHelper.getSellerInfo(ctx);
        if (orgUnit != null && orgUnit.isIsBizUnit()) {
            application.setValue(saleOrgKey, (Object)orgUnit, 0);
            if (seller != null) {
                PersonInfo person;
                ForbidStatusEnum status;
                SaleGroupInfo group;
                application.setValue(sellerKey, (Object)ContextUtil.getCurrentUserInfo((Context)ctx), 0);
                if (null != saleGroupKey && (group = seller.getSaleGroup()) != null && (status = group.getDeletedStatus()) != null && status.getValue() == 1) {
                    application.setValue(saleGroupKey, (Object)group, 0);
                }
                if ((person = ((UserInfo)ctx.get((Object)"UserInfo")).getPerson()) != null) {
                    if (isDelegatDept) {
                        application.setValue(depKey, (Object)CommonUtil.getOrgUnit(OrgType.Sale, OrgType.Admin, orgUnit.getId()), 0);
                    } else {
                        application.setValue(depKey, (Object)DefaultValueHelper.getDept(person, ctx), 0);
                    }
                }
            }
        }
    }

    public static AdminOrgUnitInfo getDept(PersonInfo person, Context ctx) throws BOSException {
        PositionMemberInfo posiMember = null;
        AdminOrgUnitInfo adminOrgUnit = null;
        CoreBaseCollection posiMemberColl = DefaultValueHelper.getPosiMemberByPerson(ctx, person.getId(), true, true);
        if (posiMemberColl != null && !posiMemberColl.isEmpty()) {
            posiMember = (PositionMemberInfo)posiMemberColl.get(0);
        } else {
            posiMemberColl = DefaultValueHelper.getPosiMemberByPerson(ctx, person.getId(), true, false);
            if (posiMemberColl != null && !posiMemberColl.isEmpty()) {
                posiMember = (PositionMemberInfo)posiMemberColl.get(0);
            } else {
                posiMemberColl = DefaultValueHelper.getPosiMemberByPerson(ctx, person.getId(), false, true);
                if (posiMemberColl != null && !posiMemberColl.isEmpty()) {
                    posiMember = (PositionMemberInfo)posiMemberColl.get(0);
                }
            }
        }
        if (posiMember != null) {
            adminOrgUnit = posiMember.getPosition() == null ? null : posiMember.getPosition().getAdminOrgUnit();
        }
        return adminOrgUnit;
    }

    private static CoreBaseCollection getPosiMemberByPerson(Context ctx, BOSUuid personId, boolean isByCu, boolean isPrimary) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId.toString()));
        if (isPrimary) {
            FilterItemInfo filterItem = new FilterItemInfo("isPrimary", (Object)"1");
            filter.getFilterItems().add(filterItem);
        }
        if (isByCu) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        }
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.*"));
        CoreBaseCollection posiMemberColl = null;
        IPositionMember iPosiMember = PositionMemberFactory.getRemoteInstance();
        posiMemberColl = iPosiMember.getCollection(viewInfo);
        return posiMemberColl;
    }

    public static void setDefaultValueForAmount(BillApplication application, OrgType orgType, String companyOrgKey, String currencyKey, String exchangeRateKey, String convertMethodKey, String bizDateKey) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyOrgUnit;
        Context ctx = application.getContext();
        OrgUnitExtInfo orgUnit = (OrgUnitExtInfo)ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)orgType);
        if (orgUnit.isIsBizUnit() && (companyOrgUnit = FinanceUtil.getCompanyOrgUnit(OrgType.getEnum((int)orgType.getValue()), orgUnit.getId())) != null) {
            application.setValue(companyOrgKey, (Object)companyOrgUnit, 0);
            CurrencyInfo currencyInfo = FinanceUtil.getBaseCurrencyInfo(companyOrgUnit);
            if (currencyInfo != null) {
                application.setValue(convertMethodKey, (Object)new Integer(0), 0);
                application.setValue(currencyKey, (Object)currencyInfo, 0);
                application.setValue(exchangeRateKey, (Object)new BigDecimal(1.0), 0);
                application.lockElement(exchangeRateKey, true);
                application.setValue(bizDateKey, (Object)CommonUtil.createDateWithYYYYDDMM(), 0);
            }
        }
    }
}

