/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CoreBillBaseCustomEntryCollection;
import com.kingdee.eas.ep.CoreBillBaseCustomEntryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserCollection;
import java.util.Map;

public class DynamicBillHelper {
    private ObjectUuidPK objectPK;
    private ICoreBase coreBase;
    private CoreBillBaseInfo parentObject;
    private BillApplication application;

    public DynamicBillHelper(BillApplication application, BOSObjectType bosType, String billId) throws BOSException, EASBizException {
        this.objectPK = new ObjectUuidPK("id", billId);
        this.coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosType, ICoreBillBase.class);
        this.parentObject = (CoreBillBaseInfo)this.coreBase.getValue((IObjectPK)this.objectPK);
        this.application = application;
    }

    public ObjectUuidPK getObjectPK() {
        return this.objectPK;
    }

    public ICoreBase getCoreBase() {
        return this.coreBase;
    }

    public CoreBillBaseInfo getParentObject() {
        return this.parentObject;
    }

    public final OpAssociatedUserCollection getOpAssociatedUserCollection() throws BOSException, EASBizException {
        return (OpAssociatedUserCollection)((Object)this.parentObject.get("associateduser"));
    }

    public final Object getParentPropertyValue(String property) {
        return this.parentObject.get(property);
    }

    public final AbstractObjectCollection getParentPropertyCollection(String property) {
        return (AbstractObjectCollection)this.parentObject.get(property);
    }

    public final IObjectValue getBillValue() {
        return this.application.getBillValue();
    }

    public final CoreBillBaseCustomEntryCollection getEntryCollection(String entryName) {
        return (CoreBillBaseCustomEntryCollection)this.getBillValue().get(entryName);
    }

    public void copyEntriesToDynamicBill(AbstractObjectCollection sourceCollection, String dyNamicEntryName, String[] conversion, Map function) throws EASBizException, BOSException {
        CoreBillBaseCustomEntryCollection dyEntryCollection = this.getEntryCollection(dyNamicEntryName);
        dyEntryCollection.clear();
        for (int i = 0; sourceCollection != null && sourceCollection.size() > 0 && i < sourceCollection.size(); ++i) {
            IObjectValue sourceObject = sourceCollection.getObject(i);
            CoreBillBaseCustomEntryInfo dyEntryInfo = new CoreBillBaseCustomEntryInfo();
            dyEntryInfo.setId(sourceObject.getBOSUuid("id"));
            dyEntryInfo.setSeq(sourceObject.getInt("seq"));
            for (int j = 0; conversion != null && j < conversion.length; ++j) {
                String[] identity = conversion[j].split(",");
                Object sourceValue = sourceObject.get(identity[0]);
                String[] k = identity[0].split("\\.");
                if (k.length == 2) {
                    ICoreBase iCoreBase = (ICoreBase)function.get(k[0]);
                    if (sourceObject.getObjectValue(k[0]) != null) {
                        sourceValue = iCoreBase.getValue("where id='" + sourceObject.getObjectValue(k[0]).get("id").toString() + "'");
                    }
                }
                dyEntryInfo.put(identity[1], sourceValue);
            }
            dyEntryCollection.add(dyEntryInfo);
        }
    }

    public void copyDynamicBillToEntries(String dyNamicEntryName, String mainEntryBosType, AbstractObjectCollection descCollection, String[] conversion) throws EASBizException, BOSException {
        try {
            descCollection.clear();
            CoreBillBaseCustomEntryCollection dyEntryCollection = this.getEntryCollection(dyNamicEntryName);
            BOSObjectType entityBosType = BOSObjectType.create((String)mainEntryBosType);
            IMetaDataLoader imetaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.application.getContext());
            for (int i = 0; dyEntryCollection != null && dyEntryCollection.size() > 0 && i < dyEntryCollection.size(); ++i) {
                CoreBillBaseCustomEntryInfo dyEntryInfo = dyEntryCollection.get(i);
                CoreBaseInfo descObject = (CoreBaseInfo)Class.forName(imetaDataLoader.getEntity(entityBosType).getObjectValueClass()).newInstance();
                descObject.setBOSUuid("id", dyEntryInfo.getBOSUuid("id"));
                descObject.setInt("seq", dyEntryInfo.getSeq());
                for (int j = 0; conversion != null && j < conversion.length; ++j) {
                    String[] identity = conversion[j].split(",");
                    String[] k = identity[0].split("\\.");
                    String key = identity[1];
                    if (k.length == 2) {
                        key = k[0];
                    }
                    descObject.put(key, dyEntryInfo.get(identity[1]));
                }
                descCollection.addObject((IObjectValue)descObject);
            }
        }
        catch (InstantiationException e) {
            throw new BOSException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new BOSException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new BOSException(e.getMessage());
        }
    }

    public void update2db() throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK("id", this.getParentObject().getId());
        this.getCoreBase().update((IObjectPK)pk, (CoreBaseInfo)this.getParentObject());
        this.application.showMessage("\u4fdd\u5b58\u6210\u529f\uff01");
    }

    public void update2db(String dyNamicEntryName, String mainEntryBosType, AbstractObjectCollection descCollection, String[] conversion) throws EASBizException, BOSException {
        this.copyDynamicBillToEntries(dyNamicEntryName, mainEntryBosType, descCollection, conversion);
        this.update2db();
    }
}

