/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.permission.OrgRangeHelper;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.OrgUnitUtil;
import com.kingdee.eas.util.app.ContextUtil;

public class FilterHelper {
    public static void setFilterAfterSallerChange(DynamicFormApplication application, DataChangeCommandArg arg, String sellerKey, String deptKey, String userKey) throws EASBizException, BOSException {
        Context ctx = application.getContext();
        if (sellerKey.equalsIgnoreCase(arg.getKey())) {
            IObjectValue newValue = (IObjectValue)arg.getNewValue();
            if (newValue instanceof PersonInfo) {
                application.setFieldFilter(deptKey, FilterHelper.getDepartmentFilterString(ctx, (PersonInfo)newValue));
                application.setFieldFilter(userKey, FilterHelper.getUserFilterString((PersonInfo)newValue));
            } else {
                if (newValue != null && ((SalePersonInfo)newValue).getPerson() != null) {
                    application.setFieldFilter(deptKey, FilterHelper.getDepartmentFilterString(ctx, (SalePersonInfo)newValue));
                }
                application.setFieldFilter(userKey, FilterHelper.getUserFilterString((SalePersonInfo)newValue));
            }
        }
    }

    public static void setF7CompanyOrgUnitFilter(DynamicFormApplication application, String key, String cuID) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("isCompanyOrgUnit=1 and CU.id='").append(cuID).append("'");
        application.setFieldFilter(key, oql.toString());
    }

    public static void setSaleOrgFilter(DynamicFormApplication application, String[] keys, String permissionItem) throws BOSException, EASBizException {
        Context context = application.getContext();
        OrgUnitCollection collection = OrgUnitUtil.getAuthOrgByPermItem((Context)context, (OrgType)OrgType.Sale, (String)permissionItem, (int)2);
        if (collection != null && !collection.isEmpty()) {
            StringBuffer oql = new StringBuffer(" id in ");
            String saleOrgIdsStr = FilterHelper.buildSaleOrgIdsStr(collection, application);
            oql.append(saleOrgIdsStr);
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    application.setFieldFilter(keys[i], oql.toString());
                }
            }
        }
    }

    public static void setSaleUserFilter(DynamicFormApplication application, String saleUserkey, String permissionItem) throws BOSException, EASBizException {
        Context context = application.getContext();
        OrgUnitCollection collection = OrgUnitUtil.getAuthOrgByPermItem((Context)context, (OrgType)OrgType.Sale, (String)permissionItem, (int)2);
        if (collection != null && !collection.isEmpty()) {
            String saleOrgIdsStr = FilterHelper.buildSaleOrgIdsStrByUser(collection, application);
            String oql = "person.id in( select fpersonid from T_BD_SalePerson  where  fsaleGroupid in( select fid from T_BD_SaleGroup where fsaleOrgid in (select fid from     T_ORG_Sale  where fid in " + saleOrgIdsStr + ")))";
            application.setFieldFilter(saleUserkey, oql);
        }
    }

    private static String buildSaleOrgIdsStr(OrgUnitCollection collection, DynamicFormApplication application) {
        Context context = application.getContext();
        StringBuffer oql = new StringBuffer(" (");
        for (int i = 0; i < collection.size(); ++i) {
            OrgUnitInfo org = collection.get(i);
            oql.append("'").append(org.getId()).append("',");
        }
        oql.append(") and isBizUnit=1");
        oql.append(" and CU.id='").append(ContextUtil.getCurrentCtrlUnit((Context)context).getId()).append("'");
        oql.deleteCharAt(oql.lastIndexOf(","));
        return oql.toString();
    }

    private static String buildSaleOrgIdsStrByUser(OrgUnitCollection collection, DynamicFormApplication application) {
        Context context = application.getContext();
        StringBuffer oql = new StringBuffer(" (");
        for (int i = 0; i < collection.size(); ++i) {
            OrgUnitInfo org = collection.get(i);
            oql.append("'").append(org.getId()).append("',");
        }
        oql.append(") and fisBizUnit=1");
        oql.append(" and FControlUnitID='").append(ContextUtil.getCurrentCtrlUnit((Context)context).getId()).append("'");
        oql.deleteCharAt(oql.lastIndexOf(","));
        return oql.toString();
    }

    public static void setDeptFilter(DynamicFormApplication application, String sellerKey, String deptKey) throws BOSException, EASBizException {
        IObjectValue seller = (IObjectValue)application.getValue(sellerKey, 0);
        if (seller != null) {
            if (seller instanceof PersonInfo) {
                application.setFieldFilter(deptKey, FilterHelper.getDepartmentFilterString(application.getContext(), (PersonInfo)seller));
            } else {
                application.setFieldFilter(deptKey, FilterHelper.getDepartmentFilterString(application.getContext(), (SalePersonInfo)seller));
            }
        } else {
            application.setFieldFilter(deptKey, "id in ()");
        }
    }

    public static String getDepartmentFilterString(Context ctx, SalePersonInfo seller) throws BOSException, EASBizException {
        if (seller != null) {
            return FilterHelper.getDepartmentFilterString(ctx, seller.getPerson());
        }
        return "";
    }

    public static String getDepartmentFilterString(Context ctx, PersonInfo person) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        if (person != null) {
            AdminOrgUnitCollection posiMemberColl = OrgRangeHelper.getAllAdminOrgUnit((Context)ctx, (BOSUuid)person.getId());
            oql.append("id in (");
            if (posiMemberColl != null) {
                for (int i = 0; i < posiMemberColl.size(); ++i) {
                    AdminOrgUnitInfo adminOrgUnitInfo = posiMemberColl.get(i);
                    if (adminOrgUnitInfo == null) continue;
                    oql.append("'").append(adminOrgUnitInfo.getId()).append("',");
                }
            }
            oql.append(")");
            if (oql.indexOf(",") != -1) {
                oql.deleteCharAt(oql.lastIndexOf(","));
            }
        }
        return oql.toString();
    }

    public static String getUserFilterString(SalePersonInfo seller) throws BOSException {
        if (seller != null) {
            FilterHelper.getUserFilterString(seller.getPerson());
        }
        return "";
    }

    public static String getUserFilterString(PersonInfo person) throws BOSException {
        StringBuffer oql = new StringBuffer();
        if (person != null) {
            UserCollection users = UserFactory.getRemoteInstance().getUserCollection("where person.id='" + person.getId().toString() + "'");
            if (users != null && !users.isEmpty()) {
                oql = oql.append(" id in (");
                for (int i = 0; i < users.size(); ++i) {
                    UserInfo user = users.get(i);
                    oql.append("'").append(user.getId()).append("',");
                }
                oql.append(")");
                oql.deleteCharAt(oql.lastIndexOf(","));
            } else {
                oql = oql.append(" id is null");
            }
        }
        return oql.toString();
    }
}

