/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.license.expirecheck.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleTaskCollection;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleTaskFactory;
import com.kingdee.eas.scm.crm.bs.SaleFunctionSaleTaskInfo;
import com.kingdee.eas.scm.crm.bs.SaleStageInfo;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.sm.BusinOpportBusinStageTaskInfo;
import com.kingdee.eas.scm.crm.sm.BusinOpportInfo;
import java.util.Date;

public abstract class SaleHelper {
    public static SaleGroupInfo getGroupBySellerId(DynamicFormApplication application, String sellerId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("id", (Object)sellerId, CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("deletedStatus", (Object)String.valueOf(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("person.deletedStatus", (Object)String.valueOf(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("saleGroup.id"));
        sic.add(new SelectorItemInfo("saleGroup.name"));
        sic.add(new SelectorItemInfo("saleGroup.deletedStatus"));
        viewInfo.setSelector(sic);
        SalePersonCollection salePersonCollection = SalePersonFactory.getRemoteInstance().getSalePersonCollection(viewInfo);
        if (salePersonCollection != null && salePersonCollection.size() > 0) {
            return salePersonCollection.get(0).getSaleGroup();
        }
        return null;
    }

    public static SalePersonInfo getSellerInfo(Context context) throws BOSException {
        UserInfo userInfo = (UserInfo)context.get((Object)"UserInfo");
        if (userInfo.getPerson() != null && userInfo.getPerson().getId() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("person", (Object)userInfo.getPerson().getId(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("deletedStatus", (Object)String.valueOf(1), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("person.deletedStatus", (Object)String.valueOf(1), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            viewInfo.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
            sic.add(new SelectorItemInfo("saleGroup.id"));
            sic.add(new SelectorItemInfo("saleGroup.name"));
            sic.add(new SelectorItemInfo("saleGroup.deletedStatus"));
            viewInfo.setSelector(sic);
            SalePersonCollection salePersonCollection = SalePersonFactory.getRemoteInstance().getSalePersonCollection(viewInfo);
            if (salePersonCollection != null && salePersonCollection.size() > 0) {
                return salePersonCollection.get(0);
            }
        }
        return null;
    }

    public static void setValueForBusinStageTask(BusinOpportInfo businOpport, SaleStageInfo stage) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("where saleStage.id='").append(stage.getId()).append("' and parent.id='").append(businOpport.getSaleFunction().getId()).append("' order by taskNum");
        SaleFunctionSaleTaskCollection collection = SaleFunctionSaleTaskFactory.getRemoteInstance().getSaleFunctionSaleTaskCollection(oql.toString());
        if (!collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                SaleFunctionSaleTaskInfo task = collection.get(i);
                BusinOpportBusinStageTaskInfo businStageTaskInfo = SaleHelper.generateBIZStageTask(task, stage);
                if (businOpport.getId() == null) {
                    if (i == 0) {
                        businOpport.getBusinStageTask().set(0, businStageTaskInfo);
                        businOpport.getBusinStageTask().get(0).setSeq(1);
                        continue;
                    }
                    businOpport.getBusinStageTask().add(businStageTaskInfo);
                    businOpport.getBusinStageTask().get(i).setSeq(i + 1);
                    continue;
                }
                if (!businOpport.getBusinStageTask().isEmpty()) {
                    int taskSize = businOpport.getBusinStageTask().size();
                    businOpport.getBusinStageTask().add(businStageTaskInfo);
                    businOpport.getBusinStageTask().get(taskSize).setSeq(taskSize + 1);
                    continue;
                }
                businOpport.getBusinStageTask().add(businStageTaskInfo);
                businOpport.getBusinStageTask().get(i).setSeq(i + 1);
            }
        }
    }

    private static BusinOpportBusinStageTaskInfo generateBIZStageTask(SaleFunctionSaleTaskInfo task, SaleStageInfo stage) throws BOSException {
        BusinOpportBusinStageTaskInfo businStageTaskInfo = new BusinOpportBusinStageTaskInfo();
        businStageTaskInfo.setSaleStage(stage);
        businStageTaskInfo.setSaleTask(task.getName());
        Date d = CommonUtil.createDateWithYYYYDDMM();
        businStageTaskInfo.setTaskPlanDate(d);
        if (task.getDay() == null) {
            businStageTaskInfo.setTaskFinishDate(d);
        } else {
            int day = 0;
            if (task.getDay().intValue() > 0) {
                day = task.getDay().setScale(0, 0).intValue() - 1;
            }
            Date finishDate = DateUtil.addDate((Date)d, (int)day);
            businStageTaskInfo.setTaskFinishDate(finishDate);
        }
        businStageTaskInfo.setTaskActBeginDate(d);
        if (task.getDay() == null) {
            businStageTaskInfo.setNumDays(0);
        }
        return businStageTaskInfo;
    }
}

