/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.support.defaultValue;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitExtInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.FinanceUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;

public class SaleDefaultValueHelper {
    public static void setSaleOrgUnitValue(BillApplication application, String saleOrgUnitKey) throws EASBizException, BOSException {
        SaleOrgUnitInfo saleOrgUnig = ContextUtil.getCurrentSaleUnit((Context)application.getContext());
        if (saleOrgUnig.isIsBizUnit()) {
            application.setValue(saleOrgUnitKey, (Object)ContextUtil.getCurrentSaleUnit((Context)application.getContext()), 0);
        }
    }

    public static void setSaleGroupValue(BillApplication application, UserInfo user, String saleGroupKey) throws BOSException, EASBizException {
        SaleGroupInfo group;
        SalePersonCollection salePersonCollection;
        SaleOrgUnitInfo saleOrgUnitInfo;
        if (user == null) {
            user = ContextUtil.getCurrentUserInfo((Context)application.getContext());
        }
        if ((saleOrgUnitInfo = ContextUtil.getCurrentSaleUnit((Context)application.getContext())) != null && saleOrgUnitInfo.isIsBizUnit() && user.getPerson() != null && user.getPerson().getId() != null && (salePersonCollection = SaleDefaultValueHelper.getSaleGroupByUser(application, user, saleOrgUnitInfo)) != null && salePersonCollection.size() > 0 && ForbidStatusEnum.UNFORBID.equals((Object)(group = salePersonCollection.get(0).getSaleGroup()).getDeletedStatus())) {
            application.setValue(saleGroupKey, (Object)salePersonCollection.get(0).getSaleGroup(), 0);
        }
    }

    public static SalePersonCollection getSaleGroupByUser(BillApplication application, UserInfo user, SaleOrgUnitInfo saleOrgUnitInfo) throws BOSException {
        if (user.getPerson() == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("saleGroup.saleOrg.id", (Object)saleOrgUnitInfo.getId(), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("deletedStatus", (Object)String.valueOf(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("person.deletedStatus", (Object)String.valueOf(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("person.id", (Object)user.getPerson().getId(), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("saleGroup.id"));
        sic.add(new SelectorItemInfo("saleGroup.name"));
        sic.add(new SelectorItemInfo("saleGroup.deletedStatus"));
        viewInfo.setSelector(sic);
        SalePersonCollection salePersonCollection = SalePersonFactory.getRemoteInstance().getSalePersonCollection(viewInfo);
        return salePersonCollection;
    }

    public static void setAmountValue(BillApplication application, OrgType orgType, String companyOrgKey, String currencyKey, String exchangeRateKey, String convertMethodKey, String bizDateKey) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyOrgUnit;
        Context ctx = application.getContext();
        OrgUnitExtInfo orgUnit = (OrgUnitExtInfo)ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)orgType);
        if (orgUnit.isIsBizUnit() && (companyOrgUnit = FinanceUtil.getCompanyOrgUnit(OrgType.getEnum((int)orgType.getValue()), orgUnit.getId())) != null) {
            application.setValue(companyOrgKey, (Object)companyOrgUnit, 0);
            CurrencyInfo currencyInfo = FinanceUtil.getBaseCurrencyInfo(companyOrgUnit);
            if (currencyInfo != null) {
                application.setValue(convertMethodKey, (Object)new Integer(0), 0);
                application.setValue(currencyKey, (Object)currencyInfo, 0);
                application.setValue(exchangeRateKey, (Object)new BigDecimal(1.0), 0);
                application.lockElement(exchangeRateKey, true);
                application.setValue(bizDateKey, (Object)CommonUtil.createDateWithYYYYDDMM(), 0);
            }
        }
    }
}

