/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.core.OpenModeEnum;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.plugin.OperationHelper;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.base.form.util.StringUtil;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.scm.common.SCMBillParamValueFactory;
import com.kingdee.eas.scm.common.SCMBillParamValueInfo;
import com.kingdee.eas.scm.crm.common.BillStatusEnum;
import com.kingdee.eas.scm.crm.common.CrmBillBaseInfo;
import com.kingdee.eas.scm.crm.common.CrmRoleCollection;
import com.kingdee.eas.scm.crm.common.CrmRoleFactory;
import com.kingdee.eas.scm.crm.plugins.support.defaultValue.CommonDefaultValueHelper;
import com.kingdee.eas.scm.crm.plugins.util.BillStatusManageUtil;
import com.kingdee.eas.scm.crm.plugins.util.CommonUtil;
import com.kingdee.eas.scm.crm.plugins.util.MyRemoteObjectUtil;
import com.kingdee.eas.scm.crm.plugins.util.ReflectionUtils;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserCollection;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BillViewUtil {
    private static final String BILL_STATUS = "billStatus";
    private static final String FIELD_TYPE_VARCHAR = "varchar";
    private static final String FIELD_TYPE_NUM = "num";

    public static boolean isHasEntryData(BillApplication application, String entryKey) {
        return application.getBillModel().getEntryRowCount(new Entity(entryKey)) > 0;
    }

    public static boolean isHasEntryData(BillApplication application, String entryKey, String alerMsg) {
        if (!BillViewUtil.isHasEntryData(application, entryKey)) {
            application.showMessage(alerMsg);
            return false;
        }
        return true;
    }

    public static boolean checkNumFieldIsUniq(BillApplication application, Object dao, String propertyName, String alerMsg, String otherFilterStr) {
        return BillViewUtil.checkFieldIsUniq(application, dao, propertyName, FIELD_TYPE_NUM, alerMsg, otherFilterStr);
    }

    public static boolean checkNumFieldIsUniq(BillApplication application, Object dao, String propertyName, String alerMsg) {
        return BillViewUtil.checkFieldIsUniq(application, dao, propertyName, FIELD_TYPE_NUM, alerMsg, null);
    }

    public static boolean checkNumFieldIsUniqInCU(BillApplication application, Object dao, String propertyName, String alerMsg) {
        OrgUnitInfo orgUnitInfo = application.getMainOrgUnit();
        String otherFilterStr = "CU='" + orgUnitInfo.getId() + "'";
        return BillViewUtil.checkFieldIsUniq(application, dao, propertyName, FIELD_TYPE_NUM, alerMsg, otherFilterStr);
    }

    public static void showBillView(BillApplication application, String billPK, String formId, String tile) throws BOSException, EASBizException {
        JSONObject urlParam = new JSONObject();
        JSONObject winParam = new JSONObject();
        try {
            urlParam.put("statu", (Object)"VIEW");
            urlParam.put("formID", (Object)formId);
            urlParam.put("pk", (Object)billPK);
            winParam.put("name", (Object)"convertion");
            winParam.put("title", (Object)tile);
            winParam.put("x", 962);
            winParam.put("y", 1110);
            String url = ResourceUtil.buildUrlEncodeParam((String)"/easweb/servlet/BillServlet", null);
            FormActionUtil.invokeShowPopupAction((IFormApplication)application, (String)urlParam.toString(), (String)winParam.toString(), (String)url, (OpenModeEnum)OpenModeEnum.OpenDialog);
            application.getBillView().refresh();
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean checkVarcharFieldIsUniq(BillApplication application, Object dao, String propertyName, String alerMsg, String otherFilterStr) {
        return BillViewUtil.checkFieldIsUniq(application, dao, propertyName, FIELD_TYPE_VARCHAR, alerMsg, otherFilterStr);
    }

    public static boolean checkVarcharFieldIsUniq(BillApplication application, Object dao, String propertyName, String alerMsg) {
        return BillViewUtil.checkFieldIsUniq(application, dao, propertyName, FIELD_TYPE_VARCHAR, alerMsg, null);
    }

    public static boolean checkVarcharFieldIsUniqInCU(BillApplication application, Object dao, String propertyName, String alerMsg) {
        OrgUnitInfo orgUnitInfo = application.getMainOrgUnit();
        String otherFilterStr = "CU='" + String.valueOf(orgUnitInfo.getId()) + "'";
        return BillViewUtil.checkFieldIsUniq(application, dao, propertyName, FIELD_TYPE_VARCHAR, alerMsg, otherFilterStr);
    }

    public static boolean checkFieldIsUniq(BillApplication application, Object dao, String propertyName, String fieldType, String alerMsg, String otherFilterStr) {
        boolean isExits = false;
        IObjectValue objectValue = application.getBillModel().getBillValue();
        otherFilterStr = otherFilterStr == null ? "" : " and " + otherFilterStr;
        StringBuffer filterStr = new StringBuffer();
        if (fieldType.equalsIgnoreCase(FIELD_TYPE_VARCHAR)) {
            filterStr = new StringBuffer("select id  where  " + propertyName + " = '" + objectValue.getString(propertyName) + "'" + otherFilterStr);
        } else if (fieldType.equalsIgnoreCase(FIELD_TYPE_NUM)) {
            filterStr = new StringBuffer("select id  where  " + propertyName + " = " + objectValue.getString(propertyName) + otherFilterStr);
        }
        if (objectValue.getBOSUuid("id") != null) {
            filterStr.append(" and  id<>'" + String.valueOf(objectValue.getBOSUuid("id")) + "'");
        }
        if (isExits = ((Boolean)ReflectionUtils.invokeMethod(dao, "exists", new Class[]{String.class}, new Object[]{filterStr.toString()})).booleanValue()) {
            application.showMessage(alerMsg);
            return false;
        }
        return true;
    }

    public static void lockElementByKeys(BillApplication application, String[] keys, boolean isLock) {
        if (keys == null) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            BillViewUtil.lockElement(application, keys[i], isLock);
        }
    }

    public static void lockElementByKeys(BillApplication application, List keys, boolean isLock) {
        BillViewUtil.lockElementByKeys(application, CommonUtil.list2Array(keys), isLock);
    }

    public static void lockElement(BillApplication application, String key, boolean isLock) {
        if (!StringUtils.isEmpty((String)key)) {
            application.lockElement(key, isLock);
        }
    }

    public static boolean isEntrysDuplicate(BillApplication application, String entryPropertyName, String uniqPropertyName) {
        IObjectValue objectValue = application.getBillModel().getBillValue();
        AbstractObjectCollection entrys = (AbstractObjectCollection)objectValue.get(entryPropertyName);
        int entrysSize = entrys.size();
        HashSet<Object> entrySet = new HashSet<Object>(entrysSize);
        for (int i = 0; i < entrysSize; ++i) {
            entrySet.add(ReflectionUtils.invokeGetterMethod(entrys.getObject(i), uniqPropertyName));
        }
        return entrysSize != entrySet.size();
    }

    public static void back2PreStatus(BillApplication application) {
        IObjectValue objectValue = application.getBillModel().getBillValue();
        BOSUuid currentModelId = (BOSUuid)objectValue.get("id");
        if (null == currentModelId) {
            ReflectionUtils.invokeSetterMethod(objectValue, BILL_STATUS, (Object)BillStatusEnum.ADD);
            try {
                application.getBillView().setOperationStatus(OperationStatus.ADDNEW);
            }
            catch (EASBizException e) {
                Logger.error((Throwable)e);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            return;
        }
        MyRemoteObjectUtil remoteObjectUtil = MyRemoteObjectUtil.getInstance();
        IObjectValue objectInfo = null;
        try {
            objectInfo = remoteObjectUtil.load(currentModelId.toString(), null);
        }
        catch (DataAccessException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        ReflectionUtils.invokeSetterMethod(objectValue, BILL_STATUS, ReflectionUtils.invokeGetterMethod(objectInfo, BILL_STATUS));
    }

    public static OperationStatus getOperationStatus(BillApplication application) {
        return application.getBillView().getOperationStatus();
    }

    public static boolean checkBillStatus(String operation, BillApplication application) {
        BillStatusManageUtil billStatusManageUtil = new BillStatusManageUtil(application);
        return billStatusManageUtil.isObeyStatusConvertRule(operation);
    }

    public static BOSUuid getBillModelId(BillApplication application) {
        IObjectValue objectValue = application.getBillValue();
        return objectValue == null ? null : (BOSUuid)application.getBillValue().get("id");
    }

    public static void setSystemFieldValue(BillApplication application, IObjectValue objectValue) throws BOSException, EASBizException {
        if (objectValue instanceof CrmBillBaseInfo) {
            Context ctx = application.getContext();
            OrgUnitInfo orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)ctx);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            AdminOrgUnitInfo dept = CommonDefaultValueHelper.getDept(userInfo.getPerson(), ctx);
            CrmBillBaseInfo baseInfo = (CrmBillBaseInfo)objectValue;
            baseInfo.setCreateOrg((FullOrgUnitInfo)orgUnitInfo);
            baseInfo.setHandler(userInfo);
            baseInfo.setPerson(BillViewUtil.getPersonInfo(userInfo));
            baseInfo.setCU(ctrlUnitInfo);
            baseInfo.setDepartment(dept);
        }
    }

    private static PersonInfo getPersonInfo(UserInfo user) throws EASBizException, BOSException {
        UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(user.getId()));
        PersonInfo person = userInfo.getPerson();
        return person;
    }

    public static boolean isSystemParamConfigEnabled(String nubmer, BillApplication application) throws EASBizException, BOSException {
        String orgId = ContextUtil.getCurrentOrgUnit((Context)application.getContext()).getId().toString();
        CoreBaseCollection param = SCMBillParamValueFactory.getRemoteInstance().getCollection("select *  where OrgUnitID='" + orgId + "' and Param.id in ( select SCMBillParam.fid from T_SCM_SCMBillParam  SCMBillParam where SCMBillParam.fnumber='" + nubmer + "')");
        if (null == param || param.size() == 0) {
            return false;
        }
        return ((SCMBillParamValueInfo)param.get(0)).getParamValue().equals("1");
    }

    public static void setDefaultRole(BillApplication application, UserInfo user) throws BOSException {
        OpAssociatedUserCollection shareUsers = (OpAssociatedUserCollection)((Object)application.getBillValue().get("associatedUser"));
        if (shareUsers != null) {
            shareUsers.get(0).setUser(user);
            CrmRoleCollection infos = CrmRoleFactory.getRemoteInstance().getCrmRoleCollection("select * where form.sourceBillId='" + application.getForm().getId() + "' and name='\u8d1f\u8d23\u4eba'");
            if (infos != null && infos.size() > 0) {
                shareUsers.get(0).setRoles(StringUtil.buildStringForObjNameAndNumber((Object[])new Object[]{infos.get(0)}));
                shareUsers.get(0).setCtrlUnit(user.getCU());
            }
        }
    }

    public static void setDefaultRole(BillApplication application) throws BOSException {
        BillViewUtil.setDefaultRole(application, ContextUtil.getCurrentUserInfo((Context)application.getContext()));
    }

    public static void setDefaultRole(BillApplication application, IObjectValue objectValue, UserInfo user, String formId) throws BOSException {
        OpAssociatedUserCollection shareUsers = (OpAssociatedUserCollection)((Object)objectValue.get("associatedUser"));
        if (shareUsers != null && shareUsers.get(0) == null) {
            OpAssociatedUserInfo opAssociatedUserInfo = new OpAssociatedUserInfo();
            opAssociatedUserInfo.setUser(user);
            CrmRoleCollection infos = CrmRoleFactory.getRemoteInstance().getCrmRoleCollection("select * where form.sourceBillId='" + formId + "' and name='\u8d1f\u8d23\u4eba'");
            if (infos != null && infos.size() > 0) {
                opAssociatedUserInfo.setRoles(StringUtil.buildStringForObjNameAndNumber((Object[])new Object[]{infos.get(0)}));
                opAssociatedUserInfo.setCtrlUnit(user.getCU());
            }
            shareUsers.add(opAssociatedUserInfo);
        }
    }

    public static void setDefaultRole(BillApplication application, IObjectValue objectValue, String formId) throws BOSException {
        BillViewUtil.setDefaultRole(application, objectValue, ContextUtil.getCurrentUserInfo((Context)application.getContext()), formId);
    }

    public static IObjectPK[] beforeLog(BillApplication application, FormOperation fo, String[] ids) throws EASBizException, BOSException {
        fo.setLogEnabled(false);
        BOSObjectType billType = BOSObjectType.create((String)application.getForm().getBosType());
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)billType, ICoreBillBase.class);
        IObjectPK[] pks = new IObjectPK[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            pks[i] = OperationHelper.beforeLogSevice((FormOperation)fo, (IObjectValue)coreBase.getValue((IObjectPK)new ObjectUuidPK(ids[i])));
        }
        return pks;
    }

    public static IObjectPK[] beforeLog(BillApplication application, String operationName, String operationLabelName, String[] ids) throws EASBizException, BOSException {
        IObjectPK[] pks = new IObjectPK[ids.length];
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("number"));
        MyRemoteObjectUtil remoteObjectUtil = MyRemoteObjectUtil.getInstance();
        for (int i = 0; i < ids.length; ++i) {
            Log.info((Object)("id==" + ids[i]));
            ObjectUuidPK pk = new ObjectUuidPK(ids[i]);
            IObjectValue objValue = remoteObjectUtil.load(ids[i], sc);
            String numberValue = null;
            Object number = objValue.get("number");
            numberValue = number == null ? String.valueOf(objValue.get("name")) : String.valueOf(number);
            pks[i] = LogUtil.beginLogWithDescription(null, (String)operationName, (BOSObjectType)objValue.getBOSType(), (IObjectPK)pk, (String)numberValue, (String)operationLabelName);
        }
        return pks;
    }

    public static void afterLog(BillApplication application, IObjectPK[] beforePks, String[] ids) throws EASBizException, BOSException {
        List filterPks = BillViewUtil.filterNull(beforePks);
        List filterIds = BillViewUtil.filterNull(ids);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(" id  in(" + CommonUtil.listToString(filterPks) + ")"));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSuccessed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("userID", (Object)ContextUtil.getCurrentUserInfo((Context)application.getContext()).getId()));
        filterInfo.getFilterItems().add(new FilterItemInfo("instanceId in(" + CommonUtil.listToString(filterIds) + ")"));
        IObjectPK[] pks = AppLogFactory.getRemoteInstance().getPKList(filterInfo, null);
        if (pks != null && pks.length == filterIds.size()) {
            CommonUtil.upateLogStatus(application.getContext(), pks);
        }
    }

    public static List filterNull(Object[] ids) {
        if (ids == null) {
            return new ArrayList(0);
        }
        ArrayList<Object> temp = new ArrayList<Object>();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            temp.add(ids[i]);
        }
        return temp;
    }
}

