/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.form.core.OpenModeEnum;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.list.ListApplication;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.base.form.web.WebListPanel;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.crm.plugins.util.ListViewUtil;
import com.kingdee.eas.scm.crm.plugins.util.MyRemoteObjectUtil;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class CommonUtil {
    private static final String VALUE_LISTPANEL_OPENTYPE = "1";
    private static final String VALUE_EDITPANEL_OPENTYPE = "2";
    private static final String URL_CHAR = "CrmChart.do";

    public static boolean isAutoNumber(IObjectValue bizObject) throws BOSException, EASBizException {
        String strCompanyID;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        return iCodingRuleManager.isExist(bizObject, strCompanyID = iCodingRuleManager.getCurrentAppOUID(bizObject));
    }

    public static Date createDateWithYYYYDDMM() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static void openWindow(IFormApplication application, String formID, String billID, String title, int x, int y) throws BOSException, EASBizException {
        JSONObject urlParam = new JSONObject();
        JSONObject winParam = new JSONObject();
        try {
            urlParam.put("BillId", (Object)billID);
            urlParam.put("formID", (Object)formID);
            urlParam.put("openSrc", (Object)VALUE_EDITPANEL_OPENTYPE);
            winParam.put("name", (Object)"distribute");
            winParam.put("title", (Object)title);
            winParam.put("x", x);
            winParam.put("y", y);
            String url = ResourceUtil.buildUrlEncodeParam((String)"BillServlet", null);
            FormActionUtil.invokeShowPopupAction((IFormApplication)application, (String)urlParam.toString(), (String)winParam.toString(), (String)url, (OpenModeEnum)OpenModeEnum.OpenDialog);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static void openWindow_old(ListApplication application, String formID, String billID, String title, int x, int y) throws BOSException, EASBizException {
        JSONObject urlParam = new JSONObject();
        JSONObject winParam = new JSONObject();
        try {
            urlParam.put("BillId", (Object)billID);
            urlParam.put("formID", (Object)formID);
            urlParam.put("openSrc", (Object)VALUE_LISTPANEL_OPENTYPE);
            winParam.put("name", (Object)"distribute");
            winParam.put("title", (Object)title);
            winParam.put("x", x);
            winParam.put("y", y);
            String url = ResourceUtil.buildUrlEncodeParam((String)"BillServlet", null);
            FormActionUtil.invokeShowPopupAction((IFormApplication)application, (String)urlParam.toString(), (String)winParam.toString(), (String)url, (OpenModeEnum)OpenModeEnum.OpenDialog);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static void openChartWindow(BillApplication application, String param, String title, int x, int y) throws BOSException, EASBizException {
        String url = ResourceUtil.buildUrlEncodeParam((String)URL_CHAR, (String)param);
        application.popupWindow(url, "openDialog", "chart", title, x, y);
    }

    public static String[] initBillIDsForOpenWindow(BillApplication application) throws BOSException {
        String[] billIDs = null;
        String openType = (String)application.getCustomParameter("openSrc");
        if (openType == null) {
            return billIDs;
        }
        if (openType.equals(VALUE_LISTPANEL_OPENTYPE)) {
            WebListPanel listPanel = (WebListPanel)application.getDynamicFormView().getParentFormView();
            billIDs = listPanel.getSelectedBillIds();
        } else if (openType.equals(VALUE_EDITPANEL_OPENTYPE)) {
            billIDs = new String[]{(String)application.getDynamicFormView().getParentFormView().getApplicationContext().getData("BillId")};
        }
        return billIDs;
    }

    public static Entity initEntityForOpenWindow(BillApplication application) throws BOSException {
        Entity entity = null;
        String openType = (String)application.getCustomParameter("openSrc");
        if (openType == null) {
            return entity;
        }
        if (openType.equals(VALUE_LISTPANEL_OPENTYPE)) {
            WebListPanel listPanel = (WebListPanel)application.getDynamicFormView().getParentFormView();
            entity = listPanel.getBusinessInfo().getEntity(0);
        } else if (openType.equals(VALUE_EDITPANEL_OPENTYPE)) {
            WebBillEditPanel billPanel = (WebBillEditPanel)application.getDynamicFormView().getParentFormView();
            entity = billPanel.getBusinessInfo().getEntity(0);
        }
        return entity;
    }

    public static void openNewWindow(BillApplication application, String formID, String billID, String title, int x, int y) throws BOSException {
        JSONObject para = new JSONObject();
        try {
            para.put("formID", (Object)formID);
            para.put("BillId", (Object)billID);
            para.put("openSrc", (Object)VALUE_EDITPANEL_OPENTYPE);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        String url = ResourceUtil.buildUrlEncodeParam((String)"BillServlet", (String)para.toString());
        application.popupWindow(url, "openDialog", "NewWindow", title, x, y);
    }

    public static void openNewListWindow(BillApplication application, String formID, String billID, String title, int x, int y) throws BOSException {
        JSONObject para = new JSONObject();
        try {
            para.put("formID", (Object)formID);
            para.put("BillId", (Object)billID);
            para.put("crm_role_type", (Object)formID);
            para.put("openSrc", (Object)VALUE_LISTPANEL_OPENTYPE);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        String url = ResourceUtil.buildUrlEncodeParam((String)"ListServlet", (String)para.toString());
        application.popupWindow(url, "openDialog", "NewWindow", title, x, y);
    }

    public static void openNewListWindow(BillApplication application, String formID, String formTypeId, String billID, String title, int x, int y) throws BOSException {
        JSONObject para = new JSONObject();
        try {
            para.put("formID", (Object)formID);
            para.put("BillId", (Object)billID);
            para.put("crm_role_type", (Object)formTypeId);
            para.put("openSrc", (Object)VALUE_LISTPANEL_OPENTYPE);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        String url = ResourceUtil.buildUrlEncodeParam((String)"ListServlet", (String)para.toString());
        application.popupWindow(url, "openDialog", "NewWindow", title, x, y);
    }

    public static OrgUnitInfo getOrgUnit(OrgType orgType, OrgType returnOrgType, BOSUuid orgPK) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection orgUnitCollection = iOrgUnitRelation.getToUnit(orgPK.toString(), orgType.getValue(), returnOrgType.getValue());
        if (orgUnitCollection.size() > 0) {
            return orgUnitCollection.get(0);
        }
        return null;
    }

    public static OrgUnitCollection getOrgUnitCollection(OrgType orgType, OrgType returnOrgType, BOSUuid orgPK) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection orgUnitCollection = iOrgUnitRelation.getToUnit(orgPK.toString(), orgType.getValue(), returnOrgType.getValue());
        return orgUnitCollection;
    }

    public static CtrlUnitCollection getFullCu(CtrlUnitInfo cu) throws BOSException {
        CtrlUnitCollection cus = null;
        String longNumber = cu.getLongNumber();
        String[] numbers = longNumber.split("!");
        StringBuffer oql = new StringBuffer("select id where ");
        if (numbers != null) {
            StringBuffer oldNumber = new StringBuffer();
            for (int i = 0; i < numbers.length; ++i) {
                if (i == 0) {
                    oql.append("longNumber='").append(numbers[i]).append("'").append(" or ");
                } else {
                    oql.append("longNumber='").append(oldNumber).append(numbers[i]).append("'").append(" or ");
                }
                oldNumber.append(numbers[i]).append("!");
            }
            if (oql.indexOf("or") != -1) {
                oql.delete(oql.lastIndexOf("or"), oql.lastIndexOf("or") + 2);
            }
            cus = CtrlUnitFactory.getRemoteInstance().getCtrlUnitCollection(oql.toString());
        }
        return cus;
    }

    public static CoreBaseCollection getPosiMemberByPerson(BOSUuid personId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId.toString()));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.*"));
        CoreBaseCollection posiMemberColl = null;
        IPositionMember iPosiMember = PositionMemberFactory.getRemoteInstance();
        posiMemberColl = iPosiMember.getCollection(viewInfo);
        return posiMemberColl;
    }

    public static UserInfo getUser(PersonInfo person) throws BOSException {
        UserCollection users = UserFactory.getRemoteInstance().getUserCollection("where person.id='" + person.getId().toString() + "'");
        if (users != null && !users.isEmpty()) {
            return users.get(0);
        }
        return null;
    }

    public static UserCollection getUserCollection() throws BOSException {
        UserCollection users = UserFactory.getRemoteInstance().getUserCollection();
        if (users != null) {
            return users;
        }
        throw new IllegalArgumentException();
    }

    public static List buildIncludeFilterValue(List values) {
        if (null == values || values.isEmpty()) {
            return null;
        }
        int maxSize = 50;
        ArrayList<String> filterValueList = new ArrayList<String>();
        StringBuffer result = new StringBuffer();
        int length = values.size();
        for (int i = 0; i < length; ++i) {
            if (i % 50 == 0 && i != 0) {
                if (result.length() > 0) {
                    result.deleteCharAt(result.lastIndexOf(","));
                }
                filterValueList.add(result.toString());
                result = new StringBuffer();
            }
            if (i < length - 1) {
                result.append(String.valueOf(values.get(i))).append(",");
                continue;
            }
            result.append(String.valueOf(values.get(i)));
        }
        filterValueList.add(result.toString());
        return filterValueList;
    }

    public static List buildIncludeIdsValue(List values) {
        if (null == values || values.isEmpty()) {
            return null;
        }
        int maxSize = 50;
        ArrayList<String> filterValueList = new ArrayList<String>();
        StringBuffer result = new StringBuffer();
        int length = values.size();
        for (int i = 0; i < length; ++i) {
            if (i % 50 == 0 && i != 0) {
                if (result.length() > 0) {
                    result.deleteCharAt(result.lastIndexOf(","));
                }
                filterValueList.add(result.toString());
                result = new StringBuffer();
            }
            if (i < length - 1) {
                result.append("'").append(String.valueOf(values.get(i))).append("',");
                continue;
            }
            result.append("'").append(String.valueOf(values.get(i))).append("'");
        }
        filterValueList.add(result.toString());
        return filterValueList;
    }

    public static EntityViewInfo buildEntityViewInfo(List filterItems) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (filterItems != null && !filterItems.isEmpty()) {
            FilterItemInfo filterItem = null;
            int size = filterItems.size();
            for (int i = 0; i < size; ++i) {
                filterItem = (FilterItemInfo)filterItems.get(i);
                filter.getFilterItems().add(filterItem);
            }
        }
        view.setFilter(filter);
        return view;
    }

    public static List getTempList(List list) {
        ArrayList tempList = null;
        if ((double)list.size() / 50.0 > 1.0) {
            tempList = new ArrayList();
            for (int m = 0; m < 50; ++m) {
                tempList.add(list.get(m));
            }
        } else {
            return list;
        }
        return tempList;
    }

    public static String listToString(List list) {
        StringBuffer idListString = new StringBuffer("");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            idListString.append("'").append(list.get(i).toString()).append("',");
        }
        if (idListString != null && idListString.lastIndexOf(",") >= 0) {
            idListString.deleteCharAt(idListString.lastIndexOf(","));
        }
        return idListString.toString();
    }

    public static String arrayToString(String[] array) {
        if (null == array || array.length == 0) {
            return null;
        }
        StringBuffer idListString = new StringBuffer("");
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            idListString.append("'").append(array[i]).append("',");
        }
        if (idListString != null && idListString.length() > 0) {
            idListString.deleteCharAt(idListString.lastIndexOf(","));
        }
        return idListString.toString();
    }

    public static String arrayToString(Object[] array) {
        if (null == array || array.length == 0) {
            return null;
        }
        StringBuffer idListString = new StringBuffer("");
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            idListString.append("'").append(array[i]).append("',");
        }
        if (idListString != null) {
            idListString.deleteCharAt(idListString.lastIndexOf(","));
        }
        return idListString.toString();
    }

    public static String[] list2Array(List list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        String[] toBeStored = new String[size];
        for (int i = 0; i < size; ++i) {
            toBeStored[i] = String.valueOf(list.get(i));
        }
        return toBeStored;
    }

    public static List array2List(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        if (array == null || array.length == 0) {
            return list;
        }
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static String addSingleQuotes(String value) {
        StringBuffer sb = new StringBuffer("'");
        sb.append(value).append("'");
        return sb.toString();
    }

    public static String formatDecimalByPrecision(Object data, int precision) {
        StringBuffer sb = new StringBuffer("0.");
        for (int i = 0; i < precision; ++i) {
            sb.append("0");
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        return df.format(data);
    }

    public static OrgType getMarketOrgTye() {
        return OrgType.getEnum((int)101);
    }

    public static OrgType getServiceOrgTye() {
        return OrgType.getEnum((int)100);
    }

    public static IObjectPK[] string2PK(Object[] ids) {
        if (null == ids) {
            return null;
        }
        IObjectPK[] pks = new IObjectPK[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            pks[i] = new ObjectUuidPK(String.valueOf(ids[i]));
        }
        return pks;
    }

    public static SalePersonInfo getSellerByPerson(PersonInfo personInfo) {
        try {
            SalePersonCollection salePersons = SalePersonFactory.getRemoteInstance().getSalePersonCollection(" person.id='" + personInfo.getId() + "'");
            if (null != salePersons && salePersons.size() == 1) {
                return salePersons.get(0);
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return null;
    }

    public static String datetimeToString(Date myDate) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sf.format(myDate);
    }

    public static String datetimeToString(Date myDate, String formatStr) {
        SimpleDateFormat sf = new SimpleDateFormat(formatStr);
        return sf.format(myDate);
    }

    public static Timestamp getTimestamp(Date date) {
        SimpleDateFormat transeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String transeDate = transeFormat.format(date);
        return Timestamp.valueOf(transeDate);
    }

    public static int getDiffDays(Date d1, Date d2) {
        CommonUtil.validArgs(d1, d2);
        Date date1 = CommonUtil.trimTime(d1);
        Date date2 = CommonUtil.trimTime(d2);
        long diff = date1.getTime() - date2.getTime();
        int days = new Long(diff /= 86400000L).intValue();
        return days;
    }

    public static Date trimTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("can't input a null date argument.");
        }
        GregorianCalendar c1 = new GregorianCalendar();
        c1.setTime(date);
        GregorianCalendar c2 = new GregorianCalendar();
        c2.set(1, c1.get(1));
        c2.set(2, c1.get(2));
        c2.set(5, c1.get(5));
        c2.set(11, 0);
        c2.set(12, 0);
        c2.set(13, 0);
        c2.set(14, 0);
        return c2.getTime();
    }

    private static void validArgs(Date d1, Date d2) {
        if (d1 == null) {
            throw new IllegalArgumentException("\u7b2c\u4e00\u4e2a\u65e5\u671f\u53c2\u6570\u662fnull!");
        }
        if (d2 == null) {
            throw new IllegalArgumentException("\u7b2c\u4e8c\u4e2a\u65e5\u671f\u53c2\u6570\u662fnull!");
        }
    }

    public static Date dateAddByMonth(Date date, int addMonth) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        c.set(2, month + 1);
        return c.getTime();
    }

    public static void upateLogStatus(Context ctx, IObjectPK[] pks) throws BOSException {
        if (pks != null) {
            List filterPks = ListViewUtil.filterNull(pks);
            if (filterPks.isEmpty()) {
                return;
            }
            String sql = "update t_log_app set FIsSuccessed = 1 where fid in ( " + CommonUtil.listToString(filterPks) + " )";
            MyRemoteObjectUtil.getInstance().execute(ctx, sql);
        }
    }
}

