/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.crm.plugins.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.crm.common.CrmPermissionItemCollection;
import com.kingdee.eas.scm.crm.common.CrmPermissionItemFactory;
import com.kingdee.eas.scm.crm.common.CrmPermissionItemInfo;
import com.kingdee.eas.scm.crm.common.CrmRoleCollection;
import com.kingdee.eas.scm.crm.common.CrmRoleFactory;
import com.kingdee.eas.scm.crm.common.CrmRoleInfo;
import com.kingdee.eas.scm.crm.common.FormInfo;
import com.kingdee.eas.scm.crm.common.ICrmPermissionItem;
import com.kingdee.eas.scm.crm.common.ICrmRole;
import com.kingdee.eas.scm.crm.plugins.util.BusinessException;
import com.kingdee.eas.scm.crm.plugins.util.PermissionKeyUtils;
import com.kingdee.eas.scm.crm.sm.IOpAssociatedUser;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserCollection;
import com.kingdee.eas.scm.crm.sm.OpAssociatedUserFactory;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrmAuthUtil {
    private static Context ctx;
    private static String DEFUALT_PERMISSIONKEY;
    private static char[] DEFUALT_PERMISSIONKEY_ITEMS;
    private static int DEFUALT_PERMISSIONKEY_LENGTH;
    private static ConcurrentMap PERMISSION_ITEMKEY_CODE_MAP;
    private static ConcurrentMap PERMISSION_ITEMCODE_KEY_MAP;
    private static Map dataMapKeyCode;
    private static Map dataMapCodeKey;
    private static ICrmPermissionItem iCrmPermissionItem;
    private ICrmRole iCrmRole;
    String currentDataCenter = ctx.getAIS();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CrmAuthUtil() {
        if (null == dataMapKeyCode.get(this.currentDataCenter)) {
            byte[] lock;
            byte[] byArray = lock = new byte[0];
            synchronized (lock) {
                StringBuffer permissionKeyDefault = new StringBuffer(DEFUALT_PERMISSIONKEY);
                for (int i = 0; i < DEFUALT_PERMISSIONKEY_LENGTH; ++i) {
                    permissionKeyDefault.append("0");
                }
                DEFUALT_PERMISSIONKEY = permissionKeyDefault.toString();
                DEFUALT_PERMISSIONKEY_ITEMS = DEFUALT_PERMISSIONKEY.toCharArray();
                try {
                    iCrmPermissionItem = CrmPermissionItemFactory.getRemoteInstance();
                }
                catch (BOSException e) {
                    throw new BusinessException(e);
                }
                this.initPermissionItemkeyCodeMap(dataMapKeyCode, dataMapCodeKey);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        PERMISSION_ITEMKEY_CODE_MAP = (ConcurrentMap)dataMapKeyCode.get(this.currentDataCenter);
        PERMISSION_ITEMCODE_KEY_MAP = (ConcurrentMap)dataMapCodeKey.get(this.currentDataCenter);
    }

    public static CrmAuthUtil getInstance(Context context) {
        ctx = context;
        return new CrmAuthUtilContainer().instance;
    }

    public void initPermissionItemkeyCodeMap(Map dataMapKeyCode, Map dataMapCodeKey) {
        ConcurrentHashMap permissionIitemkeyCodeMap = new ConcurrentHashMap();
        ConcurrentHashMap permissionItemcodeKeyMap = new ConcurrentHashMap();
        CrmPermissionItemCollection crmPermissionItemCollection = null;
        try {
            crmPermissionItemCollection = iCrmPermissionItem.getCrmPermissionItemCollection("select form.*,itemKey,permissionCode,permissionScope where isEnabled=1  and  isDeleted=0");
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
        if (null == crmPermissionItemCollection) {
            return;
        }
        int size = crmPermissionItemCollection.size();
        for (int i = 0; i < size; ++i) {
            CrmPermissionItemInfo crmPermissionItemInfo = crmPermissionItemCollection.get(i);
            FormInfo finfo = crmPermissionItemInfo.getForm();
            String formId = finfo.getSourceBillId().toString();
            String itemKey = crmPermissionItemInfo.getItemKey().toUpperCase();
            String scope = crmPermissionItemInfo.getPermissionScope() == null ? "_ALL" : crmPermissionItemInfo.getPermissionScope().getValue();
            String permissionCode = String.valueOf(crmPermissionItemInfo.getPermissionCode());
            permissionIitemkeyCodeMap.put((Object)String.valueOf(formId + itemKey + scope), (Object)new Integer(permissionCode));
            permissionItemcodeKeyMap.put((Object)(formId + permissionCode), (Object)crmPermissionItemInfo.getItemKey());
        }
        dataMapKeyCode.put(this.currentDataCenter, permissionIitemkeyCodeMap);
        dataMapCodeKey.put(this.currentDataCenter, permissionItemcodeKeyMap);
    }

    private boolean isAuthed(int permissionIndex, String permissionKeyStr) {
        if (StringUtils.isEmpty((String)permissionKeyStr) || permissionIndex < 0) {
            return false;
        }
        return permissionKeyStr.charAt(permissionIndex) == '1';
    }

    public String generatePermmissionKeyStr(CrmPermissionItemCollection crmPermissionItemCollection) {
        if (crmPermissionItemCollection == null || crmPermissionItemCollection.size() == 0) {
            return "";
        }
        char[] cs = (char[])DEFUALT_PERMISSIONKEY_ITEMS.clone();
        CrmPermissionItemInfo crmPermissionItem = null;
        int size = crmPermissionItemCollection.size();
        for (int i = 0; i < size; ++i) {
            crmPermissionItem = crmPermissionItemCollection.get(i);
            if (null == crmPermissionItem) continue;
            int permissioncode = crmPermissionItem.getPermissionCode();
            boolean isAuthed = crmPermissionItem.isIsEnabled();
            cs[permissioncode] = isAuthed ? 49 : 48;
        }
        return PermissionKeyUtils.convertPermissionKey2HexStr(String.valueOf(cs));
    }

    public void initCrmPermissionItemCollectionAuthed(CrmPermissionItemCollection crmPermissionItemCollection, String permissionKeyStr) {
        permissionKeyStr = PermissionKeyUtils.convertPermissionKey2BinStr(permissionKeyStr);
        if (crmPermissionItemCollection == null || crmPermissionItemCollection.size() == 0) {
            return;
        }
        char[] cs = permissionKeyStr.toCharArray();
        CrmPermissionItemInfo crmPermissionItem = null;
        int size = crmPermissionItemCollection.size();
        for (int i = 0; i < size; ++i) {
            crmPermissionItem = crmPermissionItemCollection.get(i);
            crmPermissionItem.setSeq(i + 1);
            if (null == crmPermissionItem) continue;
            int permissioncode = crmPermissionItem.getPermissionCode();
            crmPermissionItem.setIsEnabled(cs[permissioncode] == '1');
        }
    }

    public boolean isUIComponentAuthed(String formId, String componentKey, String permissionKey) {
        if (null == permissionKey || permissionKey.trim().length() == 0) {
            return true;
        }
        if (null == PERMISSION_ITEMKEY_CODE_MAP || PERMISSION_ITEMKEY_CODE_MAP.size() == 0) {
            throw new BusinessException("PERMISSION_ITEMKEY_CODE_MAP \u7f13\u5b58\u6ca1\u88ab\u521d\u59cb\u5316\uff01");
        }
        if (null == PERMISSION_ITEMKEY_CODE_MAP.get((Object)(formId + componentKey + "_ALL"))) {
            return true;
        }
        permissionKey = PermissionKeyUtils.convertPermissionKey2BinStr(permissionKey);
        int permissionCode = (Integer)PERMISSION_ITEMKEY_CODE_MAP.get((Object)(formId + componentKey + "_ALL"));
        return this.isAuthed(permissionCode, permissionKey);
    }

    public List getUnAuthedUIComponentKeys(String formId, int permissionType, String permissionKey) {
        ArrayList<Object> unAuthedKeys = new ArrayList<Object>();
        int i = 1;
        int endNum = 100;
        switch (permissionType) {
            case 1: {
                i = 1;
                endNum = 100;
                break;
            }
            case 0: {
                i = 101;
                endNum = 200;
                break;
            }
            case 2: {
                i = 201;
                endNum = 300;
                break;
            }
            default: {
                throw new BusinessException("\u6743\u9650\u9879\u7c7b\u578b\u4e0d\u5b58\u5728\uff01");
            }
        }
        if (null == permissionKey || permissionKey.trim().length() == 0) {
            return unAuthedKeys;
        }
        permissionKey = PermissionKeyUtils.convertPermissionKey2BinStr(permissionKey);
        char[] keys = permissionKey.toCharArray();
        while (i <= endNum) {
            Object key;
            if ('0' == keys[i] && null != (key = PERMISSION_ITEMCODE_KEY_MAP.get((Object)(formId + String.valueOf(i))))) {
                unAuthedKeys.add(key);
            }
            ++i;
        }
        return unAuthedKeys;
    }

    public int getRelatedFormAuth(String formId, String componentKey, String permissionKey) {
        componentKey = componentKey.toUpperCase();
        String allScopeKey = String.valueOf(formId + componentKey + "_ALL");
        String myScopeKey = String.valueOf(formId + componentKey + "_MY");
        if (null == permissionKey || permissionKey.trim().length() == 0) {
            return 3;
        }
        if (null == PERMISSION_ITEMKEY_CODE_MAP || PERMISSION_ITEMKEY_CODE_MAP.size() == 0) {
            throw new BusinessException("PERMISSION_ITEMKEY_CODE_MAP \u7f13\u5b58\u6ca1\u88ab\u521d\u59cb\u5316\uff01");
        }
        if (null == PERMISSION_ITEMKEY_CODE_MAP.get((Object)allScopeKey) && null == PERMISSION_ITEMKEY_CODE_MAP.get((Object)myScopeKey)) {
            return 3;
        }
        int permissionCode = -1;
        boolean isAuthed = false;
        if (PERMISSION_ITEMKEY_CODE_MAP.get((Object)allScopeKey) != null) {
            permissionCode = (Integer)PERMISSION_ITEMKEY_CODE_MAP.get((Object)allScopeKey);
            if (permissionCode < 200) {
                throw new BusinessException("CRM_PERMISSION  \u4f20\u5165\u7684\u63a7\u4ef6\u4e0d\u662f\u5173\u8054\u5355\u636e\uff01");
            }
            isAuthed = this.isAuthed(permissionCode, permissionKey);
            if (isAuthed) {
                return 3;
            }
        }
        if (PERMISSION_ITEMKEY_CODE_MAP.get((Object)myScopeKey) == null) {
            return 1;
        }
        permissionCode = (Integer)PERMISSION_ITEMKEY_CODE_MAP.get((Object)myScopeKey);
        if (permissionCode < 300) {
            throw new BusinessException("CRM_PERMISSION  \u4f20\u5165\u7684\u63a7\u4ef6\u4e0d\u662f\u5173\u8054\u5355\u636e\uff01");
        }
        isAuthed = this.isAuthed(permissionCode, permissionKey);
        if (isAuthed) {
            return 2;
        }
        return 1;
    }

    public void refreshPermissionItemCache() {
        PERMISSION_ITEMKEY_CODE_MAP.clear();
        PERMISSION_ITEMCODE_KEY_MAP.clear();
        this.initPermissionItemkeyCodeMap(dataMapKeyCode, dataMapCodeKey);
    }

    public void reBuildPermissionKeyStrs(String formId, int oldIndex, int newIndex, String operationType) throws EASBizException, BOSException {
        this.refreshPermissionItemCache();
        CrmRoleCollection crmRoleCollection = null;
        try {
            this.iCrmRole = CrmRoleFactory.getRemoteInstance();
            crmRoleCollection = this.iCrmRole.getCrmRoleCollection("select permissionKey  where  form.id='" + formId + "'");
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
        CoreBaseCollection crmRoleInfoCollection = new CoreBaseCollection();
        int size = crmRoleCollection.size();
        for (int i = 0; i < size; ++i) {
            CrmRoleInfo crmRoleInfo = crmRoleCollection.get(i);
            char[] keys = PermissionKeyUtils.convertPermissionKey2BinStr(crmRoleInfo.getPermissionKey()).toCharArray();
            if (operationType.equalsIgnoreCase("Delete")) {
                keys[oldIndex] = 48;
            }
            if (operationType.equalsIgnoreCase("Edit")) {
                keys[newIndex] = keys[oldIndex];
                keys[oldIndex] = 48;
            }
            crmRoleInfo.setPermissionKey(PermissionKeyUtils.convertPermissionKey2HexStr(String.valueOf(keys)));
            crmRoleInfoCollection.add((CoreBaseInfo)crmRoleInfo);
        }
        this.iCrmRole.updateBatchData(crmRoleInfoCollection);
    }

    public void reBuildPermissionKeyStrsOnDelete(String formId, int permissionCode) {
        CrmRoleCollection crmRoleCollection = null;
        try {
            this.iCrmRole = CrmRoleFactory.getRemoteInstance();
            crmRoleCollection = this.iCrmRole.getCrmRoleCollection("select permissionKey  where  form.id='" + formId + "'");
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
        CoreBaseCollection crmRoleInfoCollection = new CoreBaseCollection();
        int size = crmRoleCollection.size();
        for (int i = 0; i < size; ++i) {
            CrmRoleInfo crmRoleInfo = crmRoleCollection.get(i);
            char[] keys = PermissionKeyUtils.convertPermissionKey2BinStr(crmRoleInfo.getPermissionKey()).toCharArray();
            keys[permissionCode] = 49;
            crmRoleInfo.setPermissionKey(PermissionKeyUtils.convertPermissionKey2HexStr(String.valueOf(keys)));
            crmRoleInfoCollection.add((CoreBaseInfo)crmRoleInfo);
        }
        try {
            this.iCrmRole.updateBatchData(crmRoleInfoCollection);
        }
        catch (EASBizException e) {
            throw new BusinessException(e);
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
    }

    public String mergeUserPermissionKeys(String formId, String recordId, String userId) {
        OpAssociatedUserCollection opAssociatedUserCollection = null;
        try {
            IOpAssociatedUser iOpAssociatedUser = OpAssociatedUserFactory.getRemoteInstance();
            opAssociatedUserCollection = iOpAssociatedUser.getOpAssociatedUserCollection("select role  where id='" + recordId + "' and  user.id='" + userId + "'");
        }
        catch (BOSException e) {
            throw new BusinessException(e);
        }
        if (null != opAssociatedUserCollection && opAssociatedUserCollection.size() > 0) {
            ArrayList<String> permissionKeys = new ArrayList<String>(opAssociatedUserCollection.size());
            int size = opAssociatedUserCollection.size();
            for (int i = 0; i < size; ++i) {
                permissionKeys.add(opAssociatedUserCollection.get(i).getRole().getPermissionKey());
            }
            return PermissionKeyUtils.convertPermissionKey2HexStr(this.mergePermissionKeys(permissionKeys));
        }
        return PermissionKeyUtils.convertPermissionKey2HexStr(DEFUALT_PERMISSIONKEY);
    }

    public String mergePermissionKeys(List permissionKeys) {
        if (null == permissionKeys || permissionKeys.size() == 0) {
            return null;
        }
        char[] finalKeyChars = (char[])DEFUALT_PERMISSIONKEY_ITEMS.clone();
        int size = permissionKeys.size();
        for (int i = 0; i < size; ++i) {
            char[] keys = PermissionKeyUtils.convertPermissionKey2BinStr((String)permissionKeys.get(i)).toCharArray();
            if (keys.length < DEFUALT_PERMISSIONKEY_LENGTH) {
                keys = DEFUALT_PERMISSIONKEY_ITEMS;
            }
            for (int j = 1; j < DEFUALT_PERMISSIONKEY_LENGTH + 1; ++j) {
                if ('1' != keys[j]) continue;
                finalKeyChars[j] = 49;
            }
        }
        return String.valueOf(finalKeyChars);
    }

    static {
        DEFUALT_PERMISSIONKEY = "1";
        DEFUALT_PERMISSIONKEY_LENGTH = 400;
        PERMISSION_ITEMKEY_CODE_MAP = new ConcurrentHashMap();
        PERMISSION_ITEMCODE_KEY_MAP = new ConcurrentHashMap();
        dataMapKeyCode = new HashMap();
        dataMapCodeKey = new HashMap();
    }

    private static class CrmAuthUtilContainer {
        private CrmAuthUtil instance = new CrmAuthUtil();

        private CrmAuthUtilContainer() {
        }
    }
}

