/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.alter.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.alter.AlterViewConfigCollection;
import com.kingdee.eas.scm.framework.alter.AlterViewConfigException;
import com.kingdee.eas.scm.framework.alter.AlterViewConfigFactory;
import com.kingdee.eas.scm.framework.alter.AlterViewConfigFieldCollection;
import com.kingdee.eas.scm.framework.alter.AlterViewConfigFieldInfo;
import com.kingdee.eas.scm.framework.alter.AlterViewConfigInfo;
import com.kingdee.eas.scm.framework.alter.app.AbstractAlterViewConfigControllerBean;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AlterViewConfigControllerBean
extends AbstractAlterViewConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.alter.app.AlterViewConfigControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.scm.framework.alter.AlterViewConfigResource";

    private void checkBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        AlterViewConfigInfo alterViewConfigInfo;
        AlterViewConfigInfo info = (AlterViewConfigInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            this.throwNullFieldException("numberCantBeNull");
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            this.throwNullFieldException("nameCantBeNull");
        }
        if (info.getCU() == null) {
            this.throwNullFieldException("CUCantBeNull");
        }
        if (StringUtils.isEmpty((String)info.getBillName()) || StringUtils.isEmpty((String)info.getBosType())) {
            this.throwNullFieldException("billCantBeNull");
        }
        if (info.getEntry() == null || info.getEntry().size() == 0) {
            this.throwNullFieldException("oneFieldAtLeast");
        }
        if (info.getId() != null && (alterViewConfigInfo = this.getNewestStatusInfo4Check(ctx, info.getId().toString())).getStatus() == UseStatusEnum.ACTIVE) {
            throw new AlterViewConfigException(AlterViewConfigException.STATUSERROR4SAVE);
        }
        this.checkNumberDup(ctx, info);
        this.checkNameDup(ctx, info);
    }

    private void checkBeforeEnable(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        AlterViewConfigInfo alterViewConfigInfo = (AlterViewConfigInfo)model;
        String checkMsg = this.buildEnableCheckMsg(ctx, alterViewConfigInfo);
        if (!StringUtils.isEmpty((String)checkMsg)) {
            throw new AlterViewConfigException(AlterViewConfigException.EMPTYEXCEPTION, new String[]{checkMsg});
        }
    }

    private void checkBeforeDisable(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        AlterViewConfigInfo alterViewConfigInfo = (AlterViewConfigInfo)model;
        String checkMsg = this.buildDisableCheckMsg(alterViewConfigInfo);
        if (!StringUtils.isEmpty((String)checkMsg)) {
            throw new AlterViewConfigException(AlterViewConfigException.EMPTYEXCEPTION, new String[]{checkMsg});
        }
    }

    private void updateModel4Submit(IObjectValue model) {
        AlterViewConfigInfo info = (AlterViewConfigInfo)model;
        if (info.getStatus() != UseStatusEnum.INACTIVE) {
            info.setStatus(UseStatusEnum.SAVED);
        }
        AlterViewConfigFieldCollection entries = info.getEntry();
        AlterViewConfigFieldInfo entry = null;
        for (int i = entries.size() - 1; i >= 0; --i) {
            entry = entries.get(i);
            if (!StringUtils.isEmpty((String)entry.getField())) continue;
            entries.removeObject((IObjectValue)entry);
        }
    }

    private void updateModel4Disable(IObjectValue model) {
        AlterViewConfigInfo info = (AlterViewConfigInfo)model;
        info.setStatus(UseStatusEnum.INACTIVE);
    }

    private void updateModel4Enable(IObjectValue model) {
        AlterViewConfigInfo info = (AlterViewConfigInfo)model;
        info.setStatus(UseStatusEnum.ACTIVE);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.updateModel4Submit(model);
        this.checkBeforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AlterViewConfigInfo info = this.getNewestStatusInfo4Check(ctx, pk.toString());
        this.checkBeforeDisable(ctx, (IObjectValue)info);
        this.updateModel4Disable((IObjectValue)info);
        super._cancel(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected Map _batchDisable(Context ctx, List idList) throws BOSException, EASBizException {
        AlterViewConfigCollection alterViewConfigCollection = this.getAlterViewConfigCollByIds(ctx, idList);
        String msg = null;
        boolean hasError = false;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder result = new StringBuilder();
        HashSet<String> validateIdSet = new HashSet<String>();
        int size = alterViewConfigCollection.size();
        for (int i = 0; i < size; ++i) {
            msg = this.buildDisableCheckMsg(alterViewConfigCollection.get(i));
            if (!StringUtils.isEmpty((String)msg)) {
                hasError = true;
                result.append(msg).append("\n");
                continue;
            }
            validateIdSet.add(alterViewConfigCollection.get(i).getId().toString());
        }
        resultMap.put("hasError", hasError);
        resultMap.put("errorMsg", result.toString());
        this.updateConfigStatus(ctx, validateIdSet, 2);
        this.buildLogInfo(ctx, alterViewConfigCollection, validateIdSet, "alterviewconfig_disable", "batchDisable");
        return resultMap;
    }

    private void buildLogInfo(Context ctx, AlterViewConfigCollection alterViewConfigCollection, Set validateIdSet, String logItem, String methodName) {
        AlterViewConfigInfo info = null;
        StringBuilder msgSb = new StringBuilder();
        int size = alterViewConfigCollection.size();
        for (int i = 0; i < size; ++i) {
            info = alterViewConfigCollection.get(i);
            IObjectPK logId = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)this.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)info.getNumber(), (String)logItem);
            if (!validateIdSet.contains(info.getId().toString())) continue;
            LogUtil.afterLog((Context)ctx, (IObjectPK)logId);
        }
    }

    private void updateConfigStatus(Context ctx, Set idSet, int stateValue) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" update T_SCM_AlterViewConfig set FStatus = ").append(stateValue).append(" ");
        sql.append(" where fid in (").append(ArrayUtil.getKeyIdStr((Object[])idSet.toArray())).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String buildDisableCheckMsg(AlterViewConfigInfo alterViewConfigInfo) {
        StringBuilder result = new StringBuilder();
        if (alterViewConfigInfo.getStatus() == UseStatusEnum.INACTIVE) {
            result.append(ResourceBase.getString((String)RESOURCE, (String)"badState2Disable", (Locale)ContextUtils.getLocaleFromEnv(), (Object[])new String[]{alterViewConfigInfo.getNumber()}));
        } else if (alterViewConfigInfo.getStatus() != UseStatusEnum.ACTIVE) {
            result.append(ResourceBase.getString((String)RESOURCE, (String)"saveState2Disable", (Locale)ContextUtils.getLocaleFromEnv(), (Object[])new String[]{alterViewConfigInfo.getNumber()}));
        }
        return result.toString();
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AlterViewConfigInfo info = this.getNewestStatusInfo4Check(ctx, pk.toString());
        this.checkBeforeEnable(ctx, (IObjectValue)info);
        this.updateModel4Enable((IObjectValue)info);
        super._cancelCancel(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected Map _batchEnable(Context ctx, List idList) throws BOSException, EASBizException {
        AlterViewConfigCollection alterViewConfigCollection = this.getAlterViewConfigCollByIds(ctx, idList);
        String msg = null;
        boolean hasError = false;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder result = new StringBuilder();
        HashSet<String> validateIdSet = new HashSet<String>();
        HashSet<String> keySet = new HashSet<String>();
        int size = alterViewConfigCollection.size();
        for (int i = 0; i < size; ++i) {
            msg = this.buildEnableCheckMsg(ctx, alterViewConfigCollection.get(i));
            if (!StringUtils.isEmpty((String)msg)) {
                hasError = true;
                result.append(msg).append("\n");
                continue;
            }
            String key = alterViewConfigCollection.get(i).getCU().getId().toString() + alterViewConfigCollection.get(i).getBosType();
            if (keySet.add(key)) {
                validateIdSet.add(alterViewConfigCollection.get(i).getId().toString());
                continue;
            }
            hasError = true;
            result.append(ResourceBase.getString((String)RESOURCE, (String)"billConfigExist", (Locale)ctx.getLocale())).append("\n");
        }
        resultMap.put("hasError", hasError);
        resultMap.put("errorMsg", result.toString());
        this.updateConfigStatus(ctx, validateIdSet, 1);
        this.buildLogInfo(ctx, alterViewConfigCollection, validateIdSet, "alterviewconfig_enable", "batchEnable");
        return resultMap;
    }

    private String buildEnableCheckMsg(Context ctx, AlterViewConfigInfo alterViewConfigInfo) throws EASBizException, BOSException {
        StringBuilder result = new StringBuilder();
        if (alterViewConfigInfo.getStatus() == UseStatusEnum.ACTIVE) {
            result.append(ResourceBase.getString((String)RESOURCE, (String)"badState2Eanble", (Locale)ctx.getLocale(), (Object[])new String[]{alterViewConfigInfo.getNumber()}));
        } else {
            CtrlUnitInfo cu = alterViewConfigInfo.getCU();
            String billBosType = alterViewConfigInfo.getBosType();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("cu", (Object)cu.getId()));
            filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)billBosType));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
            boolean exists = AlterViewConfigFactory.getLocalInstance(ctx).exists(filter);
            if (exists) {
                result.append(ResourceBase.getString((String)RESOURCE, (String)"billConfigExist", (Locale)ctx.getLocale()));
            }
        }
        return result.toString();
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AlterViewConfigInfo info = this.getNewestStatusInfo4Check(ctx, pk.toString());
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    private void checkExist(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (!this.exists(ctx, pk)) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"BILL_NOT_FOUND", (Locale)ctx.getLocale());
            throw new AlterViewConfigException(AlterViewConfigException.EMPTYEXCEPTION, new String[]{msg});
        }
    }

    private void checkBeforeDelete(Context ctx, AlterViewConfigInfo info) throws EASBizException {
        if (info.getStatus() != UseStatusEnum.SAVED) {
            throw new AlterViewConfigException(AlterViewConfigException.STATUSERROR4DELETE);
        }
    }

    private AlterViewConfigInfo getNewestStatusInfo4Check(Context ctx, String id) throws EASBizException, BOSException {
        this.checkExist(ctx, (IObjectPK)new ObjectUuidPK(id));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("status"));
        sics.add(new SelectorItemInfo("isSystem"));
        sics.add(new SelectorItemInfo("number"));
        sics.add(new SelectorItemInfo("bosType"));
        sics.add(new SelectorItemInfo("CU.id"));
        return this.getAlterViewConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(id), sics);
    }

    private void throwNullFieldException(String resourceKey) throws EASBizException {
        String excptionContent = EASResource.getString((String)RESOURCE, (String)resourceKey);
        throw new AlterViewConfigException(AlterViewConfigException.EMPTYEXCEPTION, new String[]{excptionContent});
    }

    private AlterViewConfigCollection getAlterViewConfigCollByIds(Context ctx, List idList) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("status"));
        sics.add(new SelectorItemInfo("isSystem"));
        sics.add(new SelectorItemInfo("number"));
        sics.add(new SelectorItemInfo("bosType"));
        sics.add(new SelectorItemInfo("CU.id"));
        view.setFilter(filter);
        view.setSelector(sics);
        AlterViewConfigCollection alterViewConfigCollection = this.getAlterViewConfigCollection(ctx, view);
        if (alterViewConfigCollection.size() != idSet.size()) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"BILL_NOT_FOUND", (Locale)ctx.getLocale());
            throw new AlterViewConfigException(AlterViewConfigException.EMPTYEXCEPTION, new String[]{msg});
        }
        return alterViewConfigCollection;
    }

    @Override
    protected void _dealSystemConfigData(Context ctx, String cuId) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE T_SCM_ALTERVIEWCONFIG SET FID = FID  WHERE FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4' AND FISSYSTEM = 1 AND FBOSTYPE = '2239F30A'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" SELECT 1 FROM T_SCM_ALTERVIEWCONFIG WHERE FCONTROLUNITID = ? AND FISSYSTEM = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{cuId});
        sql.setLength(0);
        try {
            if (!rs.next()) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("CU", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4"));
                filter.getFilterItems().add(new FilterItemInfo("isSystem", (Object)1));
                view.setFilter(filter);
                AlterViewConfigCollection alterViewConfigCol = this.getAlterViewConfigCollection(ctx, view);
                if (alterViewConfigCol != null && !alterViewConfigCol.isEmpty()) {
                    CoreBaseCollection cols = new CoreBaseCollection();
                    CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                    ctrlUnitInfo.setId(BOSUuid.read((String)cuId));
                    int size = alterViewConfigCol.size();
                    for (int i = 0; i < size; ++i) {
                        alterViewConfigCol.get(i).setId(null);
                        alterViewConfigCol.get(i).setStatus(UseStatusEnum.INACTIVE);
                        alterViewConfigCol.get(i).setCU(ctrlUnitInfo);
                        AlterViewConfigFieldCollection entries = alterViewConfigCol.get(i).getEntry();
                        int len = entries.size();
                        for (int j = 0; j < len; ++j) {
                            entries.get(j).setId(null);
                            entries.get(j).setParent(null);
                        }
                        cols.add((CoreBaseInfo)alterViewConfigCol.get(i));
                    }
                    this.addnewBatchData(ctx, cols);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

