/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.app.InvBalanceReCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BalancePlugInCollection;
import com.kingdee.eas.scm.framework.balance.BalancePlugInFactory;
import java.util.HashMap;
import java.util.Map;

public final class BalanceModelCache {
    private static Map<String, BalanceModelInfo> balanceModelCache = new HashMap<String, BalanceModelInfo>();
    private static Map<String, BalanceDataModelCollection> balanceDataModelCache = new HashMap<String, BalanceDataModelCollection>();
    private static Map<String, BalancePlugInCollection> handlerCache = new HashMap<String, BalancePlugInCollection>();
    private static String isDebug = System.getProperty("balance.isdebug");

    public static BalanceModelInfo getBalanceModelInfo(Context ctx, String balanceModelId) throws EASBizException, BOSException {
        if (balanceModelId == null || ctx == null) {
            return null;
        }
        String balanceDataModelMemoryid = ctx.getAIS().toString() + "^" + balanceModelId.toString();
        if (balanceModelCache.containsKey(balanceDataModelMemoryid) && !"true".equalsIgnoreCase(isDebug)) {
            return balanceModelCache.get(balanceDataModelMemoryid);
        }
        BalanceModelInfo info = BalanceModelFactory.getLocalInstance(ctx).getBalanceModelInfo(BalanceModelCache.toIObjectPK(balanceModelId));
        balanceModelCache.put(balanceDataModelMemoryid, info);
        return info;
    }

    public static BalanceDataModelCollection getBalanceDataModelCollection(Context ctx, EntityViewInfo balanceDataModelView) throws BOSException {
        if (balanceDataModelView == null || ctx == null) {
            return null;
        }
        String balanceDataModelid = ctx.getAIS().toString() + "^" + balanceDataModelView.toString();
        if (balanceDataModelCache.containsKey(balanceDataModelid) && !"true".equalsIgnoreCase(isDebug)) {
            return balanceDataModelCache.get(balanceDataModelid);
        }
        BalanceDataModelCollection col = BalanceDataModelFactory.getLocalInstance(ctx).getBalanceDataModelCollection(balanceDataModelView);
        balanceDataModelCache.put(balanceDataModelid, col);
        return col;
    }

    public static BalancePlugInCollection getBalancePlugInCollection(Context ctx, EntityViewInfo handlerView) throws BOSException {
        if (handlerView == null || ctx == null) {
            return null;
        }
        String handlerId = ctx.getAIS().toString() + "^" + handlerView.toString();
        if (handlerCache.containsKey(handlerId) && !"true".equalsIgnoreCase(isDebug)) {
            return handlerCache.get(handlerId);
        }
        BalancePlugInCollection handlers = BalancePlugInFactory.getLocalInstance(ctx).getBalancePlugInCollection(handlerView);
        handlerCache.put(handlerId, handlers);
        return handlers;
    }

    private static IObjectPK toIObjectPK(String id) {
        if (id.length() == 0) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        return pk;
    }

    public static void clearMemory() {
        balanceModelCache.clear();
        balanceDataModelCache.clear();
        handlerCache.clear();
    }
}

