/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.app.InvBalanceReCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class KsqlUtil {
    private static final Logger logger = Logger.getLogger((String)KsqlUtil.class.getName());

    public static StringBuffer TO_DECIMAL(String string) {
        StringBuffer str = new StringBuffer();
        str.append("TO_DECIMAL(").append(string).append(",21,8)");
        return str;
    }

    public static int getDBType(Context ctx) throws BOSException {
        int dbType = 0;
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)con);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return dbType;
    }

    public static int getDBType(Connection con) throws BOSException {
        int dbType = 0;
        try {
            dbType = KSqlUtil.getDbType((Connection)con);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return dbType;
    }

    public static boolean isOracle(Context ctx) throws BOSException {
        int dbType = KsqlUtil.getDBType(ctx);
        return dbType == 2 || dbType == 7 || dbType == 8;
    }

    public static boolean isDB2(Context ctx) throws BOSException {
        int dbType = KsqlUtil.getDBType(ctx);
        return dbType == 1;
    }

    public static boolean isSQLServer(Context ctx) throws BOSException {
        int dbType = KsqlUtil.getDBType(ctx);
        return dbType == 3;
    }

    public static IRowSet executeQuery(Context ctx, String selectSql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(selectSql);
            if (!ArrayUtil.isEmpty((Object[])params)) {
                int len = params.length;
                for (int i = 0; i < len; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Context ctx, String selectSql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(selectSql);
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return jdbcRowSet;
    }

    public static int executeUpdate(Context ctx, String updateSql, Object[] params) throws BOSException {
        return KsqlUtil.updateWithRowCount(ctx, updateSql, params);
    }

    private static int updateWithRowCount(Context ctx, String updateSql, Object[] params) throws BOSException {
        int i;
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(updateSql);
            if (!ArrayUtil.isEmpty((Object[])params)) {
                int len = params.length;
                for (i = 0; i < len; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            i = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
        return i;
    }

    public static String createTempTable(Context ctx, String createSql) throws BOSException {
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            return pool.createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String createTempTableWithNewTx(Context ctx, String createSql) throws BOSException {
        try {
            Method method = KsqlUtil.class.getDeclaredMethod("createTempTable4NewTx", Context.class, String.class);
            method.setAccessible(true);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)new KsqlUtil());
            Object value = txInvoker.invoke(method, new Object[]{ctx, createSql}, 3);
            return value.toString();
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    String createTempTable4NewTx(Context ctx, String createSql) throws BOSException {
        return KsqlUtil.createTempTable(ctx, createSql);
    }

    public static void releaseTempTable(Context ctx, String tableName) throws BOSException {
        if (tableName == null) {
            return;
        }
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            pool.releaseTable(tableName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static boolean isConjunctionUpdating(String sql) {
        boolean result = false;
        String updSql = sql.toUpperCase();
        int idx = updSql.indexOf("SET");
        if (idx > 0) {
            return updSql.substring(idx + 3).trim().startsWith("(");
        }
        return result;
    }

    public static Collection getRSValue(IRowSet rs, String columnName, boolean distinct) throws BOSException {
        try {
            int columnIndex = rs.findColumn(columnName);
            return KsqlUtil.getRSValue(rs, columnIndex, distinct);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static Collection getRSValue(IRowSet rs, int columnIdx, boolean distinct) throws BOSException {
        try {
            rs.first();
            AbstractCollection collection = null;
            collection = distinct ? new HashSet() : new ArrayList();
            if (rs.isFirst()) {
                do {
                    collection.add(rs.getObject(columnIdx));
                } while (rs.next());
            }
            return collection;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRSColumnNameByIndex(IRowSet rs, int columnIndex) {
        IRowSetMetaData rsmd = null;
        String columnName = "";
        try {
            rsmd = rs.getRowSetMetaData();
            columnName = rsmd.getColumnName(columnIndex);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            rsmd = null;
        }
        return columnName;
    }

    public static String getBindMarks(int count) {
        return StringUtil.makeQuestionMark((int)count);
    }

    public static void executeBatch(Context ctx, String updateSql, Object[][] params) throws BOSException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(updateSql);
            if (params != null) {
                boolean isDoubleParam = KsqlUtil.isDoubleParam(ctx, updateSql);
                int len = params.length;
                for (int i = 0; i < len; ++i) {
                    int j;
                    Object[] arr = params[i];
                    if (null == arr) continue;
                    int arrLen = arr.length;
                    for (j = 0; j < arrLen; ++j) {
                        ps.setObject(j + 1, params[i][j]);
                    }
                    if (isDoubleParam) {
                        for (j = 0; j < arrLen; ++j) {
                            ps.setObject(arrLen + j + 1, params[i][j]);
                        }
                    }
                    ps.addBatch();
                }
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
    }

    public static void executeBatch(Context ctx, String[] updateSql) throws BOSException {
        if (ArrayUtil.isEmpty((Object[])updateSql)) {
            return;
        }
        Connection con = null;
        Statement ps = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.createStatement();
            int len = updateSql.length;
            for (int i = 0; i < len; ++i) {
                ps.addBatch(updateSql[i]);
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
    }

    public static boolean isUniqueViolated(Context ctx, SQLException e) throws BOSException {
        boolean result = false;
        result = KsqlUtil.isDB2(ctx) && "23505".equals(e.getSQLState()) || KsqlUtil.isOracle(ctx) && "23000".equals(e.getSQLState()) && e.getErrorCode() == 1 || KsqlUtil.isSQLServer(ctx) && "14".equals(e.getSQLState()) && e.getErrorCode() == 1505;
        return result;
    }

    public static boolean isDoubleParam(Context ctx, String updateSql) throws BOSException {
        return !KsqlUtil.isSQLServer(ctx) && KsqlUtil.isConjunctionUpdating(updateSql);
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlstr, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public static void execute(Context ctx, String[] sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            KsqlUtil.execute(statement, sql);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlstr, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public static void execute(Connection conn, String[] sql) throws BOSException, SQLException {
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer(64);
        try {
            statement = conn.createStatement();
            KsqlUtil.execute(statement, sql);
        }
        catch (SQLException e) {
            throw new SQLException(ResourceUtil.getMessage((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"279_SQLEr", (String[])new String[]{e.toString(), sqlstr.toString()}));
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
        }
    }

    private static void execute(Statement statement, String[] sql) throws SQLException {
        StringBuffer sqlstr = new StringBuffer(64);
        if (!ArrayUtil.isEmpty((Object[])sql)) {
            int n = sql.length;
            for (int i = 0; i < n; ++i) {
                statement.addBatch(sql[i]);
                sqlstr.append(sql[i]).append("\t\n");
            }
        }
        statement.executeBatch();
        statement.clearBatch();
    }

    public static void execute(Connection conn, String sql) throws BOSException, SQLException {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new SQLException(e + "SQL:");
        }
        finally {
            if (statement != null) {
                statement.clearBatch();
                statement.close();
            }
        }
    }

    public static void createTempTableIndex(Context ctx, String tableName, String columns, boolean isUnique) throws BOSException {
        KsqlUtil.createTempTableIndex(ctx, tableName, columns, isUnique, false);
    }

    public static void createTempTableIndex(Context ctx, String tableName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        try {
            TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
            tmpPool.createIndex(tableName, columns, isUnique, isClustered);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void analyseTable(Context ctx, Connection con, String table) throws SQLException {
        TempTablePool.getInstance((Context)ctx).analyzeTable(con, table);
    }

    public static final void cleanup(Connection cn) {
        KsqlUtil.cleanup(null, null, cn);
    }

    public static final void cleanup(Statement stmt) {
        KsqlUtil.cleanup(null, stmt, null);
    }

    public static final void cleanup(Statement stmt, Connection cn) {
        KsqlUtil.cleanup(null, stmt, cn);
    }

    public static final void cleanup(ResultSet rs) {
        KsqlUtil.cleanup(rs, null, null);
    }

    public static final void cleanup(ResultSet rs, Statement stmt) {
        KsqlUtil.cleanup(rs, stmt, null);
    }

    public static void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                logger.error((Object)"cleanup error", (Throwable)e);
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                logger.error((Object)"cleanup error", (Throwable)e);
            }
            stmt = null;
        }
        if (cn != null) {
            try {
                cn.close();
            }
            catch (Exception e) {
                logger.error((Object)"cleanup error", (Throwable)e);
            }
            cn = null;
        }
    }

    public static final void insertTempTable(Context ctx, String tempTableName, String fieldName, Set<String> ids) throws BOSException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        Object[][] idArr = new String[ids.size()][1];
        StringBuffer insertBaseSql = new StringBuffer();
        insertBaseSql.append("insert into ").append(tempTableName).append("(").append(fieldName).append(") ").append("values(?)");
        KsqlUtil.executeBatch(ctx, insertBaseSql.toString(), idArr);
    }

    public static Object takeValue(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Object object = KsqlUtil.takeValue(conn, sql);
            return object;
        }
        catch (SQLException ex) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    public static Object takeValue(Connection conn, String sql) throws BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        block4: {
            Object object;
            stmt = null;
            rs = null;
            try {
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs == null || !rs.next()) break block4;
                object = rs.getObject(1);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return object;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return null;
    }
}

