/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.app.InvBalanceReCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.framework.app.InvBalanceReCal.AbstractBalanceReCalCalculator;
import com.kingdee.eas.scm.framework.app.InvBalanceReCal.KsqlUtil;
import com.kingdee.eas.scm.framework.app.InvBalanceReCal.PeriodBalanceReCalSQLBuilder;
import com.kingdee.eas.scm.framework.app.thread.QueryDataSyncLock;
import com.kingdee.eas.scm.framework.app.thread.QueryDataTask;
import com.kingdee.eas.scm.framework.app.thread.ThreadPool;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.PlugInApplyRangeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.InvokeTime;
import com.kingdee.eas.scm.framework.balance.app.log.PeriodBalanceLogger;
import com.kingdee.eas.scm.framework.balance.app.plugin.HandlerParameter;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class PeriodBalanceReCalCalculator
extends AbstractBalanceReCalCalculator {
    private String orgUnitID;
    private PeriodInfo prePeriod;
    protected PeriodInfo curPeriod;
    private PeriodInfo nextPeriod;
    private boolean isReCalculate;
    private boolean hasInit;
    private String Field_issuebill = "FIsIsseBill";
    private String Field_costadjust = "FCostadjustbill";
    private HashMap params;

    public PeriodBalanceReCalCalculator(Context ctx, BalanceModelInfo balanceModelInfo) throws BOSException, EASBizException {
        super(ctx, balanceModelInfo);
    }

    public PeriodBalanceReCalCalculator(Context ctx, BalanceModelInfo balanceModelInfo, HashMap params) throws EASBizException, BOSException {
        super(ctx, balanceModelInfo);
        this.params = params;
    }

    @Override
    protected void init() throws BOSException, EASBizException {
        PeriodBalanceLogger tmpLogger = (PeriodBalanceLogger)this.logger;
        tmpLogger.setOrgUnitID(this.orgUnitID);
        tmpLogger.setPeriodInfo(this.curPeriod);
        this.hasInit = this.hasInitWarehouse();
        super.init();
        this.prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)this.curPeriod);
        this.nextPeriod = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)this.curPeriod);
    }

    @Override
    protected void beforeCalculate() throws BalanceModelException, BOSException {
        if (OperationTypeEnum.Positive.equals((Object)this.OPType)) {
            this.bakBalance();
        }
    }

    private String getReCalFilterSql() {
        HashSet storageIDSet = (HashSet)this.params.get("storageIDSet");
        HashSet materialIDSet = (HashSet)this.params.get("materialIDSet");
        HashSet warehouseIDSet = (HashSet)this.params.get("warehouseIDSet");
        StringBuffer filterSql = new StringBuffer();
        if (storageIDSet != null && storageIDSet.size() > 0) {
            String storageIDstr = ArrayUtil.getKeyIdStr((Object[])storageIDSet.toArray());
            filterSql.append(" AND FSTORAGEORGUNITID IN (");
            filterSql.append(storageIDstr).append(")");
        }
        if (warehouseIDSet != null && warehouseIDSet.size() > 0) {
            String warehouseIDStr = ArrayUtil.getKeyIdStr((Object[])warehouseIDSet.toArray());
            filterSql.append(" AND FWAREHOUSEID IN (");
            filterSql.append(warehouseIDStr).append(")");
        }
        if (materialIDSet != null && materialIDSet.size() > 0) {
            String materialsIDStr = ArrayUtil.getKeyIdStr((Object[])materialIDSet.toArray());
            filterSql.append(" AND FMATERIALID IN (");
            filterSql.append(materialsIDStr).append(")");
        }
        if (filterSql.length() > 0) {
            return filterSql.toString();
        }
        return "";
    }

    private void bakBalance() throws BOSException {
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeStr = formater.format(new Date());
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("Insert Into ").append("T_IM_INVENTORYBALANCE_BAK").append("(");
        insertSQL.append(BalanceEnginUtil.getBalanceModelFieldStr(this.balanceModelInfo, null));
        insertSQL.append(",FBAKTIME");
        insertSQL.append(")");
        insertSQL.append("SELECT ");
        insertSQL.append(BalanceEnginUtil.getBalanceModelFieldStr(this.balanceModelInfo, null)).append("\r\n");
        insertSQL.append(",{ts'").append(timeStr).append("'} ");
        insertSQL.append("FROM ").append(this.balanceModelInfo.getTabName()).append("\r\n");
        insertSQL.append(this.getBalanceTableFilter(this.curPeriod));
        insertSQL.append(this.getReCalFilterSql());
        KsqlUtil.execute(this.ctx, insertSQL.toString());
    }

    @Override
    protected FilterInfo getBalanceDataModelFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)this.balanceModelInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)UseStatusEnum.ACTIVE));
        if (!this.hasInit) {
            filter.getFilterItems().add(new FilterItemInfo("isInitialize", (Object)Boolean.FALSE));
        }
        return filter;
    }

    private Boolean hasInitWarehouse() throws BOSException {
        boolean hasInit = false;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT 1 FROM T_DB_SOAccreditWH where FISSTARTED =1 and FCOMPANYID = '");
        sql.append(this.orgUnitID).append("' and FPERIODID = '");
        sql.append(this.curPeriod.getId().toString()).append("' ");
        HashSet storageIDSet = (HashSet)this.params.get("storageIDSet");
        HashSet warehouseIDSet = (HashSet)this.params.get("warehouseIDSet");
        StringBuffer filterSql = new StringBuffer();
        if (storageIDSet != null && storageIDSet.size() > 0) {
            String storageIDstr = ArrayUtil.getKeyIdStr((Object[])storageIDSet.toArray());
            filterSql.append(" AND FSTORAGEORGID IN (");
            filterSql.append(storageIDstr).append(")");
        }
        if (warehouseIDSet != null && warehouseIDSet.size() > 0) {
            String warehouseIDStr = ArrayUtil.getKeyIdStr((Object[])warehouseIDSet.toArray());
            filterSql.append(" AND FWAREHOUSEID IN (");
            filterSql.append(warehouseIDStr).append(")");
        }
        sql.append(filterSql);
        IRowSet rs = KsqlUtil.executeQuery(this.ctx, sql.toString());
        try {
            if (rs.next()) {
                hasInit = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hasInit;
    }

    @Override
    protected FilterInfo getPlugInFilter() {
        FilterInfo filter = super.getPlugInFilter();
        filter.getFilterItems().add(new FilterItemInfo("applyRange", (Object)PlugInApplyRangeEnum.OnlyForInit, CompareType.NOTEQUALS));
        return filter;
    }

    @Override
    public void calculate(String orgUnitID, PeriodInfo period, OperationTypeEnum OPType, boolean isReCalculate) throws BOSException, EASBizException {
        this.orgUnitID = orgUnitID;
        this.curPeriod = period;
        this.isReCalculate = isReCalculate;
        this.logger.beginLog();
        super.calculate(orgUnitID, period, OPType, isReCalculate);
        this.logger.endLog();
    }

    @Override
    protected void calculateStep() throws BOSException, EASBizException {
        if (OperationTypeEnum.Positive.equals((Object)this.OPType)) {
            this.reCalculateBalance();
        } else {
            this.reverseCalculateBalance();
        }
    }

    private void reCalculateBalance() throws BOSException, EASBizException {
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)new ObjectUuidPK(this.orgUnitID));
        if (this.prePeriod != null) {
            this.insertNextPeriodBeginData(this.prePeriod, this.curPeriod);
        }
        this.deleteZeroBeginData(this.curPeriod);
        if (currentPeriod.getNumber() != this.curPeriod.getNumber() || this.hasInit) {
            this.takeBillData(currentPeriod.getNumber() == this.curPeriod.getNumber() && this.hasInit);
        }
        if (currentPeriod.getNumber() != this.curPeriod.getNumber()) {
            this.invokePlugInHandler(InvokeTime.AfterDetailData, this.params);
        }
        this.groupDetailDataToFinalTable();
        if (currentPeriod.getNumber() != this.curPeriod.getNumber()) {
            this.updateCalculateField();
        }
        this.deletePeriodBalance(this.curPeriod);
        this.insertReadyDataToBalanceTable();
    }

    private void reverseCalculateBalance() throws BOSException, EASBizException {
        this.deletePeriodBalance(this.curPeriod);
        String whereSQL = this.getBalanceTableFilter(this.prePeriod);
        this.calculateYearTotalField(this.balanceModelInfo.getTabName(), whereSQL);
        this.deleteZeroBeginData(this.prePeriod);
        this.updateNotBeginData2Zero(this.prePeriod);
    }

    protected void takeBillData(boolean onlyInit) throws BOSException, BalanceModelException {
        ISQLBuilder sqlBuilder = null;
        List<ISQLBuilder> sqlBuilderList = this.getSQLBuilder(onlyInit);
        Connection conn = null;
        QueryDataSyncLock lock = new QueryDataSyncLock();
        ThreadPool threadPool = ThreadPool.getInstance();
        int size = sqlBuilderList.size();
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            String insertSQL = this.getInsertSQL(this.detailTempTable);
            StringBuffer sSQL = new StringBuffer();
            ArrayList<String> sqls = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                sqlBuilder = sqlBuilderList.get(i);
                String selectSQL = sqlBuilder.getSQL();
                if (StringUtil.isEmpty((String)selectSQL)) continue;
                sSQL.setLength(0);
                sSQL.append(insertSQL).append("\r\n").append(selectSQL);
                this.logger.debugSQL("\u53d6\u6570SQL\uff1a", sSQL.toString());
                if (this.isUseThreadPool4TakeBill().booleanValue()) {
                    QueryDataTask thread = new QueryDataTask(lock, sqlBuilder.getExecuteLockName(), conn, sSQL.toString());
                    lock.addLock(sqlBuilder.getExecuteLockName());
                    threadPool.addTask(thread);
                    continue;
                }
                sqls.add(sSQL.toString());
            }
            if (sqls.size() > 0) {
                KsqlUtil.executeBatch(this.ctx, sqls.toArray(new String[sqls.size()]));
            } else {
                lock.waitFinish();
            }
        }
        catch (BOSException e) {
            this.logger.error("\u591a\u7ebf\u7a0b\u53d6\u6570\u51fa\u9519\uff1a" + (Object)((Object)e));
            throw e;
        }
        catch (SQLException e) {
            this.logger.error("\u591a\u7ebf\u7a0b\u53d6\u6570\u51fa\u9519\uff1a" + e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected ISQLBuilder createSQLBuilder(BalanceDataModelInfo dataModelInfo) {
        return new PeriodBalanceReCalSQLBuilder(this.balanceModelInfo, dataModelInfo, this.orgUnitID, this.curPeriod, this.params);
    }

    @Override
    protected HandlerParameter getHandlerParameter() {
        HandlerParameter params = super.getHandlerParameter();
        params.setOrgUnitID(this.orgUnitID);
        params.setCurPeriod(this.curPeriod);
        params.setNextPeriod(this.nextPeriod);
        return params;
    }

    protected void deleteZeroBeginData(PeriodInfo period) throws BOSException {
        StringBuffer delSql = new StringBuffer();
        delSql.append("DELETE FROM ").append(this.detailTempTable).append("\r\n");
        delSql.append(this.getBalanceTableFilter(period)).append("\r\n");
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.BeginData.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType())) continue;
            delSql.append(" AND ").append(fieldInfo.getFieldName()).append(" = 0").append("\r\n");
        }
        this.logger.debugSQL("\u5220\u9664\u4f59\u989d\u8868\u4e2d\u671f\u521d\u4e3a0\u7684\u8bb0\u5f55SQL\uff1a", delSql.toString());
        KsqlUtil.execute(this.ctx, delSql.toString());
    }

    protected void takeBeginData() throws BalanceModelException, BOSException {
        StringBuffer selectSQL = new StringBuffer();
        String insertSQL = this.getInsertSQL(this.detailTempTable);
        selectSQL.append(insertSQL).append("\r\n");
        selectSQL.append(this.getBeginDataSQL(this.curPeriod));
        this.logger.debugSQL("\u83b7\u53d6\u671f\u521d\u6570\u636eSQL\uff1a", selectSQL.toString());
        KsqlUtil.execute(this.ctx, selectSQL.toString());
    }

    protected String getBeginDataSQL(PeriodInfo curPeriod) {
        StringBuffer selectSQL = new StringBuffer("SELECT ");
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (i > 0) {
                selectSQL.append(",");
            }
            if (BizDataTypeEnum.InData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.OutData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.EndData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (curPeriod.getPeriodNumber() == 1 && BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            selectSQL.append(fieldInfo.getFieldName());
        }
        selectSQL.append("\r\n");
        selectSQL.append("FROM ").append(this.balanceModelInfo.getTabName()).append("\r\n");
        selectSQL.append(this.getBalanceTableFilter(curPeriod));
        return selectSQL.toString();
    }

    protected String getNewPeriodBeginDataSQL(PeriodInfo prePeriod, PeriodInfo curPeriod) throws BalanceModelException {
        StringBuffer selectSQL = new StringBuffer("SELECT ");
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (i > 0) {
                selectSQL.append(",");
            }
            if (BizDataTypeEnum.PrimaryKey.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("newbosid('").append(this.balBosType).append("') AS FID");
                continue;
            }
            if (BizDataTypeEnum.Year.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append(curPeriod.getPeriodYear()).append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (BizDataTypeEnum.Month.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append(curPeriod.getPeriodNumber()).append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (BizDataTypeEnum.Period.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("'").append(curPeriod.getId().toString()).append("'").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (BizDataTypeEnum.BeginData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append(this.parser.getSQLExpression(fieldInfo));
                continue;
            }
            if (BizDataTypeEnum.InData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.OutData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.EndData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (curPeriod.getPeriodNumber() == 1 && BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (this.Field_issuebill.equals(fieldInfo.getFieldName())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (this.Field_costadjust.equals(fieldInfo.getFieldName())) {
                selectSQL.append(" '' ").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            selectSQL.append(fieldInfo.getFieldName());
        }
        selectSQL.append("\r\n");
        selectSQL.append("FROM ").append(this.balanceModelInfo.getTabName()).append("\r\n");
        selectSQL.append(this.getBalanceTableFilter(prePeriod));
        selectSQL.append(this.getReCalFilterSql());
        return selectSQL.toString();
    }

    protected String getBalanceTableFilter(PeriodInfo period) {
        StringBuffer whereSQL = new StringBuffer();
        whereSQL.append("WHERE ").append(this.balanceModelInfo.getMainOrgUnitField().getFieldName()).append("='").append(this.orgUnitID).append("'");
        whereSQL.append("\r\n").append("AND ");
        if (this.balanceModelInfo.getPeriodField() == null) {
            whereSQL.append(this.balanceModelInfo.getPeriodYearField().getFieldName()).append("=").append(period.getPeriodYear());
            whereSQL.append(" AND ");
            whereSQL.append(this.balanceModelInfo.getPeriodMonthField().getFieldName()).append("=").append(period.getPeriodNumber());
        } else {
            whereSQL.append(this.balanceModelInfo.getPeriodField().getFieldName()).append("='").append(period.getId().toString()).append("'");
        }
        return whereSQL.toString();
    }

    protected void deletePeriodBalance(PeriodInfo period) throws BOSException {
        StringBuffer deleteSQL = new StringBuffer();
        deleteSQL.append("Delete from ").append(this.balanceModelInfo.getTabName()).append("\r\n");
        deleteSQL.append(this.getBalanceTableFilter(period));
        deleteSQL.append(this.getReCalFilterSql());
        this.logger.debugSQL("\u5220\u9664period\u671f\u95f4\u4f59\u989d\u6570\u636eSQL\uff1a", deleteSQL.toString());
        KsqlUtil.execute(this.ctx, deleteSQL.toString());
    }

    protected void updateNotBeginData2Zero(PeriodInfo period) throws BOSException {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append("Update ").append(this.balanceModelInfo.getTabName()).append(" set ").append("\r\n");
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        boolean isFirst = true;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (fieldInfo.getFieldName().equalsIgnoreCase("FPeriodAdjustDiff") || !BizDataTypeEnum.InData.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.OutData.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.EndData.equals((Object)fieldInfo.getBizDataType())) continue;
            if (!isFirst) {
                updateSQL.append(",");
            }
            updateSQL.append(fieldInfo.getFieldName()).append(" = 0");
            isFirst = false;
        }
        updateSQL.append("\r\n").append(this.getBalanceTableFilter(period));
        this.logger.debugSQL("\u66f4\u65b0period\u671f\u95f4\u975e\u671f\u521d\u6570\u636e\u4e3a\u96f6SQL\uff1a", updateSQL.toString());
        KsqlUtil.execute(this.ctx, updateSQL.toString());
    }

    protected void updateCalculateField() throws BOSException, BalanceModelException {
        this.calculateFormulaField();
        this.calculateYearTotalField(this.finalTempTable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateFormulaField() throws BalanceModelException, BOSException {
        List<BalanceFieldModelInfo> fieldList = this.getCalculateFieldList();
        String sSQL = "";
        try {
            while (fieldList.size() > 0) {
                sSQL = this.getUpdateCalculateFieldSQL(fieldList);
                this.logger.debugSQL("\u66f4\u65b0\u4f59\u989d\u6a21\u578b\u52a8\u6001\u8ba1\u7b97\u5b57\u6bb5SQL\uff1a", sSQL);
                KsqlUtil.execute(this.ctx, sSQL);
                fieldList = this.getCalculateFieldList();
            }
        }
        finally {
            BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
            for (int i = 0; i < coll.size(); ++i) {
                coll.get(i).setBoolean("IsCalculated", false);
            }
        }
    }

    protected void calculateYearTotalField(String tabName, String whereSQL) throws BalanceModelException, BOSException {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append("Update ").append(tabName).append(" Set ").append("\r\n");
        boolean isFirst = true;
        String sign = OperationTypeEnum.Positive.equals((Object)this.OPType) ? "+" : "-";
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType()) || StringUtil.isEmpty((String)fieldInfo.getCalExpression())) continue;
            if (!isFirst) {
                updateSQL.append(",").append("\r\n");
            }
            updateSQL.append(fieldInfo.getFieldName()).append(" = ").append(fieldInfo.getFieldName());
            updateSQL.append(sign);
            updateSQL.append(this.parser.getSQLExpression(fieldInfo));
            isFirst = false;
        }
        if (!StringUtil.isEmpty((String)whereSQL)) {
            updateSQL.append("\r\n").append(whereSQL);
        }
        this.logger.debugSQL("\u8ba1\u7b97\u672c\u5e74\u7d2f\u8ba1\u5b57\u6bb5SQL\uff1a", updateSQL.toString());
        KsqlUtil.execute(this.ctx, updateSQL.toString());
    }

    private List<BalanceFieldModelInfo> getCalculateFieldList() throws BalanceModelException {
        ArrayList<BalanceFieldModelInfo> fieldList = new ArrayList<BalanceFieldModelInfo>();
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (BizDataTypeEnum.BeginData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType()) || !this.parser.isCanCalculate(fieldInfo)) continue;
            fieldList.add(fieldInfo);
        }
        return fieldList;
    }

    protected String getUpdateCalculateFieldSQL(List<BalanceFieldModelInfo> fieldList) throws BalanceModelException {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append("Update ").append(this.finalTempTable).append(" Set ").append("\r\n");
        boolean isFirst = true;
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < fieldList.size(); ++i) {
            fieldInfo = fieldList.get(i);
            if (StringUtil.isEmpty((String)fieldInfo.getCalExpression())) continue;
            if (!isFirst) {
                updateSQL.append(",").append("\r\n");
            }
            updateSQL.append(fieldInfo.getFieldName()).append("=").append(this.parser.getSQLExpression(fieldInfo));
            fieldInfo.setBoolean("IsCalculated", true);
            isFirst = false;
        }
        return updateSQL.toString();
    }

    protected void insertReadyDataToBalanceTable() throws BOSException {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(this.getInsertSQL(this.balanceModelInfo.getTabName())).append("\r\n");
        insertSQL.append("SELECT ");
        insertSQL.append(BalanceEnginUtil.getBalanceModelFieldStr(this.balanceModelInfo, null)).append("\r\n");
        insertSQL.append("FROM ").append(this.finalTempTable).append("\r\n");
        this.logger.debugSQL("\u63d2\u5165\u672c\u671f\u6700\u7ec8\u6570\u636e\u5230\u4f59\u989d\u8868SQL: ", insertSQL.toString());
        KsqlUtil.execute(this.ctx, insertSQL.toString());
    }

    protected void insertNextPeriodBeginData(PeriodInfo prePeriod, PeriodInfo curPeriod) throws BOSException, BalanceModelException {
        StringBuffer selectSQL = new StringBuffer();
        String insertSQL = this.getInsertSQL(this.detailTempTable);
        selectSQL.append(insertSQL).append("\r\n");
        selectSQL.append(this.getNewPeriodBeginDataSQL(prePeriod, curPeriod));
        KsqlUtil.execute(this.ctx, selectSQL.toString());
    }

    @Override
    public void releaseTempTable() throws BOSException {
        super.releaseTempTable();
    }

    public String getOrgUnitID() {
        return this.orgUnitID;
    }

    public void setOrgUnitID(String orgUnitID) {
        this.orgUnitID = orgUnitID;
    }

    public PeriodInfo getPrePeriod() {
        return this.prePeriod;
    }

    public void setPrePeriod(PeriodInfo prePeriod) {
        this.prePeriod = prePeriod;
    }

    public PeriodInfo getCurPeriod() {
        return this.curPeriod;
    }

    public void setCurPeriod(PeriodInfo curPeriod) {
        this.curPeriod = curPeriod;
    }

    public PeriodInfo getNextPeriod() {
        return this.nextPeriod;
    }

    public void setNextPeriod(PeriodInfo nextPeriod) {
        this.nextPeriod = nextPeriod;
    }

    public boolean isReCalculate() {
        return this.isReCalculate;
    }

    public void setReCalculate(boolean isReCalculate) {
        this.isReCalculate = isReCalculate;
    }
}

