/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.app.InvBalanceReCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DateFilterTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceDataModelSQLBuilder;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

public class PeriodBalanceReCalSQLBuilder
extends BalanceDataModelSQLBuilder {
    private String orgUnitID;
    private PeriodInfo period;
    private HashMap params;

    public PeriodBalanceReCalSQLBuilder(BalanceModelInfo balanceModelInfo, BalanceDataModelInfo dataModelInfo) {
        super(balanceModelInfo, dataModelInfo);
    }

    public PeriodBalanceReCalSQLBuilder(BalanceModelInfo balanceModelInfo, BalanceDataModelInfo dataModelInfo, String orgUnitID, PeriodInfo period) {
        super(balanceModelInfo, dataModelInfo);
        this.orgUnitID = orgUnitID;
        this.period = period;
    }

    public PeriodBalanceReCalSQLBuilder(BalanceModelInfo balanceModelInfo, BalanceDataModelInfo dataModelInfo, String orgUnitID2, PeriodInfo curPeriod, HashMap params) {
        this(balanceModelInfo, dataModelInfo, orgUnitID2, curPeriod);
        this.params = params;
    }

    @Override
    protected String getFieldSQL(BalanceFieldModelInfo fieldModel) {
        String result = "";
        if (this.period == null) {
            return super.getFieldSQL(fieldModel);
        }
        result = BizDataTypeEnum.Year.equals((Object)fieldModel.getBizDataType()) ? this.period.getPeriodYear() + " AS " + fieldModel.getFieldName() : (BizDataTypeEnum.Month.equals((Object)fieldModel.getBizDataType()) ? this.period.getPeriodNumber() + " AS " + fieldModel.getFieldName() : (BizDataTypeEnum.Period.equals((Object)fieldModel.getBizDataType()) ? "'" + this.period.getId().toString() + "'" + " AS " + fieldModel.getFieldName() : super.getFieldSQL(fieldModel)));
        return result;
    }

    @Override
    protected FilterInfo getExtendFilter() throws BalanceModelException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.mergeFilter(this.getOrgUnitFilterInfo(), "AND");
        filter.mergeFilter(this.getDateFilterInfo(), "AND");
        filter.mergeFilter(this.getReCalFilterInfo(), "AND");
        return filter;
    }

    @Override
    protected String getFromSQL() {
        String fromSQL = super.getFromSQL();
        if (this.dataModelInfo.isIsInitialize()) {
            fromSQL = fromSQL + " INNER JOIN  T_DB_SOACCREDITWH SOAWH ON INVENTORYINITENTRY.FSTORAGEORGUNITID = SOAWH.FSTORAGEORGID AND INVENTORYINITENTRY.FWAREHOUSEID = SOAWH.FWAREHOUSEID AND InventoryInitEntry.FCompanyOrgUnitID =  SOAWH.FCOMPANYID \n";
        }
        return fromSQL;
    }

    private FilterInfo getReCalFilterInfo() {
        FilterInfo filter = new FilterInfo();
        HashSet storageIDSet = (HashSet)this.params.get("storageIDSet");
        HashSet materialIDSet = (HashSet)this.params.get("materialIDSet");
        HashSet warehouseIDSet = (HashSet)this.params.get("warehouseIDSet");
        StringBuffer filterSql = new StringBuffer();
        String storageIDStr = this.dataModelInfo.getFieldDataModelByFieldID("0SOg92CMRii3km9JKb07IlpFjOY=").getValueExpression();
        String warehouseIDStr = this.dataModelInfo.getFieldDataModelByFieldID("j3BKRXTHTVGRqSpn5kpDQFpFjOY=").getValueExpression();
        String materialIDStr = this.dataModelInfo.getFieldDataModelByFieldID("vxiVd2MMR5azXvZtF/9vaVpFjOY=").getValueExpression();
        if (storageIDSet != null && storageIDSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(storageIDStr, (Object)storageIDSet, CompareType.INCLUDE));
        }
        if (warehouseIDSet != null && warehouseIDSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(warehouseIDStr, (Object)warehouseIDSet, CompareType.INCLUDE));
        }
        if (materialIDSet != null && materialIDSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(materialIDStr, (Object)materialIDSet, CompareType.INCLUDE));
        }
        return filter;
    }

    protected FilterInfo getOrgUnitFilterInfo() {
        if (StringUtil.isEmpty((String)this.orgUnitID)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getOrgField(), (Object)this.orgUnitID));
        if ("YFFVbonARBO4SBicXj6CbOLrECg=".equals(this.dataModelInfo.getId().toString().toString()) || "oUVkd5hjQkyQBxjnnACOmOLrECg=".equals(this.dataModelInfo.getId().toString().toString()) || "oo/wOKSuQnGz+gE2mmUby+LrECg=".equals(this.dataModelInfo.getId().toString().toString()) || "DBE12qfsQi6f4MVvmfHwweLrECg=".equals(this.dataModelInfo.getId().toString().toString()) || "MyXpmjjrTWys1hk83sAQkOLrECg=".equals(this.dataModelInfo.getId().toString().toString()) || "rG/6bqE0Q3GLS8djPcAN5eLrECg=".equals(this.dataModelInfo.getId().toString().toString())) {
            filter.getFilterItems().add(new FilterItemInfo("OrgUnitRelation.FTOUNITID", (Object)this.orgUnitID));
        }
        return filter;
    }

    protected FilterInfo getDateFilterInfo() {
        if (this.period == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        if (this.dataModelInfo.isIsInitialize()) {
            filter.getFilterItems().add(new FilterItemInfo("SOAWH.FPERIODID", (Object)this.period.getId().toString()));
            return filter;
        }
        if (DateFilterTypeEnum.BizDate.equals((Object)this.dataModelInfo.getDateFilterType())) {
            Date beginDate = this.period.getBeginDate();
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(this.period.getEndDate());
            endDate.add(6, 1);
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getBizDateField(), (Object)beginDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getBizDateField(), (Object)endDate.getTime(), CompareType.LESS));
        } else if (DateFilterTypeEnum.YearAndMonth.equals((Object)this.dataModelInfo.getDateFilterType())) {
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getPeriodYear(), (Object)this.period.getPeriodYear()));
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getPeriodMonth(), (Object)this.period.getPeriodNumber()));
        } else if (DateFilterTypeEnum.PeriodID.equals((Object)this.dataModelInfo.getDateFilterType())) {
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getPeriodIdField(), (Object)this.period.getId().toString()));
        }
        return filter;
    }

    public String getOrgUnitID() {
        return this.orgUnitID;
    }

    public void setOrgUnitID(String orgUnitID) {
        this.orgUnitID = orgUnitID;
    }

    public PeriodInfo getPeriod() {
        return this.period;
    }

    public void setPeriod(PeriodInfo period) {
        this.period = period;
    }
}

