/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceTypeEnum;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DateFilterTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.AbstractBalanceDataModelControllerBean;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceModelCache;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceSQLBuilderFactory;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class BalanceDataModelControllerBean
extends AbstractBalanceDataModelControllerBean {
    private static final long serialVersionUID = 1L;

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BalanceDataModelInfo info;
        if (model == null) {
            model = this.getValue(ctx, pk);
        }
        if ((info = (BalanceDataModelInfo)model).getState().getValue() != 1) {
            throw new BalanceModelException(BalanceModelException.CANNOTINACTIVE);
        }
        info.setState(UseStatusEnum.INACTIVE);
        super._cancel(ctx, pk, model);
        BalanceModelCache.clearMemory();
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        selector.add(new SelectorItemInfo("balanceModel.balanceType"));
        selector.add(new SelectorItemInfo("balanceModel.entry.*"));
        model = this.getValue(ctx, pk, selector);
        BalanceDataModelInfo info = (BalanceDataModelInfo)model;
        if (info.getState().getValue() == 1) {
            throw new BalanceModelException(BalanceModelException.CANNOTACTIVE);
        }
        this.beforeActiveCheck(info);
        this.checkSQLValid(ctx, pk);
        info.setState(UseStatusEnum.ACTIVE);
        super._cancelCancel(ctx, pk, model);
        BalanceModelCache.clearMemory();
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BalanceDataModelInfo dataBaseInfo = (BalanceDataModelInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)dataBaseInfo.getBalanceModel().getId().toString(), CompareType.EQUALS));
        if (dataBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        }
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dataQuery", (Object)dataBaseInfo.getDataQuery().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)dataBaseInfo.getBalanceModel().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("updateType", (Object)dataBaseInfo.getUpdateType().getValue(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dataFilter", (Object)dataBaseInfo.getDataFilter(), CompareType.EQUALS));
        if (dataBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (super._exists(ctx, filter)) {
            throw new BalanceModelException(BalanceModelException.BALDATAMODELDUP);
        }
    }

    private void beforeActiveCheck(BalanceDataModelInfo info) throws BalanceModelException {
        BalanceModelInfo balanceModel = info.getBalanceModel();
        if (BalanceTypeEnum.RealTime.equals((Object)balanceModel.getBalanceType())) {
            if (info.getBillIdField() == null) {
                throw new BalanceModelException(BalanceModelException.DATAMODELACTIVEFAIL, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"0_BalanceDataModelControllerBean", (Locale)ContextUtils.getLocaleFromEnv())});
            }
        } else {
            if (info.getOrgField() == null) {
                throw new BalanceModelException(BalanceModelException.DATAMODELACTIVEFAIL, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"1_BalanceDataModelControllerBean", (Locale)ContextUtils.getLocaleFromEnv())});
            }
            DateFilterTypeEnum type = info.getDateFilterType();
            if (DateFilterTypeEnum.YearAndMonth.equals((Object)type)) {
                if (info.getPeriodYear() == null) {
                    throw new BalanceModelException(BalanceModelException.DATAMODELACTIVEFAIL, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"2_BalanceDataModelControllerBean", (Locale)ContextUtils.getLocaleFromEnv())});
                }
                if (info.getPeriodMonth() == null) {
                    throw new BalanceModelException(BalanceModelException.DATAMODELACTIVEFAIL, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"3_BalanceDataModelControllerBean", (Locale)ContextUtils.getLocaleFromEnv())});
                }
            } else if (DateFilterTypeEnum.BizDate.equals((Object)type)) {
                if (info.getBizDateField() == null) {
                    throw new BalanceModelException(BalanceModelException.DATAMODELACTIVEFAIL, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"4_BalanceDataModelControllerBean", (Locale)ContextUtils.getLocaleFromEnv())});
                }
            } else if (DateFilterTypeEnum.PeriodID.equals((Object)type) && info.getPeriodIdField() == null) {
                throw new BalanceModelException(BalanceModelException.DATAMODELACTIVEFAIL, new String[]{ResourceBase.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"5_BalanceDataModelControllerBean", (Locale)ContextUtils.getLocaleFromEnv())});
            }
        }
        BalanceFieldModelInfo field = null;
        BalanceFieldDataModelInfo dataField = null;
        BalanceFieldModelCollection fieldColl = balanceModel.getEntry();
        for (int i = 0; i < fieldColl.size(); ++i) {
            field = fieldColl.get(i);
            dataField = info.getFieldDataModelByFieldID(field.getId().toString());
            if (!this.isNotAllowNull(field, info.isIsInitialize()) || dataField != null) continue;
            throw new BalanceModelException(BalanceModelException.DATAMODELACTIVEFAIL, new String[]{field.getAlias() + ResourceBase.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"6_BalanceDataModelControllerBean", (Locale)ContextUtils.getLocaleFromEnv())});
        }
    }

    private boolean isNotAllowNull(BalanceFieldModelInfo field, boolean isInit) {
        if (field.getName().equals("ID")) {
            return false;
        }
        if (BizDataTypeEnum.EndData.equals((Object)field.getBizDataType()) || BizDataTypeEnum.Year.equals((Object)field.getBizDataType()) || BizDataTypeEnum.Month.equals((Object)field.getBizDataType()) || BizDataTypeEnum.Period.equals((Object)field.getBizDataType())) {
            return false;
        }
        if (isInit && (BizDataTypeEnum.InData.equals((Object)field.getBizDataType()) || BizDataTypeEnum.OutData.equals((Object)field.getBizDataType()))) {
            return false;
        }
        if (!isInit && (BizDataTypeEnum.BeginData.equals((Object)field.getBizDataType()) || BizDataTypeEnum.YearTotalData.equals((Object)field.getBizDataType()))) {
            return false;
        }
        return !field.isIsNullable() && StringUtil.isEmpty((String)field.getDefaultValue());
    }

    private void checkSQLValid(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sSQL = this._getSQL(ctx, pk);
        try {
            TransUtil.Translate((String)sSQL, (int)KsqlUtil.getDBType((Context)ctx));
        }
        catch (SqlTranslateException e) {
            throw new BalanceModelException(BalanceModelException.SQLPARSEERROR, new String[]{e.getMessage()});
        }
    }

    @Override
    protected String _getSQL(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BalanceDataModelInfo dataModelInfo = BalanceDataModelFactory.getLocalInstance(ctx).getBalanceDataModelInfo(pk, BalanceEnginUtil.getBalanceDataModelSelector());
        BalanceModelInfo balanceModelInfo = BalanceModelFactory.getLocalInstance(ctx).getBalanceModelInfo((IObjectPK)new ObjectUuidPK(dataModelInfo.getBalanceModel().getId()), BalanceEnginUtil.getBalanceModelSelector());
        ISQLBuilder sqlBuilder = BalanceSQLBuilderFactory.getBalanceSQLBuilder(balanceModelInfo, dataModelInfo);
        return sqlBuilder.getSQL();
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        return super._submit(ctx, model);
    }
}

