/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.app.InvBalanceReCal.BalanceCalculatorFactory;
import com.kingdee.eas.scm.framework.app.InvBalanceReCal.KsqlUtil;
import com.kingdee.eas.scm.framework.app.InvBalanceReCal.PeriodBalanceReCalCalculator;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.AbstractBalanceReCalCalculateFacadeControllerBean;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BalanceReCalCalculateFacadeControllerBean
extends AbstractBalanceReCalCalculateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.balance.app.BalanceReCalCalculateFacadeControllerBean");

    @Override
    protected void _reCalBalance(Context ctx, HashMap params) throws BOSException, EASBizException {
        int yearFrom = (Integer)params.get("yearFrom");
        int periodFrom = (Integer)params.get("periodFrom");
        int yearTo = (Integer)params.get("yearTo");
        int periodTo = (Integer)params.get("periodTo");
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.get("companyInfo");
        PeriodInfo fromPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)yearFrom, (int)periodFrom, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo toPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)yearTo, (int)periodTo, (CompanyOrgUnitInfo)companyInfo);
        while (fromPeriodInfo.getNumber() <= toPeriodInfo.getNumber()) {
            this.doRecal(ctx, companyInfo, fromPeriodInfo, params);
            if ((fromPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)fromPeriodInfo)) != null) continue;
            break;
        }
    }

    @Override
    protected void _updateBalance(Context ctx, HashMap params) throws BOSException, EASBizException {
        StringBuffer delSql = new StringBuffer();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.get("companyInfo");
        PeriodInfo curPeriodInfo = (PeriodInfo)params.get("curPeriodInfo");
        HashSet storageIDSet = (HashSet)params.get("storageIDSet");
        HashSet warehouseIDSet = (HashSet)params.get("warehouseIDSet");
        HashSet materialIDSet = (HashSet)params.get("materialIDSet");
        String calType = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), "SCM_CAL_002");
        String storageId = null;
        if (storageIDSet != null) {
            storageId = ArrayUtil.getKeyIdStr((Object[])storageIDSet.toArray());
        }
        String warehouseId = null;
        if (warehouseIDSet != null) {
            warehouseId = ArrayUtil.getKeyIdStr((Object[])warehouseIDSet.toArray());
        }
        String materialId = null;
        if (materialIDSet != null) {
            materialId = ArrayUtil.getKeyIdStr((Object[])materialIDSet.toArray());
        }
        delSql.append("DELETE FROM t_cl_inventorybalance WHERE FCOMPANYORGUNITID = '").append(companyInfo.getId().toString()).append("'");
        delSql.append(" and FPERIOD = ").append(curPeriodInfo.getPeriodNumber()).append(" and FYEAR = ").append(curPeriodInfo.getPeriodYear());
        if (storageId != null) {
            delSql.append(" and FSTORAGEORGUNITID in (").append(storageId).append(" ) ");
        }
        if (warehouseId != null) {
            delSql.append(" and FWAREHOUSEID in (").append(warehouseId).append(" ) ");
        }
        if (materialId != null) {
            delSql.append(" and FMATERIALID in (").append(materialId).append(" ) ");
        }
        String fWarehouseId = "''";
        String fStorageOrgUnitId = "''";
        if ("1".equals(calType)) {
            fStorageOrgUnitId = "FSTORAGEORGUNITID";
        } else if ("2".equals(calType)) {
            fStorageOrgUnitId = "FSTORAGEORGUNITID";
            fWarehouseId = "FWAREHOUSEID";
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into t_cl_inventorybalance ");
        insertSql.append("(FID, FCOMPANYORGUNITID, FPERIOD, FMATERIALID, FYEAR, FSTORETYPEID, FSTORAGEORGUNITID, FWAREHOUSEID,");
        insertSql.append("FPERIODBEGINQTY, FPERIODENDQTY, FPERIODISSUEQTY, FPERIODENDASSISTQTY, FPERIODISSUEASSISTQTY,");
        insertSql.append("FPERIODBEGINBALANCE, FPERIODENDBALANCE, FPERIODISSUEAMOUNT, FPERIODBEGINCOSTDIFF, FPERIODENDCOSTDIFF,");
        insertSql.append("FPERIODRECEIPTCOSTDIFF, FPERIODISSUECOSTDIFF, FYEARISSUEAMOUNT, FYEARISSUEQTY, FYEARRECEIPTCOSTDIFF,");
        insertSql.append("FYEARISSUECOSTDIFF, FPERIODADJUSTDIFF,  FPERIODRECEIPTQTY, FPERIODRECEIPTASSISTQTY, FPERIODRECEIPTAMOUNT,");
        insertSql.append("  FPERIODBEGINASSISTQTY, FYEARRECEIPTASSISTQTY, FYEARISSUEASSISTQTY) ");
        insertSql.append("select newbosid('7159C195') AS FID, T.FCOMPANYORGUNITID, T.FPERIOD, T.FMATERIALID, T.FYEAR, T.FSTORETYPEID, ");
        insertSql.append(fStorageOrgUnitId).append(" AS FSTORAGEORGUNITID, ").append(fWarehouseId).append(" AS FWAREHOUSEID, ");
        insertSql.append("SUM(T.FPERIODBEGINQTY), SUM(T.FPERIODENDQTY), SUM(T.FPERIODISSUEQTY), SUM(T.FPERIODENDASSISTQTY), SUM(T.FPERIODISSUEASSISTQTY),");
        insertSql.append("SUM(T.FPERIODBEGINBALANCE), SUM(T.FPERIODENDBALANCE), SUM(T.FPERIODISSUEAMOUNT), SUM(T.FPERIODBEGINCOSTDIFF), SUM(T.FPERIODENDCOSTDIFF), ");
        insertSql.append("SUM(T.FPERIODRECEIPTCOSTDIFF), SUM(T.FPERIODISSUECOSTDIFF), SUM(T.FYEARISSUEAMOUNT), SUM(T.FYEARISSUEQTY), SUM(T.FYEARRECEIPTCOSTDIFF), ");
        insertSql.append("SUM(T.FYEARISSUECOSTDIFF), SUM(T.FPERIODADJUSTDIFF), SUM(T.FPERIODRECEIPTQTY), SUM(T.FPERIODRECEIPTASSISTQTY), ");
        insertSql.append("SUM(T.FPERIODRECEIPTAMOUNT),  SUM(T.FPERIODBEGINASSISTQTY), SUM(T.FYEARRECEIPTASSISTQTY), SUM(T.FYEARISSUEASSISTQTY)");
        insertSql.append(" from t_im_inventorybalance T ");
        insertSql.append(" inner join t_bd_materialcompanyinfo mat on mat.FCOMPANYID = T.FCOMPANYORGUNITID and mat.FMATERIALID = T.FMATERIALID");
        insertSql.append(" where mat.FACCOUNTTYPE = 4 and T.FISCALCULATE = 1 ");
        insertSql.append(" and T.FCOMPANYORGUNITID = '").append(companyInfo.getId().toString()).append("'");
        insertSql.append(" and T.FPERIOD = ").append(curPeriodInfo.getPeriodNumber()).append(" and T.fyear = ").append(curPeriodInfo.getPeriodYear());
        if (storageId != null) {
            insertSql.append(" and FSTORAGEORGUNITID in (").append(storageId).append(" ) ");
        }
        if (warehouseId != null) {
            insertSql.append(" and FWAREHOUSEID in (").append(warehouseId).append(" ) ");
        }
        if (materialId != null) {
            insertSql.append(" and FMATERIALID in (").append(materialId).append(" ) ");
        }
        insertSql.append(" Group by T.FCOMPANYORGUNITID, T.FPERIOD, T.FMATERIALID, T.FYEAR, T.FSTORETYPEID, T.FSTORAGEORGUNITID, T.FWAREHOUSEID");
        KsqlUtil.execute(ctx, new String[]{delSql.toString(), insertSql.toString()});
    }

    private void doRecal(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo curPeriodInfo, HashMap params) throws EASBizException, BOSException {
        BalanceModelInfo balanceModelInfo = BalanceCalculatorFactory.getBalanceModelInfo(ctx, "seqjlFTGSS+fnntnBdl2kyPUYjI=");
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        PeriodBalanceReCalCalculator balanceReCalCalculator = new PeriodBalanceReCalCalculator(ctx, balanceModelInfo, params);
        balanceReCalCalculator.calculate(companyInfo.getId().toString(), curPeriodInfo, OperationTypeEnum.Positive, false);
    }
}

