/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.app.AbstractTableIndexManageFacadeControllerBean;
import com.kingdee.eas.scm.framework.model.TableIndexInfo;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TableIndexManageFacadeControllerBean
extends AbstractTableIndexManageFacadeControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected List _getIndexes(Context ctx, String tableName) throws BOSException, EASBizException {
        String selectIndex_SQLServer = "/*dialect*/ select a.name as indexName,c.name as columnName,b.key_ordinal as columnNO,a.is_unique as isUnique from sys.indexes a inner join sys.index_columns b on a.index_id = b.index_id and a.object_id = b.object_id inner join sys.columns c on c.object_id = a.object_id and c.column_id = b.column_id where a.object_id = object_id(''{0}'') order by a.name,b.key_ordinal";
        String selectIndex_Oracle = "/*dialect*/ select b.index_name as indexName,b.column_name as columnName,b.column_position as columnNO, case a.uniqueness when ''UNIQUE'' then 1 else 0 end as isUnique from all_indexes a, all_ind_columns b where b.index_name=a.index_name and a.table_name=''{0}'' order by b.index_name,b.column_position";
        String selectIndex_DB2 = "/*dialect*/ select indname as indexName,colnames as columnName, case uniquerule when ''U'' then 1 else 0 end as isUnique from syscat.indexes where tabname=''{0}''";
        ArrayList indexList = new ArrayList();
        String sql = null;
        sql = KsqlUtil.isSQLServer((Context)ctx) ? MessageFormat.format(selectIndex_SQLServer, tableName) : (KsqlUtil.isOracle((Context)ctx) ? MessageFormat.format(selectIndex_Oracle, tableName.toUpperCase()) : MessageFormat.format(selectIndex_DB2, tableName.toUpperCase()));
        TableIndexInfo indexInfo = null;
        HashMap<String, TableIndexInfo> indexMap = new HashMap<String, TableIndexInfo>();
        String indexName = null;
        String columnName = null;
        boolean isUnique = false;
        IRowSet rs = KsqlUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                indexName = rs.getString("indexName");
                indexInfo = (TableIndexInfo)indexMap.get(indexName);
                if (indexInfo == null) {
                    isUnique = rs.getBoolean("isUnique");
                    indexInfo = new TableIndexInfo(tableName, indexName, isUnique);
                }
                columnName = rs.getString("columnName");
                indexInfo.addColumn(columnName);
                indexMap.put(indexName, indexInfo);
            }
            Iterator iterator = indexMap.entrySet().iterator();
            while (iterator.hasNext()) {
                indexList.add(iterator.next().getValue());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            KsqlUtil.cleanup((ResultSet)rs);
        }
        return indexList;
    }

    @Override
    protected boolean _createIndex(Context ctx, String tableName, String indexName, List fieldList, boolean isUnique) throws BOSException, EASBizException {
        if (fieldList == null || fieldList.size() == 0) {
            return false;
        }
        String columns = "";
        for (int i = 0; i < fieldList.size(); ++i) {
            if (i > 0) {
                columns = columns + ",";
            }
            columns = columns + fieldList.get(i).toString();
        }
        String sql = null;
        sql = isUnique ? "CREATE UNIQUE INDEX " + indexName + " ON " + tableName + " (" + columns + ")" : "CREATE INDEX " + indexName + " ON " + tableName + " (" + columns + ")";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            throw new BalanceModelException(BalanceModelException.CREATEINDEXERROR, new String[]{e.getMessage()});
        }
        return true;
    }

    @Override
    protected void _deleteIndex(Context ctx, String tableName, String indexName) throws BOSException, EASBizException {
        String delSQL = "drop index " + tableName + "." + indexName;
        try {
            KsqlUtil.execute((Context)ctx, (String)delSQL);
        }
        catch (BOSException e) {
            throw new BalanceModelException(BalanceModelException.DELETEINDEXERROR, new String[]{e.getMessage()});
        }
    }

    @Override
    protected boolean _rebuildIndex(Context ctx, String tableName, String indexName) throws BOSException, EASBizException {
        String rebuildSQL_SQLServer = "/*dialect*/ DBCC DBREINDEX (" + tableName + ", " + indexName + ", 80)";
        String rebuildSQL_Oracle = "/*dialect*/ ALTER INDEX " + indexName + " REBUILD ONLINE";
        String rebuildSQL_DB2 = "/*dialect*/ CALL SYSPROC.ADMIN_CMD('reorg indexes all for table " + tableName + " ALLOW WRITE ACCESS')";
        String sql = null;
        sql = KsqlUtil.isSQLServer((Context)ctx) ? rebuildSQL_SQLServer : (KsqlUtil.isOracle((Context)ctx) ? rebuildSQL_Oracle : rebuildSQL_DB2);
        try {
            KsqlUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            throw new BalanceModelException(BalanceModelException.REBUILDINDEXERROR, new String[]{e.getMessage()});
        }
        return true;
    }
}

