/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.util.BalanceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;

public class BalanceEnginUtil {
    public static SelectorItemCollection getBalanceDataModelSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        selector.add(new SelectorItemInfo("entry.balanceField.*"));
        selector.add(new SelectorItemInfo("dataQuery.*"));
        selector.add(new SelectorItemInfo("dataQuery.entry.*"));
        return selector;
    }

    public static SelectorItemCollection getBalanceModelSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        return selector;
    }

    public static String getBalanceModelFieldStr(BalanceModelInfo balanceModelInfo, String prefix) {
        StringBuffer str = new StringBuffer();
        BalanceFieldModelCollection coll = balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        String tmpPrefix = "";
        if (!StringUtil.isEmpty((String)prefix)) {
            tmpPrefix = prefix + ".";
        }
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (i > 0) {
                str.append(",");
            }
            str.append(tmpPrefix).append(fieldInfo.getFieldName());
        }
        return str.toString();
    }

    public static String getCreateTempTableSQL(Context ctx, BalanceModelInfo balanceModelInfo) throws BalanceModelException {
        StringBuffer createSQL = new StringBuffer();
        createSQL.append("Create Table ").append("BalanceTempTable").append("(").append("\r\n");
        BalanceFieldModelCollection coll = balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            String fieldName = fieldInfo.getFieldName();
            String dataType = BalanceUtil.getDataTypeStr(ctx, fieldInfo);
            String defaultValue = BalanceUtil.getDefaultValueSQL(fieldInfo, true);
            String constraint = !fieldInfo.isIsNullable() ? "Not Null" : "";
            if (i > 0) {
                createSQL.append(",").append("\r\n");
            }
            createSQL.append("  ").append(fieldName).append(" ").append(dataType).append(" ").append(defaultValue).append(" ").append(constraint);
        }
        createSQL.append("\r\n").append(")");
        return createSQL.toString();
    }

    public static String getBalanceDimFieldStr(BalanceModelInfo balanceModelInfo, String prefix) {
        StringBuffer str = new StringBuffer();
        BalanceFieldModelCollection coll = balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        String tmpPrefix = "";
        if (!StringUtil.isEmpty((String)prefix)) {
            tmpPrefix = prefix + ".";
        }
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.Dim.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Organization.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Period.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Year.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Month.equals((Object)fieldInfo.getBizDataType())) continue;
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(tmpPrefix).append(fieldInfo.getFieldName());
        }
        return str.toString();
    }
}

