/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.PlugInApplyRangeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.AbstractBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.InvokeTime;
import com.kingdee.eas.scm.framework.balance.app.engine.PeriodBalanceSQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.log.PeriodBalanceLogger;
import com.kingdee.eas.scm.framework.balance.app.plugin.HandlerParameter;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class PeriodBalanceCalculator
extends AbstractBalanceCalculator {
    protected String orgUnitID;
    protected PeriodInfo prePeriod;
    protected PeriodInfo curPeriod;
    protected PeriodInfo nextPeriod;
    protected boolean isReCalculate;
    private String Field_issuebill = "FIsIsseBill";
    private String Field_costadjust = "FCostadjustbill";

    public PeriodBalanceCalculator(Context ctx, BalanceModelInfo balanceModelInfo) throws BOSException, EASBizException {
        super(ctx, balanceModelInfo);
    }

    @Override
    protected void init() throws BOSException, EASBizException {
        PeriodBalanceLogger tmpLogger = (PeriodBalanceLogger)this.logger;
        tmpLogger.setOrgUnitID(this.orgUnitID);
        tmpLogger.setPeriodInfo(this.curPeriod);
        super.init();
        this.prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)this.curPeriod);
        this.nextPeriod = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)this.curPeriod);
    }

    @Override
    protected void beforeCalculate() throws BalanceModelException {
        if (this.prePeriod == null && OperationTypeEnum.Reverse.equals((Object)this.OPType)) {
            throw new BalanceModelException(BalanceModelException.PREPERIODISNULL);
        }
        if (this.nextPeriod == null && OperationTypeEnum.Positive.equals((Object)this.OPType)) {
            throw new BalanceModelException(BalanceModelException.NEXTPERIODISNULL);
        }
    }

    @Override
    protected FilterInfo getBalanceDataModelFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)this.balanceModelInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)UseStatusEnum.ACTIVE));
        filter.getFilterItems().add(new FilterItemInfo("isInitialize", (Object)Boolean.FALSE));
        return filter;
    }

    @Override
    protected FilterInfo getPlugInFilter() {
        FilterInfo filter = super.getPlugInFilter();
        filter.getFilterItems().add(new FilterItemInfo("applyRange", (Object)PlugInApplyRangeEnum.OnlyForInit, CompareType.NOTEQUALS));
        return filter;
    }

    @Override
    public void calculate(String orgUnitID, PeriodInfo period, OperationTypeEnum OPType, boolean isReCalculate) throws BOSException, EASBizException {
        this.orgUnitID = orgUnitID;
        this.curPeriod = period;
        this.isReCalculate = isReCalculate;
        this.logger.beginLog();
        super.calculate(orgUnitID, period, OPType, isReCalculate);
        this.logger.endLog();
    }

    @Override
    protected void calculateStep() throws BOSException, EASBizException {
        if (OperationTypeEnum.Positive.equals((Object)this.OPType)) {
            this.calculateBalance();
        } else {
            this.reverseCalculateBalance();
        }
    }

    protected void calculateBalance() throws BOSException, EASBizException {
        this.timer.reset();
        this.takeBeginData();
        this.logger.info("\u53d6\u671f\u521d\u6570\u636e\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.takeBillData();
        this.logger.info("\u6839\u636e\u6a21\u578b\u53d6\u6570\u914d\u7f6e\u4fe1\u606f\u53d6\u6570\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.logger.info("==================\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e==================");
        this.invokePlugInHandler(InvokeTime.AfterDetailData);
        this.logger.info("==================\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e\u7ed3\u675f\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue() + "==================");
        this.timer.reset();
        this.groupDetailDataToFinalTable();
        this.logger.info("\u5c06\u660e\u7ec6\u6570\u636e\u6309\u7ef4\u5ea6\u6c47\u603b\u5230\u5206\u7ec4\u4e34\u65f6\u8868\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.updateCalculateField();
        this.logger.info("\u66f4\u65b0\u4f59\u989d\u6a21\u578b\u52a8\u6001\u8ba1\u7b97\u5b57\u6bb5\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.logger.info("==================\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u5904\u7406\u6700\u7ec8\u6570\u636e==================");
        this.invokePlugInHandler(InvokeTime.AfterFinalData);
        this.logger.info("==================\u63d2\u4ef6\u5904\u7406\u6700\u7ec8\u6570\u636e\u7ed3\u675f\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue() + "==================");
        this.timer.reset();
        this.deletePeriodBalance(this.curPeriod);
        this.logger.info("\u5220\u9664\u4f59\u989d\u8868\u672c\u671f\u671f\u521d\u6570\u636e\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.insertReadyDataToBalanceTable();
        this.logger.info("\u63d2\u5165\u672c\u671f\u6700\u7ec8\u6570\u636e\u5230\u4f59\u989d\u8868\u82b1\u8d39\uff1a" + this.timer.msValue());
        if (!this.isReCalculate) {
            this.timer.reset();
            this.deletePeriodBalance(this.nextPeriod);
            this.logger.info("\u5220\u9664\u4e0b\u671f\u4f59\u989d\u6570\u636e\u82b1\u8d39\uff1a" + this.timer.msValue());
            this.timer.reset();
            this.insertNextPeriodBeginData(this.curPeriod, this.nextPeriod);
            this.logger.info("\u63d2\u5165\u4e0b\u671f\u671f\u521d\u82b1\u8d39\uff1a" + this.timer.msValue());
            this.timer.reset();
            this.deleteZeroBeginData(this.nextPeriod);
            this.logger.info("\u5220\u9664\u4f59\u989d\u8868\u4e2d\u671f\u521d\u4e3a0\u7684\u8bb0\u5f55\u82b1\u8d39\uff1a" + this.timer.msValue());
        }
    }

    protected void reverseCalculateBalance() throws BOSException, EASBizException {
        this.timer.reset();
        this.deletePeriodBalance(this.curPeriod);
        this.logger.info("\u5220\u9664\u4f59\u989d\u8868\u672c\u671f\u671f\u521d\u6570\u636e\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        String whereSQL = this.getBalanceTableFilter(this.prePeriod);
        this.calculateYearTotalField(this.balanceModelInfo.getTabName(), whereSQL);
        this.logger.info("\u66f4\u65b0\u672c\u5e74\u7d2f\u8ba1\u6570\u636e\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.deleteZeroBeginData(this.prePeriod);
        this.logger.info("\u5220\u9664\u4f59\u989d\u8868\u4e2d\u671f\u521d\u4e3a\u96f6\u7684\u8bb0\u5f55\u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.updateNotBeginData2Zero(this.prePeriod);
        this.logger.info("\u66f4\u65b0\u975e\u671f\u521d\u6570\u636e\u4e3a\u96f6\u82b1\u8d39\uff1a" + this.timer.msValue());
    }

    @Override
    protected ISQLBuilder createSQLBuilder(BalanceDataModelInfo dataModelInfo) {
        return new PeriodBalanceSQLBuilder(this.balanceModelInfo, dataModelInfo, this.orgUnitID, this.curPeriod);
    }

    @Override
    protected HandlerParameter getHandlerParameter() {
        HandlerParameter params = super.getHandlerParameter();
        params.setOrgUnitID(this.orgUnitID);
        params.setCurPeriod(this.curPeriod);
        params.setNextPeriod(this.nextPeriod);
        return params;
    }

    protected void deleteZeroBeginData(PeriodInfo period) throws BOSException {
        StringBuffer delSql = new StringBuffer();
        delSql.append("DELETE FROM ").append(this.balanceModelInfo.getTabName()).append("\r\n");
        delSql.append(this.getBalanceTableFilter(period)).append("\r\n");
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.BeginData.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType())) continue;
            delSql.append(" AND ").append(fieldInfo.getFieldName()).append(" = 0").append("\r\n");
        }
        this.logger.debugSQL("\u5220\u9664\u4f59\u989d\u8868\u4e2d\u671f\u521d\u4e3a0\u7684\u8bb0\u5f55SQL\uff1a", delSql.toString());
        KsqlUtil.execute((Context)this.ctx, (String)delSql.toString());
    }

    protected void takeBeginData() throws BalanceModelException, BOSException {
        StringBuffer selectSQL = new StringBuffer();
        String insertSQL = this.getInsertSQL(this.detailTempTable);
        selectSQL.append(insertSQL).append("\r\n");
        selectSQL.append(this.getBeginDataSQL(this.curPeriod));
        this.logger.debugSQL("\u83b7\u53d6\u671f\u521d\u6570\u636eSQL\uff1a", selectSQL.toString());
        KsqlUtil.execute((Context)this.ctx, (String)selectSQL.toString());
    }

    protected String getBeginDataSQL(PeriodInfo curPeriod) {
        StringBuffer selectSQL = new StringBuffer("SELECT ");
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (i > 0) {
                selectSQL.append(",");
            }
            if (BizDataTypeEnum.InData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.OutData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.EndData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (curPeriod.getPeriodNumber() == 1 && BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            selectSQL.append(fieldInfo.getFieldName());
        }
        selectSQL.append("\r\n");
        selectSQL.append("FROM ").append(this.balanceModelInfo.getTabName()).append("\r\n");
        selectSQL.append(this.getBalanceTableFilter(curPeriod));
        return selectSQL.toString();
    }

    protected String getNewPeriodBeginDataSQL(PeriodInfo curPeriod, PeriodInfo nextPeriod) throws BalanceModelException {
        StringBuffer selectSQL = new StringBuffer("SELECT ");
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (i > 0) {
                selectSQL.append(",");
            }
            if (BizDataTypeEnum.PrimaryKey.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("newbosid('").append(this.balBosType).append("') AS FID");
                continue;
            }
            if (BizDataTypeEnum.Year.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append(nextPeriod.getPeriodYear()).append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (BizDataTypeEnum.Month.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append(nextPeriod.getPeriodNumber()).append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (BizDataTypeEnum.Period.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("'").append(nextPeriod.getId().toString()).append("'").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (BizDataTypeEnum.BeginData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append(this.parser.getSQLExpression(fieldInfo));
                continue;
            }
            if (BizDataTypeEnum.InData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.OutData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.EndData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (nextPeriod.getPeriodNumber() == 1 && BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (this.Field_issuebill.equals(fieldInfo.getFieldName())) {
                selectSQL.append("0").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            if (this.Field_costadjust.equals(fieldInfo.getFieldName())) {
                selectSQL.append(" '' ").append(" AS ").append(fieldInfo.getFieldName());
                continue;
            }
            selectSQL.append(fieldInfo.getFieldName());
        }
        selectSQL.append("\r\n");
        selectSQL.append("FROM ").append(this.balanceModelInfo.getTabName()).append("\r\n");
        selectSQL.append(this.getBalanceTableFilter(curPeriod));
        return selectSQL.toString();
    }

    protected String getBalanceTableFilter(PeriodInfo period) {
        StringBuffer whereSQL = new StringBuffer();
        whereSQL.append("WHERE ").append(this.balanceModelInfo.getMainOrgUnitField().getFieldName()).append("='").append(this.orgUnitID).append("'");
        whereSQL.append("\r\n").append("AND ");
        if (this.balanceModelInfo.getPeriodField() == null) {
            whereSQL.append(this.balanceModelInfo.getPeriodYearField().getFieldName()).append("=").append(period.getPeriodYear());
            whereSQL.append(" AND ");
            whereSQL.append(this.balanceModelInfo.getPeriodMonthField().getFieldName()).append("=").append(period.getPeriodNumber());
        } else {
            whereSQL.append(this.balanceModelInfo.getPeriodField().getFieldName()).append("='").append(period.getId().toString()).append("'");
        }
        return whereSQL.toString();
    }

    protected void deletePeriodBalance(PeriodInfo period) throws BOSException {
        StringBuffer deleteSQL = new StringBuffer();
        deleteSQL.append("Delete from ").append(this.balanceModelInfo.getTabName()).append("\r\n");
        deleteSQL.append(this.getBalanceTableFilter(period));
        this.logger.debugSQL("\u5220\u9664period\u671f\u95f4\u4f59\u989d\u6570\u636eSQL\uff1a", deleteSQL.toString());
        KsqlUtil.execute((Context)this.ctx, (String)deleteSQL.toString());
    }

    protected void updateNotBeginData2Zero(PeriodInfo period) throws BOSException {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append("Update ").append(this.balanceModelInfo.getTabName()).append(" set ").append("\r\n");
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        boolean isFirst = true;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (fieldInfo.getFieldName().equalsIgnoreCase("FPeriodAdjustDiff") || !BizDataTypeEnum.InData.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.OutData.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.EndData.equals((Object)fieldInfo.getBizDataType())) continue;
            if (!isFirst) {
                updateSQL.append(",");
            }
            updateSQL.append(fieldInfo.getFieldName()).append(" = 0");
            isFirst = false;
        }
        updateSQL.append("\r\n").append(this.getBalanceTableFilter(period));
        this.logger.debugSQL("\u66f4\u65b0period\u671f\u95f4\u975e\u671f\u521d\u6570\u636e\u4e3a\u96f6SQL\uff1a", updateSQL.toString());
        KsqlUtil.execute((Context)this.ctx, (String)updateSQL.toString());
    }

    protected void updateCalculateField() throws BOSException, BalanceModelException {
        this.calculateFormulaField();
        this.calculateYearTotalField(this.finalTempTable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateFormulaField() throws BalanceModelException, BOSException {
        List<BalanceFieldModelInfo> fieldList = this.getCalculateFieldList();
        String sSQL = "";
        try {
            while (fieldList.size() > 0) {
                sSQL = this.getUpdateCalculateFieldSQL(fieldList);
                this.logger.debugSQL("\u66f4\u65b0\u4f59\u989d\u6a21\u578b\u52a8\u6001\u8ba1\u7b97\u5b57\u6bb5SQL\uff1a", sSQL);
                KsqlUtil.execute((Context)this.ctx, (String)sSQL);
                fieldList = this.getCalculateFieldList();
            }
        }
        finally {
            BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
            for (int i = 0; i < coll.size(); ++i) {
                coll.get(i).setBoolean("IsCalculated", false);
            }
        }
    }

    protected void calculateYearTotalField(String tabName, String whereSQL) throws BalanceModelException, BOSException {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append("Update ").append(tabName).append(" Set ").append("\r\n");
        boolean isFirst = true;
        String sign = OperationTypeEnum.Positive.equals((Object)this.OPType) ? "+" : "-";
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType()) || StringUtil.isEmpty((String)fieldInfo.getCalExpression())) continue;
            if (!isFirst) {
                updateSQL.append(",").append("\r\n");
            }
            updateSQL.append(fieldInfo.getFieldName()).append(" = ").append(fieldInfo.getFieldName());
            updateSQL.append(sign);
            updateSQL.append(this.parser.getSQLExpression(fieldInfo));
            isFirst = false;
        }
        if (!StringUtil.isEmpty((String)whereSQL)) {
            updateSQL.append("\r\n").append(whereSQL);
        }
        this.logger.debugSQL("\u8ba1\u7b97\u672c\u5e74\u7d2f\u8ba1\u5b57\u6bb5SQL\uff1a", updateSQL.toString());
        KsqlUtil.execute((Context)this.ctx, (String)updateSQL.toString());
    }

    private List<BalanceFieldModelInfo> getCalculateFieldList() throws BalanceModelException {
        ArrayList<BalanceFieldModelInfo> fieldList = new ArrayList<BalanceFieldModelInfo>();
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (BizDataTypeEnum.BeginData.equals((Object)fieldInfo.getBizDataType()) || BizDataTypeEnum.YearTotalData.equals((Object)fieldInfo.getBizDataType()) || !this.parser.isCanCalculate(fieldInfo)) continue;
            fieldList.add(fieldInfo);
        }
        return fieldList;
    }

    protected String getUpdateCalculateFieldSQL(List<BalanceFieldModelInfo> fieldList) throws BalanceModelException {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append("Update ").append(this.finalTempTable).append(" Set ").append("\r\n");
        boolean isFirst = true;
        BalanceFieldModelInfo fieldInfo = null;
        for (int i = 0; i < fieldList.size(); ++i) {
            fieldInfo = fieldList.get(i);
            if (StringUtil.isEmpty((String)fieldInfo.getCalExpression())) continue;
            if (!isFirst) {
                updateSQL.append(",").append("\r\n");
            }
            updateSQL.append(fieldInfo.getFieldName()).append("=").append(this.parser.getSQLExpression(fieldInfo));
            fieldInfo.setBoolean("IsCalculated", true);
            isFirst = false;
        }
        return updateSQL.toString();
    }

    protected void insertReadyDataToBalanceTable() throws BOSException {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(this.getInsertSQL(this.balanceModelInfo.getTabName())).append("\r\n");
        insertSQL.append("SELECT ");
        insertSQL.append(BalanceEnginUtil.getBalanceModelFieldStr(this.balanceModelInfo, null)).append("\r\n");
        insertSQL.append("FROM ").append(this.finalTempTable).append("\r\n");
        this.logger.debugSQL("\u63d2\u5165\u672c\u671f\u6700\u7ec8\u6570\u636e\u5230\u4f59\u989d\u8868SQL: ", insertSQL.toString());
        KsqlUtil.execute((Context)this.ctx, (String)insertSQL.toString());
    }

    protected void insertNextPeriodBeginData(PeriodInfo prePeriod, PeriodInfo curPeriod) throws BOSException, BalanceModelException {
        StringBuffer selectSQL = new StringBuffer();
        String insertSQL = this.getInsertSQL(this.balanceModelInfo.getTabName());
        selectSQL.append(insertSQL).append("\r\n");
        selectSQL.append(this.getNewPeriodBeginDataSQL(prePeriod, curPeriod));
        this.logger.debugSQL("\u63d2\u5165\u4e0b\u671f\u671f\u521d\u6570\u636eSQL: ", selectSQL.toString());
        KsqlUtil.execute((Context)this.ctx, (String)selectSQL.toString());
    }

    @Override
    public void releaseTempTable() throws BOSException {
        super.releaseTempTable();
    }

    public String getOrgUnitID() {
        return this.orgUnitID;
    }

    public void setOrgUnitID(String orgUnitID) {
        this.orgUnitID = orgUnitID;
    }

    public PeriodInfo getPrePeriod() {
        return this.prePeriod;
    }

    public void setPrePeriod(PeriodInfo prePeriod) {
        this.prePeriod = prePeriod;
    }

    public PeriodInfo getCurPeriod() {
        return this.curPeriod;
    }

    public void setCurPeriod(PeriodInfo curPeriod) {
        this.curPeriod = curPeriod;
    }

    public PeriodInfo getNextPeriod() {
        return this.nextPeriod;
    }

    public void setNextPeriod(PeriodInfo nextPeriod) {
        this.nextPeriod = nextPeriod;
    }

    public boolean isReCalculate() {
        return this.isReCalculate;
    }

    public void setReCalculate(boolean isReCalculate) {
        this.isReCalculate = isReCalculate;
    }

    @Override
    protected void afterCreateTempTable() throws BOSException {
        String balanceModelId = this.balanceModelInfo.getId().toString();
        if ("rZr83XuPQXGYgUePQ5LecSPUYjI=".equals(balanceModelId) || "ffjhq9qjQDajSUiiCFG1NCPUYjI=".equals(balanceModelId)) {
            KsqlUtil.createTempTableIndex((Context)this.ctx, (String)this.detailTempTable, (String)"FAsstActID, FAsstActTypeID", (boolean)false, (boolean)false);
        }
    }
}

