/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DateFilterTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceDataModelSQLBuilder;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class PeriodBalanceSQLBuilder
extends BalanceDataModelSQLBuilder {
    protected String orgUnitID;
    protected PeriodInfo period;
    protected static Set<String> OrgRelToUnitSet = new HashSet<String>();

    public PeriodBalanceSQLBuilder(BalanceModelInfo balanceModelInfo, BalanceDataModelInfo dataModelInfo) {
        super(balanceModelInfo, dataModelInfo);
    }

    public PeriodBalanceSQLBuilder(BalanceModelInfo balanceModelInfo, BalanceDataModelInfo dataModelInfo, String orgUnitID, PeriodInfo period) {
        super(balanceModelInfo, dataModelInfo);
        this.orgUnitID = orgUnitID;
        this.period = period;
    }

    @Override
    protected String getFieldSQL(BalanceFieldModelInfo fieldModel) {
        String result = "";
        if (this.period == null) {
            return super.getFieldSQL(fieldModel);
        }
        result = BizDataTypeEnum.Year.equals((Object)fieldModel.getBizDataType()) ? this.period.getPeriodYear() + " AS " + fieldModel.getFieldName() : (BizDataTypeEnum.Month.equals((Object)fieldModel.getBizDataType()) ? this.period.getPeriodNumber() + " AS " + fieldModel.getFieldName() : (BizDataTypeEnum.Period.equals((Object)fieldModel.getBizDataType()) ? "'" + this.period.getId().toString() + "'" + " AS " + fieldModel.getFieldName() : super.getFieldSQL(fieldModel)));
        return result;
    }

    @Override
    protected FilterInfo getExtendFilter() throws BalanceModelException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.mergeFilter(this.getOrgUnitFilterInfo(), "AND");
        filter.mergeFilter(this.getDateFilterInfo(), "AND");
        return filter;
    }

    protected FilterInfo getOrgUnitFilterInfo() {
        if (StringUtil.isEmpty((String)this.orgUnitID)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getOrgField(), (Object)this.orgUnitID));
        if (OrgRelToUnitSet.contains(this.dataModelInfo.getId().toString().toString())) {
            filter.getFilterItems().add(new FilterItemInfo("OrgUnitRelation.FTOUNITID", (Object)this.orgUnitID));
        }
        return filter;
    }

    protected FilterInfo getDateFilterInfo() {
        if (this.period == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        if (DateFilterTypeEnum.BizDate.equals((Object)this.dataModelInfo.getDateFilterType())) {
            Date beginDate = this.period.getBeginDate();
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(this.period.getEndDate());
            endDate.add(6, 1);
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getBizDateField(), (Object)beginDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getBizDateField(), (Object)endDate.getTime(), CompareType.LESS));
        } else if (DateFilterTypeEnum.YearAndMonth.equals((Object)this.dataModelInfo.getDateFilterType())) {
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getPeriodYear(), (Object)this.period.getPeriodYear()));
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getPeriodMonth(), (Object)this.period.getPeriodNumber()));
        } else if (DateFilterTypeEnum.PeriodID.equals((Object)this.dataModelInfo.getDateFilterType())) {
            filter.getFilterItems().add(new FilterItemInfo(this.dataModelInfo.getPeriodIdField(), (Object)this.period.getId().toString()));
        }
        return filter;
    }

    public String getOrgUnitID() {
        return this.orgUnitID;
    }

    public void setOrgUnitID(String orgUnitID) {
        this.orgUnitID = orgUnitID;
    }

    public PeriodInfo getPeriod() {
        return this.period;
    }

    public void setPeriod(PeriodInfo period) {
        this.period = period;
    }

    static {
        OrgRelToUnitSet.add("YFFVbonARBO4SBicXj6CbOLrECg=");
        OrgRelToUnitSet.add("oUVkd5hjQkyQBxjnnACOmOLrECg=");
        OrgRelToUnitSet.add("oo/wOKSuQnGz+gE2mmUby+LrECg=");
        OrgRelToUnitSet.add("DBE12qfsQi6f4MVvmfHwweLrECg=");
        OrgRelToUnitSet.add("MyXpmjjrTWys1hk83sAQkOLrECg=");
        OrgRelToUnitSet.add("rG/6bqE0Q3GLS8djPcAN5eLrECg=");
    }
}

