/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.AbstractBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.InsertNewRecordHelper;
import com.kingdee.eas.scm.framework.balance.app.engine.InvokeTime;
import com.kingdee.eas.scm.framework.balance.app.engine.RealTimeBalanceSQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.log.RealTimeBalanceLogger;
import com.kingdee.eas.scm.framework.balance.app.plugin.HandlerParameter;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RealTimeBalanceCalculator
extends AbstractBalanceCalculator {
    private String billBosType;
    private String billId;
    private ObjectBaseInfo bill;

    public RealTimeBalanceCalculator(Context ctx, BalanceModelInfo balanceModelInfo) throws BOSException, EASBizException {
        super(ctx, balanceModelInfo);
    }

    @Override
    protected void init() throws BOSException, EASBizException {
        super.init();
    }

    @Override
    protected FilterInfo getBalanceDataModelFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)this.balanceModelInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("dataQuery.BillBosType", (Object)this.billBosType));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)UseStatusEnum.ACTIVE));
        this.logger.debug("\u53d6\u6570\u914d\u7f6e\u6a21\u578b\u8fc7\u6ee4\u6761\u4ef6\uff1a" + filter.toSql());
        return filter;
    }

    @Override
    protected ISQLBuilder createSQLBuilder(BalanceDataModelInfo dataModelInfo) {
        return new RealTimeBalanceSQLBuilder(this.balanceModelInfo, dataModelInfo, this.billId);
    }

    @Override
    protected HandlerParameter getHandlerParameter() {
        HandlerParameter params = super.getHandlerParameter();
        params.setBillID(this.billId);
        params.setBillBosType(this.billBosType);
        params.setBill(this.bill);
        params.setLogger(this.logger);
        return params;
    }

    @Override
    public void calculate(String bosType, String billId, OperationTypeEnum OPType) throws BOSException, EASBizException {
        this.billBosType = bosType;
        this.billId = billId;
        this.OPType = OPType;
        RealTimeBalanceLogger tmpLogger = (RealTimeBalanceLogger)this.logger;
        tmpLogger.setBillId(billId);
        tmpLogger.setOPType(OPType);
        this.getBill(bosType, billId);
        this.logger.beginLog();
        super.calculate(bosType, billId, OPType);
        this.logger.endLog();
    }

    @Override
    protected void calculateStep() throws BOSException, EASBizException {
        this.timer.reset();
        this.takeBillData();
        this.logger.info("\u5355\u636e\u53d6\u6570\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        if (this.isTempTableNull()) {
            this.logger.error("\u8b66\u544a\uff1a \u6ca1\u6709\u53d6\u5230\u6570\u636e\uff0c\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        this.timer.reset();
        this.logger.info("==================\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e==================");
        this.invokePlugInHandler(InvokeTime.AfterDetailData);
        this.logger.info("==================\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e\u5b8c\u6210\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue() + "==================");
        this.logger.debugData("\u660e\u7ec6\u8868\u6570\u636e\u8bb0\u5f55\uff1a", this.detailTempTable);
        this.timer.reset();
        this.groupDetailDataToFinalTable();
        this.logger.info("\u6309\u7ef4\u5ea6\u5206\u7ec4\u6c47\u603b\u6570\u636e\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.insertNewRecord();
        this.logger.info("\u63d2\u5165\u4f59\u989d\u8868\u4e2d\u4e0d\u5339\u914d\u7684\u65b0\u8bb0\u5f55\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.updateBalanceIdToTempTable();
        this.logger.info("\u66f4\u65b0\u4f59\u989d\u8868ID\u5230\u4e34\u65f6\u8868\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.createOrderedTempTable();
        this.logger.info("\u521b\u5efa\u6709\u5e8f\u8868\u9632\u6b62\u6b7b\u9501\uff0c  \u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.logger.info("==================\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u5904\u7406\u9501\u5b9a\u524d\u6570\u636e\u5904\u7406==================");
        this.invokePlugInHandler(InvokeTime.AfterFinalBeforeLock);
        this.logger.info("==================\u63d2\u4ef6\u5904\u7406\u6700\u7ec8\u6570\u636e\u5b8c\u6210\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue() + "==================");
        this.timer.reset();
        this.lockBalanceRows();
        this.logger.info("\u6839\u636eID\u9501\u5b9a\u4f59\u989d\u8868\u8bb0\u5f55\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.calculateBalance();
        this.logger.info("\u8ba1\u7b97\u66f4\u65b0\u540e\u7684\u4f59\u989d\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        this.logger.debugData("\u6700\u7ec8\u6570\u636e\u8bb0\u5f55\uff1a", this.finalTempTable);
        this.timer.reset();
        this.logger.info("==================\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u5904\u7406\u6700\u7ec8\u6570\u636e==================");
        this.invokePlugInHandler(InvokeTime.AfterFinalData);
        this.logger.info("==================\u63d2\u4ef6\u5904\u7406\u6700\u7ec8\u6570\u636e\u5b8c\u6210\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue() + "==================");
        this.timer.reset();
        this.updateResultToBalance();
        this.logger.info("\u66f4\u65b0\u6700\u7ec8\u6570\u636e\u5230\u4e34\u65f6\u8868\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
    }

    protected boolean isTempTableNull() throws EASBizException, BOSException {
        String sql = "select count(*) as recordCount from " + this.detailTempTable;
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        int count = 0;
        try {
            if (rs.next()) {
                count = rs.getInt("recordCount");
            }
            if (count == 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return false;
    }

    protected void insertNewRecord() throws BOSException {
        InsertNewRecordHelper helper = new InsertNewRecordHelper(this.balanceModelInfo, this.logger);
        String sSQL = helper.getSelectNotExistRecordSQL(this.finalTempTable);
        this.logger.debugSQL("\u67e5\u8be2\u4f59\u989d\u8868\u4e2d\u4e0d\u5339\u914d\u7684\u65b0\u8bb0\u5f55SQL\uff1a", sSQL);
        try {
            helper.doInsertNewRecord(this.ctx, sSQL);
        }
        catch (Exception e) {
            this.logger.error("\u63d2\u5165\u65b0\u589e\u8bb0\u5f55\u5230\u5373\u65f6\u5e93\u5b58\u8868\u51fa\u9519\uff1a" + e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    protected void updateBalanceIdToTempTable() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(this.finalTempTable).append(" as tmp set (FID) = ").append("\r\n");
        sql.append("(select bal.FID from ").append(this.balanceModelInfo.getTabName()).append(" bal ").append("\r\n");
        sql.append("where ").append(InsertNewRecordHelper.getMatchCondition(this.balanceModelInfo, "tmp", "bal")).append(")");
        this.logger.debugSQL("\u66f4\u65b0\u65b0ID\u5230\u4e34\u65f6\u8868\u4e2dSQL: ", sql.toString());
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    protected void lockBalanceRows() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(this.balanceModelInfo.getTabName()).append(" set FID = FID where FID IN ");
        sql.append("(select FID from ").append(this.finalTempTable).append(" where FID IS NOT NULL)");
        this.logger.debugSQL("\u5bf9\u6570\u636e\u8868\u52a0\u884c\u9501SQL: ", sql.toString());
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    protected void calculateBalance() throws BOSException {
        StringBuffer setFieldStr = new StringBuffer();
        StringBuffer selFieldStr = new StringBuffer();
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        String sign = "+";
        if (OperationTypeEnum.Reverse.equals((Object)this.OPType)) {
            sign = "-";
        }
        for (int i = 1; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.HappenData.equals((Object)fieldInfo.getBizDataType())) continue;
            if (setFieldStr.length() > 0) {
                setFieldStr.append(",");
                selFieldStr.append(",");
            }
            setFieldStr.append(fieldInfo.getFieldName());
            selFieldStr.append("bal.").append(fieldInfo.getFieldName());
            selFieldStr.append(sign);
            selFieldStr.append("tmp.").append(fieldInfo.getFieldName());
        }
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("update ").append(this.finalTempTable).append(" as tmp set (").append(setFieldStr.toString()).append(") = (");
        sSQL.append("select ").append(selFieldStr.toString()).append(" from ").append(this.balanceModelInfo.getTabName()).append(" bal ");
        sSQL.append("where tmp.FID = bal.FID)");
        this.logger.debugSQL("\u8ba1\u7b97\u66f4\u65b0\u4f59\u989dSQL: ", sSQL.toString());
        KsqlUtil.execute((Context)this.ctx, (String)sSQL.toString());
    }

    protected void updateResultToBalance() throws BOSException {
        StringBuffer setFieldStr = new StringBuffer();
        StringBuffer selFieldStr = new StringBuffer();
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        for (int i = 1; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.HappenData.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.AssistInfo.equals((Object)fieldInfo.getBizDataType())) continue;
            if (setFieldStr.length() > 0) {
                setFieldStr.append(",");
                selFieldStr.append(",");
            }
            setFieldStr.append(fieldInfo.getFieldName());
            selFieldStr.append("tmp.").append(fieldInfo.getFieldName());
        }
        setFieldStr.append(",").append("FLastUpdateTime");
        selFieldStr.append(",").append("getdate()");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("update ").append(this.balanceModelInfo.getTabName()).append(" as bal set (").append(setFieldStr.toString()).append(") = (");
        sSQL.append("select ").append(selFieldStr.toString()).append(" from ").append(this.finalTempTable).append(" tmp ");
        sSQL.append("where tmp.FID = bal.FID)");
        this.logger.debugSQL("\u66f4\u65b0\u6700\u7ec8\u7ed3\u679c\u5230\u4f59\u989d\u8868SQL: ", sSQL.toString());
        KsqlUtil.execute((Context)this.ctx, (String)sSQL.toString());
    }

    public String getBillBosType() {
        return this.billBosType;
    }

    public void setBillBosType(String bosType) {
        this.billBosType = bosType;
    }

    public String getBillId() {
        return this.billId;
    }

    public void setBillId(String billId) {
        this.billId = billId;
    }

    public OperationTypeEnum getOPType() {
        return this.OPType;
    }

    public void setOPType(OperationTypeEnum oPType) {
        this.OPType = oPType;
    }

    private void getBill(String bosType, String billId) throws BOSException, EASBizException {
        ICoreBillBase iBiz = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)BOSObjectType.create((String)bosType));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("transactionType.id");
        selector.add("bizDate");
        this.bill = iBiz.getObjectBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
    }

    @Override
    protected Boolean isUseThreadPool4TakeBill() {
        return false;
    }

    private void createOrderedTempTable() throws BOSException {
        try {
            String createTmpTblSql = BalanceEnginUtil.getCreateTempTableSQL(this.ctx, this.balanceModelInfo);
            String tmpTblName = KsqlUtil.createTempTableWithNewTx((Context)this.ctx, (String)createTmpTblSql);
            StringBuffer selectInsertSql = new StringBuffer();
            selectInsertSql.append("insert into ").append(tmpTblName).append(" select * from ").append(this.finalTempTable).append(" order by FId");
            DbUtil.execute((Context)this.ctx, (String)selectInsertSql.toString());
            KsqlUtil.releaseTempTable((Context)this.ctx, (String)this.finalTempTable);
            this.finalTempTable = tmpTblName;
        }
        catch (BalanceModelException e) {
            throw new BOSException((Throwable)((Object)e));
        }
    }
}

