/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.app.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.app.log.IBalanceLogger;
import com.kingdee.eas.scm.util.app.log.Log4j2Util;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;

public class BalanceLogger
implements IBalanceLogger {
    private static final String PARAM_LEVEL_NAME = "BalanceCalLogLevel";
    private static final String LOGGER_NAME = "com.kingdee.eas.scm.framework.balance";
    private static final int INFO = 1;
    private static final int DEBUG = 2;
    private static final int DATA = 3;
    protected Context ctx;
    protected Logger logger;
    protected int level;
    protected BalanceModelInfo balanceModelInfo;
    private StringBuffer logBuffer;
    private LowTimer innerTimer;

    public BalanceLogger(Context ctx, BalanceModelInfo balanceModelInfo) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.innerTimer = new LowTimer();
        this.logBuffer = new StringBuffer();
        this.balanceModelInfo = balanceModelInfo;
        this.initLogger();
        this.initParam();
    }

    @Override
    public void beginLog() {
        if (this.level == 0) {
            return;
        }
        this.innerTimer.reset();
        this.logBuffer.append("************** Begin BalanceCaculate **************\n");
        this.logBuffer.append(this.getLogHeadInfo()).append("\n");
    }

    @Override
    public void error(String message) {
        this.logBuffer.append("BalanceCaculator error: ").append(message).append("\n");
        this.logger.info((Object)this.logBuffer.toString());
        this.logBuffer.setLength(0);
    }

    @Override
    public void info(String message) {
        if (this.level < 1) {
            return;
        }
        this.logBuffer.append(message).append("\n");
    }

    @Override
    public void debug(String message) {
        if (this.level < 2) {
            return;
        }
        this.logBuffer.append(message).append("\n");
    }

    @Override
    public void debugSQL(String message, String sSQL) {
        if (this.level < 2) {
            return;
        }
        this.logBuffer.append(message).append(sSQL).append("\n");
    }

    @Override
    public void debugData(String message, String tableName) {
        if (this.level < 3) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getLogHeadInfo()).append(message);
        int j = 1;
        String fields = null;
        String value = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)("SELECT * FROM " + tableName));
            while (rs.next()) {
                buffer.append("\r\n").append("Line ").append(j).append(":");
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    fields = rs.getMetaData().getColumnName(i);
                    value = rs.getObject(i) == null ? null : rs.getObject(i).toString();
                    buffer.append(fields).append("=").append(value == null ? " " : value).append(";  ");
                }
                buffer.append("\n");
                ++j;
            }
            this.logBuffer.append(buffer.toString());
        }
        catch (BOSException e) {
            this.logger.info((Object)("Debug Data throw ex:" + e.getMessage()));
        }
        catch (SQLException e) {
            this.logger.info((Object)("Debug Data throw ex:" + e.getMessage()));
        }
    }

    @Override
    public void endLog() {
        if (this.level == 0) {
            return;
        }
        this.logBuffer.append("************** End BalanceCaculate, spend times: " + this.innerTimer.msValue() + " **************").append("\n");
        this.logger.info((Object)this.logBuffer.toString());
        this.logBuffer.setLength(0);
    }

    protected String getLogHeadInfo() {
        String clientIP = this.ctx.getClientHostIP();
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u5ba2\u6237\u7aefIP\uff1a").append(clientIP);
        return buffer.toString();
    }

    private void initParam() throws EASBizException, BOSException {
        String sql = "SELECT FValue From T_DT_DTTempParam WHERE FKey = 'BalanceCalLogLevel'";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            this.level = rs.next() ? rs.getInt("FValue") : 0;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void initLogger() {
        if (this.balanceModelInfo == null) {
            return;
        }
        if (this.logger == null) {
            String loggerName = this.balanceModelInfo.getNumber();
            String fileName = "BalanceCalculate_" + loggerName + ".log";
            Log4j2Util.addRollFileLogConfig((String)"balance", (String)LOGGER_NAME, (String)fileName, (Level)Level.INFO, (String)"50MB", (String)"10");
            this.logger = Logger.getLogger((String)LOGGER_NAME);
        }
    }

    private Properties getLogProperties() {
        Properties properties = new Properties();
        String loggerName = this.balanceModelInfo.getNumber();
        String appendFullName = "log4j.appender." + loggerName;
        String fileName = "${EAS_INSTANCE_HOME}/logs/BalanceCalculate_" + loggerName + ".log";
        properties.put("log4j.logger.com.kingdee.eas.scm.framework.balance", "info, " + loggerName);
        properties.put("log4j.additivity.com.kingdee.eas.scm.framework.balance", "false");
        properties.put(appendFullName, "org.apache.log4j.RollingFileAppender");
        properties.put(appendFullName + ".MaxBackupIndex", "10");
        properties.put(appendFullName + ".MaxFileSize", "50MB");
        properties.put(appendFullName + ".layout", "org.apache.log4j.PatternLayout");
        properties.put(appendFullName + ".layout.ConversionPattern", "[%d{yyyy-MM-dd HH:mm:ss.SSS} %-6p] %m %n");
        properties.put(appendFullName + ".encoding", "UTF-8");
        properties.put(appendFullName + ".File", fileName);
        return properties;
    }
}

