/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.framework.bizflow.BizFlowException;
import com.kingdee.eas.scm.framework.bizflow.BizFlowFacadeFactory;
import com.kingdee.eas.scm.framework.bizflow.IBizFlowFacade;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;

public final class BizFlowServerHelper {
    public static void doProcessing(Context ctx, IObjectValue model, BatchActionEnum action) throws BOSException, EASBizException {
        IBizFlowFacade iBizFlow = BizFlowFacadeFactory.getLocalInstance(ctx);
        if (action.equals((Object)BatchActionEnum.SAVE)) {
            IObjectCollection colValue = BizFlowServerHelper.getFlowKeyObjByModel(ctx, model);
            iBizFlow.bizFlowInject(model, colValue, BatchActionEnum.SAVE);
        }
        if (action.equals((Object)BatchActionEnum.SUBMIT)) {
            iBizFlow.bizFlowInject(model, BatchActionEnum.SUBMIT);
        }
        if (action.equals((Object)BatchActionEnum.AUDIT) || action.equals((Object)BatchActionEnum.UNAUDIT) || action.equals((Object)BatchActionEnum.ALTER) || action.equals((Object)BatchActionEnum.DELETE) || action.equals((Object)BatchActionEnum.CLOSE) || action.equals((Object)BatchActionEnum.UNCLOSE) || action.equals((Object)BatchActionEnum.CANCEL) || action.equals((Object)BatchActionEnum.FREEZE) || action.equals((Object)BatchActionEnum.UNFREEZE)) {
            iBizFlow.bizFlowWriteBack(model, action);
        }
    }

    private static IObjectCollection getFlowKeyObjByModel(Context ctx, IObjectValue model) throws BOSException {
        IObjectCollection retValue = null;
        if (model.get("relationColl") instanceof IObjectCollection) {
            retValue = (IObjectCollection)model.get("relationColl");
        } else if (model.get("relationColl") instanceof String) {
            String bOTRelation = model.get("relationColl").toString();
            BOTRelationCollection collection = new BOTRelationCollection();
            List list = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)bOTRelation, List.class);
            for (int i = 0; i < list.size(); ++i) {
                JSONObject jsonObject = JSONObject.fromObject(list.get(i));
                BOTRelationInfo botRelationInfo = (BOTRelationInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonObject.toString(), BOTRelationInfo.class);
                collection.add(botRelationInfo);
            }
            retValue = collection;
        }
        return retValue;
    }

    public static void doWriteBack(Context ctx, IObjectValue model, BatchActionEnum action) throws BOSException, EASBizException {
        IBizFlowFacade iBizFlow = BizFlowFacadeFactory.getLocalInstance(ctx);
        if (action.equals((Object)BatchActionEnum.SUBMIT)) {
            iBizFlow.bizFlowWriteBack(model, action);
        }
    }

    public static void doProcessing(Context ctx, Object[] bills, BatchActionEnum action) throws BOSException, EASBizException {
        IObjectValue model = null;
        if ((action.equals((Object)BatchActionEnum.AUDIT) || action.equals((Object)BatchActionEnum.UNAUDIT)) && bills != null && bills.length > 0) {
            for (int i = 0; i < bills.length; ++i) {
                model = BizFlowServerHelper.getBillModelByID(ctx, bills[i].toString());
                BizFlowServerHelper.doProcessing(ctx, model, action);
            }
        }
    }

    public static void doProcessing(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum action) throws BOSException, EASBizException {
        IObjectValue model;
        int i;
        IBizFlowFacade iBizFlow = BizFlowFacadeFactory.getLocalInstance(ctx);
        if (action.equals((Object)BatchActionEnum.SAVE)) {
            for (i = 0; i < entries.length; ++i) {
                model = (IObjectValue)entries[i].get(0);
                if (model.get("relationColl") == null || iBizFlow.bizFlowInject(model, (IObjectCollection)model.get("relationColl"), BatchActionEnum.SAVE)) continue;
                throw new BizFlowException(BizFlowException.BIZFLOW_ERROR004);
            }
        }
        if (action.equals((Object)BatchActionEnum.SUBMIT)) {
            for (i = 0; i < entries.length; ++i) {
                model = (IObjectValue)entries[i].get(0);
                if (!iBizFlow.bizFlowInject(model, null, BatchActionEnum.SUBMIT)) {
                    throw new BizFlowException(BizFlowException.BIZFLOW_ERROR004);
                }
                iBizFlow.bizFlowWriteBack(model, action);
            }
        }
        if (action.equals((Object)BatchActionEnum.AUDIT) || action.equals((Object)BatchActionEnum.UNAUDIT) || action.equals((Object)BatchActionEnum.ALTER) || action.equals((Object)BatchActionEnum.DELETE) || action.equals((Object)BatchActionEnum.CLOSE) || action.equals((Object)BatchActionEnum.UNCLOSE) || action.equals((Object)BatchActionEnum.CANCEL) || action.equals((Object)BatchActionEnum.FREEZE) || action.equals((Object)BatchActionEnum.UNFREEZE)) {
            for (i = 0; i < entries.length; ++i) {
                model = (IObjectValue)entries[i].get(0);
                iBizFlow.bizFlowWriteBack(model, action);
            }
        }
    }

    public static void bizProcessParamBuilder(Context ctx, IObjectValue model, IObjectCollection relationColl, BatchActionEnum action) throws BOSException, EASBizException {
        IObjectCollection newRelationColl = BizFlowServerHelper.getNewRelationColl(model, relationColl);
        model.put("relationColl", (Object)newRelationColl);
    }

    private static IObjectCollection getNewRelationColl(IObjectValue model, IObjectCollection relationColl) {
        if (model.get("entry") == null && model.get("entries") == null) {
            return relationColl;
        }
        IObjectCollection entryColl = (IObjectCollection)model.get("entry");
        if (entryColl == null) {
            entryColl = (IObjectCollection)model.get("entries");
        }
        IObjectValue entryInfo = null;
        HashMap<String, Set<String>> idMapping = new HashMap<String, Set<String>>();
        HashSet<String> newEntryIDSet = null;
        String oldEntryId = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.getObject(i);
            if (entryInfo.get("OLD_ENTRY_ID") == null) continue;
            oldEntryId = entryInfo.get("OLD_ENTRY_ID").toString();
            newEntryIDSet = (HashSet<String>)idMapping.get(oldEntryId);
            if (newEntryIDSet == null) {
                newEntryIDSet = new HashSet<String>();
            }
            newEntryIDSet.add(entryInfo.get("id").toString());
            idMapping.put(oldEntryId, newEntryIDSet);
        }
        if (!CollectionUtil.isEmpty(idMapping)) {
            BOTRelationInfo btpRelationInfo = null;
            int size2 = relationColl.size();
            for (int i = 0; i < size2; ++i) {
                btpRelationInfo = ((BOTRelationCollection)relationColl).get(i);
                BOTRelationEntryCollection newBOTRelationEntryColl = BizFlowServerHelper.getNewRelationEntryColl(btpRelationInfo, idMapping);
                btpRelationInfo.getRelationEntries().clear();
                btpRelationInfo.getRelationEntries().addObjectCollection((IObjectCollection)newBOTRelationEntryColl);
            }
        }
        return relationColl;
    }

    private static BOTRelationEntryCollection getNewRelationEntryColl(BOTRelationInfo btpRelationInfo, Map<String, Set<String>> idMapping) {
        BOTRelationEntryCollection newBtpRelationEntryColl = new BOTRelationEntryCollection();
        BOTRelationEntryCollection btpRelationEntryColl = btpRelationInfo.getRelationEntries();
        BOTRelationEntryInfo btpRelationEntryInfo = null;
        String entryId = null;
        int size = btpRelationEntryColl.size();
        for (int i = 0; i < size; ++i) {
            btpRelationEntryInfo = btpRelationEntryColl.get(i);
            entryId = btpRelationEntryInfo.getDestEntryID();
            if (idMapping.containsKey(entryId)) {
                Set<String> newEntryIDSet = idMapping.get(entryId);
                Iterator<String> itor = newEntryIDSet.iterator();
                String newEntryId = null;
                BOTRelationEntryInfo newbtpRelationEntryInfo = null;
                while (itor.hasNext()) {
                    newEntryId = itor.next();
                    newbtpRelationEntryInfo = (BOTRelationEntryInfo)btpRelationEntryInfo.clone();
                    newbtpRelationEntryInfo.setDestEntryID(newEntryId);
                    newBtpRelationEntryColl.add(newbtpRelationEntryInfo);
                }
                continue;
            }
            newBtpRelationEntryColl.add(btpRelationEntryInfo);
        }
        return newBtpRelationEntryColl;
    }

    private static IObjectValue getBillModelByID(Context ctx, String billID) throws BOSException, EASBizException {
        if (billID == null || billID.length() == 0) {
            return null;
        }
        CoreBillBaseInfo model = null;
        ICoreBillBase iCoreBill = null;
        iCoreBill = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)BOSUuid.read((String)billID).getType().toString()));
        model = iCoreBill.getCoreBillBaseInfo((IObjectPK)new ObjectUuidPK(billID));
        return model;
    }
}

