/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.app.formula.function;

import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.service.formula.api.IParaInputFormulaFunctions;
import com.kingdee.bos.service.formula.api.InvokeFunctionException;
import com.kingdee.bos.service.formula.api.funcpara.IFuncParaInputProvider;
import com.kingdee.eas.scm.framework.bizflow.app.formula.function.FuncInfo;
import com.kingdee.eas.scm.framework.secure.util.MathRandom;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class BaseFormulaFunctions
implements IParaInputFormulaFunctions {
    private Vector funcInfos = new Vector();
    static final String BASERESOURCE = "com.kingdee.bos.formula.FORMULAAutoGenerateResource";

    public BaseFormulaFunctions() {
        this.funcInfos.add(new FuncInfo("round", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"1_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("sqrt", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"2_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("int", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"3_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("ln", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"4_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("log", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"5_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("log10", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"6_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("exp", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"7_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("power", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"8_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("mod", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"9_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("pi", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"10_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("rand", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"11_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("degrees", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"12_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("radians", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"13_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("sin", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"14_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("asin", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"15_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("cos", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"16_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("acos", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"17_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("tan", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"18_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("atan", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"19_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("convertBigDecimal", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"20_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("trim", FuncInfo.CATEGORY_STRING, EASResource.getString((String)BASERESOURCE, (String)"21_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("left", FuncInfo.CATEGORY_STRING, EASResource.getString((String)BASERESOURCE, (String)"22_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("right", FuncInfo.CATEGORY_STRING, EASResource.getString((String)BASERESOURCE, (String)"23_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("rept", FuncInfo.CATEGORY_STRING, EASResource.getString((String)BASERESOURCE, (String)"24_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("now", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"25_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("convertJavaDate", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"26_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("year", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"27_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("month", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"28_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("date", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"29_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("hour", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"30_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("minute", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"31_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("second", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"32_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("yearday", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"33_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("weekday", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"34_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("datevalue", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"35_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("days", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"36_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("hours", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"37_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("milliseconds", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"38_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("minutes", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"39_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("seconds", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"40_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("ticks", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"41_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("totaldays", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"42_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("totalhours", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"43_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("totalmilliseconds", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"44_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("totalminutes", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"45_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("totalseconds", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"46_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("dateDiff", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"47_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("dateAdd", FuncInfo.CATEGORY_TIME, EASResource.getString((String)BASERESOURCE, (String)"48_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("abs", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"49_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("parseInt", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"50_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("parseFloat", FuncInfo.CATEGORY_MATH, EASResource.getString((String)BASERESOURCE, (String)"51_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("len", FuncInfo.CATEGORY_STRING, EASResource.getString((String)BASERESOURCE, (String)"52_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("avg", FuncInfo.CATEGORY_SET, EASResource.getString((String)BASERESOURCE, (String)"53_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("count", FuncInfo.CATEGORY_SET, EASResource.getString((String)BASERESOURCE, (String)"54_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("max", FuncInfo.CATEGORY_SET, EASResource.getString((String)BASERESOURCE, (String)"55_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("min", FuncInfo.CATEGORY_SET, EASResource.getString((String)BASERESOURCE, (String)"56_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("sum", FuncInfo.CATEGORY_SET, EASResource.getString((String)BASERESOURCE, (String)"57_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("print", FuncInfo.CATEGORY_IO, EASResource.getString((String)BASERESOURCE, (String)"58_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("println", FuncInfo.CATEGORY_IO, EASResource.getString((String)BASERESOURCE, (String)"59_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("eval", FuncInfo.CATEGORY_OTHER, EASResource.getString((String)BASERESOURCE, (String)"60_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("newid", FuncInfo.CATEGORY_OTHER, EASResource.getString((String)BASERESOURCE, (String)"61_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("conditional_sum", FuncInfo.CATEGORY_OTHER, EASResource.getString((String)BASERESOURCE, (String)"62_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("conditional_avg", FuncInfo.CATEGORY_OTHER, EASResource.getString((String)BASERESOURCE, (String)"63_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("conditional_max", FuncInfo.CATEGORY_OTHER, EASResource.getString((String)BASERESOURCE, (String)"64_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("conditional_min", FuncInfo.CATEGORY_OTHER, EASResource.getString((String)BASERESOURCE, (String)"65_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("conditional_count", FuncInfo.CATEGORY_OTHER, EASResource.getString((String)BASERESOURCE, (String)"66_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("ignoreNullString", FuncInfo.CATEGORY_NULLJUDGE, EASResource.getString((String)BASERESOURCE, (String)"67_BaseFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("ignoreNullNumber", FuncInfo.CATEGORY_NULLJUDGE, EASResource.getString((String)BASERESOURCE, (String)"68_BaseFormulaFunctions")));
    }

    public boolean existFunction(String funcName) {
        if (funcName == null) {
            return false;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return true;
        }
        return false;
    }

    public String[] getAllFuncNames() {
        String[] funcNames = new String[this.funcInfos.size()];
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            funcNames[i] = ((FuncInfo)this.funcInfos.get((int)i)).funcName;
        }
        return funcNames;
    }

    public String getFuncCategory(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).funcCategory;
        }
        return null;
    }

    public String getFuncDesc(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).funcDesc;
        }
        return null;
    }

    private Object now(List paramList) throws InvokeFunctionException {
        if (paramList != null && paramList.size() > 0) {
            throw new InvokeFunctionException("now", 1);
        }
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat nowDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance();
        nowDateFormat.applyPattern(pattern);
        return nowDateFormat.format(new Date());
    }

    private Object convertJavaDate(List paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException("convertJavaDate", 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException("convertJavaDate", 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException("convertJavaDate", 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Date)) {
            throw new InvokeFunctionException("convertJavaDate", 3);
        }
        Locale locale = null;
        DateFormat dateFormat = null;
        locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), Locale.CHINA.getCountry());
        dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        return dateFormat.format((Date)paramList.get(0));
    }

    private Object timeFuncSetString(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        Locale locale = null;
        DateFormat dateFormat = null;
        locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), Locale.CHINA.getCountry());
        dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        try {
            if ("year".equals(funcName)) {
                int year = dateFormat.parse((String)paramList.get(0)).getYear() + 1900;
                return new Integer(year);
            }
            if ("month".equals(funcName)) {
                int month = dateFormat.parse((String)paramList.get(0)).getMonth() + 1;
                return new Integer(month);
            }
            if ("date".equals(funcName)) {
                int date = dateFormat.parse((String)paramList.get(0)).getDate();
                return new Integer(date);
            }
            if ("hour".equals(funcName)) {
                int hour = dateFormat.parse((String)paramList.get(0)).getHours();
                return new Integer(hour);
            }
            if ("minute".equals(funcName)) {
                int minute = dateFormat.parse((String)paramList.get(0)).getMinutes();
                return new Integer(minute);
            }
            if ("second".equals(funcName)) {
                int year = dateFormat.parse((String)paramList.get(0)).getSeconds();
                return new Integer(year);
            }
            if ("yearday".equals(funcName)) {
                Date date = dateFormat.parse((String)paramList.get(0));
                Calendar calendar = Calendar.getInstance();
                calendar.set(date.getYear(), date.getMonth(), date.getDate());
                return new Integer(calendar.get(6));
            }
            if ("weekday".equals(funcName)) {
                int weekday = dateFormat.parse((String)paramList.get(0)).getDay();
                return new Integer(weekday);
            }
            if ("datevalue".equals(funcName)) {
                long time = dateFormat.parse((String)paramList.get(0)).getTime();
                return new Long(time);
            }
            return null;
        }
        catch (ParseException e) {
            throw new InvokeFunctionException(funcName, (Throwable)e);
        }
    }

    private Object timeFuncDateDiff(List paramList) throws InvokeFunctionException {
        String funcName = "dateDiff";
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null || paramList.get(1) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String) && !(paramList.get(0) instanceof Date) || !(paramList.get(1) instanceof String) && !(paramList.get(1) instanceof Date)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        Locale locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), Locale.CHINA.getCountry());
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        GregorianCalendar leapYearCalendar = null;
        leapYearCalendar = new GregorianCalendar();
        try {
            int currMonth;
            Date date1 = dateFormat.parse((String)paramList.get(0));
            Date date2 = dateFormat.parse((String)paramList.get(1));
            boolean isMinus = false;
            if (date2.after(date1)) {
                Date tmpDate = date1;
                date1 = date2;
                date2 = tmpDate;
                isMinus = true;
            }
            int year1 = date1.getYear() + 1900;
            int year2 = date2.getYear() + 1900;
            int month1 = date1.getMonth() + 1;
            int month2 = date2.getMonth() + 1;
            int d1 = date1.getDate();
            int d2 = date2.getDate();
            if (year1 == year2 && month1 == month2) {
                if (!isMinus) {
                    return new Integer(d1 - d2);
                }
                return new Integer(d2 - d1);
            }
            int yearDates = 0;
            if (year1 - year2 >= 2) {
                for (int currYear = year2 + 1; currYear < year1; ++currYear) {
                    if (leapYearCalendar.isLeapYear(currYear)) {
                        yearDates += 366;
                        continue;
                    }
                    yearDates += 365;
                }
            }
            int year2dates = 0;
            int year1dates = 0;
            if (year1 == year2) {
                for (currMonth = month2 + 1; currMonth <= month1 - 1; ++currMonth) {
                    year1dates += this.monthDates(year1, currMonth);
                }
            } else {
                for (currMonth = month2 + 1; currMonth <= 12; ++currMonth) {
                    year2dates += this.monthDates(year2, currMonth);
                }
                for (currMonth = 1; currMonth <= month1 - 1; ++currMonth) {
                    year1dates += this.monthDates(year1, currMonth);
                }
            }
            int month2dates = this.monthDates(year2, month2) - d2;
            int month1dates = d1;
            int totalDates = yearDates + year2dates + year1dates + month2dates + month1dates;
            if (isMinus) {
                totalDates = -totalDates;
            }
            return new Integer(totalDates);
        }
        catch (ParseException e) {
            throw new InvokeFunctionException(funcName, (Throwable)e);
        }
    }

    private Object timeFuncDateAdd(List paramList) throws InvokeFunctionException {
        String funcName = "dateAdd";
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null || paramList.get(1) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String) && !(paramList.get(0) instanceof Date) || !(paramList.get(1) instanceof String) && !(paramList.get(1) instanceof Integer)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        Locale locale = new Locale(Locale.SIMPLIFIED_CHINESE.getLanguage(), Locale.CHINA.getCountry());
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        try {
            Date date1 = dateFormat.parse((String)paramList.get(0));
            int offset = 0;
            offset = paramList.get(1) instanceof String ? Integer.valueOf((String)paramList.get(1)).intValue() : ((Integer)paramList.get(1)).intValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date1);
            calendar.set(6, calendar.get(6) + offset);
            String pattern = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat nowDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance();
            nowDateFormat.applyPattern(pattern);
            return nowDateFormat.format(calendar.getTime());
        }
        catch (ParseException e) {
            throw new InvokeFunctionException(funcName, (Throwable)e);
        }
    }

    private int monthDates(int year, int month) {
        GregorianCalendar leapYearCalendar = null;
        leapYearCalendar = new GregorianCalendar();
        if (month < 1 || month > 12) {
            return 0;
        }
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            return 31;
        }
        if (month == 2) {
            if (leapYearCalendar.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 30;
    }

    private Object timeFuncSetInt(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Long) && !(paramList.get(0) instanceof Integer)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        long time = 0L;
        if (paramList.get(0) instanceof Long) {
            time = (Long)paramList.get(0);
        } else if (paramList.get(0) instanceof Integer) {
            time = ((Integer)paramList.get(0)).intValue();
        }
        if ("days".equals(funcName)) {
            return new Integer((int)(time / 86400000L));
        }
        if ("hours".equals(funcName)) {
            return new Integer((int)(time / 3600000L));
        }
        if ("milliseconds".equals(funcName)) {
            return new Integer((int)time);
        }
        if ("minutes".equals(funcName)) {
            return new Integer((int)(time / 60000L));
        }
        if ("seconds".equals(funcName)) {
            return new Integer((int)(time / 1000L));
        }
        if ("ticks".equals(funcName)) {
            return new Integer((int)(time / 3600000L));
        }
        if ("totaldays".equals(funcName)) {
            return new Double((double)time / 8.64E7);
        }
        if ("totalhours".equals(funcName)) {
            return new Double((double)time / 3600000.0);
        }
        if ("totalmilliseconds".equals(funcName)) {
            return new Double(time);
        }
        if ("totalminutes".equals(funcName)) {
            return new Double((double)time / 60000.0);
        }
        if ("totalseconds".equals(funcName)) {
            return new Double((double)time / 1000.0);
        }
        return null;
    }

    private Object trim(List paramList) throws InvokeFunctionException {
        String funcName = "trim";
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        return ((String)paramList.get(0)).trim();
    }

    private Object stringFuncSet(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null || paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String) || !(paramList.get(1) instanceof Integer)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        String inputStr = (String)paramList.get(0);
        int cnt = (Integer)paramList.get(1);
        if (cnt < 0) {
            throw new InvokeFunctionException(funcName, "parameter 2 must be greater than 0!");
        }
        if ("left".equals(funcName)) {
            if (inputStr.length() < cnt) {
                return inputStr;
            }
            return inputStr.substring(0, cnt);
        }
        if ("right".equals(funcName)) {
            if (inputStr.length() < cnt) {
                return inputStr;
            }
            return inputStr.substring(inputStr.length() - cnt, inputStr.length());
        }
        if ("rept".equals(funcName)) {
            String retStr = "";
            for (int i = 0; i < cnt; ++i) {
                retStr = retStr + inputStr;
            }
            return retStr;
        }
        return null;
    }

    private Object mathFuncSet0(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList != null && paramList.size() > 0) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if ("pi".equals(funcName)) {
            return new Double(Math.PI);
        }
        if ("rand".equals(funcName)) {
            return MathRandom.nextDouble();
        }
        return null;
    }

    private Object mathFuncSet1(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Number)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        double param1 = Double.valueOf(paramList.get(0).toString());
        if ("sqrt".equals(funcName)) {
            return new Double(Math.sqrt(param1));
        }
        if ("int".equals(funcName)) {
            return new Integer((int)param1);
        }
        if ("ln".equals(funcName)) {
            return new Double(Math.log(param1));
        }
        if ("log10".equals(funcName)) {
            return new Double(Math.log(param1) / Math.log(10.0));
        }
        if ("exp".equals(funcName)) {
            return new Double(Math.pow(10.0, param1));
        }
        if ("degrees".equals(funcName)) {
            return new Double(Math.toDegrees(param1));
        }
        if ("radians".equals(funcName)) {
            return new Double(Math.toRadians(param1));
        }
        if ("sin".equals(funcName)) {
            return new Double(Math.sin(param1));
        }
        if ("asin".equals(funcName)) {
            return new Double(Math.asin(param1));
        }
        if ("cos".equals(funcName)) {
            return new Double(Math.cos(param1));
        }
        if ("acos".equals(funcName)) {
            return new Double(Math.acos(param1));
        }
        if ("tan".equals(funcName)) {
            return new Double(Math.tan(param1));
        }
        if ("atan".equals(funcName)) {
            return new Double(Math.atan(param1));
        }
        return null;
    }

    private Object mathFuncSet2(List paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null || paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Number) || !(paramList.get(1) instanceof Number)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        double param1 = Double.valueOf(paramList.get(0).toString());
        double param2 = Double.valueOf(paramList.get(1).toString());
        if ("log".equals(funcName)) {
            return new Double(Math.log(param2) / Math.log(param1));
        }
        if ("power".equals(funcName)) {
            return new Double(Math.pow(param1, param2));
        }
        if ("mod".equals(funcName)) {
            return new Double(param1 % param2);
        }
        return null;
    }

    private Object convertBigDecimal(List paramList) throws InvokeFunctionException {
        String funcName = "convertBigDecimal";
        if (paramList == null) {
            return new Integer(0);
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof BigDecimal)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        return new Integer(((BigDecimal)paramList.get(0)).intValue());
    }

    private Object ignoreNull(String funcName, List paramList) throws InvokeFunctionException {
        if (paramList == null) {
            return null;
        }
        if (paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            if ("ignoreNullString".equals(funcName)) {
                return "";
            }
            if ("ignoreNullNumber".equals(funcName)) {
                return new Integer(0);
            }
        }
        return paramList.get(0);
    }

    private BigDecimal round(String funcName, List paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null || paramList.get(1) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Number) || !(paramList.get(1) instanceof Number)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        BigDecimal dSource = new BigDecimal(paramList.get(0).toString());
        int oldScale = dSource.scale();
        int scale = Integer.parseInt(paramList.get(1).toString());
        if (scale < 0) {
            throw new InvokeFunctionException(funcName, "The scale must be a positive integer or zero");
        }
        if (scale > oldScale) {
            scale = oldScale;
        }
        BigDecimal one = new BigDecimal("1");
        BigDecimal rev = dSource.divide(one, scale, 4);
        return rev;
    }

    public Object evalFunction(String funcName, List paramList) throws KScriptException {
        if (funcName == null) {
            return null;
        }
        try {
            if ("round".equals(funcName)) {
                return this.round(funcName, paramList);
            }
            if ("now".equals(funcName)) {
                return this.now(paramList);
            }
            if ("convertJavaDate".equals(funcName)) {
                return this.convertJavaDate(paramList);
            }
            if ("year".equals(funcName) || "month".equals(funcName) || "date".equals(funcName) || "hour".equals(funcName) || "minute".equals(funcName) || "second".equals(funcName) || "yearday".equals(funcName) || "weekday".equals(funcName) || "datevalue".equals(funcName)) {
                return this.timeFuncSetString(paramList, funcName);
            }
            if ("dateDiff".equals(funcName)) {
                return this.timeFuncDateDiff(paramList);
            }
            if ("dateAdd".equals(funcName)) {
                return this.timeFuncDateAdd(paramList);
            }
            if ("days".equals(funcName) || "hours".equals(funcName) || "milliseconds".equals(funcName) || "minutes".equals(funcName) || "seconds".equals(funcName) || "ticks".equals(funcName) || "totaldays".equals(funcName) || "totalhours".equals(funcName) || "totalmilliseconds".equals(funcName) || "totalminutes".equals(funcName) || "totalseconds".equals(funcName)) {
                return this.timeFuncSetInt(paramList, funcName);
            }
            if ("trim".equals(funcName)) {
                return this.trim(paramList);
            }
            if ("left".equals(funcName) || "right".equals(funcName) || "rept".equals(funcName)) {
                return this.stringFuncSet(paramList, funcName);
            }
            if ("pi".equals(funcName) || "rand".equals(funcName)) {
                return this.mathFuncSet0(paramList, funcName);
            }
            if ("sqrt".equals(funcName) || "int".equals(funcName) || "ln".equals(funcName) || "log10".equals(funcName) || "exp".equals(funcName) || "degrees".equals(funcName) || "radians".equals(funcName) || "sin".equals(funcName) || "asin".equals(funcName) || "cos".equals(funcName) || "acos".equals(funcName) || "tan".equals(funcName) || "atan".equals(funcName)) {
                return this.mathFuncSet1(paramList, funcName);
            }
            if ("convertBigDecimal".equals(funcName)) {
                return this.convertBigDecimal(paramList);
            }
            if ("log".equals(funcName) || "power".equals(funcName) || "mod".equals(funcName)) {
                return this.mathFuncSet2(paramList, funcName);
            }
            if ("ignoreNullString".equals(funcName) || "ignoreNullNumber".equals(funcName)) {
                return this.ignoreNull(funcName, paramList);
            }
        }
        catch (InvokeFunctionException e) {
            throw new KScriptException(e.toString(), (Throwable)e);
        }
        return null;
    }

    public IFuncParaInputProvider getFuncParaInputProvider(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).input;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        Interpreter.publicFuncProviderList.add(new BaseFormulaFunctions());
        for (int i = 0; i < 1000; ++i) {
            Thread t = new Thread("Thead" + i){

                @Override
                public void run() {
                    while (true) {
                        try {
                            String text = "var formula_result;formula_result=month(now());return formula_result;";
                            HashMap context = new HashMap();
                            Interpreter interpreter = new Interpreter();
                            Object rtnValue = interpreter.eval(text, context);
                            System.out.println("formula_result:" + rtnValue);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            t.start();
            System.out.println(t.getName() + ":Start");
        }
    }
}

